#if !defined (_TWEAK_PDB_USAGE_)

#define _TWEAK_PDB_USAGE_

/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#define WUSAGE "\
  ----------------------------------------------------\n\
     TweakPDB v1.7 (December 8, 2022)\n\
     www.igs.umaryland.edu/labs/neuwald/software/auxiliary/\n\
     Copyright 2022 The University of Maryland\n\
     Freely distributed under the MIT License\n\
  ----------------------------------------------------\n\
   TweakPDB\n\
   Usage: tweakPDB pdb_prefix [options]\n\
       -A=<int>:<int>  Report all contacts between the <int1>th and <int2>th chain\n\
       -a<int>:<int>:<int>  Calculate angle between atomno=a,b,c\n\
       -angles=<char> determine angles for H-bonds\n\
       -B=<str>:<real> Output chains in <str> along with other chains within <real> of these\n\
			Only uppercase letter designations allowed (e.g., <str> = \"ACE\")\n\
       -b	     Output histograms of bond lengths\n\
       -C<int>       Chain of reference (default: 1)\n\
       -c<int>       Start chain of reference (default: 1)\n\
       -C            Convert MSE (selenomethionines) to Met and HIE, HID, HIP to HIS\n\
       -cnt=<int1>:<int2>:<char>  Print the number of atoms for residue <int1> to <int2> in chain <char>\n\
       -D=<char1>:<pdbfile2>:<char2> Find the surface buried for residues in \n\
                          in subunit <char1> of the input pdb file when compared\n\
                          to subunit <char2> of <pdbfile2> corresponding to \n\
                          the same sequence.\n\
       -D<float>     dmax for non-classical H-bonds (default: case dependent)\n\
       -d<float>     dmax in Angstroms for classical H-bonds (default: 2.5 Angstoms)\n\
       -dist=<int><char>:<int><char>  find dmin in Angstroms between two residues\n\
       -F<int>      Input file identifier for output.\n\
       -Full        Output full length report of contacts and H-bonds.\n\
       -f<cmafile>:<int><str>  - Find contacts between conserved residues in cmafile\n\
                                with <int>% sequence conservation in subunits <str>\n\
       -E<char>:<char> Find the surface buried for residues in 1st upon binding to 2nd chain\n\
       -E=<char>     output exposed surface for type <char1> residues in all chains\n\
       -e<int><char> output percent exposed surface for residue int in chain <char>\n\
                        (if <int> == 0 then print all)\n\
       -e=<char>:<char> output exposed surface for type <char1> residues in chain <char>\n\
       -H            Output all potential H-bonds\n\
       -h            Output potential H-bonds for input residue\n\
       -K<int1>..<int2> key contacts for residues in range <int1> to <int2>\n\
       -K<int1>..<int2><char> key contacts for residues in range <int1> to <int2>\n\
                       in chain <char>\n\
       -k<int>       key contacts for residue <int>\n\
       -k<int><char> key contacts for residue <int> in chain <char>\n\
       -list         List the components and the label of each chain\n\
       -L            Label all unlabeled or duplicately labeled chains\n\
       -M<str>:<str> Transpose via triads given in <tofile>:<fromfile>\n\
       -m<str>:<str>:<int><chn>  Twist chn at residue <int> (if < 0 twist back)\n\
                                   via triads given in <tofile>:<fromfile>\n\
       -N<int>       list contacts with atom_no = <int>\n\
       -n<char>      Output a copy of input pdb file without chain <char>\n\
       -O<int1><char><int2> print out residues <int1> to <int2> in chain <char>\n\
       -o            output non-protein chains\n\
       -P            Output potential non-aromatic pi-H-bonds for input residue\n\
       -p            Output potential aromatic pi-H-bonds for input residue\n\
       -Q            find and output all buried waters coordinating with 4 -C=O groups\n\
       -R            Relabel null and redundantly labeled chains\n\
       -RR           Add TER to change changes if absent\n\
       -Read=<char>  Input file listing the paths to MULTIPLE PDB COORDINATES\n\
                      Output histograms of donor-to-acceptor angles and distances\n\
		        where <char> corresponds to the donor atom type\n\
                         (i.e., 'S','O','N' or 'C')\n\
         -donor=<str>  input donor string of permissible amino acids residues\n\
         -accept=<str> input acceptor string of permissible amino acids residues\n\
       -R=<int><char> Renumber residues in chain <char> starting from <int>\n\
       -R<int><char> rename chain <int> to chain <char>\n\
       -S            output sequences in fasta format\n\
       -shrink=<int1>:<int2>:<real>  Set the bond distance between atom_numbers\n\
                        <int1> and <int2> to <real> by moving <int2> closer to <int1>\n\
       -sub=<int>:<int>:<char> Print out the substructure res <int1> to <int2> for chain <char>\n\
       -s<int><char> shift residue numbering in chain <char> by <int>\n\
       -s=<int><char>:<int1>..<int2>  shift residue numbering in chain <char> by <int>\n\
                        from residue <int1> to residue <int2>\n\
       -T            find catalytic triads in pdb file\n\
       -t<file>      transform pdb coordinates using 'CE' information in <file>\n\
       -useMC	     use main chain distances when computing residue distances\n\
       -W            Output a copy of input file eliminating water > dmax from non-water\n\
       -w<char>      Output a copy of input pdb file - chain <char>\n\
       -w<int><char> Output H-bonds for HOH<int> in 'chain' <char>\n\
                     (If <int> == 0 then find for all waters in chain <char>)\n\
       -w=<int>..<int><char> Output residues <int1> to <int2> in chain <char>\n\
       -x=<int>..<int><char> Output all of chain <char> except for residues <int1> to <int2>\n\
       -z            simulate evolved sequences (using PAM value)\n\
\n"

#endif

