/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

/****************** pdb.h ***************/ 
#if !defined(_TWEAK_PDB_HEADER_)
#define _TWEAK_PDB_HEADER_

#include "pdb.h"
#include "swaln.h"
#include "cmsa.h"
#include "mps_typ.h"
#include "karlin.h"
#include "twp_typ_usage.h"

class twp_typ {  // TweakPDB type 
public: 
	twp_typ(){ print_error("twp_typ( ) constructor disallowed"); }
	twp_typ(int ac, char **av,pdb_typ pdb=0){ 
		argc=ac; argv=av; in_pdb=pdb;
	}
	int	Run(FILE *ofp=NULL);
	~twp_typ(){ }
private:
	int	argc;
	char	**argv;
	pdb_typ	in_pdb;
	Int4    ListChainsPDB(FILE *fp,pdb_typ pdb);
	char    *BaseName(char *path);
	void	ReadCETransformFile(char *filename,double xyz[4][5],const char *usage);
	char    *Foo(cma_typ cma, Int4 cmacutoff, char *cma_chns,
                Int4 *ResStart,Int4 *ResEnd, pdb_typ P);
	double  GetResDistance(FILE *fptr, Int4 resC,Int4 resD, char chnC, char chnD, pdb_typ P,
                BooLean noMainChn=TRUE);
};

#endif
