/*********************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 **********************************************************************************/
#include "trm_typ.h"

Int4	trm_typ::PutKeyTerms(cma_typ cma,const char *Prefix,Int4 cutoff,
			FILE *fp,FILE *efp)
// given a cma and a 3 letter prefix return a list of the terms matching this 
// prefix along with the number of occurances for each term.. 
{
     char   c,d,e,**Argv;
     char   **Rtn; 
     Int4   i,j,k,x,I,J,sq,n,z;

     head=0;
     for(sq=1; sq <= NumSeqsCMSA(cma); sq++){
	e_type Sq=TrueSeqCMSA(sq,cma);
	// PutSeq(stderr,Sq,AB);
	char *info=StrSeqInfo(Sq);
	if(strncmp("Random",info,6) == 0){ free(info);  continue; }
	// fprintf(fp,"%s\n",info);
	char *sp=strchr(info,'}');
	if(sp==0) sp=info; else sp++;
	NEWP(Argv,strlen(sp)+3,char);
	for(i=1; sp[i]; i++){
	   if(sp[i]=='[') sp[i]=0;
	   else if(ispunct(sp[i])) sp[i]=' ';
	   else if(sp[i]=='['){
		for(Int4 j=i; sp[j] && sp[j]!=']'; j++) sp[j]=' ';
	   }
	}
	n=string2argv(Argv,sp);
	if(0 && efp) fprintf(efp,"%d(%d):",sq,n);
	for(z=0,J=0; J < n; J++){
	   Int4 len=strlen(Argv[J]);
	   if(len < 3){ free(Argv[J]); continue; }
	   char *str=Argv[J]; x=len-1;
	   if(str[x]==']'){ free(Argv[J]); continue; }
	   for(j=0; j < len; j++){
		if(isupper(Argv[J][j])) Argv[J][j]=tolower(Argv[J][j]);
	   }
	   BooLean skip=TRUE;
	   for(x=0; x < 3; x++){ str[x]=tolower(str[x]); }
	   if(strncmp(Prefix,str,3) != 0){ free(Argv[J]); continue; }
	   if(this->IgnoreTerm(str)) { free(Argv[J]); continue; }
	   if(0 && efp) fprintf(efp," %s",str); z++;
	   i=(Int4)(str[0] - 'a' + 1);
	   j=(Int4)(str[1] - 'a' + 1);
	   k=(Int4)(str[2] - 'a' + 1);
	   char *term=Argv[J];
	   if(head==0){
     		head=tail=new tml_typ(Argv[J]);
	   } else {
		tml_typ *nxt=0;
		for(nxt=head; nxt != 0; nxt=nxt->next){
		   if(nxt->next ==0) tail = nxt;
		   char *nstr=nxt->str;
		   if(strcmp(nstr,term) == 0){ nxt->Num++; break; }
		}
		if(nxt == 0){
		   tail ->next = new tml_typ(term);
		}
	   }
	} free(Argv); free(info);
	if(0 && efp)fprintf(efp,"\n");
   }
#if 1
   this->PutRankedTerms(fp,head,cutoff);
#else
   tml_typ *nxt=head;
   for(n=1; nxt != 0; n++,nxt=nxt->next){
	fprintf(stdout,"%d (%d): %s\n",n,nxt->Num,nxt->str);
   }
#endif
   delete head;
   return z;
}

Int4    trm_typ::CountTerms(tml_typ *head)
{
	Int4	N;
	tml_typ *nxt=head;
	for(N=0; nxt != 0; nxt=nxt->next) N++;
	return N;
}

Int4    trm_typ::PutRankedTerms(FILE *fp,tml_typ *head,Int4 cutoff)
{
	Int4	i,j,N;
	double	key;
	N=this->CountTerms(head);
	dh_type dH=dheap(N+3,4);
	tml_typ **tml; NEWP(tml,N+3,tml_typ);
	tml_typ *nxt=head;
	for(i=1; nxt != 0; i++,nxt=nxt->next){
		if(nxt->Num < cutoff) continue;
		key=nxt->Num;
		insrtHeap(i,-key,dH);	
		tml[i]=nxt;
	}
	double bst=-minkeyHeap(dH);
	for(j=1; !emptyHeap(dH); j++){
	  key=-minkeyHeap(dH);
	  i=delminHeap(dH);
	  double dd=key/bst;
	  if(dd > 0.40){
		fprintf(fp,"%d(%d): %s\n",j,tml[i]->Num,tml[i]->str);
	  }
	  
	} free(tml);
	Nildheap(dH);
}

BooLean trm_typ::IgnoreTerm(const char *term)
{
	if(strcmp("uncharacterized",term) == 0) return TRUE;
	if(strcmp("hypothetical",term) == 0) return TRUE;
	if(strcmp("containing",term) == 0) return TRUE;
	if(strcmp("bacterium",term) == 0) return TRUE;
	if(strcmp("predicted",term) == 0) return TRUE;
	if(strcmp("sequence",term) == 0) return TRUE;
	if(strcmp("unnamed",term) == 0) return TRUE;
	if(strcmp("related",term) == 0) return TRUE;
	if(strcmp("protein",term) == 0) return TRUE;
	if(strcmp("homolog",term) == 0) return TRUE;
	if(strcmp("partial",term) == 0) return TRUE;
	if(strcmp("subunit",term) == 0) return TRUE;
	if(strcmp("product",term) == 0) return TRUE;
	// if(strcmp("forming",term) == 0) return TRUE;
	if(strcmp("family",term) == 0) return TRUE;
	if(strcmp("domain",term) == 0) return TRUE;
	if(strcmp("group",term) == 0) return TRUE;
	if(strcmp("chain",term) == 0) return TRUE;
	if(strcmp("clone",term) == 0) return TRUE;
	if(strcmp("like",term) == 0) return TRUE;
	if(strcmp("and",term) == 0) return TRUE;
	return FALSE;
}

Int4	trm_typ::CollectData(cma_typ cma,FILE *efp)
{
     char   c,d,e,**Argv;
     Int4   i,j,k,x,I,J,sq,n,z;

     for(sq=1; sq <= NumSeqsCMSA(cma); sq++){
	e_type Sq=TrueSeqCMSA(sq,cma);
	// PutSeq(stderr,Sq,AB);
	char *info=StrSeqInfo(Sq);
	if(strncmp("Random",info,6) == 0){ free(info);  continue; }
	// fprintf(fp,"%s\n",info);
	char *sp=strchr(info,'}');
	if(sp==0) sp=info; else sp++;
	NEWP(Argv,strlen(sp)+3,char);
	for(i=1; sp[i]; i++){
	   if(sp[i]=='[') sp[i]=0;
	   else if(ispunct(sp[i])) sp[i]=' ';
	   else if(sp[i]=='['){
		for(Int4 j=i; sp[j] && sp[j]!=']'; j++) sp[j]=' ';
	   }
	}
	n=string2argv(Argv,sp);
	if(efp) fprintf(efp,"%d(%d):",sq,n);
	for(z=0,J=0; J < n; J++){
	   Int4 len=strlen(Argv[J]);
	   for(j=0; j < len; j++){
		if(isupper(Argv[J][j])) Argv[J][j]=tolower(Argv[J][j]);
	   }
	   if(len < 3){ free(Argv[J]); continue; }
	   char *str=Argv[J]; x=len-1;
	   if(str[x]==']'){ free(Argv[J]); continue; }
	   if(this->IgnoreTerm(str)) { free(Argv[J]); continue; }
	   if(!isalpha(str[0]) || !isalpha(str[1]) || !isalpha(str[2]))
		{ free(Argv[J]); continue; }
	   for(x=0; x < 3; x++){ str[x]=tolower(str[x]); }
	   if(efp) fprintf(efp," %s",str); z++;
	   i=(Int4)(str[0] - 'a' + 1);
	   j=(Int4)(str[1] - 'a' + 1);
	   k=(Int4)(str[2] - 'a' + 1);
	   Prfx[i][j][k]++;
	   free(Argv[J]);
	} free(Argv); free(info);
	if(efp)fprintf(efp,"\n");
   } return z;
}

Int4	trm_typ::Scan4Terms(FILE *fp)
{
	char	c,d,e,**Argv;
	Int4	i,j,k,x,I,J,sq,n,z;
	FILE	*efp=0; // efp=stderr;

	// for(i=1; i <= 26; i++){ NEWP(Prfx[i],30,Int4); }
	for(I=1; IN_CMA[I] != 0; I++){
	   cma_typ cma=IN_CMA[I];
	   a_type AB=AlphabetCMSA(cma);
	   for(i=1; i <= 26; i++){
	      for(j=1; j <= 26; j++){
		if(Prfx[i][j] != 0) free(Prfx[i][j]);
	        NEW(Prfx[i][j],30,Int4);
	      }
	   }
	   CollectData(cma,0);
	   dh_type dH=dheap(18000,4);	// pow(26,3)=17,576.
	   h_type HG=Histogram("number of matches",0,1000,5.0);
	   char Str[10],**code=0; NEWP(code,18000,char);
	   for(x=0,c='a'; c <= 'z'; c++){
	      i=(Int4)(c-'a'+1);
	      for(d='a'; d <= 'z'; d++){
	        j=(Int4)(d-'a'+1);
	        for(e='a'; e <= 'z'; e++){
	          k=(Int4)(e-'a'+1);
		  sprintf(Str,"%c%c%c",c,d,e);
		  x++; code[x]=AllocString(Str);
		  double key=(double)Prfx[i][j][k];
		  if(key == 0.0) key=-0.2;
		  insrtHeap(x,-key,dH);
		  IncdHist(key, HG);
	       }
	     }
	   }
	   double dd=MeanHist(HG);
	   double stdev=sqrt(VarianceHist(HG));
	   double max=MaxValHist(HG);
	   if(0) PutHist(stdout,60,HG); 
	   NilHist(HG);
	   double Dd,bst=0.0;
	   Int4	Bst[20];
	   for(z=1;!emptyHeap(dH);z++){
	      dd=-minkeyHeap(dH);
	      x=delminHeap(dH);
	      i=(Int4)(code[x][0]-'a'+1);
	      j=(Int4)(code[x][1]-'a'+1);
	      k=(Int4)(code[x][2]-'a'+1);
	      if(efp) fprintf(efp,"%d: %s %ld (%.1lf)",z,code[x],Prfx[i][j][k],dd);
	      if(bst > 0.0){
	      	Dd = 100.0 * (dd/bst);
		if(efp) fprintf(efp,"%.1lf%c\n",Dd,'%');
	      } else { Dd=100.0; bst=dd; if(efp) fprintf(efp,"\n");}
	      if(Dd > 33.0) Bst[z]=x; else Bst[z]=0;
	      if(z > 10) break;
	   } Bst[z]=0; Nildheap(dH);
	   Int4 cutoff=(Int4) ceil(bst * 0.25);
	   fprintf(fp,"============ %s (%d seqs) =============\n",
			NameCMSA(cma),NumSeqsCMSA(cma));
	   fprintf(fp,"------------  terms  -------------\n",NameCMSA(cma));
	   for(z=1; Bst[z]; z++){
		x=Bst[z];
		this->PutKeyTerms(cma,code[x],cutoff,fp,efp);
	   }
	   fprintf(fp,"------------  phyla  -------------\n",NameCMSA(cma));
	   char NumKing;
	   Int4 NumNull,num_phyla;
	   num_phyla=PutPhylaSeqSet(fp,0,TrueDataCMSA(cma),NumKing,NumNull,0,FALSE);
#if 1
	   fprintf(fp," %d phyla; %d kingdoms.\n\n",num_phyla,NumKing);
#else
	   fprintf(fp,"\n%s(%d seqs): %d phyla; %d kingdoms.\n\n",
                        NameCMSA(cma),NumSeqsCMSA(cma),num_phyla,NumKing);
#endif
	}
}

