/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined (_EDC_TYP_)
#define _EDC_TYP_

#include "stdinc.h"
#include "residues.h"
#include "pdb.h"
#include "dheap.h"
#include "swaln.h"
#include "set_typ.h"
#include "dsets.h"
#include "dci_typ.h"

class dcm_typ;

class edc_typ {         // evaluate direct couplings type
		friend class dcm_typ;
public:
                edc_typ(){ time1=0; program=0; } // called by dcm_typ...
                edc_typ(int argc,char *argv[],char *mAln=0,char mode=0,
				Int4 *inbpps=0,char *inPDBID=0){
			// fprintf(stderr,"DEBUG SCL: '%c'\n",mode);
			if(inPDBID){ assert(inbpps); sprintf(PDBID,"%6s",inPDBID); }
			else PDBID[0]=0;
			Mode=mode; Init(argc,argv,mAln); 
			if(this->bpps == 0 && inbpps != 0) this->bpps=inbpps; 
		}
                ~edc_typ( ){ Free(); }
                // ~edc_typ( ){ if(AB) PutAlpha(stderr,AB); Free(); }
	dci_typ	*RunDCA(char ColorCode=0, FILE *dcfp=0,Int4 num_dc=0,char *chns=0,
			dcm_typ *dcmBG=0,FILE *lgfp=0, set_typ SetUsd=0);
	void	ReSetMinSqSep(Int4 Val){ MinSqSeparation=Val; }
	float	**CalcMtrxPDB(Int4 &num_resC);
	float	**TheOtherMtrx;
	set_typ	TheOtherSet;
	void	SetOtherMtrx(float **OM, Int4 onr, set_typ tos=0){
			TheOtherMtrx=OM; OtherNumResC=onr; TheOtherSet=tos; }
	Int4	DoShowPairs(){ return ShowPairs; }
	char	Mode;
	char	RtnKeyChain(){ return KeyChain; }
	char	*RtnChains(){
			char tmp[20]; 
			if(NumAdjChns > 0){
			    AdjacentChains[0]=':'; AdjacentChains[NumAdjChns+1]=0;
			    sprintf(tmp,"%c%s",KeyChain,AdjacentChains); return AllocString(tmp);
			} else { sprintf(tmp,"%c",KeyChain); return AllocString(tmp); }
		}
	char	pdbid[100];
	char	PDBID[10];
	Int4	*RtnBPPS() { return bpps; }
	Int4	RtnDCA2pdbOS() { return dca2pdbOS; }
	Int4	ShowPairs;
	dcm_typ	*RtnDCM();
	BooLean	UsePPV;
	char	*pdbFileRtn(){ return pdb_file; }
	Int4	NumHits;
private:
	Int4	Split;		// use for heteromeric DCA
	Int4	UseSide;	// if == -1 left; if == 1 right.
#if 1	
	float	TruncateArray;	// -F=<real> option: 
#endif
	char	AdjacentChains[70];
	Int4	NumAdjChns;
	Int4	*bpps;
	Int4     *ParseIntegers(char *str,const char *msg);
	BooLean	ComputeOverRange;
	Int4	OtherNumResC;
	// Based on Equation 6 in Yu et al., NAR (2006) 34(20):5966-73. PMID: 17068079.
	long double DualPval(long double Pa, long double Pb){ return (Pa*Pb*(1.0 - logl(Pa*Pb))); }
// protected:
	void	Free(),InitDefaults();
	void	Init(int argc,char *argv[],char *mAln=0);
	Int4	ChainExistsPDB(char chain,pdb_typ pdb);	// returns chain id if it exists.
	Int4	MinSqSeparation;
	Int4	PermuteMillions;
	UInt4   seed;
	time_t	time1;
	char	*program;
	void	PrintError(char *program_name);
	//BooLean OverlappingSeqs(Int4 &os, e_type E1, e_type E2, Int4 MinOL, Int4 MaxMsMtch);
	void    PutOverlapSeqs(FILE *fp,Int4 OS, Int4 st1, e_type E1, Int4 st2, e_type E2);
private:	// accessed by dcm_typ.
	char	*dca_file,KeyChain,*pdb_file;
	char	color_code;
	e_type	dcaE;
	Int4	dca2pdbOS;	// offset between dca and pdb sequence files.
	Int4    Simulate,ShuffleRanks;
	BooLean	UseHydrogens,UseJeffreys;
	long double PowerBase;
	float	MaxDist,MinDist;
	FILE    *efptr,*afptr;
	a_type	AB;
};

class dcm_typ: private edc_typ {	// direct coupling matrix type
   public:
                dcm_typ(){ print_error("dcm_typ( ) constructor is disallowed"); }
                dcm_typ(char ch, pdb_typ p,edc_typ *S)
		{ 
			if(S->PDBID[0]) sprintf(PDBID,"%6s",S->PDBID); else PDBID[0]=0;
			chain=ch; PDB=p; Init2(S);
		}
                ~dcm_typ( ){ Free2(); }	// Warning: this calls ~edc_typ() as well!
	BooLean	InitializedOkay(){ return InitOkay; }
	//================= inline routines ====================
	set_typ	RtnDistPairSet(){ set_typ st=DistPairSet; DistPairSet=0; return st; }
	//=================== dcm_run.cc =======================
	dci_typ	*PDBvsDCA(FILE *fp, char ColorCode=0, FILE *dcfp=0,Int4 num_dc=0,
			char *chns=0,set_typ SetUsd=0);
	//=================== dcm_init.cc =======================
	void	MinusBgMtrxDCA(dcm_typ *dcmBG);
	//=================== dcm_typ.cc =======================
	float	**RtnMtrxDCA(Int4 &LLL){ LLL=num_resC; return MtrxDCA; }
   private:
	Int4	RtnL();
	void	CalcDistMtrx(BooLean UseUsed=TRUE);	// okay!!!
	void	GetAdjChainContacts(char *SeqKey);
	Int4	AddAdjctToDistMtrx(char chainAdj);
	BooLean	GetMtrxDCA(char *dca_file);
	void	CalcMtrxBPPS();
	char    ConvertXtoRes(Int4 x, char cx,Int4 X,char cX,e_type xE,e_type pdbE);
	//=================== dcm_run.cc =======================
	class stdh_typ {  // starc run type.
	public:
                stdh_typ(){ print_error("stdh_typ( ) constructor is disallowed"); }
		stdh_typ(Int4 mm,Int4 mmp, dcm_typ *DCM){
			that=DCM; n=0; MM=mm; MMP=mmp; MaxDist=that->MaxDist; 
			this->Init(); 
		}
		~stdh_typ(){ this->Free(); }
	  Int4	LoadUp(set_typ SetUsd=0);
	  set_typ RtnSetPDB(){ return SetPDB;}
	  set_typ RtnSetBP(){ return SetBP;}
	  Int4	*RtnRank(){ return Rank; }
	  Int4	MkArrayPDB( );
	  Int4  *SortArrayDCA(FILE *fp,FILE *dcfp,Int4 num_dc,char *chns);
	  void	RtnN2Arrays(Int4 *&x2i,Int4 *&x2j,Int4 *&x2I,Int4 *&x2J,
			char *&x2cI,char *&x2cJ,float *&x2d,float *&x2dc){
			x2i=n2i; x2j=n2j; x2I=n2I; x2J=n2J; 
			x2cI=n2cI; x2cJ=n2cJ; x2d=n2d; x2dc=n2dc;
		}
	  void	RtnBallInUrn(Int4 &munX,Int4 &munD,Int4 &munB,Int4 &munO,Int4 &munAll,Int4 &N)
		{ munX=numX;munD=numD; munB=numB; munO=numO; munAll=numAll; N=LLL; }
	  Int4	ShuffleRanks();
	private:
	  set_typ SetPDB,SetBP;
	  dcm_typ *that;
	  Int4	*Rank,LLL;
	  Int4	MM,MMP;
	  void	Init();
	  Int4	Insert(Int4 i, Int4 j, Int4 II, Int4 JJ);
	  void	Free();
	  char  RtnLL(dcm_typ *dcm){ return dcm->chain; }
	  Int4	n,*n2i,*n2j,*n2I,*n2J;
	  char  *n2cI,*n2cJ;
          float *n2d,dD,*n2dc,MaxDist;
	  Int4	numX,numD,numB,numO,numAll;
	  // Int4	*i2I,*I2i;	// i = ResALL index; I = ResI site.
	  // long double biu;
	  dh_type dH_pdb,dH_dca;
	};
#if 0
	typedef struct stdh {
	} stdh_type;
	typedef stdh_type *stdh_typ;
#endif
	// Int4	*n2i,*n2j,*n2I,*n2J;
	// Int4	*i2I,*I2i;	// i = ResALL index; I = ResI site.
	//=====================================
	//=================== dcm_pval.cc ======================
	long double  OneTailCumHyperGeomProb(Int4 Nr,Int4 Nb, Int4 rd);
	long double  LnFact(Int4 n);
	long double  CumHyperGeomProb(Int4 N1,Int4 N2, Int4 n,Int4 x);
	Int4    ScorePermutation(Int4 *P, Int4 N);
	double  PermutationPvalue(FILE *fp,Int4 N, Int4 *sprs);
	Int4    pvcalcD(Int4 L,Int4 D,Int4 *pos,long double &pval, BooLean jf=FALSE,BooLean cf=TRUE);
	Int4	pvcalcICA_BIU(Int4 L,Int4 D,Int4 *pos,long double *binp,Int4 jeff,Int4 cflag,
			long double &pval);
	//================= inline routines ====================
	Int4	FindIndex(Int4 s){
		   for(Int4 i=1; i <= num_resC; i++){
			if(ResidueID(ResALL[i]) == s) return i; 
		   } return 0;
		}
	//=================== dcm_init.cc =======================
        void	Init2(edc_typ *S);
	void	Free2();
	void	Shuffle();
	//=====================================
	Int4	NumDistinguished,CC,resStart,resEnd,num_resC;
	float	**MtrxPDB,**MtrxDCA,**MtrxBPPS;
	char    **AdjChn,chain;		// AdjChn[i][j] = chain for j only.
	BooLean	InitOkay,UseHydrogens;
	BooLean **Used;		// index to residue positions or to position in ResALL array?
	pdb_typ PDB;
	e_type	pdbE;
	set_typ	SetBPPS,DistPairSet;
	res_typ	*ResALL;
#if 1	// Added to avoid memory leak
	long double  *lni,*lrat,*offset;
	Int4     oldL,oldD;
#endif
};

#endif

