/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "dci_typ.h"

void	dch_typ::Free()
{
	double  key,s0;
	Int4    item;
	char	*chns,*id;
	dci_typ *dci=NULL;
	while((dci=DelMax(key,item,chns,id,s0)) != NULL){
		// dci->PutResults(stderr,'M',chns,id,s0);
		free(id); free(chns); delete dci; 
	}
	NilMheap(mH); free(DCI); free(Chns); free(pdbid); free(S0);
}

long double dch_typ::RtnMaxResults(Int4 &D,Int4 &d,Int4 &X,Int4 &L)
{
	Int4    i,j,item;
	double  key,s0,Prs;
	long double dd,S;
	char	*chns,*id;
	dci_typ *dci=this->DelMax(key,item,chns,id,s0);
	if(dci){ 
	  D=dci->RtnDstngshPrs();
	  d=dci->RtnLftDstngshPrs();
	  X=dci->RtnOptCutPnt();
	  L=dci->RtnNumPairsL(); 
	  S=dci->RtnScores(dd); 
// fprintf(stderr,"NEW: S=%.3Lf; X=%d; d=%d; D=%d; L=%d; S=%.3Lf\n",S,X,d,D,L);
	  free(chns); free(id); delete dci;
	} else S = -1.0;
	return S;
}

Int4	dch_typ::RtnResults(FILE *fp,double &AvgS,double &AvgL,Int4 mindist,char mode)
// Use this for COMPASS program.
{
	double  key,s0,TotNumPrs=0.0;
	long double dd,Total=0.0;
	Int4    i,j,item;
	char	*chns,*id;
	dci_typ *dci=0;
	h_type	HG=0; // HG=Histogram("S-scores",0,1000,5.0);
	if(ItemsInMheap(mH) == 0){ if(fp) fprintf(fp,"DCA heap is empty.\n"); return 0; }
	if(fp) fprintf(fp,"pdbid\tchn(s)\tScore\tL\tMD\n");
	for(j=i=0; (dci=DelMax(key,item,chns,id,s0)) != NULL; ){
	   i++;  
	   if(strlen(chns) == 1){
		long double S=dci->RtnScores(dd); Total += S; j++;
		double Prs=dci->RtnNumPairsL(); TotNumPrs += Prs;
		if(fp) fprintf(fp,"%s\t%s\t%.2Lf\t%.0lf\t%d\n",id,chns,S,Prs,mindist);
		if(HG) IncdHist((double)dci->RtnScores(dd),HG);
	   } free(id); free(chns); delete dci;
	}
	if(0) fprintf(fp,"\tAvg. S-score=%LG; Avg. #pairs=%.1lf; %.4LG millinats/pair\n",
		Total/(long double)i,TotNumPrs/(double)i,
		2302.5851*(Total/(long double)TotNumPrs));
	if(HG) { PutHist(stdout,60,HG); NilHist(HG); }
	AvgS=(double)(Total/(long double)i);
	AvgL=(double)(TotNumPrs/(double)i);
	return j;
}

Int4	dch_typ::Put(FILE *fp,char mode)
{
	double AvgS,AvgL;
	Int4 rtn=this->Put(fp,AvgS,AvgL,mode); return rtn;
}

Int4	dch_typ::Put(FILE *fp,double &AvgS,double &AvgL,char mode)
{
	double  key,s0,TotNumPrs=0.0;
	long double dd,Total=0.0;
	Int4    i,item;
	char	*chns,*id;
	dci_typ *dci=0;
h_type	HG=0; // HG=Histogram("S-scores",0,1000,5.0);
	if(ItemsInMheap(mH) == 0){ fprintf(fp,"DCA heap is empty.\n"); return 0; }
	fprintf(fp,"pdbid\tchn(s)\tr(A)\tScore\tBiU\tL\tD\tX\td\tF\tdS\n");
	for(i=0; (dci=DelMax(key,item,chns,id,s0)) != NULL; ){
		i++;  
		if(mode==0) dci->PutResults(fp,'M',chns,id,s0);
		else dci->PutResults(fp,mode,chns,id,s0);
		Total += dci->RtnScores(dd);
		TotNumPrs += dci->RtnNumPairsL();
if(HG) IncdHist((double)dci->RtnScores(dd),HG);
		free(id); free(chns); delete dci;
	} fprintf(fp,"\tAvg. S-score=%LG; Avg. #pairs=%.1lf; %.4LG millinats/pair\n",
		Total/(long double)i,TotNumPrs/(double)i,
		2302.5851*(Total/(long double)TotNumPrs));
if(HG) { PutHist(stdout,60,HG); NilHist(HG); }
	AvgS=(double)(Total/(long double)i);
	AvgL=(double)(TotNumPrs/(double)i);
	return i;
}

Int4	dch_typ::Insert(dci_typ *dci, char *chns,char *id, double s0)
{
	long double biuS,S=dci->RtnScores(biuS);
	Int4	L= dci->RtnNumPairsL();
	// double key=100.0*(double)S/(double)L;
	double key=(double)S;
#if 0
	double minkey = MinKeyMheap(mH);
	if(minkey < -key){
		// need to delete associated objects...
	}
#else
	if(FullMheap(mH)){
	    fprintf(stderr,"%d items in heap of size %d\n",ItemsInMheap(mH),SizeMheap(mH));
	    print_error("dch_typ::Insert() full; need to increase heapsize");
	} assert(!FullMheap(mH));
#endif
	Int4	item=InsertMheap(key, mH); 
	if(item==0) return 0;	// failed to insert...?
	Chns[item]=AllocString(chns); DCI[item]=dci; 
	pdbid[item]=AllocString(id); S0[item]=s0;
	return item;
}

dci_typ *dch_typ::DelMin(double &key, Int4 &item, char *&chns, char *&id, double &s0)
{
	key = MinKeyMheap(mH); item = DelMinMheap(mH); 
	if(item==0) return NULL;
	dci_typ *dci= DCI[item]; DCI[item]=NULL; 
	chns=Chns[item]; Chns[item]=NULL;
	id=pdbid[item]; pdbid[item]=NULL;
	s0=S0[item]; S0[item]=0;
	return dci;
}

dci_typ *dch_typ::DelMax(double &key, Int4 &item, char *&chns, char *&id, double &s0)
{
	key = MaxKeyMheap(mH); item = DelMaxMheap(mH); 
	if(item==0) return NULL;
	dci_typ *dci= DCI[item]; DCI[item]=NULL;
	chns=Chns[item]; Chns[item]=NULL;
	id=pdbid[item]; pdbid[item]=NULL;
	s0=S0[item]; S0[item]=0;
	return dci;
}

