/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined (_SCH_TYP_)
#define _SCH_TYP_

#include "stdinc.h"
#include "pdb.h"
#include "dheap.h"
#include "swaln.h"
#include "cmsa.h"
#include "set_typ.h"
#include "chn_vsi.h"

	//================== structural cluster heap ======================
class	sch_typ {	// structural cluster heap.
public:
	   sch_typ(){ print_error("sch_typ( ) constructor is disallowed"); }
	   sch_typ(Int4 n,Int4 mnp, Int4 strt,Int4 end, char cls, set_typ stX, 
			res_typ *RA, a_type ab){
	     resEnd=end; size=n; mH=Mheap(size,3); NEWP(SCI,size +5, sci_typ);Clss=cls; 
	     resStart=strt; MaxNumPttrns=mnp; Bonferroni=size;
	     // Warning: cannot make Mheap > size of n=MaxPrint or else will return erroneous values..
	     ResALL=RA; AB=ab; SetX=stX; // don't own these...
	   }
           ~sch_typ( ){ Free(); }

	sch_typ	*GetSets(Int4 &II,double *&pval, Int4 *&II2ii,set_typ *&SetII);
	set_typ	Put(FILE *fptr, FILE *vsifp, FILE *efp, FILE *tfp, char FullCluster=0, char *aStr=0, 
			double cutoff=0.05, BooLean PutAll=FALSE,BooLean TakeUnion=FALSE,
			Int4 *PttrnSites=0);
	Int4	Insert(Int4 id, Int4 bstm,Int4 mxstr,Int4 *strng,double p){
		if(mxstr < 1) return 0;
		Int4 i=InsertMheap((keytyp)p,mH);
		if(i==0) return 0;
		if(SCI[i]){ delete SCI[i]; }
		SCI[i]= new sci_typ(id,bstm,mxstr,strng,p);
		return i;
	}
	Int4	PrintVSI(FILE *fptr, Int4 i){ return PrintSite(fptr,i,'v'); }
	Int4	PrintWhiteVSI(FILE *fptr, Int4 i){ return PrintSite(fptr,i,'W'); }
	Int4	PrintSite(FILE *fptr, Int4 ii, char mode='m',FILE *tfp=0);
	void	PutItem(FILE *fp, Int4 i){ if(SCI[i]!=0){ SCI[i]->Put(fp); } }
	Int4	Remove(Int4 i){
		   if(i < 1 || i > size) return 0;
		   Int4 rtn=RmMheap(i,mH);
		   if(rtn == 0) return 0;
		   assert(SCI[i]); delete SCI[i]; SCI[i]=0;
		   return rtn;
		}
	Int4	DeleteMin(Int4 &id, Int4 &bstm,Int4 &maxstr,Int4 *&strng,double &p){
		Int4 i=DelMinMheap(mH); 
		if(i==0) return 0;
		SCI[i]->Rtn(id,bstm,maxstr,strng,p); delete SCI[i]; SCI[i]=0;
		return i;
	}
private:
	Int4	Bonferroni;
	class sci_typ {	// structural cluster information type.
	public:
	   	  sci_typ(){ print_error("sci_typ( ) constructor is disallowed"); }
		  sci_typ (Int4 id, Int4 bstm,Int4 mxstr,Int4 *strng,double p){
			ID=id; pval=p; bestm=bstm; MaxStr=mxstr; String=strng;
		  }
		  ~sci_typ(){ if(String) free(String); }
		sci_typ *Copy(){
			   sci_typ *sci= new sci_typ(ID,bestm,MaxStr,this->CopyStrng(),pval);
			   return sci;
			}
		void	Rtn(Int4 &id, Int4 &bstm,Int4 &maxstr,Int4 *&strng,double &p){
		   		id=ID; bstm=bestm; maxstr=MaxStr; strng=String; p=pval;
		   		String=0; ID=bestm=MaxStr=0; pval=0;
		}
		void	Put(FILE *fp){
			   fprintf(fp,"bestm=%d; MaxStr=%d; ID=%d; pval=%g\n",bestm,MaxStr,ID,pval);
			}
		
		double	pvalue(){ return pval; }
		double	pval;
		Int4	bestm,MaxStr,ID,*String; 
	private:
		Int4	*CopyStrng(){
			   Int4 i,*s; NEW(s,MaxStr+9,Int4);
			   for(i=0; i <= MaxStr; i++) s[i]=String[i]; 
			   return s;
			}
	};
	sch_typ	*Copy(){
		  sch_typ *sch = new sch_typ(size,MaxNumPttrns,resStart,resEnd,
					Clss,CopySet(SetX),ResALL,AB);
		  for(Int4 i=1; i <= size; i++){
		     if(SCI[i]){ Int4 x=sch->Insert(SCI[i]->Copy()); assert(x != 0); }
		  } return sch;
		}
	Int4	Insert(sci_typ *sci){
		    Int4 i=InsertMheap((keytyp)sci->pvalue(),mH);
		    if(i==0) return 0;
		    if(SCI[i]){ delete SCI[i]; }
		    SCI[i]= sci; return i;
		}
	sci_typ **SCI;
	void	Free( ){
	  Int4 i;
	  // AB=0;
	  while((i=DelMinMheap(mH))){
	    Int4 id; Int4 bstm,maxstr,*strng; double p;
	    if(SCI[i]){ 
		   SCI[i]->Rtn(id, bstm,maxstr,strng,p);
		   if(strng) free(strng); delete SCI[i]; 
	    }
	  } free(SCI); NilMheap(mH);
	}
	mh_type	mH;
	res_typ	*ResALL;
	set_typ	SetX;
	a_type	AB;
	Int4	size,MaxNumPttrns,resStart,resEnd,Clss; // Clss = 'M', 'R', etc.
}; //================== structural cluster heap ======================

#endif

