/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "spc_typ.h"
#include "spc_usage.h"

void	spc_typ::CreateMtrx(pdb_typ pdb)
// Create contact matrix...
{
	Int4	i,j,x;
	i=GetChainNumberPDB(pdb,Chain[0]);
        e_type Sq=GetPDBSeq(i,pdb);
        a_type AB=AminoAcidAlphabetPDB(pdb);
	if(mode=='S' && PlotGrph){	// Create contact matrix...
	  assert(wdgfile != 0); 
	  NEWP(Mtrx,EndMtrx+3, char);
	  NEW(IsBB,EndMtrx+3,set_typ);
	  NEW(IsSC,EndMtrx+3,set_typ);
	  NEW(ResMtrx,EndMtrx+3, char);
	  Int4 os=OffSetSeq(Sq);
	  for(i=StrtMtrx; i <= EndMtrx; i++){
		ResMtrx[i]=AlphaChar(ResSeq(i-os,Sq),AB);
		NEW(Mtrx[i],EndMtrx+3, char);
	  	IsBB[i]=MakeSet(EndMtrx+4); ClearSet(IsBB[i]);
	  	IsSC[i]=MakeSet(EndMtrx+4); ClearSet(IsSC[i]);
	  }
	  UseSB=MakeSet(EndMtrx+4); ClearSet(UseSB);
	  FILE *mfp=open_file(wdgfile,"","r");
	  cma_typ cma=ReadCMSA(mfp,AB); fclose(mfp);
	  e_type qE=TrueSeqCMSA(1,cma);
	  Int4	start;
	  Int4 MinOverlap=10,MaxMisMatch=0;
	  if(OverlappingSeqs(start,qE,Sq, MinOverlap,MaxMisMatch)){
	     if(start < 0){ x=1; start = -start;} else x=2;
	  } else x=0;
	  // return TRUE if E1 & E2 are overlapping fragments of the same sequence.
	  // This sets offset > 0 if query starts before pdbseq else it sets dcaOS <= 0.

	  if(x <= 0){
	  	fprintf(stderr,"x=%d; start=%d\n",x,start);
	  	PutSeq(stderr,Sq,AB); PutSeq(stderr,qE,AB);
	  	AlnSeqSW(stderr,11, 1,qE, Sq, AB); exit(1);
	  } else if(0){
	      fprintf(stderr,"x=%d; start=%d; StrtMtrx=%d\n",x,start,StrtMtrx);
	      PutSeq(stderr,Sq,AB); PutSeq(stderr,qE,AB);
	      AlnSeqSW(stderr,11, 1,qE, Sq, AB);
	  }
	  // x == 1 --> qE a subseq of Sq; 
	  // x == 2 --> Sq a subseq of qE;
	  // x == 3 --> Sq == qE.
	  Int4 pos[10],sq=1,site;
	  unsigned char r;
	  assert(PosSiteCMSA(1, sq, pos, cma));
	  float   *RE=RelEntropyCMA(1,cma);
	  double  **Frq=ColResFreqsCMSA(1,cma);
	  wdg=MakeWdgraph(EndMtrx+4,EndMtrx+4);
	  AddVerticesWdgraph(EndMtrx, wdg);
	  h_type HG=Histogram("relative entropy",0,10,0.1);
	  for(i=1; i <= LengthCMSA(1,cma); i++){
		if(IsDeletedCMSA(1, pos[1] + i - 1 , cma)) continue;
		site=TruePosCMSA(sq, i,cma);
		if(site > 0) r=ResSeq(site,qE);
if(x == 1) site += start+StrtMtrx-1;
else if(x == 2) site += StrtMtrx-start-1;
else site += StrtMtrx-1;
		double dd=0.0;
		Int4	nFrq=0;
		char	c=AlphaChar(r,AB),str[30];
		if(strchr("XCSTNDEQKRH",c) != 0){
	          for(Int4 R=1; R <= nAlpha(AB); R++){
		     if(valAlphaR(r,R,AB) < 0) continue;
		     if(Frq[i][R] > 0.20){
		        str[nFrq]=AlphaChar(R,AB); dd+=Frq[i][R]; nFrq++; 
		     }
		  } str[nFrq]=0;
		  if(dd >= 0.75){
		     if(0) fprintf(stderr,"%d: %c%d; RE=%.3f; Frq=%.3lf (%d); %s\n",
			i,AlphaChar(r,AB),site,RE[i],dd,nFrq,str);
		     IncdHist(RE[i],HG); 
		     // AddSet(site,UseSB);
		     AddSet(site,UseSB);
	          }
		} free(Frq[i]);
	  } // PutHist(stderr,60,HG); 
	  NilHist(HG); free(RE); free(Frq);
	  for(i=StrtMtrx; i <= EndMtrx; i++){
	    // Int4 fake_pos=RealToFakeCMSA(1,i,cma);
	  }
	  // BooLean *skip=0; ResidueDiversityCMSA(stderr,skip,cma);
	  TotalNilCMSA(cma);
	} NilSeq(Sq); 
}

void	spc_typ::PutSubGraphs(FILE *mfp)
{
	if(!(PlotGrph && Mtrx)) return;
        FILE *fp;
	char str[100],c;
	a_type AB=MkAlpha(AMINO_ACIDS,GBLAST_BLOSUM62);
	// FILE *mfp=open_file(argv[1],".mtrx","w");
	Int4 i,j,k;
	for(i=StrtMtrx; i <= EndMtrx; i++){
	      if(Mtrx[i][0] == 0) continue;
	      fprintf(mfp,"%c%d(%d)\t",ResMtrx[i],i,Mtrx[i][0]);
	      for(j=StrtMtrx; j <= EndMtrx; j++){
#if 0
		 if(Mtrx[i][j] == 0) fprintf(mfp," ");
		 else if(Mtrx[i][j] < 10) fprintf(mfp,"%d",Mtrx[i][j]);
		 else fprintf(mfp,"*");
#else
		 if(Mtrx[i][j] > 0){
		   c='?';
		   if(MemberSet(j,IsBB[i])) c='b';
		   if(MemberSet(j,IsSC[i])){ if(c=='b') c='*'; else c='s'; }
		   fprintf(mfp,"%c%d(%d)%c ",ResMtrx[j],j,Mtrx[i][j],c);
		 }
#endif
	      }	fprintf(mfp,"\n");
	} fprintf(mfp,"\n"); // if(mfp != stdout) fclose(mfp);

	PutWdgraph(mfp,wdg);
	Int4 *path,*dist;
	NEW(path,EndMtrx+8,Int4); NEW(dist,EndMtrx+8,Int4);
	Int4 r,s,e,NumBonds=0;
#if 1
	for(s=StrtMtrx; s < EndMtrx; s++){
	      for(e=s+1; e <= EndMtrx; e++){ if(Mtrx[s][e] > 0) NumBonds++; }
	} fprintf(mfp,"NumBonds=%d\n",NumBonds);
#endif
      set_typ SetUsed=CopySet(UseSB);  ClearSet(SetUsed);
      set_typ SetTmp=CopySet(UseSB);  ClearSet(SetTmp);
      FILE *pfp=open_file(wdgfile,".pml","w");
      this->PutHeaderPyMOL(pfp);
      for(s=StrtMtrx; s < EndMtrx; s++){
	if(!MemberSet(s,UseSB)) continue;
	if(MemberSet(s,SetUsed)) continue;
	if(ShortestPathWdgraph(wdg,s,path,dist)) print_error("cycle in graph");
        for(e=s+1; e <= EndMtrx; e++){
	   if(!MemberSet(e,UseSB)) continue;
	   // if(Mtrx[e][path[e]] == 0) continue;
	   if(dist[e]==INT4_MAX) continue;
	   if(MemberSet(e,SetUsed)) continue;
	   if(path[e] == s) continue; // skip length 1 paths
	   j=path[e]; c='?';
	   if(MemberSet(j,IsBB[e])) c='b';
	   if(MemberSet(j,IsSC[e])){ if(c=='b') c='*'; else c='s'; }
	   Int4 len=1;
	   fprintf(mfp,"start %c%d(%d)%c ",ResMtrx[e],e,Mtrx[e][path[e]],c);
           for(r=path[e]; r != s && r != 0; r = path[r]){
		len++;
	        j=path[r]; c='?';
	        if(MemberSet(j,IsBB[r])) c='b';
	        if(MemberSet(j,IsSC[r])){ if(c=='b') c='*'; else c='s'; }
                fprintf(mfp,"-> %c%d(%d)%c ",ResMtrx[r],r,Mtrx[r][path[r]],c);
                // fprintf(mfp,"-> %d ",r);
           } fprintf(mfp,"-> %c%d (dist = %d; len=%d)\n",
		ResMtrx[s],s,dist[e],len);
	   if(len >= 2){
		wdg_typ tree=RtnMinSpanningTree(0,s,wdg);
		ClearSet(SetTmp);
		Int4 n=AddTreeNodes2SetWDG(SetTmp,s,tree);
		UnionSet(SetUsed,SetTmp);
#if 1
	   	for(k=0,j=StrtMtrx; j <= EndMtrx; j++){
		   if(MemberSet(j,SetTmp)){
                	fprintf(mfp,"%c%d ",ResMtrx[j],j); k++;
			if(k % 10 ==0) fprintf(mfp,"\n");
		   }
		} fprintf(mfp,"\n");
	   	for(k=0,j=StrtMtrx; j <= EndMtrx; j++){
		   if(MemberSet(j,SetTmp)){
		     r=AlphaCode(ResMtrx[j],AB);
		     fprintf(pfp,
		       "cmd.create(\"%c%d_R\",\"resn %s and resi %d\")\n",
			ResMtrx[j],j,AARes[r],j);
	  	     fprintf(pfp, "cmd.show(\"sticks\",\"%c%d_R ",ResMtrx[j],j);
	  	     fprintf(pfp,
			"and not (name c or name n or name o or hydro)\")\n");
	  	     fprintf(pfp,"cmd.color(\"deepsalmon\",\"%c%d_R\")\n",
			ResMtrx[j],j);
	  	     fprintf(pfp,"cmd.set(\"seq_view\",0,\"%c%d_R\")\n",ResMtrx[j],j);
	  	     fprintf(pfp,"cmd.disable(\"%c%d_R\")\n",ResMtrx[j],j);
		   }
		}
#endif
#if 1
		fprintf(pfp,"cmd.create(\"Class_%c%d\",\"",ResMtrx[s],s);
	   	for(k=0,j=StrtMtrx; j <= EndMtrx; j++){
		   if(MemberSet(j,SetTmp)){
		     r=AlphaCode(ResMtrx[j],AB);
		     fprintf(pfp,"%c%d_R ",ResMtrx[j],j);
		   }
		} fprintf(pfp,"\")\n");
#endif
                fprintf(mfp,"%d nodes: ",n);
		PrintNewickTreeWDG(mfp,s,tree); fprintf(mfp,"\n");
		// PutSet(mfp,SetUsed);
	   	NilWdgraph(tree);
	   } else fprintf(mfp,"\n");
        }
       } NilSet(SetUsed);
      for(i=StrtMtrx; i <= EndMtrx; i++){
	      free(Mtrx[i]); NilSet(IsBB[i]); NilSet(IsSC[i]);
      } free(Mtrx); free(IsBB); free(IsSC); free(ResMtrx); NilSet(UseSB);
      if(pfp != stdout) fclose(pfp);
      NilWdgraph(wdg); NilAlpha(AB);
      fprintf(stderr,"PyMOL output files done.\n");
      return;
}

