/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "spc_typ.h"

#define MAX_angleDHA 90

double spc_typ::GetHBonds(FILE *fp,res_typ ResI,res_typ ResJ, Int4 cI,
			Int4 cJ,float dmax,pdb_typ P)
// Too redundant with other code; need to condense this at some point!
/** return the number of residues in chain cJ within distance dmax of atoms in 
residue res0 of chain cI **/
{
	Int4	aI,aJ,rI,rJ,resI,resJ;
	atm_typ	H,Donor,Accept;
	double	Min_d_HA=this->UnDefHBond; 
	
	if(cI > P->nchains || cI<1 || cJ >P->nchains || cJ<1) pdb_error("GetBondsPDB( ) input error"); 
	for(aI=1; aI <= ResidueAtomNumber(ResI); aI++){
	    if(!ResidueAtomHydrogens(aI,ResI)) continue;
	    Donor = AtomResidue(aI,ResI); resI=ResAtom(Donor);
	    if(SkipWeakHBonds && CarbonAtom(Donor)) continue;
	    // assert(IsAminoAcidAtom(Donor));
// if(IsWaterAtom(A)) continue;
	    if(P->maxres[cI] < resI) rI=0; else if(P->seq[cI]) rI=P->seq[cI][resI];  else rI=0; 
	    for(Int4 h=1; (H=ResidueAtomHydrogen(aI,h,ResI)); h++){
	       for(aJ = 1; aJ <= ResidueAtomNumber(ResJ); aJ++){
	          Accept = AtomResidue(aJ,ResJ); resJ=ResAtom(Accept);
		  if(HydrogenAtom(Accept) || (SkipWeakHBonds && CarbonAtom(Accept))) continue;
		  if(Accept == Donor) continue;
	          // assert(IsAminoAcidAtom(Accept));
		  switch (mode){
		   case 'm': if(!SideAtom(Donor) && !SideAtom(Accept)) continue;
		    break;
		   case 'B': if(SideAtom(Donor) || SideAtom(Accept)) continue;
		    break;
		   case 'S': if(!SideAtom(Donor) || !SideAtom(Accept)) continue;
		    break;
		   case 's': 
			if(!SideAtom(Donor) && !SideAtom(Accept)) continue;
			else if(SideAtom(Donor) && SideAtom(Accept)) continue;
		    break;
		   default: print_error("spc_typ->GetHBonds() illegal mode"); break;
		  }
	          if(P->maxres[cJ] < resJ) rJ=0; else if(P->seq[cJ]) rJ=P->seq[cJ][resJ]; else rJ=0;
		  if(cI==cJ && abs(resJ - resI) < 2) continue;
		  double d_HA = DistanceAtoms(H,Accept);
		  double angle_DHA = CalcAngle(Donor,H,Accept);
		  double d_DA = DistanceAtoms(Donor,Accept);
		  Min_d_HA = MINIMUM(double,Min_d_HA,d_HA);
		  // if(d_HA <= 2.5 && d_DA > d_HA && angle_DHA >= 90){
		  // if(d_HA <= (double) dmax && d_DA > d_HA && angle_DHA >= MAX_angleDHA){
		  if(fp && d_HA <= 2.5){
		    char *nameI=AtomLowerName(Donor),*nameJ=AtomLowerName(Accept);
		    fprintf(fp, "%.2f\t%.2f\t%.1f\t%c%d%c_%s-h\t%c%d%c_%s\n",
			d_DA,d_HA,angle_DHA,
			AlphaChar(rI,P->A),resI,AtomChain(Donor),nameI,
			AlphaChar(rJ,P->A),resJ,AtomChain(Accept),nameJ);
			// PutAtom(fp,Donor); PutAtom(fp,Accept);
		  }
	       }
	    }
	} return Min_d_HA;
}

BooLean	spc_typ::InvalidHbondPair(char rI, char rJ, char mode)
{
	if(SkipWeakHBonds){
            if(mode == 's'){		// sc2bb
               if(strchr("GAFVILMP",rI) && strchr("GAFVILMP",rJ)) return TRUE;
            } else if(mode == 'S'){	// sc2sc
		if(strchr("GAFVILP",rI) || strchr("GAFVILP",rJ)) return TRUE;
                if(strchr("DE",rI) &&  strchr("DE",rJ)) return TRUE;
                if(strchr("RK",rI) &&  strchr("RK",rJ)) return TRUE;
            } else if(mode == 'A') {	// aromatic-aromatic interactions
                if(!(strchr("WFYH",rI) &&  strchr("WFYH",rJ))) return TRUE;
            } else if(mode == 'P') {	// CH-pi interactions
                if(!(strchr("WFYH",rI) ||  strchr("WFYH",rJ))) return TRUE;
            } else if(mode == 'B') {	// bb2bb 
               // if(strchr("GAFVILMP",rI) && strchr("GAFVILMP",rJ)) return TRUE;
	    } else print_error("InvalidHbondPair() input error 1");
	} else {
            if(mode == 's'){
               if(strchr("GAVILP",rI) && strchr("GAVILP",rJ)) return TRUE;
            } else if(mode == 'S'){
                if(strchr("GAVILP",rI) &&  strchr("GAVILP",rJ)) return TRUE;
                if(strchr("DE",rI) &&  strchr("DE",rJ)) return TRUE;
                if(strchr("RK",rI) &&  strchr("RK",rJ)) return TRUE;
            } else if(mode == 'A') {	// aromatic-aromatic interactions
                if(!(strchr("WFYH",rI) &&  strchr("WFYH",rJ))) return TRUE;
            } else if(mode == 'P') {	// CH-pi interactions: need an aromatic residue
                if(!(strchr("WFYH",rI) ||  strchr("WFYH",rJ))) return TRUE;
            } else if(mode == 'B') { // then anything goes...
               // if(strchr("GAVILP",rI) && strchr("GAVILP",rJ)) return TRUE;
	    } else print_error("InvalidHbondPair() input error 2");
	} return FALSE;  // i.e., the residues ARE valid.
}

double	spc_typ::GetContactsPDB(FILE *fptr, Int4 resI,Int4 resJ, float HA_dmax,
		Int4 cI, Int4 cJ, pdb_typ P)
{
	char	rI,rJ;
 	return this->GetContactsPDB(fptr, resI,resJ,HA_dmax,cI,cJ,P,rI,rJ);
}

double	spc_typ::GetContactsPDB(FILE *fptr, Int4 resI,Int4 resJ, float HA_dmax,
		Int4 cI, Int4 cJ, pdb_typ P,char &rI, char &rJ)
// Move this routine to libpdb.a at some point:
{
	if(cI==0 || cJ==0){ print_error("chain not found!"); }

	Int4	i,j,I=0,J=0;
	res_typ *ResI,*ResJ,**ResALL;
	Int4	num_resC,*num_resALL;
	a_type	AB=AminoAcidAlphabetPDB(P);
	NEWP(ResALL,nChainsPDB(P)+3,res_typ); NEW(num_resALL,nChainsPDB(P)+3,Int4);
	ResALL[cI] = MakeResPDB(cI,&num_resALL[cI],P);
	if(cI != cJ) ResALL[cJ] = MakeResPDB(cJ,&num_resALL[cJ],P);

	ResI=ResALL[cI];
	for(i=num_resALL[cI]; i >= 1; i--){ if(ResidueID(ResI[i]) == resI) { I=i; break; } }

	ResJ=ResALL[cJ]; num_resC=num_resALL[cJ]; 
	for(j = num_resALL[cJ]; j >= 1; j--){ if(ResidueID(ResJ[j]) == resJ) { J=j; break; } }

	double Dd,dd=0.0;
	if(I != 0  && J != 0){
	   rI=GetCharResidue(ResI[I],AB);
	   rJ=GetCharResidue(ResJ[J],AB);
	   dd=this->GetHBonds(fptr,ResI[I],ResJ[J],cI,cJ,HA_dmax,P);
	   // I == donor; J == acceptor.
#if 1
	   if(fptr) fprintf(fptr,"------------------------------\n");
	   Dd=this->GetHBonds(fptr,ResJ[J],ResI[I],cJ,cI,HA_dmax,P);
	   // J == donor; I == acceptor.
	   dd = MINIMUM(double,dd,Dd);
#endif
	} else rI=rJ='X';
	for(cJ=1; cJ <= nChainsPDB(P); cJ++){ 
		for(i=1; i <= num_resALL[cJ]; i++) NilRes(ResALL[cJ][i]);
		free(ResALL[cJ]);
	} free(ResALL); free(num_resALL);
	return dd;
} 

//========================= min Distance code ======================
 // char chnC, char chnD, 
/************************************************************
 ************************************************************/
double	spc_typ::Res2HeteroDist(FILE *fptr, Int4 resI,Int4 C, pdb_typ P,
		const char *HeteroMol,const char *HetAtm)
{
	Int4 res0,ai,a,r,i,j,x,D,num_resI,num_resD,nI,nJ;
	if(C==0){ print_error("chain not found!"); }
	res_typ *ResAllC=MakeResPDB(C,&num_resI,P);

	a_type AB = AminoAcidAlphabetPDB(P);
	// Find minimum Res-Res distance ...
	atm_typ	atmI,atmJ,minAI,minAJ;
	res_typ	ResI;
	char	cI,*mole_name,str[100],hetmol[100],HetMol[100];
	double	min=BigDist,dd,maxdist=20.0;
	for(i=0; HeteroMol[i]; i++) hetmol[i]=tolower(HeteroMol[i]); hetmol[i]=0;
	for(i=0; HeteroMol[i]; i++) HetMol[i]=toupper(HeteroMol[i]); HetMol[i]=0;
#if 0
	for(i=1; i <= num_resI; i++){
	   ResI=ResAllC[i]; cI=GetCharResidue(ResI,AB); nI=ResidueID(ResI);
// fprintf(stderr,"Debug 2: resI=%c%d\n",cI,nI);
	   if(nI != resI) continue;
// PrintResidueAtoms(stderr,ResI);
	   for(ai=1; ai <= ResidueAtomNumber(ResI); ai++){
	     atmI=AtomResidue(ai,ResI);
#else
	{
// fprintf(stderr,"'%s' or '%s'\n",hetmol,HetMol); exit(1);
	  for(i=1; i<= NumberAtomsPDB(C,P); i++) {
             atmI = AtomPDB(C,i,P);
	     if(!IsAminoAcidAtom(atmI)) continue;
	     nI=ResAtom(atmI);
	     if(nI != resI) continue;
#endif
	     for(D=1; D <= nChainsPDB(P); D++)
		    for(a=1; a<= NumberAtomsPDB(D,P); a++) {
               atmJ = AtomPDB(D,a,P);
               if(IsAminoAcidAtom(atmJ)) continue;
               if(IsWaterAtom(atmJ)) continue;
               if(IsHeteroAtom(atmJ)){
// PutAtom(stderr,atmJ);
                 if(DistanceAtoms(atmJ,atmI) <= maxdist){
                     mole_name=AtomResName(atmJ);
                     while(isspace(mole_name[0])){
                        mole_name++;
                        if(!isprint(mole_name[0])){
			   print_error("Res2HeteroDist() error");
			}
                     }
		     sprintf(str,"%s",mole_name);
                     for(x=1; isprint(str[x]) && !isspace(str[x]); ) x++;
		     if(str[x] != 0) str[x]=0;
// fprintf(stderr,"'%s'; '%s'\n",MoleName,HetMol); 
		     if(strcmp(str,hetmol) == 0 || strcmp(str,HetMol) == 0){
// fprintf(stderr,"%s == %s or %s == %s\n",str,hetmol,str,HetMol);
		       if(HetAtm && strcmp(HetAtm,AtomLowerName(atmJ)) != 0) continue;
		       dd=DistanceAtoms(atmI,atmJ);
		       if(dd < min){
#if 0
                          fprintf(stderr,"%c%d%c ... %s_%d%c_%s = %.2lf",
				cI,nI,AtomChain(atmI),
				str,ResAtom(atmJ),
				AtomChain(atmJ),AtomLowerName(atmJ),min);
#endif
			  min=dd; minAI=atmI; minAJ=atmJ; 
		       }
		     }
                }
               }
             }
           }
	}
	// if(min < 999) fprintf(stderr,"%s = %.2lf\n",str,min);
	for(i=1; i <= num_resI; i++) NilRes(ResAllC[i]); free(ResAllC); 
	return min;
} 

double	spc_typ::Res2ResDistance(FILE *fptr, Int4 resC,Int4 resD, Int4 C, Int4 D,
				pdb_typ P, BooLean noMainChn)
{
	Int4 res0,ai,aj,r,i,j,x,num_resC,num_resD,nI,nJ;
	if(C==0 || D == 0){ print_error("chain not found!"); }
	res_typ *ResAllD,*ResAllC=MakeResPDB(C,&num_resC,P);
	if(C != D) ResAllD=MakeResPDB(D,&num_resD,P);
	else { ResAllD=ResAllC; num_resD=num_resC; }

	a_type AB = AminoAcidAlphabetPDB(P);
	// Find minimum Res-Res distance ...
	atm_typ	atmI,atmJ,minAI,minAJ;
	res_typ	ResI,ResJ;
	char	cI,cJ;
	float	max,min,dd;
	for(i=1; i <= num_resC; i++){
	   ResI=ResAllC[i]; cI=GetCharResidue(ResI,AB); nI=ResidueID(ResI);
	   if(nI != resC) continue;
	   for(j=1; j <= num_resD; j++){
	        ResJ=ResAllD[j]; cJ=GetCharResidue(ResJ,AB);
	        nJ=ResidueID(ResJ);
	        if(nJ != resD) continue;
		dd=0.0; min=BigDist;
		for(ai=1; ai <= ResidueAtomNumber(ResI); ai++){
		  atmI=AtomResidue(ai,ResI);
		  if(noMainChn){
		    if(!(SideAtom(atmI) || (cI=='G' && AlphaCarbonAtom(atmI)))) continue;
		  }
		  //fprintf(stderr,"%s: \n",ResidueName(ResI)); PutAtom(stderr,atmI);
		  for(aj=1; aj <= ResidueAtomNumber(ResJ); aj++){
		    atmJ=AtomResidue(aj,ResJ);
		    if(noMainChn){
		      if(!(SideAtom(atmJ) || (cJ=='G' && AlphaCarbonAtom(atmJ)))) continue;
		    }
		    dd=DistanceAtoms(atmI,atmJ);
		    if(dd < min){ min=dd; minAI=atmI; minAJ=atmJ; }
		  }
		}
		if(fptr){
		  char chnI=ChainCharPDB(C,P),chnJ=ChainCharPDB(D,P);
		  fprintf(fptr,"%c%d%c\t%c%d%c\t%.2lf\n",cI,nI,chnI,cJ,nJ,chnJ,min); 
		  // PutAtom(fptr,minAI); PutAtom(fptr,minAJ);
		}
		for(x=1; x <= num_resC; x++) NilRes(ResAllC[x]); free(ResAllC); 
		if(C != D){ for(x=1; x <= num_resD; x++) NilRes(ResAllD[x]); free(ResAllD); }
		return min;
	   }
	}
	for(i=1; i <= num_resC; i++) NilRes(ResAllC[i]); free(ResAllC); 
	if(C != D) { for(i=1; i <= num_resD; i++) NilRes(ResAllD[i]); free(ResAllD);  }
	return 0.0;
} 

void	spc_typ::PutContacts(FILE *fptr, Int4 file_id, set_typ SetB, float HA_dmax,
	    float dmax,Int4 C, Int4 C2, char chain, BooLean *skip, char color,
		pdb_typ pdb, char Mode)
{
	Int4 res0;
	Int4 r,i,j,num_resA,num_resD;
	if(chain) C=GetChainNumberPDB(pdb,chain); // C = query residue chain.
	if(C==0){ 
		     fprintf(stderr,"chain = %c\n",chain);
		     print_error("chain not found!");
	}
	if(chain==0) chain='?';
	// Int4 Start,End;
	res_typ *ResCA,*ResOA,*ResCD,*ResOD,**ResALL;
	Int4	num_resC,num_resO,*num_resALL;
	NEWP(ResALL,nChainsPDB(pdb)+3,res_typ);
	NEW(num_resALL,nChainsPDB(pdb)+3,Int4);
	for(C2=1; C2 <= nChainsPDB(pdb); C2++){ 
	  ResALL[C2] = MakeResPDB(C2,&num_resALL[C2],pdb);
	}
	num_resC=num_resALL[C]; ResCA=ResCD=ResALL[C];

	// Move this routine to libpdb.a at some point:
	a_type AB = AminoAcidAlphabetPDB(pdb);
	Int4	MaxNeighbors=50; // maximum residue neighbors to look at
	res_typ	*Contact;
	double	contact_surface,*Ratio;
	NEW(Contact,MaxNeighbors+3,res_typ);
	NEW(Ratio,MaxNeighbors+3,double);

	for(res0=MinResPDB(C,pdb); res0 <= MaxResPDB(C,pdb); res0++){
	     if(!MemberSet(res0,SetB)) continue;	// skip unconserved residues...
	     if(skip && skip[res0]) continue;	// skip unconserved residues...
	     Int4	hpsz=0;
	     dh_type dH = dheap(MaxNeighbors,4);

     	    //********** Check out surface VDW contacts of res0 to nearby residues.
	    if(Mode==0) fprintf(fptr,"\n");
	  if(Mode==0 && !skip){ 
	     fprintf(fptr,"\n//*********** ResidueToResidueContacts (%d): ***********\n",res0);
	     for(j=1; j <= num_resALL[C]; j++){
	       if(ResidueID(ResCD[j]) == res0) {
		double total_ratio = 0.0;
		BooLean	SideChainOnly;
		char c_res = GetCharResidue(ResCD[j],AB);
		if(c_res == 'G') SideChainOnly=FALSE;
		else SideChainOnly=TRUE;
		for(C2=1; C2 <= nChainsPDB(pdb); C2++){ 
		   res_typ *ResC2 = ResALL[C2];
		   if(num_resALL[C2] > 0 && !isspace(ChainResidue(ResC2[1])))
			   fprintf(fptr,"//======== Chain %c ==========\n",
					   	ChainResidue(ResC2[1]));
	           for(hpsz=0,i=1; i <= num_resALL[C2]; i++){
		   	if(ResCD[j] == ResC2[i]) continue;
#if 1	// This removes non conserved residues from consideration:
			if(skip && C == C2){
				Int4 res2=ResidueID(ResC2[i]);
				if(skip[res2]) continue;
	     			if(!MemberSet(res2,SetB)) continue;	// skip unconserved residues...
			}
#endif
			double ratio;
	     		contact_surface = 
				ResidueToResidueContact(ResCD[j],ResC2[i],&ratio,SideChainOnly);
			if(contact_surface > 0.0){
				hpsz++;
				insrtHeap(hpsz,(keytyp)-contact_surface,dH);
				Ratio[hpsz]=ratio; total_ratio+= ratio;
				Contact[hpsz]=ResC2[i];
			}
		   }
		   Int4 hp_pos=1;
		   while(!emptyHeap(dH)){
			contact_surface = (double) -minkeyHeap(dH);
			assert((i=delminHeap(dH)) != 0);
			char    c2_res = GetCharResidue(Contact[i],AB);
			if(!isspace(ChainResidue(Contact[i]))){
			   fprintf(fptr,
				"#%c%d:%c.X  // %c%d:%c %.1f A^2 contact (%1.f%%:%d).\n",
					c2_res,ResidueID(Contact[i]),ChainResidue(Contact[i]),
					c_res,ResidueID(ResCD[j]),ChainResidue(ResCD[j]),
					contact_surface,Ratio[i]*100.0,hp_pos);
			} else {
			   fprintf(fptr,"#%c%d.X  // %c%d %.1f A^2 contact (%1.f%%:%d).\n",
					c2_res,ResidueID(Contact[i]),
					c_res,ResidueID(ResCD[j]),
					contact_surface,Ratio[i]*100.0,hp_pos);
			} hp_pos++;
			// PrintResidueSurface(fptr,ResCD[j]);
		   } hpsz=0;
		}
		Nildheap(dH);
		fprintf(fptr,"# total percent surface = %.1f\n",total_ratio*100.0);
		break;
	       }
	     }
	} //====================== end if(!skip)... =================
	     // find H-bonds...
	     for(C2=1; C2 <= nChainsPDB(pdb); C2++){ 
	      ResOD=ResOA=ResALL[C2];	// other than query residue.
	      num_resO=num_resALL[C2];
	      
	      if(Mode==0 && !skip) fprintf(fptr,
			"//=========== H-bond donor (%d:%c): ===========\n",res0,chain);
	      for(j=1; j <= num_resC; j++){
		if(ResidueID(ResCD[j]) == res0) {
		   if(skip){
		     if(C == C2){
			for(Int4 res2=1; res2 <=num_resO; res2++){
			  if(!skip[res2]) 
				FindHBondsPDB(fptr,ResCD[j],C,C2,HA_dmax,res2,color,file_id,pdb,Mode); 
			}
		     }
		   } else {
			// PrintResidueAtoms(stdout,ResCD[j]); // ResCD == query.
			// PutBondsInRes(stdout,ResCD[j]);
			FindHBondsPDB(fptr,ResCD[j],C,C2,HA_dmax,0,color,file_id,pdb,Mode);
		   }
		}
	      }
	      if(Mode==0 && !skip) fprintf(fptr,
			"//=========== H-bond acceptor (%d:%c): ===========\n",res0,chain);
	      for(j=1; j <= num_resO; j++){
//NOTE: !!!!!!!!!!! NEED TO modify FindHBondsPDB so that it can skip unconserved!!!!
#if 1	// This removes non conserved residues from consideration:
		if(skip){
		  if(C == C2){
			Int4 res2=ResidueID(ResOD[j]); 
			if(!skip[res2]) FindHBondsPDB(fptr,ResOD[j],C2,C,HA_dmax,res0,
						color,file_id,pdb,Mode); 
		  }
		  // 	FindHBondsPDB(fp,Res,C,C2,HA_dmax,Res2,0,pdb);
		} else FindHBondsPDB(fptr,ResOD[j],C2,C,HA_dmax,res0,color,file_id,pdb,Mode); // res0 is acceptor.
#endif
	      }

	      if(Mode==0 && !skip) fprintf(fptr,"//=========== pi-bonds: ===========\n");
	      for(i=1; i <= num_resC; i++){
		if(ResidueID(ResCD[i]) == res0){	// --> ResCA[i] == res0
	         for(j=1; j <= num_resO; j++){
#if 1	// This removes non conserved residues from consideration:
		  if(skip){
		    Int4 res2;
		    if(C == C2){
		      res2=ResidueID(ResOA[j]); 
		      if(!skip[res2]){
		       FindAromaticHbondsPDB(fptr,ResCD[i],ResOA[j],C,C2,dmax,color,pdb);
		       FindOtherPiHbondsPDB(fptr,ResCD[i],ResOA[j],C,C2,dmax,color,pdb);
		      }
		      res2=ResidueID(ResOD[j]); 
		      if(!skip[res2]){
		       FindAromaticHbondsPDB(fptr,ResOD[j],ResCA[i],C2,C,dmax,color,pdb);
		       FindOtherPiHbondsPDB(fptr,ResOD[j],ResCA[i],C2,C,dmax,color,pdb);
		      }
		    }
#endif
		  } else {
		   // PrintResidueAtoms(fptr,ResA[i]);
		   double dd=0;
		   FindAromaticHbondsPDB(fptr,ResCD[i],ResOA[j],C,C2,dmax,color,pdb,dd,Mode);
		   FindAromaticHbondsPDB(fptr,ResOD[j],ResCA[i],C2,C,dmax,color,pdb,dd,Mode);
		   FindOtherPiHbondsPDB(fptr,ResCD[i],ResOA[j],C,C2,dmax,color,pdb,dd,Mode);
		   FindOtherPiHbondsPDB(fptr,ResOD[j],ResCA[i],C2,C,dmax,color,pdb,dd,Mode);
		  }
		 }
		}
	      }
	     }
	 } //********** end of res0 loop... *****
	 for(C2=1; C2 <= nChainsPDB(pdb); C2++){ 
		for(i=1; i <= num_resALL[C2]; i++) NilRes(ResALL[C2][i]);
		free(ResALL[C2]);
	 } free(ResALL); free(num_resALL);
} 

Int4	spc_typ::GetContacts(FILE *fptr, set_typ SetB, float HA_dmax, Int4 cI,
			Int4 cJ, pdb_typ pdb, double Cutoff)
// Move this routine to libpdb.a at some point:
{
	if(cI==0 || cJ==0){ print_error("chain not found!"); }

	Int4	i,j,I=0,J=0,resI,resJ,hits;
	res_typ *ResI,*ResJ,**ResALL;
	Int4	*num_resALL;
	NEWP(ResALL,nChainsPDB(pdb)+3,res_typ); NEW(num_resALL,nChainsPDB(pdb)+3,Int4);
	ResALL[cI] = MakeResPDB(cI,&num_resALL[cI],pdb);
	if(cI != cJ) ResALL[cJ] = MakeResPDB(cJ,&num_resALL[cJ],pdb);
	ResI=ResALL[cI]; ResJ=ResALL[cJ]; 

	double Dd,dd=0.0;
	for(hits=0,i=num_resALL[cI]; i >= 1; i--){ 
	    resI=ResidueID(ResI[i]); I=i;
	    if(!MemberSet(resI,SetB)) continue;
	    for(j = num_resALL[cJ]; j >= 1; j--)
	    { 
		if(cI == cJ && i >= j) continue;
	        resJ=ResidueID(ResJ[j]); J=j; 
	        if(!MemberSet(resJ,SetB)) continue;
	        if(I != 0  && J != 0){
	           dd=this->GetHBonds(fptr,ResI[I],ResJ[J],cI,cJ,HA_dmax,pdb);
	           // I == donor; J == acceptor.
	  	   Dd=this->GetHBonds(fptr,ResJ[J],ResI[I],cJ,cI,HA_dmax,pdb);
	   	   // J == donor; I == acceptor.
		   dd = MINIMUM(double,dd,Dd);
		   if(dd <= Cutoff){ 
		      hits++;
	   	      if(fptr) fprintf(fptr,"------------------------------\n");
		   }
		}
	    }
	}
	for(cJ=1; cJ <= nChainsPDB(pdb); cJ++){ 
		for(i=1; i <= num_resALL[cJ]; i++) NilRes(ResALL[cJ][i]);
		free(ResALL[cJ]);
	} free(ResALL); free(num_resALL);
	return hits;
} 

