/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "spc_typ.h"
#include "spc_usage.h"

void    spc_typ::PutHeaderPyMOL(FILE *fp)
{
	Int4	i,j;
	if(fp == 0){ if(pmlfp == 0) return; else fp=pmlfp; }
	static char ChnColor[9][13]={"lightorange","palegreen","lightblue",
		"paleyellow", "lightpink","palecyan", "bluewhite","wheat","gray70"};
	fprintf(fp,"cmd.color(\"gray90\",\"all\")\n");
	// fprintf(fp,"bg_color white\n");
	for(i=0; Chain[i]; i++){
	     j = i%8;
	     fprintf(fp,"cmd.color(\"%s\",\"chain %c\")\n",ChnColor[j],Chain[i]);
	}
	fprintf(fp,"cmd.color(\"cyan\",\"hetatm\")\n");
	fprintf(fp,"cmd.set(\"cartoon_transparency\",0.6)\n");
	fprintf(fp,"cmd.set(\"stick_radius\",\"0.40\",\"all\")\n");
	fflush(fp);
}

void	spc_typ::PutResPairPyMOL(Int4 ri,char rI,Int4 nI,Int4 rj,char rJ,Int4 nJ)
{
	if(pmlfp==0) return;
	fprintf(pmlfp,"cmd.create(\"%c%d_%c%d\",",rI,nI,rJ,nJ);
        fprintf(pmlfp, "\"((resn %s and resi %d) or (resn %s and resi %d))",
                                AARes[ri],nI,AARes[rj],nJ);
        fprintf(pmlfp, " and (chain %c ",Chain[0]);
        for(Int4 i=1; Chain[i]; i++) fprintf(pmlfp," or chain %c",Chain[i]);
        fprintf(pmlfp,")\")\n");
        fprintf(pmlfp,"cmd.show(\"sticks\",\"%c%d_%c%d ",rI,nI,rJ,nJ);
        fprintf(pmlfp,"and not (name c or name n or name o or hydro)\")\n");
        if(0) fprintf(pmlfp,"cmd.color(\"deepsalmon\",\"%c%d_%c%d\")\n",
                                        rI,nI,rJ,nJ);
        else fprintf(pmlfp,"cmd.color(\"tv_red\",\"%c%d_%c%d\")\n",
                                        rI,nI,rJ,nJ);
        fprintf(pmlfp,"cmd.set(\"seq_view\",0,\"%c%d_%c%d\")\n",rI,nI,rJ,nJ);
        fprintf(pmlfp,"cmd.disable(\"%c%d_%c%d\")\n",rI,nI,rJ,nJ);
        fflush(pmlfp);
}

void	spc_typ::PutResiduePyMOL(Int4 ri,char rI,Int4 nI,char HetMol[])
{
	if(pmlfp==0) return;
        fprintf(pmlfp,"cmd.create(\"%c%d_%s\",",rI,nI,HetMol);
        fprintf(pmlfp, "\"((resn %s and resi %d)",AARes[ri],nI);
        fprintf(pmlfp, " and (chain %c ",Chain[0]);
        for(Int4 i=1; Chain[i]; i++) fprintf(pmlfp," or chain %c",Chain[i]);
        fprintf(pmlfp,")\")\n");
        fprintf(pmlfp,"cmd.show(\"sticks\",\"%c%d_%s ",rI,nI,HetMol);
        fprintf(pmlfp,"and not (name c or name n or name o or hydro)\")\n");
        if(0) fprintf(pmlfp,"cmd.color(\"deepsalmon\",\"%c%d_%s\")\n",
        			rI,nI,HetMol);
        else fprintf(pmlfp,"cmd.color(\"tv_red\",\"%c%d_%s\")\n",
                                        rI,nI,HetMol);
        fprintf(pmlfp,"cmd.set(\"seq_view\",0,\"%c%d_%s\")\n",rI,nI,HetMol);
        fprintf(pmlfp,"cmd.disable(\"%c%d_%s\")\n",rI,nI,HetMol);
        fflush(pmlfp);
}


void    spc_typ::PutTailPyMOL()
{
	fprintf(pmlfp,"cmd.set(\"stick_radius\",\"0.40\",\"all\")\n");
}



