/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "spc_typ.h"
#include "spc_usage.h"

Int4	spc_typ::CountHbonds()
// return the number of residues in Set that form Hbonds with each other
{
// fprintf(stderr,"DABUG CHB\n");
	Int4	i,j,k,x,y,N,Hits,nChn,chn,*TotHits=0;
	char	Str[500],**buffer=0,c,str[100];
	Int4	*res_pos=0,vsi_id=0,bst_id=0,max_hits=0,NumStruct;
	set_typ Set[5];
	FILE	*tfp=stdout,*vfp;
	h_type	*HGM,*tHG,HG;
	HG=Histogram("the number of H-bonds above the cutoff",-2,100,1.0);
	Int4	MinRes=0,MaxRes=0;
	assert(argc > 4);
	FILE *ifp=open_file(argv[4],"","r");
	if(fscanf(ifp,"%s",Str) == 1){
	   NEW(res_pos,strlen(Str)+5,Int4);
	   x=ParseIntegers(Str,res_pos,USAGE_SPARC_HBONDS);
	   res_pos[0]=x;
	   y = x*(x-1)/2; NEWP(buffer,y,char);
	   // fprintf(stderr,"x=%d=%d\n",x,res_pos[0]);
	} else print_error(USAGE_SPARC_HBONDS);
	fclose(ifp);
	ifp=open_file(argv[2],"","r");
	for(NumStruct=0; fscanf(ifp,"%s\n",Str) == 1; ){
		NumStruct++;
	} rewind(ifp);
	vfp=open_file(argv[4],".vsi","w");
	for(N=0,vsi_id=0; fscanf(ifp,"%s\n",Str) == 1; )
	{
	  // fprintf(stderr,"%d.%s\n",N+1,Str);

	  //=========== Make the res_typ & pdb ===============
	  pdb_typ pdb = MakePDB(Str); N++; 
	  if(N==1){
	    NEW(TotHits,nChainsPDB(pdb)+3,Int4);
	    NEW(HGM,nChainsPDB(pdb)+3,h_type);
	    NEW(tHG,nChainsPDB(pdb)+3,h_type);
	    for(nChn=i=0 ; Chain[i]; i++){
	      sprintf(str,"the number of H-bonds for chain %c",Chain[i]);
	      HGM[i]=Histogram(str,-2,100,1.0);
	      sprintf(str,"the number of H-bonds for chain %c over time",Chain[i]);
	      tHG[i]=Histogram(str,0,NumStruct+20,20);
	      nChn++; j=GetChainNumberPDB(pdb,Chain[i]);
              MinRes=MAXIMUM(Int4,MinRes,MinResPDB(j,pdb));
              MaxRes=MAXIMUM(Int4,MaxRes,MaxResPDB(j,pdb));
	    }
	    Set[Ct]=MakeSet(MaxRes+4); ClearSet(Set[Ct]);
	    for(i=1; i <= res_pos[0]; i++){
	     // fprintf(stderr,"%d: %d\n",i,res_pos[i]);
	     if(res_pos[i] > MaxRes) print_error("FATAL: hbonds option input error");
	     AddSet(res_pos[i],Set[Ct]);
	    } free(res_pos); // PutSet(stderr,Set[Ct]);
	    Set[Rt]=Set[Lt]=Set[Ct];
	  }
	  res_typ  **ResALL;
	  Int4     *num_res;
	  NEWP(ResALL,nChainsPDB(pdb)+3,res_typ);
	  NEW(num_res,nChainsPDB(pdb)+3,Int4);
	  for(i=0 ; Chain[i]; i++){
	    j=GetChainNumberPDB(pdb,Chain[i]);
	    ResALL[j]=MakeResPDB(j,&num_res[j],pdb);
	  }
	  //=========== Make the res_typ ===============
          for(i=0,j=nChn-1,k=1; Chain[i]; i++,k++,j=i-1){
	    if(Chain[k]==0) k=0; tfp=tmpfile();
	    Hits=0;
	    this->CisHbonds(Set[Ct],buffer,Chain[i],Hits,ResALL,num_res,pdb,tfp);
	    if(nChn > 1){
              this->TransLeftHbonds(Set,buffer,Chain[i],Hits,ResALL,num_res,pdb,tfp);
              this->TransRightHbonds(Set,buffer,Chain[i],Hits,ResALL,num_res,pdb,tfp);
	    }
	    if(Hits >= MinNumBonds){
		vsi_id++;
		fprintf(vfp,"~$=%d.\n",vsi_id);
		fprintf(vfp,"File1=%s:%c  // \n\n1-10000.W15\n\n",Str,Chain[i]);
		fprintf(vfp,"%d-%d:%c.G80\n",MinRes,MaxRes,Chain[j]); // G=palegreen
		fprintf(vfp,"%d-%d:%c.B80\n",MinRes,MaxRes,Chain[i]); // B=lightblue
		fprintf(vfp,"%d-%d:%c.M80\n\n",MinRes,MaxRes,Chain[k]); // M=lightpink
		rewind(tfp); c=fgetc(tfp); // skip initial ',' character.
		while((c=fgetc(tfp)) != EOF) fprintf(vfp,"%c",c); fclose(tfp);
		fprintf(vfp,"\n\n");
	       	fprintf(stdout,"%d: %d hits(chain %c) '%s'\n",
				vsi_id,Hits,Chain[i],Str);
	        for(j=1; buffer[j]; j++) fprintf(stdout,"%d:%s\n",j,buffer[j]);
		fprintf(stdout,"\n");
	        IncdHist(Hits,HG); TotHits[i] += Hits;
	    } else fclose(tfp);
	    if(Hits > max_hits){
		bst_id=vsi_id; max_hits=Hits; 
	    }
	    IncdMHist(N-1,Hits,tHG[i]); IncdHist(Hits,HGM[i]); TotHits[i] += Hits;
	    for(j=1; buffer[j]; j++){ free(buffer[j]); buffer[j]=0; }
          }

	  //=========== Free the res_typ & pdb ===============
	  for(x=1; x <= nChainsPDB(pdb); x++){ 
	     if(ResALL[x]){
		for(y=1; y <= num_res[y]; y++) NilRes(ResALL[x][y]);
		free(ResALL[x]);
	     }
	  } free(ResALL); free(num_res); NilPDB(pdb);
	} free(buffer); PutHist(stdout,60,HG); NilHist(HG);
	fprintf(vfp,"\n"); fclose(vfp);
#if 1	// create best PyMol file.
	char	*Argv[20];
	Int4	Argc;
	//sprintf(str,"chn_vsi %s.vsi 1 %d -T -skip=W -d2.5 -v -D",argv[4],bst_id);
	sprintf(str,"chn_vsi %s_X 1 %d -T -skip=W -d2.5 -v -D",argv[4],bst_id);
	Argc=string2argv(Argv,str);       // mode == 'T'
	FILE *xfp = tmpfile();
	vfp=open_file(argv[4],".vsi","r");
	ChainVSI(Argc,Argv,vfp,xfp); rewind(xfp); 
	for(Argc-- ; Argc >= 0; Argc--) free(Argv[Argc]);
	// while((c=fgetc(xfp)) != EOF) fprintf(stderr,"%c",c); rewind(xfp);
// exit(1);
	sprintf(str,"chn_vsi %s_X.crs 1 -d2.5 -c -D -pml=%s_%d",
		argv[4],argv[4],bst_id);
	Argc=string2argv(Argv,str);
	ChainVSI(Argc,Argv,xfp,0); fclose(xfp);
	for(Argc-- ; Argc >= 0; Argc--) free(Argv[Argc]);
#endif
        for(i=0; Chain[i]; i++){
	     PutHist(stdout,60,HGM[i]); NilHist(HGM[i]);
	     PutHist(stdout,60,tHG[i]); NilHist(tHG[i]);
	} free(HGM); free(tHG);
        for(i=0; Chain[i]; i++){
	    fprintf(stdout,"chain %c: %d\n",Chain[i],TotHits[i]);
	} NilSet(Set[Ct]); free(TotHits);
	return N;
}

