/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "spc_typ.h"
#include "spc_usage.h"

long double spc_typ::RunLoneSTARC(int argC, char *argV[],Int4 &hits)
// starc pdbs/1rp_H.pdb B:AC XXX_X
//   0       1           2     3
{
	Int4	i,j,C,C2,file_id=0,rtn=0;
	double	HA_dmax=2.5,dmax=3.6;
	long double dd=0.0,biuS=0.0;
// for(i=0; i < argC; i++) fprintf(stderr,"%d %s\n",i,argV[i]);
	edc_typ *edc= new edc_typ(argC,argV);
	dci_typ *dci=edc->RunDCA( ); 
	FILE	*efp=0; // efp=stderr;
	if(dci){ 
		char c,adj[9],*Chns=edc->RtnChains(); 
#if 0
		dci->PutResults(stdout,edc->Mode,Chns); free(Chns);
#endif
		dd=dci->RtnScores(biuS); delete dci; 
                Int4 *bpps=edc->RtnBPPS();
                set_typ SetB=0;
                if(bpps){
		    pdb_typ pdb=MakePDB(edc->pdbFileRtn());
		    if(efp) fprintf(efp,"======== %s ========\n",edc->pdbFileRtn());
                    SetB=MakeSet(5000);
                    for(i=1; i <= bpps[0]; i++) AddSet(bpps[i],SetB);
                    if(0 && SetB) PutSet(stderr,SetB);
#if 0
		    this->PutContacts(stdout,file_id,SetB,HA_dmax,dmax,C,C2,Chns[0],0,0,pdb,'X');
#else
		    sscanf(argV[2],"%c:%s",&c,adj);
		    C=GetChainNumberPDB(pdb,c);
		    C2=GetChainNumberPDB(pdb,c);
		    rtn=this->GetContacts(efp,SetB,HA_dmax,C,C2,pdb); // double Cutoff);
		    for(j=0; isalpha(adj[j]); j++){
		      C2=GetChainNumberPDB(pdb,adj[j]);
		      rtn += this->GetContacts(efp,SetB,HA_dmax,C,C2,pdb); // double Cutoff);
		    }
#endif
		    NilSet(SetB); NilPDB(pdb);
		}
		free(Chns);
	} delete edc; hits=rtn;
	return dd;
}

#if 0
//============================= COMPARE ==============================
BooLean	spc_typ::OverlappingSeqA(Int4 &offset, e_type E1, e_type E2, Int4 MinOverlap,
			Int4 MaxMisMatch)
/*************************************************************
return TRUE if E1 & E2 are overlapping fragments of the same sequence.
This sets offset > 0 if query starts before pdbseq else it sets dcaOS <= 0.
It also allows for 'X' residues in pdb files...

Start:					end1=21; end2=24; MinOverlap=5;
       	E1  ----+----+----+----+-     	start1=end1-MinOverlap+1 = 21-5+1=17;
                            |||||	start2 = 1;
	E2                  ----+----+----+----+----           
		:	:	:		(offset= start1 - start2 = 17 -1 = 16)
		:	:	:		( add 16 to second seq)
	E1  ----+----+----+----+-	
	    |||||||||||||||||||||		start1=start2=1 offset = 1 - 1 = 0
	E2  ----+----+----+----+----
		:	:	:	
		:	:	:	
End:					
	E1                     ----+----+----+----+-
                               |||||	
	E2  ----+----+----+----+----    start2=end2 - MinOverlap +1 = 24 -5 + 1 = 20       
					offset = 1 - 20 = -19 (add 19 to first seq)
 (move to sequence.cc eventually)
 *************************************************************/
{
	Int4	start1,start2,end1,end2;
	Int4	s1,s2,e1,e2,stop1,stop2;
	unsigned char	*sq1,*sq2;
	Int4    mismatches=0;

	end1=LenSeq(E1); end2=LenSeq(E2); sq1=SeqPtr(E1); sq2=SeqPtr(E2);
	stop1=end1 - MinOverlap +1; stop2=end2 - MinOverlap +1;
	// for(start1=stop1,start2=1; start1 >= 1 && start2 <= stop2; start1--,start2++)
        for(start1=stop1 ; start1 >= 1; start1--)
	   {
           for(start2=1; start2 <= stop2; start2++){

		mismatches=0;
		for(s1=start1, s2=start2; s1 <= end1 && s2 <= end2; s1++,s2++){
	       		if(sq1[s1]==0 || sq2[s2] == 0) continue;	// one or two == 'X'.
	       		if(sq1[s1] != sq2[s2]){ 
			   mismatches++;
			   if(sq1[s1] != 0 && sq2[s2] != 0 && mismatches > MaxMisMatch) break; 
			}	// allow for missing residues in pdb files...
		}
		if(s1 > end1 || s2 > end2){ offset= start1-start2; return TRUE; }
#if 0
		else {
		   fprintf(stderr,"start1=%d; end1=%d; offset=%d; start2=%d; end2=%d\n",
			start1,end1,start1-start2,start2,end2);
		}
#endif
	   }
	} offset=0; return FALSE;
}

BooLean	spc_typ::OverlappingSeqsC(Int4 &offset, e_type E1, e_type E2, Int4 MinOverlap,
			Int4 MaxMisMatch)
//edc_typ::
/*************************************************************
return TRUE if E1 & E2 are overlapping fragments of the same sequence.
This sets offset > 0 if query starts before pdbseq else it sets dca2pdbOS <= 0.
It also allows for 'X' residues in pdb files...

Start:					end1=21; end2=24; MinOverlap=5;
	E1  ----+----+----+----+-	
	    |||||||||||||||||||||	start1=start2=1 offset = 1 - 1 = 0
	E2  ----+----+----+----+----
		:	:	:		(offset= start1 - start2 = 17 -1 = 16)
		:	:	:		( add 16 to second seq)
	E1                     ----+----+----+----+-
                               |||||	
	E2  ----+----+----+----+----    start2=stop2 = end2 - MinOverlap +1 = 24 -5 + 1 = 20       
					offset = 1 - 20 = -19 (add 19 to first seq)
		:	:	:	
		:	:	:	
       	E1  ----+----+----+----+-     	start1=stop1=end1-MinOverlap+1 = 21-5+1=17;
                            |||||	start2 = 1;
	E2                  ----+----+----+----+----           

 (move to sequence.cc eventually)
 *************************************************************/
{
	Int4	start1,start2,end1,end2,s1,s2,e1,e2,stop1,stop2,mismatch,match,best=0;
	unsigned char	*sq1,*sq2;

	end1=LenSeq(E1); end2=LenSeq(E2); sq1=SeqPtr(E1); sq2=SeqPtr(E2);
	stop1=end1 - MinOverlap +1; stop2=end2 - MinOverlap +1; best=0;
// fprintf(stderr,"end1=%d; end2=%d; stop1=%d; stop2=%d\n",end1,end2,stop1,stop2);
        for(start1=start2=1; start2 <= stop2; start2++){
	   for(match=mismatch=0,s1=start1, s2=start2; s1 <= end1 && s2 <= end2; s1++,s2++){
		if(sq1[s1]==0 || sq2[s2] == 0) continue;  // skip one or two == 'X'.
	       	if(sq1[s1] == sq2[s2]) match++;
		else { mismatch++; if(mismatch > MaxMisMatch) break; }
	   }
	   if(s1 >= end1 || s2 >= end2){
	   	// fprintf(stderr,"s1=%d; s2=%d; match=%d; best=%d; offset=%d\n",s1,s2,match,best,offset);
		if(match >= MinOverlap && match > best){ best=match; offset=start1-start2; }
	   }
	}
        for(start1=start2=1; start1 <= stop1; start1++) {
	   for(match=mismatch=0,s1=start1, s2=start2; s1 <= end1 && s2 <= end2; s1++,s2++){
		if(sq1[s1]==0 || sq2[s2] == 0) continue;  // skip one or two == 'X'.
	       	if(sq1[s1] == sq2[s2]) match++;
		else {
#if 0
if(0) fprintf(stderr,"mismatch: %c%d != %c%d\n",AlphaChar(sq1[s1],AB),s1,
			AlphaChar(sq2[s2],AB),s2);
#endif
			mismatch++; if(mismatch > MaxMisMatch) break; 
		}
	   }
	   if(s1 >= end1 || s2 >= end2){
	   	// fprintf(stderr,"s1=%d; s2=%d; match=%d; best=%d; offset=%d\n",s1,s2,match,best,offset);
		if(match >= MinOverlap && match > best){ best=match; offset=start1-start2; }
	   }
	}
if(0) fprintf(stderr,"best = %d\n",best);
	if(best > 0) return TRUE; else return FALSE;
}
//============================= COMPARE ==============================
#endif

int	spc_typ::SetUpStarcMDS(Int4 argC,char *argV[])
// e.g., sparc bEBP_FG pdb_list 4LY6_A ABCDEF  ...
//    argV[0]    [1]     [2]      [3]   [4]    [5..]
{ 
	Int4	i,Cut,Size,NN,Num,thrds=1,x,A,arg;
	char    c,*Argv[20],str[5004],mode='P',chn=0;
	int     Argc=0;
	UInt4   Seed=18364592;
	BooLean	PutPyMOL=FALSE;
	Int4	time1=time(NULL);
	Int4	gpu_num=-1;

	// 0. Get parameters for the analysis.
	if(argC < 4) print_error(USAGE_SPARC_MDS);
	if(strlen(argV[3]) != 6) print_error(USAGE_SPARC_MDS);
	Cut=1; Size=1000; Num=2;
	for(arg=4; arg < argC; arg++){
	   if(argV[arg][0] != '-') print_error(USAGE_SPARC_MDS);
           switch(argV[arg][1]) {
               case 'd':
		  if(sscanf(argV[arg],"-dev=%d",&x) != 1) print_error(USAGE_SPARC_MDS);
		  else if(x < 0) print_error(USAGE_SPARC_MDS); else gpu_num=x;
//  fprintf(stderr,"argV[%d]=%s; gpu_num=%d\n",arg,argV[arg],gpu_num);
                  break;
               case 't':
		  if(sscanf(argV[arg],"-thrds=%d",&x) != 1) print_error(USAGE_SPARC_MDS);
		  else if(x < 1) print_error(USAGE_SPARC_MDS); else thrds=x;
                  break;
               default : print_error(USAGE_SPARC_MDS); break;
	   }
        }
	
	Int4	sq,Start=0,ncol=0,OffSet=0;
	e_type	keyE=0;
	FILE	*fp=0;
	a_type  AB=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
	{
	   // fprintf(stderr,"strlen(argV[1])=%d; (%d)\n",strlen(argV[1]),strlen(""));
	   fp=open_file(argV[1],"","r");
	   cma_typ cma=ReadCMSA(fp,AB); fclose(fp);
	   if(cma == NULL) print_error("FATAL: invalid input file");
	   assert(nBlksCMSA(cma) == 1);
	   ncol=LengthCMSA(1,cma); 
	   for(sq=1; sq <= NumSeqsCMSA(cma); sq++){
		e_type E=TrueSeqCMSA(sq,cma);
		StrSeqID(str,10,E);
		if(strlen(str) != 6) continue;
                if(str[4] != '_') continue;
                if(!isdigit(str[0])) continue;
		str[6]=0;
fprintf(stderr,"str='%s'; argV[3]='%s'\n",str,argV[3]);
		if(strcmp(str,argV[3]) == 0){ keyE=CopySeq(E); break; }
	   } TotalNilCMSA(cma);
	} 
	if(keyE){
	   for(i=0; i < 4; i++) str[i]=tolower(argV[3][i]); str[i]=0;
	   char filename[50]; sprintf(filename,"%s/%s_H.pdb",argV[2],str);
	   pdb_typ pdb=MakePDB(filename);
	   Int4 chn=GetChainNumberPDB(pdb,argV[3][5]);
	   e_type pdbE=GetPDBSeq(chn,pdb);
// AlnSeqSW(stderr,11,1,pdbE,keyE,AB);
	   NilPDB(pdb);
	   // 1. Find offset needed to map DC-pairs to pdb coordinates.
#if 0	
	   Int4 start;
	   if(IsSubSeq(keyE,pdbE,&start,TRUE)==0)	// sequence mismatch! 
	   {
	      fprintf(stderr,"\n\t======= pdb %s%c vs msa %s: =======",
					str,argV[3][5],argV[3]);
	      PutSeq(stderr,pdbE,AB); PutSeq(stderr,keyE,AB);
	      AlnSeqSW(stderr,11,1,pdbE,keyE,AB);
	      print_error("\tFATAL: pdb vs MSA sequence mismatch!\n");
	   } 
	   // PutSeq(stdout,keyE,AB); PutSeq(stdout,pdbE,AB);
#else
	   // PutSeq(stdout,keyE,AB); PutSeq(stdout,pdbE,AB);
	   Int4 minol=ncol/2;
	   // if(this->OverlappingSeqA(Start,keyE,pdbE,minol,0))
	   //if(this->OverlappingSeqsC(Start,keyE,pdbE,minol,0))
	   if(OverlappingSeqs(Start,keyE,pdbE,minol,0))
	   {
		Int4 os=OffSetSeq(pdbE); Int4 kos=OffSetSeq(keyE); 
		OffSet=(Start + kos) -os;
		if(0) fprintf(stderr,"Start=%d; os=%d; kos=%d; OffSet=%d\n",
				Start,os,kos,OffSet);
	   } // exit(1);
	   // PutSeq(stdout,pdbE,AB); PutSeq(stdout,keyE,AB); 
	   AlnSeqSW(stderr,11,1,pdbE,keyE,AB);
#endif
	   NilSeq(keyE); NilSeq(pdbE);
	} else {
	   fprintf(stderr,"pdb sequence %s absent from the alignment\n",argV[3]);
	   print_error("FATAL: input error");
	}
	// 2. create the *_X.mst and *.in files.
	Argv[0]=AllocString("cma2aln"); Argc=1; Argv[Argc]=argV[1]; Argc++;
        char **pdbID=run_cma2aln(Argc,Argv,NN); // pdbID=pdbids in *_fg and in *.mst files.
	free(Argv[0]);

	// 3. Create an initial DCA file in PSICOV format = <infile>_fg_X.dca
	// 	don't need a large file for this...
	char str0[50];
#if 1	//================ turn this off when reading in the *.dca and *.mst files.
    if(InputDCA == FALSE){
        sprintf(str,"%s.in",argV[1]); sprintf(str0,"%s_tmp.in",argV[1]);
        // ReSizeForCCM(250,str,str0);
	Argv[3]=Argv[4]=0; 
	Argv[0]=AllocString("ccmpred"); Argc=1;
        Argv[Argc]=AllocString("-t"); Argc++;
        sprintf(str,"%d",thrds); Argv[Argc]=AllocString(str); Argc++;
	if(gpu_num >= 0){ sprintf(str,"-d %d",gpu_num); Argv[Argc]=AllocString(str); Argc++; }
	// fprintf(stderr,"gpu_num = %d\n",gpu_num);
        // sprintf(str,"%s_tmp.in",argV[1]); Argv[Argc]=AllocString(str); Argc++;
        sprintf(str,"%s.in",argV[1]); Argv[Argc]=AllocString(str); Argc++;
        sprintf(str,"%s_X.dca",argV[1]); Argv[Argc]=AllocString(str); Argc++;
        run_ccmpred(Argc,Argv);  fflush(stdout); fflush(stderr);
	for(A=0; A < Argc; A++){ free(Argv[A]); Argv[A]=0; } Argc=0;
        sprintf(str,"%s.in",argV[1]); remove(str);
    }
#endif

	// 2. Create a DCA file in EV-couplings format mapped to <pdbid> = <infile>_fg_X
	Argv[Argc]=AllocString("starc"); Argc++; 
	Argv[Argc]=AllocString(argV[1]); Argc++; 
	// Argv[Argc]=AllocString("pdb_paths"); Argc++; 
	Argv[Argc]=AllocString(argV[2]); Argc++; 
	if(thrds != 1){ sprintf(str,"-thrds=%d",thrds); Argv[Argc]=AllocString(str); Argc++; }
	if(gpu_num >= 0){
	   sprintf(str,"-dev=%d",gpu_num); Argv[Argc]=AllocString(str); Argc++; 
	}
	// sprintf(str,"-inCCM=%d",Size); Argv[Argc]=AllocString(str); Argc++; 
	drc_typ *drc = new drc_typ(Argc,Argv,'B',TRUE,InputDCA);
	drc->run_key_starc(argV[3],argV[2]);
	delete drc;
	if(pdbID){ for(i=1; pdbID[i]; i++) free(pdbID[i]); free(pdbID); }

	fp=open_file(argV[1],"_X.mst","r");
	FILE *tfp=0;
	while(fgets(str,5000,fp) != NULL){
	  char pdbid[20];
	  if(strncmp(argV[3],str,6) == 0){
	    tfp=open_file(argV[1],"_X.aln","w");
	    for(i=8; !isspace(str[i]); i++){
		fprintf(tfp,"%c",str[i]);
	    } fprintf(tfp,"\n"); break;
	  }
	}
	if(tfp == 0) print_error("FATAL: alignment not found");
	else fclose(tfp);
	
#if 1   // remove temporary files.
        // sprintf(str,"%s_X.mst",argV[1]); remove(str);
        sprintf(str,"%s.in",argV[1]); remove(str);
#else
        sprintf(str,"%s_X",argV[1]); remove(str);
        sprintf(str,"%s_X.dca",argV[1]); remove(str);
	fprintf(stderr,"\nMDS scoring completed successfully.\n");
	fprintf(stderr,"\trun time: %d seconds (%0.2f minutes)\n\n",
		time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
#endif
	NilAlpha(AB);
	return 0;
}

char    *spc_typ::BaseName2(char *path)
{
	Int4 cnt=0;
        for(Int4 i=strlen(path)-1; i >= 0; i--){
           if(path[i] == '/'){
		if(cnt > 0){ i++; return (&path[i]); }
		else cnt++;
	   }
        } return path;
}

char    *spc_typ::BaseName(char *path)
{
        for(Int4 i=strlen(path)-1; i >= 0; i--){
           if(path[i] == '/'){ i++; return (&path[i]); }
        } return path;
}

int	spc_typ::RunModeMDS()
{
	Int4	i,j,k,N,NumStruct;
	char	c;
	Int4	time1=time(NULL);
	// sparc mds infile pdb_dir PDBID chains pdb_list [options]
	// argv  [1]  [2]    [3]     [4]   [5]    [6]      [7...]
	// e.g., sparc mds bEBP_FG pdbdir 4LY6_A ABCDEF pdb_list -dev=5
	//  argv  [0]  [1]   [2]    [3]     [4]   [5]    [6]      [7...]
	// for(i=0; i < argc; i++) fprintf(stderr,"%d: %s\n",i,argv[i]);
	char    str[200],**ArgV; NEWP(ArgV,argc+9,char);
	int     ArgC=0; ArgV[0]=argv[0]; ArgC++;
	//================ look for STARC input files =================
        sprintf(str,"%s_X.dca",argv[2]);
	FILE *ifp=fopen(str,"r");
	if(ifp != 0){
	    fclose(ifp); sprintf(str,"%s_X.aln",argv[2]); ifp=fopen(str,"r");
	}
	if(ifp == 0){
	    ArgV[1]=argv[2]; ArgC++; ArgV[2]=argv[3]; ArgC++;
	    ArgV[3]=argv[4]; ArgC++; 
	    for(i=7,j=4; i < argc; i++){
		ArgV[j] = argv[i]; ArgC++; j++;
	    }
	    SetUpStarcMDS(ArgC,ArgV); ArgV[5]=0;
	} else fclose(ifp);

	// starc pdbs/1rp_H.pdb B:AC 1XXX_X [options]
	//  [0]   [1]            [2]  [3]  [4...]
	FILE *tfp=0;
	tfp=open_file(argv[6],"","r");
	char pdbfile[1000],chn[9];
	ArgV[0]=AllocString("starc"); 
	Int4 X,Y,nchn=strlen(argv[5]);
	FILE *ofp=0,*bfp=0;
	ofp=open_file(argv[2],".sscr","w"); fprintf(ofp,"index");
	for(i=7; i < argc; i++){
	   if(strncmp("-bpps=",argv[i],6) == 0){
		bfp=open_file(argv[2],".bpps","w"); fprintf(bfp,"index");
		fprintf(stderr,"%d %s\n",i,argv[i]);
		
	   }
	}
	if(nchn > 1) {
	   for(i=0; argv[5][i]; i++){
		j=i-1; k=i+1; if(j < 0) j=nchn-1; if(k >= nchn) k=0;
		char x=argv[5][i],y=argv[5][j],z=argv[5][k];
		sprintf(chn,"%c:%c%c",x,y,z); fprintf(ofp,"\t%s",chn);
		if(bfp) fprintf(bfp,"\t%s",chn);
	   } fprintf(ofp,"\tAvg.\tFile\n"); if(bfp) fprintf(bfp,"\tSum\tFile\n");
	} else {
	   if(bfp) fprintf(bfp,"\t%c\tSum\tFile\n",argv[5][0]);
	   fprintf(ofp,"\t%c\tFile\n",argv[5][0]); 
	}
#if 1
	for(X=Y=0; fgets(pdbfile,500,tfp) != NULL; ){ X++; Y += nchn; }
	NumStruct=X; rewind(tfp);
	dh_type dH=dheap(X+5,4);
	dh_type sudH=dheap(Y+5,4);
#else
	dh_type dH=dheap(NSeqsSeqSet(P1)+10,4);
	insrtHeap(n,(keytyp)Random(),dH);
	n=delminHeap(dH);
	while(!emptyHeap(dH)) ;
	d=minkeyHeap(dH);
	Nildheap(dH);

	mh_type mH=Mheap(N+3,3);
	for(i=1; ItemsInMheap(mH) > 0; i++){
	DelMinMheap(mH);
	MinKeyMheap(mH);
	NilMheap(mH);

	double key = MaxKeyMheap(H->mH);
	Int4 rtn,x=DelMaxMheap(mH);
	int4 item=InsertMheap(key, H->mH);
#endif
	keytyp key;
	long double minkey=DBL_MAX;
	long double dd,sum,*Sum,*Max,minsum=DBL_MAX,maxsum=0.0;
	char	*maxid=0;
	NEW(Sum,nchn+2,long double); NEW(Max,nchn+4,long double);
	Int4	hits,sumhits;
#if 0
FILE *ifp=open_file(argv[2],".bpps","r");
#endif
#if 1
	//sprintf(str,"average S-score %c over time",Chain[i]);
	sprintf(str,"average aggregate S-score over time");
	h_type tHG=Histogram(str,0,NumStruct+20,20);
	double sum20=0.0;
#endif
	char *MaxPDB=0;
	Int4 MaxID=0;
	for(X=Y=0; fgets(pdbfile,500,tfp) != NULL; ){
	     i=strlen(pdbfile); pdbfile[i-1]=0;	// remove newline character.
	     ArgV[1]=AllocString(pdbfile); 
	     sprintf(str,"%s_X",argv[2]);
	     ArgV[3]=AllocString(str); ArgC=4;
	     for(i=7,j=4; i < argc; i++){
		if(strncmp(argv[i],"-dev=",5) == 0) continue;
		if(strncmp(argv[i],"-thrds=",7) == 0) continue;
		ArgV[j]=argv[i]; ArgC++; j++;
	     }
	     X++; fprintf(ofp,"%d",X);
	     if(X % 20 == 5) fprintf(stderr,".");
	     for(sumhits=0,sum=0.0,i=0; argv[5][i]; i++){
		j=i-1; k=i+1; if(j < 0) j=nchn-1; if(k >= nchn) k=0;
		char x=argv[5][i],y=argv[5][j],z=argv[5][k];
		if(nchn==1) sprintf(chn,"%c",x);
		else sprintf(chn,"%c:%c%c",x,y,z);
	     	ArgV[2]=AllocString(chn); 
	  	dd=RunLoneSTARC(ArgC,ArgV,hits); free(ArgV[2]);
		sum += dd; Sum[i] += dd;
		sumhits += hits;
		if(dd > Max[i]){ 
			Max[i]=dd; MaxID=X;
			if(MaxPDB != 0) free(MaxPDB);
			MaxPDB=AllocString(BaseName2(pdbfile)); 
		} 
		if(dd < minkey) minkey=dd;
	        Y++; insrtHeap(Y,-dd,sudH);
		fprintf(ofp,"\t%.1Lf",dd);
		if(bfp) fprintf(bfp,"\t%d",hits);
	     } 
	     if(nchn > 1){
		 fprintf(ofp,"\t%.1Lf\t%s\n",sum/(long double)nchn,BaseName2(pdbfile));
	     } else fprintf(ofp,"\t%s\n",BaseName2(pdbfile));
	     if(bfp) fprintf(bfp,"\t%d\t%s\n",sumhits,BaseName2(pdbfile));
	     Int4 size = nchn*3*(Int4) ceil(sum + 0.5);
	     key = (keytyp) -sum;
	     insrtHeap(X,key,dH);
	     if(sum > maxsum){
		if(maxid) free(maxid); maxid=AllocString(pdbfile); maxsum=sum;
	     }
	     if(sum < minsum) minsum=sum;
sum20+=(double )sum;
if(X % 20 == 0){ 
	Int4 XX=(Int4)floor((sum20/20.0) + 0.5);
	IncdMHist(X-1,XX,tHG); sum20=0.0;
}
	     free(ArgV[1]); free(ArgV[3]);
	} fprintf(stderr,"\n");
	if(bfp) fclose(bfp);
	fprintf(ofp,"Avg:");
	for(i=0,dd=0.0; i < nchn; i++){
	     fprintf(ofp,"\t%.1Lf",Sum[i]/(long double)X); dd += Sum[i]/(long double)X;
	} fprintf(ofp,"\t%.1Lf\n",dd/(long double)nchn);
	fprintf(ofp,"Max:");
	for(i=0,dd=0.0; i < nchn; i++){
	     dd += Max[i]; fprintf(ofp,"\t%.1Lf",Max[i]); 
	} fprintf(ofp,"\t%.1Lf (%d.%s)\n\n",dd/(long double)nchn,MaxID,MaxPDB);
	free(MaxPDB);
PutHist(ofp,60,tHG); NilHist(tHG);

	if(nchn > 1){
	  i=(Int4) floor(minsum - 0.5);
	  j=(Int4) ceil(maxsum + 0.5);
	  double d=(double)(j-i)/40.0;
	  h_type HG=0;
	  if(nchn > 1) HG=Histogram("aggregate S-scores",i,j,d);
	  for(X=0; !emptyHeap(dH); ){
	    X++; key=-minkeyHeap(dH); i=delminHeap(dH);
	    if(X <= 5){ fprintf(ofp,"%d: %d = %.1lf",X,i,key);
	      if(X == 1) fprintf(ofp,"\t(best = %s)\n",maxid); else fprintf(ofp,"\n");
	    } if(HG) IncdHist(key,HG);
	  } Nildheap(dH); fprintf(ofp,"\n");
	  if(HG) { PutHist(ofp,60,HG); NilHist(HG); }
	} else Nildheap(dH);

	i=(Int4) floor((double)minkey - 0.5);
	key=-minkeyHeap(sudH);
	j=(Int4) ceil(key+ 0.5);
	double d=(double)(j-i)/40.0;
	h_type sHG=Histogram("subunit S-scores",i,j,d);
	for(Y=0; !emptyHeap(sudH); ){
	   Y++; key=-minkeyHeap(sudH); i=delminHeap(sudH);
	   if(Y <= 5){ fprintf(ofp,"%d: %d = %.1lf\n",Y,i,key);
	   } IncdHist(key,sHG);
	} Nildheap(sudH); fprintf(ofp,"\n");
	PutHist(ofp,60,sHG); NilHist(sHG);

	if(ofp != stdout) fclose(ofp);

	ofp=open_file(argv[2],".sscr","r");
	while((c=fgetc(ofp)) != EOF) fprintf(stdout,"%c",c);
	fclose(ofp);
	  
	free(Max); free(ArgV); free(Sum); 
        // sprintf(str,"%s_X",argv[2]); remove(str);
	fprintf(stderr,"\trun time: %d seconds (%0.2f minutes)\n\n",
		time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	return 0;
}

