/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "spc_typ.h"
#include "sparc_usage.h"
#include "spc_typ_usage.h"

Int4	spc_typ::FindHbondNetwork( )
// return the number of residues in that form Hbonds with each other
// print out PyMOL scripts
{
	Int4	i,j,k,x,y,N,Hits,nchn,chn,*TotHits=0;
	Int4	MinRes=0,MaxRes=0;
	char	Str[500],**buffer=0,c,str[100];
	set_typ **Set;
	FILE	*tfp=stdout,*vfp;
	FILE	*ifp=0;
	h_type	*HGM,*tHG,HG;

	HG=Histogram("the number of H-bonds above the cutoff",-2,100,1.0);
	//====================================================================
	//============== Get 1st structure for residue ranges ================
	//====================================================================
	ifp=open_file(argv[2],"","r");
	if(fscanf(ifp,"%s\n",Str) != 1) print_error("Fatal: input file error");
	else rewind(ifp);
	pdb_typ pdb = MakePDB(Str);
	NEW(TotHits,nChainsPDB(pdb)+3,Int4);
	NEW(HGM,nChainsPDB(pdb)+3,h_type); NEW(tHG,nChainsPDB(pdb)+3,h_type);
	for(nchn=i=0 ; Chain[i]; i++){
	      sprintf(str,"the number of H-bonds for chain %c",Chain[i]);
	      HGM[i]=Histogram(str,-2,100,1.0);
	      sprintf(str,"the number of H-bonds for chain %c over time",Chain[i]);
	      tHG[i]=Histogram(str,0,1000,20);
	      nchn++; j=GetChainNumberPDB(pdb,Chain[i]);
              MinRes=MAXIMUM(Int4,MinRes,MinResPDB(j,pdb));
              MaxRes=MAXIMUM(Int4,MaxRes,MaxResPDB(j,pdb));
	} NilPDB(pdb);
	//===================================================================
	//=============== Get Interacting Residue Positions =================
	//===================================================================
	for(i=0 ; Chain[i]; ) i++;
	NEWP(Set,i+3,set_typ);
	x = MaxRes;
	y = x*(x-1)/2; NEWP(buffer,y+2,char);
	for(i=0 ; Chain[i]; i++){
	   NEW(Set[i],5,set_typ);
	   Set[i][Lt]=MakeSet(MaxRes+4); Set[i][Ct]=MakeSet(MaxRes+4); 
	   Set[i][Rt]=MakeSet(MaxRes+4); 
	   ClearSet(Set[i][Lt]); ClearSet(Set[i][Ct]); ClearSet(Set[i][Rt]);
	   for(int Su=Lt; Su <= Rt; Su++){
	     Int4 *res_pos = sis->RtnPos((subunit)Su,i);	// chain i
	     for(j=1; j <= res_pos[0]; j++){
	       // fprintf(stderr,"%d: %d\n",j,res_pos[j]);
	       if(res_pos[j] > MaxRes) print_error("FATAL: hbonds option input error");
	       AddSet(res_pos[j],Set[i][Su]);
	     } // PutSet(stderr,Set[i][Su]);
	   }
	}
	//===================================================
	//=========== Make each pdb & res_typ ===============
	//===================================================
	Int4	*max_hits=0,vsi_id=0,*bst_id=0;
	NEW(max_hits,nchn+3,Int4); NEW(bst_id,nchn+3,Int4);
	vfp=open_file(argv[2],".vsi","w");
	for(N=0,vsi_id=0; fscanf(ifp,"%s\n",Str) == 1; ){
	  // fprintf(stderr,"%d.%s\n",N+1,Str);
	  pdb = MakePDB(Str); N++; 
	  //============================================
	  //=========== Make the res_typ ===============
	  //============================================
	  res_typ  **ResALL;
	  Int4     *num_res;
	  NEWP(ResALL,nChainsPDB(pdb)+3,res_typ);
	  NEW(num_res,nChainsPDB(pdb)+3,Int4);
	  for(i=0 ; Chain[i]; i++){
	    j=GetChainNumberPDB(pdb,Chain[i]);
	    ResALL[j]=MakeResPDB(j,&num_res[j],pdb);
	  }
          for(i=0,j=nchn-1,k=1; Chain[i]; i++,k++,j=i-1){
	    if(Chain[k]==0) k=0; tfp=tmpfile(); Hits=0;
	    this->CisHbonds(Set[i][Ct],buffer,Chain[i],Hits,ResALL,num_res,pdb,tfp);
	    if(nchn > 1){
	      this->TransLeftHbonds(Set[i],buffer,Chain[i],Hits,ResALL,num_res,pdb,tfp);
	      this->TransRightHbonds(Set[i],buffer,Chain[i],Hits,ResALL,num_res,pdb,tfp);
	    }
	    if(Hits >= MinNumBonds){
		vsi_id++;
		fprintf(vfp,"~$=%d.\n",vsi_id);
		fprintf(vfp,"File1=%s:%c  // \n\n1-10000.W15\n\n",Str,Chain[i]);
		fprintf(vfp,"%d-%d:%c.G80\n",MinRes,MaxRes,Chain[j]); // G=palegreen
		fprintf(vfp,"%d-%d:%c.B80\n",MinRes,MaxRes,Chain[i]); // B=lightblue
		fprintf(vfp,"%d-%d:%c.M80\n\n",MinRes,MaxRes,Chain[k]); // M=lightpink
		rewind(tfp); c=fgetc(tfp); // skip initial ',' character.
		while((c=fgetc(tfp)) != EOF) fprintf(vfp,"%c",c); fclose(tfp);
		fprintf(vfp,"\n\n");
	       	fprintf(stdout,"%d: %d hits(chain %c) '%s'\n",
				vsi_id,Hits,Chain[i],Str);
	        for(j=1; buffer[j]; j++) fprintf(stdout,"%d:%s\n",j,buffer[j]);
		fprintf(stdout,"\n");
	        IncdHist(Hits,HG); TotHits[i] += Hits;
	    } else fclose(tfp);
	    if(Hits > max_hits[i]){
		bst_id[i]=vsi_id; max_hits[i]=Hits; 
	    }
	    IncdMHist(N,Hits,tHG[i]); IncdHist(Hits,HGM[i]); TotHits[i] += Hits;
	    for(j=1; buffer[j]; j++){ free(buffer[j]); buffer[j]=0; }
          }

	  //==================================================
	  //=========== Free the res_typ & pdb ===============
	  //==================================================
	  for(x=1; x <= nChainsPDB(pdb); x++){ 
	     if(ResALL[x]){
		for(y=1; y <= num_res[x]; y++) NilRes(ResALL[x][y]);
		free(ResALL[x]);
	     }
	  } free(ResALL); free(num_res); NilPDB(pdb);
	} free(buffer); PutHist(stdout,60,HG); NilHist(HG);
	fprintf(vfp,"\n"); fclose(vfp);
	//============================================================
	//================ Create best PyMOL file. ===================
	//============================================================
	char	*Argv[20];
	Int4	Argc;
        for(i=0; Chain[i]; i++){
	  if(bst_id[i] == 0) continue;
	  sprintf(str,"chn_vsi %s_X 1 %d -T -skip=W -d2.5 -v -D",argv[2],bst_id[i]);
// fprintf(stderr,"%d: %s\n",i,str);
	  Argc=string2argv(Argv,str);       // mode == 'T'
	  FILE *xfp = tmpfile();
	  vfp=open_file(argv[2],".vsi","r");
	  ChainVSI(Argc,Argv,vfp,xfp); rewind(xfp); 
	  for(Argc-- ; Argc >= 0; Argc--) free(Argv[Argc]);
	  sprintf(str,"chn_vsi %s_X.crs 1 -d2.5 -c -D -pml=%s%c_%d",
		argv[2],argv[2],Chain[i],bst_id[i]);
	  Argc=string2argv(Argv,str);
	  ChainVSI(Argc,Argv,xfp,0); fclose(xfp);
	  for(Argc-- ; Argc >= 0; Argc--) free(Argv[Argc]);
	}
	//===========================================================
	//============== Output histograms ==========================
	//===========================================================
        for(i=0; Chain[i]; i++){
	    PutHist(stdout,60,HGM[i]); NilHist(HGM[i]);
	    PutHist(stdout,60,tHG[i]); NilHist(tHG[i]);
	} free(HGM); free(tHG);
        for(i=0; Chain[i]; i++){
	    fprintf(stdout,"chain %c: %d\n",Chain[i],TotHits[i]);
	    NilSet(Set[i][Lt]); NilSet(Set[i][Ct]); NilSet(Set[i][Rt]); 
	    free(Set[i]);
	} free(Set); free(TotHits);
	free(max_hits); free(bst_id);
	return N;
}

Int4	spc_typ::CisHbonds(set_typ Set,char **buffer,char ChnC,Int4 &Sum,
		res_typ **ResALL,Int4 *num_resALL,pdb_typ pdb,FILE *tfp)
// This goes through all the pdb files.
{
	float	HA_dmax=2.5,dmax=3.6; 
	FILE	*efp=0,*ofp=stdout;
	char	bst=0,Ci,Cj,chnI,chnJ;
	Int4	cC,nI,nJ,nchn,i,j,k,N;
	res_typ *ResC;
	set_typ	SetC=Set,SetX=CopySet(SetC); ClearSet(SetX);
	if(verbose) efp=stderr;
        a_type AB=AminoAcidAlphabetPDB(pdb);

	//=======================================================
	//============ Get cis chain ==========================
	//=======================================================
	for(nchn=i=0 ; Chain[i]; i++) nchn++;
	for(i=0 ; Chain[i]; i++) if(ChnC==Chain[i]){ break; }
	cC=GetChainNumberPDB(pdb,ChnC);
	ResC=ResALL[cC]; 
        Int4 MinResC=MinResPDB(cC,pdb),MaxResC=MaxResPDB(cC,pdb);

	//========= Go through all of the pairs in SetC ======
        for(nI=MinResC; nI <= MaxResC; nI++) {
           if(!MemberSet(nI,SetC)) continue;
           for(nJ=nI+1; nJ <= MaxResC; nJ++) {
             if(!MemberSet(nJ,SetC)) continue;

	     Int4  IL,IC,IR,JL,JC,JR;
	     //============ cis Interaction ==================
	     for(IC=0,k=num_resALL[cC]; k >= 1; k--){
		if(nI == ResidueID(ResC[k])){ IC=k; break; } 
	     } assert(IC != 0);
	     for(JC=0,k=num_resALL[cC]; k >= 1; k--){
		if(nJ == ResidueID(ResC[k])){ JC=k; break; } 
	     } assert(JC != 0);

	     double  dC,DC,dR,DR,dL,DL,dB;
	     //============ cis Interaction ==================
	     dC=this->GetHBonds(efp,ResC[IC],ResC[JC],cC,cC,HA_dmax,pdb);
	     DC=this->GetHBonds(efp,ResC[JC],ResC[IC],cC,cC,HA_dmax,pdb);

// fprintf(stderr,"dd=%.2lf; dD=%.2lf; Dd=%.2lf; DD=%.2lf\n",dd,dD,Dd,DD);

	     chnI=chnJ=ChnC; Ci=GetCharResidue(ResC[IC],AB);
	     Cj=GetCharResidue(ResC[JC],AB);
	     if(dC < DC){ dB=dC; bst='c'; } else { dB=DC; bst='C'; }
	     if(dB <= 2.5){
		char str[100];
		//================ vsi file.. =====================
		switch (bst){
		  case 'c': case 'C':
		   if(!MemberSet(nI,SetX)){
		     fprintf(tfp,",%c%d:%c.R",Ci,nI,chnI); AddSet(nI,SetX);
		   }
		   if(!MemberSet(nJ,SetX)){
		     fprintf(tfp,",%c%d:%c.R",Cj,nJ,chnJ); AddSet(nJ,SetX);
		   } break;
		  default: print_error("This should not happen");
		}
		//================ vsi file.. =====================
		sprintf(str,"%c%d%c_%c%d%c %.2lf; %c",
					Ci,nI,chnI,Cj,nJ,chnJ,dB,bst);
		Sum++; buffer[Sum]=AllocString(str);
	     }
	   }
	} NilSet(SetX);
	return Sum;
}

Int4	spc_typ::TransLeftHbonds(set_typ *Set,char **buffer,char ChnC, Int4 &Sum,
		res_typ **ResALL,Int4 *num_resALL,pdb_typ pdb,FILE *tfp)
// this goes through all the pdb files.
{
	float	HA_dmax=2.5,dmax=3.6; 
	FILE	*efp=0,*ofp=stdout;
	char	bst=0,Ci,Cj,ChnL,chnI,chnJ;
	Int4	nI,nJ,rtn=0,nchn,i,j,k,N,cL,cC,nL,nC;
	res_typ *ResL,*ResC;
	set_typ	SetC=Set[Ct],SetL=Set[Lt];
	set_typ	SetXL=CopySet(SetL); ClearSet(SetXL);
	set_typ	SetXC=CopySet(SetC); ClearSet(SetXC);
	if(verbose) efp=stderr;
        a_type AB=AminoAcidAlphabetPDB(pdb);

	//=======================================================
	//============ Get Adj. chains ==========================
	//=======================================================
	for(nchn=i=0 ; Chain[i]; i++) nchn++;
	for(i=0 ; Chain[i]; i++) if(ChnC==Chain[i]){ break; }
	k = (i-1); if(k < 0) k=nchn-1; ChnL=Chain[k];

	cC=GetChainNumberPDB(pdb,ChnC);
	cL=GetChainNumberPDB(pdb,ChnL);
	assert(!(cL == 0 || !IsProteinPDB(cL,pdb)));
	assert(!(cC == 0 || !IsProteinPDB(cC,pdb)));
	ResL=ResALL[cL]; ResC=ResALL[cC]; 
        Int4 MinResC=MinResPDB(cC,pdb),MinResL=MinResPDB(cL,pdb);
        Int4 MaxResC=MaxResPDB(cC,pdb),MaxResL=MaxResPDB(cL,pdb);

	Int4 IL,IC,JL,JC;
        for(nI=MinResC; nI <= MaxResC; nI++) {
           if(!MemberSet(nI,SetC)) continue;
	   for(IC=0,k=num_resALL[cC]; k >= 1; k--){
		if(nI==ResidueID(ResC[k])){ IC=k; break; } 
	   } assert(IC != 0);
	   //=========== left trans interating residue ===============
           for(nJ=MinResL; nJ <= MaxResL; nJ++) {
	     if(nJ == nI) continue;
             if(!MemberSet(nJ,SetL)) continue;
	     for(JL=0,k=num_resALL[cL]; k >= 1; k--){
		if(nJ == ResidueID(ResL[k])){ JL=k; break; } 
	     } assert(JL != 0);

	     double  dL,DL,dB=DBL_MAX;
//if(0) fprintf(stderr,"%d%c vs %d%c: IJ=%d; JJ=%d\n", nI,adjChn,nJ,adjChn,IJ,JJ);
	     //=========== left trans interation ===============
	     DL=this->GetHBonds(efp,ResC[IC],ResL[JL],cC,cL,HA_dmax,pdb);
	     dL=this->GetHBonds(efp,ResL[JL],ResC[IC],cL,cC,HA_dmax,pdb);
// fprintf(stderr,"dd=%.2lf; dD=%.2lf; Dd=%.2lf; DD=%.2lf\n",dd,dD,Dd,DD);

	     bst='L'; dB=DL; chnI=ChnC; chnJ=ChnL;
	     Ci=GetCharResidue(ResC[IC],AB);
	     Cj=GetCharResidue(ResL[JL],AB);
	     if(DL > dL){ bst='l'; dB=dL; }

	     if(dB <= 2.5){
		char str[100];
		//=================== for vsi file =====================
		if(!MemberSet(nI,SetXC)){
		     fprintf(tfp,",%c%d:%c.R",Ci,nI,chnI); AddSet(nI,SetXC);
		}
		if(!MemberSet(nJ,SetXL)){
		     fprintf(tfp,",%c%d:%c.R",Cj,nJ,chnJ); AddSet(nJ,SetXL);
		} 
		//================= for stdout file ====================
		sprintf(str,"%c%d%c_%c%d%c %.2lf; %c",
					Ci,nI,chnI,Cj,nJ,chnJ,dB,bst);
		Sum++; buffer[Sum]=AllocString(str);
	     }
	   }
	} return Sum;
}

Int4	spc_typ::TransRightHbonds(set_typ *Set,char **buffer,char ChnC, Int4 &Sum,
		res_typ **ResALL,Int4 *num_resALL,pdb_typ pdb,FILE *tfp)
// this goes through all the pdb files.
{
	float	HA_dmax=2.5,dmax=3.6; 
	FILE	*efp=0,*ofp=stdout;
	char	bst=0,Ci,Cj,ChnR,chnI,chnJ;
	Int4	nI,nJ,rtn=0,nchn,i,j,k,N,cR,cC,nR,nC;
	res_typ *ResR,*ResC;
	set_typ	SetC=Set[Ct],SetR=Set[Rt];
	set_typ	SetXR=CopySet(SetR); ClearSet(SetXR);
	set_typ	SetXC=CopySet(SetC); ClearSet(SetXC);
	if(verbose) efp=stderr;
        a_type AB=AminoAcidAlphabetPDB(pdb);

	//=======================================================
	//============ Get Adj. chains ==========================
	//=======================================================
	for(nchn=i=0 ; Chain[i]; i++) nchn++;
	for(i=0 ; Chain[i]; i++) if(ChnC==Chain[i]){ break; }
	k = (i+1); if(k >= nchn) k=0; ChnR=Chain[k];

	cC=GetChainNumberPDB(pdb,ChnC);
	cR=GetChainNumberPDB(pdb,ChnR);
	assert(!(cR == 0 || !IsProteinPDB(cR,pdb)));
	assert(!(cC == 0 || !IsProteinPDB(cC,pdb)));
	ResR=ResALL[cR]; ResC=ResALL[cC]; 
        Int4 MinResC=MinResPDB(cC,pdb),MinResR=MinResPDB(cR,pdb);
        Int4 MaxResC=MaxResPDB(cC,pdb),MaxResR=MaxResPDB(cR,pdb);

	Int4 IR,IC,JR,JC;
        for(nI=MinResC; nI <= MaxResC; nI++) {
           if(!MemberSet(nI,SetC)) continue;
	   for(IC=0,k=num_resALL[cC]; k >= 1; k--){
		if(nI==ResidueID(ResC[k])){ IC=k; break; } 
	   } assert(IC != 0);
	   //=========== left trans interating residue ===============
           for(nJ=MinResR; nJ <= MaxResR; nJ++) {
	     if(nJ == nI) continue;
             if(!MemberSet(nJ,SetR)) continue;
	     for(JR=0,k=num_resALL[cR]; k >= 1; k--){
		if(nJ == ResidueID(ResR[k])){ JR=k; break; } 
	     } assert(JR != 0);

	     double  dR,DR,dB;
//if(0) fprintf(stderr,"%d%c vs %d%c: IJ=%d; JJ=%d\n", nI,adjChn,nJ,adjChn,IJ,JJ);
	     //=========== left trans interation ===============
	     DR=this->GetHBonds(efp,ResC[IC],ResR[JR],cC,cR,HA_dmax,pdb);
	     dR=this->GetHBonds(efp,ResR[JR],ResC[IC],cR,cC,HA_dmax,pdb);
// fprintf(stderr,"dd=%.2lf; dD=%.2lf; Dd=%.2lf; DD=%.2lf\n",dd,dD,Dd,DD);

	     Ci=GetCharResidue(ResC[IC],AB);
	     Cj=GetCharResidue(ResR[JR],AB);
	     bst='R'; dB=DR; chnI=ChnC; chnJ=ChnR;
	     if(DR > dR){ bst='r'; dB=dR; }

	     if(dB <= 2.5){
		char str[100];
		//=================== vsi file. ======================
		if(!MemberSet(nI,SetXC)){
		     fprintf(tfp,",%c%d:%c.R",Ci,nI,chnI); AddSet(nI,SetXC);
		}
		if(!MemberSet(nJ,SetXR)){
		     fprintf(tfp,",%c%d:%c.R",Cj,nJ,chnJ); AddSet(nJ,SetXR);
		}
		//================= stdout file. =====================
		sprintf(str,"%c%d%c_%c%d%c %.2lf; %c",
					Ci,nI,chnI,Cj,nJ,chnJ,dB,bst);
		Sum++; buffer[Sum]=AllocString(str);
	     }
	   }
	} return Sum;
}

Int4	spc_typ::RunAllPairs(char HetMol[],char HetAtm[],FILE *ofp)
{
	Int4	N,NN,i,j,k,x,MinRes,MaxRes,nI,nJ;
	char	pdbid[200],lastid[200];
	pdb_typ	pdb=0,pdb2=0;
	FILE	*ifp,*efp=0;
	Int4	nChn,MaxLen=0;

	for(i=0 ; Chain[i]; ) i++; nChn=i; 
	if(pmlfp){ this->PutHeaderPyMOL(); }
	// 1. open up one of the structures for reference.
	ifp=open_file(argv[2],"","r");
	for(N=0; fscanf(ifp,"%s\n",lastid) == 1; ) N++;
	pdb2=MakePDB(lastid); rewind(ifp);
// fprintf(stderr,"N=%d: %s\n",N,lastid); // exit(1);
	for(N=0; fscanf(ifp,"%s\n",pdbid) == 1; ){
	  pdb = MakePDB(pdbid); N++; 
	  MinRes=999999;
	  MaxRes=0;
	  for(i=0; Chain[i]; i++){
	        j=GetChainNumberPDB(pdb,Chain[i]);
		if((x=MinResPDB(j,pdb)) > 0){ MinRes=MINIMUM(Int4,MinRes,x); }
		if(i==0) MaxRes=MAXIMUM(Int4,MaxRes,MaxResPDB(j,pdb));
		else MaxRes=MINIMUM(Int4,MaxRes,MaxResPDB(j,pdb));
		Int4 Len=MaxRes-MinRes+1;
		MaxLen = MAXIMUM(Int4,Len,MaxLen);
	  } break;	// Only need to look at one; they are all the same.
	} fclose(ifp);
//fprintf(stderr,"DEBUG 1\n");
	if(sis==0) sis = new sis_typ(Chain,MaxLen);
	if(vsifp){
	  fprintf(vsifp,"~$=1.\n");
	  for(i=1; i <= nChn; i++){
	     fprintf(vsifp,"File%d=%s:%c  //\n",i,pdbid,Chain[i-1]);
	  } fprintf(vsifp,"\n1-10000.W15\n\n");
	  fprintf(vsifp,"%d-%d.Y80\n",MinRes,MaxRes);
	}
#if 0
    if(key==0){
	Int4	space=4;
	for(nI=key; nI == key; nI++){
	   for(nJ=MinRes; nJ <= MaxRes-space; nJ++) {
	      fprintf(stdout,"nI=%d; nJ=%d\n",nI,nJ);
	      this->RunOnePair(nI,nJ,Chain,HetMol,HetAtm,trans);
	   }
	}
    } else
#endif
    {
	i=GetChainNumberPDB(pdb,Chain[0]);
	e_type Sq=GetPDBSeq(i,pdb);
	a_type AB=AminoAcidAlphabetPDB(pdb); StrtMtrx=MinRes; EndMtrx=MaxRes;
	set_typ useSB=0;
	if(mode=='S' && PlotGrph){	// Create contact matrix...
	  this->CreateMtrx(pdb);
	} else { useSB=MakeSet(MaxRes+4); FillSet(useSB); }
	Int4 NumVSI=0;
// MinRes=410;
	for(nI=MinRes; nI <= MaxRes; nI++) {
	   if(!MemberSet(nI,useSB)) continue;
// if(nI >= 411) break;
// if(nI > 274) break;
// if(nI > 54) break;
// if(nI>=144) break; nI=144;
// MinRes=262;
	   for(nJ=MinRes; nJ <= MaxRes; nJ++)
	   // for(nJ=nI+1; nJ <= MaxRes; nJ++)
	   {
	     if(!MemberSet(nJ,useSB)) continue;
// if(nJ>=263) break; 
// if(nJ>=147) break; nJ=147;
	     if(abs(nI-nJ) < MinSpacing) continue;
	     if(mode=='s' && nJ < nI) continue;  // only need to check one way.
	     double d=BigDist,dd,D=BigDist,DD=BigDist,Dd=BigDist;
#if 0
	     dd=this->GetContactsPDB(efp,nI,nJ,HA_dmax,cI,cJ,pdb);
	     case 'D': { dd=this->Res2ResDistance(efp,nI,nJ,cI,cJ,pdb,noMainChn); } break;
#else
#endif
	     Int4	cI,cJ;
	     float	HA_dmax=2.5,dmax=3.6; 
	     double	dIJ,dJI,dII,cut=2.5,cutX=3.0,Cut=0.01;
	     for(i=0; Chain[i]; i++){
	       // find residues relatively near each other.
	       cI=GetChainNumberPDB(pdb,Chain[i]);
	       j=i+1;
	       if(Chain[j]==0) j=0;
	       cJ=GetChainNumberPDB(pdb,Chain[j]);
	       dIJ=DistancePDB(nI,"CA",cI,nJ,"CA",cJ,pdb);
	       dJI=DistancePDB(nI,"CA",cJ,nJ,"CA",cI,pdb);
	       dII=DistancePDB(nI,"CA",cI,nJ,"CA",cI,pdb);
	       if(0) fprintf(stderr,
			"%d -> %d%c vs %d%c: dIJ=%lf; dJI=%lf; dII=%lf\n",
		  	N,nI,Chain[i],nJ,Chain[j],dIJ,dJI,dII);
	       if(dIJ > 30.0 && dJI > 30.0 && dII > 30.0){
		  // d=D=DD=Dd=30.0; break;
		  // d=D=DD=Dd=30.0; continue;
		  continue;
	       }
#if 0
	       dd=this->Res2ResDistance(efp,nI,nJ,ch,ch,pdb,TRUE); 
#elif 1
	       pdb_typ tpdb=0;
	       for(k=0,tpdb=pdb; k <= 1; k++,tpdb=pdb2){ 
	         dd=this->GetContactsPDB(efp,nI,nJ,HA_dmax,cI,cJ,tpdb);
	         if(dd > 0.0) d=MINIMUM(double,d,dd);	// trans
	         dd=this->GetContactsPDB(efp,nI,nJ,HA_dmax,cJ,cI,tpdb);
	         if(dd > 0.0) D=MINIMUM(double,D,dd);	// trans
	         dd=this->GetContactsPDB(efp,nI,nJ,HA_dmax,cI,cI,tpdb);
	         if(dd > 0.0) DD=MINIMUM(double,DD,dd);	// cis
	         dd=this->GetContactsPDB(efp,nJ,nI,HA_dmax,cI,cI,tpdb);
	         if(dd > 0.0) Dd=MINIMUM(double,Dd,dd);	// cis
if(1 && dd < 30.0) fprintf(stderr,
		"%d -> %d%c vs %d%c: d=%lf; D=%lf; DD=%lf; Dd=%lf; dd=%lg\n",
		  N,nI,Chain[i],nJ,Chain[j],d,D,DD,Dd,dd);
	       }
#else
	       dd=this->GetContactsPDB(efp,nI,nJ,HA_dmax,cI,cJ,pdb);
	       if(dd > 0.0) d=MINIMUM(double,d,dd);	// trans
	       dd=this->GetContactsPDB(efp,nI,nJ,HA_dmax,cJ,cI,pdb);
	       if(dd > 0.0) D=MINIMUM(double,D,dd);	// trans
	       dd=this->GetContactsPDB(efp,nI,nJ,HA_dmax,cI,cI,pdb);
	       if(dd > 0.0) DD=MINIMUM(double,DD,dd);	// cis
	       dd=this->GetContactsPDB(efp,nJ,nI,HA_dmax,cI,cI,pdb);
	       if(dd > 0.0) Dd=MINIMUM(double,Dd,dd);	// cis
	       
#endif
#if 1
	     }
	     if((d < cutX && d > Cut) || (D < cutX && D > Cut) ||
		(DD < cutX && DD > Cut) || (Dd < cutX && Dd > Cut)) {
#endif
		char Str[150],str[10];
		Int4 os=OffSetSeq(Sq);
		char rI=AlphaChar(ResSeq(nI-os,Sq),AB);
		char rJ=AlphaChar(ResSeq(nJ-os,Sq),AB);
		if(mode=='s') sprintf(str,"sc2bb");
		else if(mode=='S') sprintf(str,"sc2sc");
		else sprintf(str,"bb2bb");
#if 1
		sprintf(Str,"%c%d vs %c%d: %.2lf %.2lf %.2lf %.2lf (%s)\n",
				rI,nI,rJ,nJ,d,D,DD,Dd,str);
#else
		sprintf(Str,"%c%d%c vs %c%d%c: %.2lf %.2lf %.2lf %.2lf (%s)\n",
				rI,nI,Chain[i],rJ,nJ,Chain[j],d,D,DD,Dd,str);
#endif
if(0) fprintf(stderr,"%s\n",Str);
		if(d <= cutX){		// trans: I vs J
		   d=this->RunOnePair(nI,nJ,HetMol,HetAtm,TRUE,cut,ofp,Str);
		}
		if(D <= cutX){		// trans: J vs I
		   D=this->RunOnePair(nJ,nI,HetMol,HetAtm,TRUE,cut,ofp,Str);
		}
		if(DD <= cutX){		// cis: I vs J
		   Dd=DD=this->RunOnePair(nI,nJ,HetMol,HetAtm,FALSE,cut,ofp,Str);
		} else if(Dd <= cutX){ 	// cis: J vs I.
		   DD=Dd=this->RunOnePair(nJ,nI,HetMol,HetAtm,FALSE,cut,ofp,Str);
		}
	        if(d < cut || D < cut || DD < cut || Dd < cut){
		  PutSeqRegion(ofp,nI-os-1,3,Sq,AB); fprintf(ofp,"\n");
		  PutSeqRegion(ofp,nJ-os-1,3,Sq,AB); fprintf(ofp,"\n\n");
		  fflush(ofp);
		  if(pmlfp){
		   Int4 ri=AlphaCode(rI,AB),rj=AlphaCode(rJ,AB);
		   this->PutResPairPyMOL(ri,rI,nI,rj,rJ,nJ);
		  }
	          if(vsifp){
		    if(NumVSI > 0) fprintf(vsifp,","); NumVSI++;
		    fprintf(vsifp,"%c%d.R,%c%d.R",rI,nI,rJ,nJ);
		    fflush(vsifp);
		  }
		} // end if(d < cut || D < cut || DD < cut || Dd < cut)
	     } // end if((d < cutX && d > Cut) || (D < cutX && D > Cut)...
	  } // end for(nJ=nI+1; nJ <= MaxRes; nJ++)
	} // end for(nI=MinRes; nI <= MaxRes; nI++)
	if(useSB) NilSet(useSB); NilSeq(Sq); 
    }
	if(vsifp){ fprintf(vsifp,"\n\n"); }
	if(pmlfp) this->PutTailPyMOL();
	NilPDB(pdb); NilPDB(pdb2);
	// free(MinRes); free(MaxRes);
	return 0;
}

