/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "spc_typ.h"
#include "spc_usage.h"

void	spc_typ::PutSeqID_CMA(FILE *ofp,cma_typ cma, char *seq_id)
{
        Int4    J,N=NumSeqsCMSA(cma);
	BooLean	*skip,found=FALSE;
	char	str[50];

	NEW(skip, N+4,BooLean);
	for(J=1; J <= N; J++) skip[J]=TRUE;
	for(J=1; J <= N; J++){
	   e_type Sq = TrueSeqCMSA(J,cma);	// get template sequence
	   StrSeqID(str,6,Sq);
	   if(strcmp(str,seq_id) == 0){ skip[J]=FALSE; found=TRUE; break; }
	}
	if(!found) print_error("sequence not found.");
	PutSelectOneCMSA(ofp,skip,cma); 
	free(skip); 
}

set_typ	*spc_typ::QueryResiduesBPPS(char *darc_file,char *cma_file,
		char *pdb_id, a_type AB)
{
	Int4	i,j,k,n,x,y,z,LenPattern=0,ArgC,NumFG=0;
	Int4	MaxRes=0,max_pattern_length=100,*col_pos;
	char	*res_str=0,str[1005],ptrn_str[100],*col_res,c,*pc;
	sst_typ	Residues;
	FILE	*fp=0;

#if 1	// Get MaxRes for 1st pdb file; if get here then argv[2]==pdb_list.
	fp=open_file(argv[2],"","r");  // == pdblist
	if(fgets(str,1002,fp) != NULL){
	   char *sp=strchr(str,'\n'); 
	   if(sp != NULL) sp[0]=0;
	   pdb_typ pdb=MakePDB(str);
	   i=GetChainNumberPDB(pdb,pdb_id[5]);
	   MaxRes=MaxResPDB(i,pdb);
	   NilPDB(pdb);
	} else print_error("FATAL: pdb_list input error");
	fclose(fp);
#endif
	fp=open_file(cma_file,"","r"); 
	cma_typ cma=ReadCMSA(fp,AB); fclose(fp);
	fp=tmpfile(); this->PutSeqID_CMA(fp,cma,pdb_id);
	TotalNilCMSA(cma);
	rewind(fp); cma=ReadCMSA(fp,AB); fclose(fp);
	fp=open_file(pdb_id,"_tmp","w"); 
	PutCMSA(fp,cma); fclose(fp);

	char	**pdbID,*ArgV[10]; ArgC=0;
	ArgV[ArgC]=AllocString("cma2aln"); ArgC++;
        sprintf(str,"%s_tmp",pdb_id);
	ArgV[ArgC]=AllocString(str); ArgC++;
        pdbID=run_cma2aln(ArgC,ArgV,NumFG);
	remove(str);
        sprintf(str,"%s_tmp.in",pdb_id); remove(str);
	if(verbose) for(i=1; pdbID[i]; i++) fprintf(stderr,"%d: %s\n",i,pdbID[i]);
	fp=open_file(pdb_id,"_tmp_X.mst","r"); str[1000]=0;
	for(i=1; fgets(str,1002,fp) != NULL; i++){
	    if(strstr(str,pdb_id) != NULL){
		if(str[1000] != 0) print_error("FATAL: Input domain too long");
		if(verbose) fprintf(stderr,"%s\n",str);
		NEW(res_str,strlen(str)+3,char);
		if(sscanf(str,"%*[^:]:%s\n",res_str) == 1){
		   // MaxRes=strlen(res_str);
		   NEW(col_res,MaxRes+3,char); NEW(col_pos,MaxRes+3,Int4);
		   col_res[0]=' ';
		   for(k=j=x=0; res_str[j]; j++){
			c= res_str[j];
			if(isalpha(c)) k++; 
			if(isupper(c) || c == '-'){ 
				x++; col_pos[x]=k; col_res[x]=c; 
			}
		   } 
		} else print_error("QueryResiduesBPPS() input error");
		if(verbose) fprintf(stderr,"%s\n",col_res);
		break;
	    }
	} fclose(fp);
        sprintf(str,"%s_tmp_X.mst",pdb_id); remove(str);

	set_typ	*set,set0; NEW(set,10,set_typ);
	TopDC_Set=MakeSet(MaxRes + 2); i=MaxRes+3;
	TopDC_Grph=MkWdgraph(i,i*i);
	fp=open_file(darc_file,"","r");
	BooLean done=FALSE;
	for(i=1; fgets(str,495,fp) != NULL; i++){
    	    if(verbose)fprintf(stderr,"%d: %s",i,str);
	    if(strstr(str,"Pattern residues:") != NULL){
	      for(j=1; fgets(str,495,fp) != NULL; j++){
    		if(verbose) fprintf(stderr,"%d.%d: %s\n",i,j,str);
		if(str[0] == '\n') break;
		pc=&str[0]; // fprintf(stderr,"%s\n%s\n",str,pc);
		BooLean	success=FALSE;
		if(sscanf(pc,"%d: %[A-Z]%d",&x,ptrn_str,&y) == 3){
		  n=0; assert(x < 10 && x > 0 && set[x] == 0);
		  if(j==1){ set[x]=MakeSet(MaxRes + 9); set0=set[x]; }
		  else { set[x]=CopySet(set0); ClearSet(set[x]); }
		  z=col_pos[y]; AddSet(z,set[x]);
		  if(verbose) fprintf(stderr, "%d. %s%d column --> %c%d position\n",
			x,ptrn_str,y,col_res[y],z);
		  n++; success=TRUE;
		} pc=strchr(pc,',');
	        if(success){
		  while(pc != 0 && sscanf(pc,",%[A-Z]%d",ptrn_str,&y) == 2){
		    z=col_pos[y]; AddSet(z,set[x]);
		    if(verbose) fprintf(stderr,"%s%d =? %c%d\n",
				ptrn_str,y,col_res[y],z);
		    n++; pc++; if((pc=strchr(pc,',')) == NULL) break;
	          }
		  if(verbose) fprintf(stderr,"set[%d] (%d==%d):\n",
				x,CardSet(set[x]),n);
		  if(verbose) PutSet(stderr,set[x]);
		}
	      } done=TRUE; break;
	    } if(done) break;
	}
#if 1	// Find highest DC-scoring pairs
	char Str[100];
	sprintf(Str,"-------------- %s chain",pdb_id);
	if(verbose) fprintf(stderr,"%s\n",Str);
	for(i=0; fgets(str,495,fp) != NULL; i++){
	  // fprintf(stderr,"%s\n",str);
	  if(strstr(str,Str) != NULL){	// found the correct section...
	   if(verbose) fprintf(stderr,"%s\n",str);
	   for(j=0; fgets(str,495,fp) != NULL; j++){
	     if(verbose) fprintf(stderr,"%d.%d: %s",i,j,str);
	     if(j==0){
		if(strstr(str,"rank") == NULL) print_error("Syntax error");
		else continue;
	     } else if(str[0]=='('){
		pc=&str[1]; // fprintf(stderr,"%s\n%s\n",str,pc);
	        if(verbose) fprintf(stderr,"%s",pc);
	     } else if(isdigit(str[0])){
		pc=&str[0]; // fprintf(stderr,"%s\n%s\n",str,pc);
	        if(verbose) fprintf(stderr,"%s",pc);
	     } else break;
	     char	resI,resJ;
	     Int4	stI,stJ,II;
	     float	dist;
	     double	score;
	     if(sscanf(pc,"%d %c%d %c%d %f %lf",
			&II,&resI,&stI,&resJ,&stJ,&dist,&score) == 7) {
		Int4 wt,ii,jj;
		if(stI < stJ){ ii=stI; jj=stJ; } else { ii=stJ; jj=stI; }
		wt=(Int4) ceil(dist*100.0);
		JoinWdgraph(ii,jj,wt,TopDC_Grph);
		if(stI > SetN(TopDC_Set) || stJ > SetN(TopDC_Set)){
		   fprintf(stderr,"Residue positions inconsistently numbered!\n");
		   fprintf(stderr,"  Residue %c%d paired with %c%d\n",resI,stI,resJ,stJ);
		   fprintf(stderr,"  Reference sequence positions are less than %d\n",SetN(TopDC_Set));
		   fprintf(stderr,"  Set the offset ('os') for seq. %s in file %s to match\n",
				pdb_id,cma_file);
		   fprintf(stderr,"    residue positions in the %s and ",darc_file);
		   for(k=0; pdb_id[k] != '_'; k++) fprintf(stderr,"%c",tolower(pdb_id[k]));
		   fprintf(stderr," pdb files.\n",darc_file);
		   fprintf(stderr,"  Syntax is \">%s {|<os>(<taxid>)|<phyla(kingdom)>}...\"\n",pdb_id);
		   print_error("QueryResiduesBPPS() input error");
		}
		AddSet(stI,TopDC_Set); AddSet(stJ,TopDC_Set);
		if(verbose) fprintf(stderr,"-->%d %c%d %c%d %f %lf\n",
				II,resI,stI,resJ,stJ,dist,score);
		// fprintf(stderr,"%s",pc);
	     } else { print_error("Syntax error"); }
	   } break;
	  }
	} if(verbose) PutWdgraph(stderr,TopDC_Grph); // exit(1);
#endif
	fclose(fp); free(col_res); free(col_pos);
	for(i=j=0; (c=res_str[i]); i++){
		if(isalpha(c)){ res_str[j]=toupper(c); j++; }
	} res_str[j]=0;
	fp=tmpfile(); fprintf(fp,">%s\n%s\n\n",pdb_id,res_str); rewind(fp);
	PtrnSeq=ReadSeq(fp,1,strlen(res_str),AB); fclose(fp); free(res_str);
	// PutSeq(stderr,PtrnSeq,AB); 
	set[0]=CopySet(set0);
	for(x=1; set[x]; x++) UnionSet(set[0],set[x]);
	if(verbose) fprintf(stderr,"set[0] (%d):\n",CardSet(set[0]));
	if(verbose) PutSet(stderr,set[0]);
	return set;
}

void	spc_typ::Init()
{
	Int4	i,j,N,x,y;
	char	c,str[200];
	PDB_ID=0;
	IsPutRes[0]=IsPutRes[1]=IsPutRes[2]=IsPutRes[3]=0;	
	if(argc < 2){
		fprintf(stderr,"%s",SPARC_VERSION); print_error(USAGE_SPARC_MAIN); 
	} 
	rm_tmp_files=TRUE;
	InputDCA=FALSE;
	show_all=FALSE;
	SkipWeakHBonds=TRUE;
#if 1
	if(argc > 2 && strcmp(argv[1],"rank") == 0){
	   FILE *tfp;
	   sprintf(str,"%s_sprc_X.dca",argv[2]);
	   if((tfp=fopen(str,"r")) != NULL){
	     fclose(tfp);
#if 0
	     sprintf(str,"%s_sprc_X.mst",argv[2]);
	     if((tfp=fopen(str,"r")) != NULL){
	        fclose(tfp); InputDCA=TRUE; rm_tmp_files=FALSE;
	     }
#else
	     InputDCA=TRUE; // rm_tmp_files=FALSE;
#endif
	   } 
	}
#endif
	time1=time(NULL);
	rpheap_size=300; 
	NumPtrn=0; PtrnSet=0; PtrnSeq=0;
	TopDC_Set=0; TopDC_Grph=0;
	Mtrx=0; StrtMtrx=EndMtrx=-1; IsBB=0; IsSC=0; mode=0; UseSB=0;
	sis=0; psd=0; rphF=rphS=rphC=rphH=rphWF=rphWS=rphAS=rphAF=0;
	wdg=0; wdgfile=0; MinNumBonds=4;
	PlotGrph=FALSE;
	// NOTE: hetmer mode is run under ihd_typ called from run_sparc.cc
        if(argc < 4 || (argc >=4 && argv[3][0]=='-')){
	   switch(argv[1][0]){
	    case 'b': if(strcmp("bb2bb",argv[1])==0) print_error(USAGE_SPARC_BB2BB); break;
	    case 'c': if(strcmp("correl",argv[1])==0) print_error(USAGE_SPARC_CORREL); break;
	    case 'd': if(strcmp("dist",argv[1])==0) print_error(USAGE_SPARC_DIST); break;
	    case 'h': if(strcmp("hbonds",argv[1])==0) print_error(USAGE_SPARC_HBONDS); break;
	    case 'm': if(strcmp("mds",argv[1])==0) print_error(USAGE_SPARC_MDS); break;
	    case 'r': if(strcmp("rank",argv[1])==0) print_error(USAGE_SPARC_RANK); break;
	    case 's': if(strcmp("sc2sc",argv[1])==0) print_error(USAGE_SPARC_SC2SC);
	        else if(strcmp("sc2bb",argv[1])==0) print_error(USAGE_SPARC_SC2BB); 
	        else if(strcmp("sc2sb",argv[1])==0) print_error(USAGE_SPARC_SC2SB); 
	        else if(strcmp("simul",argv[1])==0) print_error(USAGE_SPARC_MDS); 
	        else if(strcmp("sipris",argv[1])==0) print_error(USAGE_SPARC_SIPRIS); 
		break;
	    case 'v': if(strcmp("vsi2pml",argv[1])==0) print_error(USAGE_SPARC_VSI2PML); break;
	    default: break;
	   } print_error(USAGE_SPARC_MAIN);
	} else {
	   switch(argv[1][0]){  // only mds and rank call ccmpred
		case 'b': if(strcmp("bb2bb",argv[1])==0) mode='B'; break;
		case 'c': if(strcmp("correl",argv[1])==0) mode='p'; break;
		case 'd': if(strcmp("dist",argv[1])==0){ mode='D'; } break;
		case 'h': 
		   if(strcmp("hbonds",argv[1])==0) mode='h';
		   else if(strcmp("hetmer",argv[1])==0){
			// this is handled in run_sparc.cc.
		   } break;
		case 'm': if(strcmp("mds",argv[1])==0) mode='m'; break;
		case 'r': if(strcmp("rank",argv[1])==0) mode='r'; break;
		case 's': if(strcmp("sc2sc",argv[1])==0) mode='S';
		  else if(strcmp("sc2bb",argv[1])==0) mode='s'; 
		  else if(strcmp("sc2sb",argv[1])==0) mode='H'; 
		  else if(strcmp("simul",argv[1])==0) mode='m'; 
		  else if(strcmp("sipris",argv[1])==0) mode='Z'; break;
		case 'v': if(strcmp("vsi2pml",argv[1])==0) mode='v'; break;
		default: break;
	   } if(mode==0) print_error(USAGE_SPARC_MAIN);
	}
	TurnOffLicenseStatement();
	verbose=FALSE;
	SrchAll=FALSE;
	MinSpacing=2;
	MaxSpacing=INT4_MAX;
	stblfp=flpfp=pmlfp=vsifp=logfp=0; Chain=0;
	arofp[0]=arofp[1]=arofp[2]=arofp[3]=0;
	Int4 start=4;
//======================================================================
	switch (mode){
	  case 'v':{ 	// vsi2pml
	     if(argc < 4 || argv[3][0] == '-') print_error(USAGE_SPARC_VSI2PML);
	     else {
		Int4 id=atol(argv[3]);
		// fprintf(stderr,"id=%d\n",id);
		this->RunVSI2PyMOL(argv[2],id);
		exit(0);
	     }
	   } break;
	  case 'D':{ 	// dist
	   } break;
	  case 'H':{	// sc2sb
	     if(argc < 4) print_error(USAGE_SPARC_SC2SB);
	     else if(argc == 4){
		if(argv[3][0] != '-') SrchAll=TRUE;
	   	else print_error(USAGE_SPARC_SC2SB);
	     } else if(argc > 4){
		if(argv[4][0] == '-') SrchAll=TRUE;
	   	else print_error(USAGE_SPARC_SC2SB);
	     }
	   } break;
	  case 'h':{	// h-bond
	     if(argc < 5 || argv[4][0] == '-') print_error(USAGE_SPARC_HBONDS);
	     SrchAll=TRUE; start=5; 
	   } break;
	  case 'm':{ 	// simul mode --> MD simulation..
		if(argc < 7 || argv[6][0] == '-') print_error(USAGE_SPARC_MDS);
		start=7;
	   } break;
	  case 'p':{	// correl
	     if(argc < 4) print_error(USAGE_SPARC_CORREL);
	     else if(argc == 4){
		if(argv[3][0] != '-') SrchAll=TRUE;
		else print_error(USAGE_SPARC_CORREL);
	     } else if(argc > 4){
		if(argv[4][0] == '-') SrchAll=TRUE;
		else print_error(USAGE_SPARC_CORREL);
	     }
	   } break;
	  case 'r':{ start=4; } break;	// rank
	  case 'Z':{	// SIPRIS
	     // if(argc < 5 || argv[4][0] == '-') print_error(USAGE_SPARC_SIPRIS);
	     if(argc < 6 || argv[5][0] == '-') print_error(USAGE_SPARC_SIPRIS);
	     SrchAll=TRUE; start=5; 
	   } break;
	  case 'S':	// sc2sc
	  case 's':	// sc2bb
	  case 'B':{	// bb2bb 
		if(argc == 4 || argv[4][0] == '-') SrchAll=TRUE;
	   } break;
	  default: {
		print_error(USAGE_SPARC_MAIN);
	   } break;
	}
//======================================================================
//============ Obtain optional settings  ===============================
	for(Int4 arg=start; arg < argc; arg++){
	   if(argv[arg][0] != '-'){
		continue; // print_error(USAGE_SPARC_MAIN);
	   }
	   switch(argv[arg][1]) {
		case 'D': 
		    if(sscanf(argv[arg],"-D=%d",&x) !=1){
			if(mode == 'r') print_error(USAGE_SPARC_RANK);
		    } break;
		case 'd': 
		    if((mode != 'm' && mode != 'r') ||
				sscanf(argv[arg],"-dev=%d",&x) !=1){
		    	print_error(USAGE_SPARC_MAIN);
		        // } else { fprintf(stderr,"--> %s\n",argv[arg]);
		    } break;
		case 'g':
		   if(sscanf(argv[arg],"-graph=%s",str) ==1){
		      if(argc > 4 && argv[4][0] != '-'){
			print_error("ERROR: -graph option disallowed\n");
		      } else if(mode=='S' || mode=='H'){
			if(wdgfile) free(wdgfile);
			wdgfile=AllocString(str); PlotGrph=TRUE; 
		      } else {
			fprintf(stderr,"ERROR: -graph option disallowed & ignored\n");
		      }
		   } else {
		      if(mode=='S') print_error(USAGE_SPARC_SC2SC);
		      else if(mode=='s') print_error(USAGE_SPARC_SC2BB);
		      else if(mode=='H') print_error(USAGE_SPARC_SC2SB);
		      else print_error(USAGE_SPARC_MAIN);
		   } break;
		case 'h':
		   if(sscanf(argv[arg],"-heap=%ld",&rpheap_size)==1){
		     if(rpheap_size < 10 || rpheap_size > 100000){
		       if(mode=='S') print_error(USAGE_SPARC_SC2SC);
		       else if(mode=='s') print_error(USAGE_SPARC_SC2BB);
		       else if(mode=='H') print_error(USAGE_SPARC_SC2SB);
		       else if(mode=='B') print_error(USAGE_SPARC_BB2BB);
		       else print_error(USAGE_SPARC_MAIN);
		     } else if(!SrchAll){
		       if(mode=='S') print_error(USAGE_SPARC_SC2SC);
		       else if(mode=='s') print_error(USAGE_SPARC_SC2BB);
		       else if(mode=='H') print_error(USAGE_SPARC_SC2SB);
		       else if(mode=='B') print_error(USAGE_SPARC_BB2BB);
		       else print_error(USAGE_SPARC_MAIN);
		     }
		   } break;
		case 'm':
		   if(sscanf(argv[arg],"-min_bond=%ld",&MinNumBonds)==1){
			if(MinNumBonds < 1 || MinNumBonds > 200)
			   print_error(USAGE_SPARC_HBONDS);
		   } else { print_error(USAGE_SPARC_HBONDS); } break;
		case 'p':
		   if(sscanf(argv[arg],"-pml=%s",str) ==1){
		     if(SrchAll) pmlfp=open_file(str,".pml","w");
		     else fprintf(stderr,"ERROR: -pml option disallowed & ignored\n");
		   } else if(mode == 'r' && strncmp("-pdbaa=",argv[arg],7)==0){
			// pass ahead...
		   } else if(mode == 'r' && strncmp("-ptrn=",argv[arg],6)==0){
			// pass ahead...
		   } else {
		      if(mode=='S') print_error(USAGE_SPARC_SC2SC);
		      else if(mode=='s') print_error(USAGE_SPARC_SC2BB);
		      else if(mode=='H') print_error(USAGE_SPARC_SC2SB);
		      else print_error(USAGE_SPARC_MAIN);
		   } break;
		case 's': 
		        if((mode=='B' || mode == 'H' || mode=='S' || mode=='s'
				|| mode == 'D' || mode == 'p')){
		   	  if(strcmp("-show",argv[arg])==0){
				show_all=TRUE;
			  } else if(mode == 'p'){
		  		print_error(USAGE_SPARC_CORREL); 
			  } else if(mode == 'D'){
		  		print_error(USAGE_SPARC_DIST); 
			  } else if(sscanf(argv[arg],"-space=%d",&MinSpacing)==1){
			    if(MinSpacing < 1 || MinSpacing > 20){
		  		print_error(USAGE_SPARC_MAIN); 
			    }
			  }
		   	} else if(mode=='r' && strcmp("-save",argv[arg])==0){
			    rm_tmp_files=FALSE; // argv[arg][1]=' ';
		   	} else if(mode=='r' && 
				sscanf(argv[arg],"-sbsmpl=%d:%d",&x,&y) ==2){
				// pass ahead...
		  	} else print_error(USAGE_SPARC_MAIN);
			break;
		case 't': 
		    if((mode != 'm' && mode != 'r') ||
		    		sscanf(argv[arg],"-thrds=%d",&x) !=1){
		    	print_error(USAGE_SPARC_MAIN);
		    } break;
		case 'v': if(strcmp("-verbose",argv[arg])==0){
		     verbose=TRUE; 
		   } else if(strcmp("-vsi",argv[arg])==0){
		     if(mode=='S'){
			 vsifp=stdout; 
			 vsifp=open_file(argv[2],".vsi","w");
		    }
		   } else print_error(USAGE_SPARC_MAIN); break;
		case 'w': if(strcmp("-weak",argv[arg])==0){
			SkipWeakHBonds=FALSE;
		    } break;
		default: print_error(USAGE_SPARC_MAIN); break;
	   }
	}
	if(mode == 'r' || mode == 'm' || mode == 'Z') return;
//==========================================================================
// fprintf(stderr,"mode='%c'\n",mode);
	NEW(Chain,strlen(argv[3])+4,char);
	char prefix[20],queryPDB[20];
	if(sscanf(argv[3],"%[A-Z]=%[^:]:%s",Chain,prefix,queryPDB) == 3){
	   if(strlen(queryPDB) != 6) print_error(USAGE_SPARC_SC2SB);
	   a_type AB=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
	   fprintf(stderr,"%s=%s:%s\n",Chain,prefix,queryPDB);
	   sprintf(str,"%s.darc",prefix);
	   char *darc_file=AllocString(str);
	   sprintf(str,"%s_fg",prefix);
	   char *cma_file=AllocString(str);
	   PtrnSet=QueryResiduesBPPS(darc_file,cma_file,queryPDB,AB);
	   PDB_ID=AllocString(queryPDB);
//PutSeq(stderr,PtrnSeq,AB);
	   NilAlpha(AB);
	   // exit(1);
	} else if(sscanf(argv[3],"%[A-Z]",Chain) == 1){
	   if(strlen(Chain) != strlen(argv[3])) print_error(USAGE_SPARC_MAIN);
	} else if(mode=='D') print_error(USAGE_SPARC_DIST);
        else print_error(USAGE_SPARC_H_BOND);
// fprintf(stderr,"mode=%c; SrchAll=%d\n",mode,SrchAll);
//==========================================================================
	if(mode=='H' || mode=='S' || mode=='s' || mode=='B'){ 
	 if(SrchAll){
	   psd=new psd_typ(argv[2],Chain,PtrnSeq); 
#if 0
	   if(PtrnSeq){
	    if(mode=='H' || mode=='S' || mode=='s'){ 
	      pdb_typ pp=psd->RtnPDB(1);
	      Int4 Start=0;
	      e_type Sq=GetPDBSeq(1,pp);
	      a_type AB=AminoAcidAlphabetPDB(pp); 
	      // PutSeq(stderr,Sq,AB);
	      if(IsSameSeq0(Sq,PtrnSeq,&Start,TRUE)){
		AlnSeqSW(stderr,11,2,Sq,PtrnSeq,AB);
	      } else print_error("Input sequence mismatch");
	      // exit(1);
	    } else print_error("Input error");
	   }
#endif
	 }
	} else if(mode=='p'){ 
	  if(SrchAll) psd=new psd_typ(argv[2],Chain); 
	}
	if(psd){ 
	  if(mode=='B' || mode=='S' || mode=='s' || mode=='H'
                                || mode == 'D' || mode=='h' || mode=='p'){
             N=10;
            if(psd->NumPDB() < N) print_error("too few structures for an analysis");
          }
	}
}

void	spc_typ::Free()
{
	if(PlotGrph && Mtrx){
		FILE *gfp=open_file(argv[2],".grph","w");
		this->PutSubGraphs(gfp); fclose(gfp);
	}
	if(Chain) free(Chain);
// fprintf(stderr,"Freeing psd_typ\n");
	if(psd) delete psd; psd=0;
        FILE *fp=0;
	char str[100],c;
	if(pmlfp && pmlfp != stdout) fclose(pmlfp);
	if(arofp[0] && arofp[0] != stdout) fclose(arofp[0]);
	if(arofp[1] && arofp[1] != stdout) fclose(arofp[1]);
	if(arofp[2] && arofp[2] != stdout) fclose(arofp[2]);
	if(logfp && logfp != stdout){
		fclose(logfp);
		logfp=open_file(argv[2],".log","r");
		while((c=getc(logfp)) != EOF) fprintf(stdout,"%c",c);
		fclose(logfp);
	}
	if(vsifp && vsifp != stdout) fclose(vsifp);
	if(flpfp && flpfp != stdout) fclose(flpfp);
	if(stblfp && stblfp != stdout) fclose(stblfp);
	if(rphF) delete rphF; rphF=0;
	if(rphS) delete rphS; rphS=0;
	if(rphC) delete rphC; rphC=0;
	if(rphH) delete rphH; rphH=0;
	if(rphWS) delete rphWS; rphWS=0;
	if(rphWF) delete rphWF; rphWF=0;
	if(rphAS) delete rphAS; rphAS=0;
	if(rphAF) delete rphAF; rphAF=0;
	if(wdgfile) free(wdgfile);
	if(rm_tmp_files){
          sprintf(str,"%s_sprc.in",argv[2]); fp=fopen(str,"r");
          if(fp){ fclose(fp); if(1) std::remove(str); }

	  if(InputDCA == FALSE){
            sprintf(str,"%s_sprc_X.dca",argv[2]); fp=fopen(str,"r");
            if(fp){ fclose(fp); if(1) std::remove(str); }
	  }

          sprintf(str,"%s_sprc_X.mst",argv[2]); fp=fopen(str,"r");
          if(fp){ fclose(fp); if(1) std::remove(str); }

          sprintf(str,"%s_sprc_X",argv[2]); fp=fopen(str,"r");
          if(fp){ fclose(fp); if(1) std::remove(str); }
	}
	// fprintf(stderr,"DEBUG XXX.1\n");
	// fp=open_file(argv[2],".sprc","r");
        sprintf(str,"%s.sprc",argv[2]); fp=fopen(str,"r");
	if(fp){ 
	   while((c=fgetc(fp))!=EOF){
		if(c==';'){ fprintf(stdout,"\n\n"); break; }
		else fprintf(stdout,"%c",c); 
	   } fclose(fp); 
	}
	fp=fopen("core_dump.vsi","r");
        if(fp){ fclose(fp); if(1) std::remove("core_dump.vsi"); }
#if 1	// pattern MDS search
	if(PtrnSet){
	  for(Int4 i=0; i <= NumPtrn;i++){ NilSet(PtrnSet[i]); } free(PtrnSet);
	}
	if(PtrnSeq) NilSeq(PtrnSeq);
	if(PDB_ID) free(PDB_ID);
	if(TopDC_Set) NilSet(TopDC_Set);
	if(TopDC_Grph) NilWdgraph(TopDC_Grph);
#endif
	// fprintf(stderr,"DEBUG XXX.2\n");
	fprintf(stderr,"\tsearch time: %d seconds (%0.2f minutes)\n",
		time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	return;
}

