/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "spc_typ.h"
#include "spc_usage.h"

void    spc_typ::GetSeqContext(char *Str,Int4 start, Int4 length, e_type E, a_type A)
{
	char	str[20];
	Int4	flank=10,end,i=MAXIMUM(Int4,1,(start+E->offset));
	Int4	e=start + length - 1;

	sprintf(Str,"%4d  ",i);
	if(flank > 0){
	  end = e + flank;
	  for(i=start-flank; i <= end; i++){
		if(i < 1 || i > (Int4) E->n) sprintf(str," ");
		else if(i == e) {
			sprintf(str,"%c ", AlphaChar(E->S[i],A));
		} else if(i == start) {
			sprintf(str," %c", AlphaChar(E->S[i],A));
		} else {
			sprintf(str,"%c", AlphaChar(E->S[i],A));
		} strcat(Str,str);
	  }
	} else {
	  for(i=start; i <= e; i++){
		if(i < 1 || i > (Int4) E->n) sprintf(str," ");
		else sprintf(str,"%c", AlphaChar(E->S[i],A));
		strcat(Str,str);
	  }
	} e = MINIMUM(Int4,e,LenSeq(E));
	sprintf(str," %4d\n",e+E->offset); strcat(Str,str);
}

Int4	spc_typ::RunAllPairsFast(FILE *ofp)
{
	Int4	N,NN,i,j,k,x,p,MinRes,MaxRes,nI,nJ;
	FILE	*efp=0;
	Int4	nChn,MaxLen=0;

	assert(mode != 'D');
	for(i=0 ; Chain[i]; ) i++; nChn=i; 
	if(pmlfp){ this->PutHeaderPyMOL(); }
	// 1. open up one of the structures for reference.
	if(mode=='S') fprintf(stderr,"sc2sc hydrogen bonds done.\n");
	else if(mode=='s') fprintf(stderr,"sc2bb hydrogen bonds done.\n");
	pdb_typ	pdb=psd->RtnPDB(1); 
	Int4	nPDB=psd->NumPDB();
	MinRes=999999; MaxRes=0;
	for(i=0; Chain[i]; i++){  // find start and end common to all chains.
	        j=GetChainNumberPDB(pdb,Chain[i]);
		if((x=MinResPDB(j,pdb)) > 0){ MinRes=MINIMUM(Int4,MinRes,x); }
		if(i==0) MaxRes=MAXIMUM(Int4,MaxRes,MaxResPDB(j,pdb));
		else MaxRes=MINIMUM(Int4,MaxRes,MaxResPDB(j,pdb));
		Int4 Len=MaxRes-MinRes+1;
		MaxLen = MAXIMUM(Int4,Len,MaxLen);
	} // Only need to look at one; they are all the same.

//fprintf(stderr,"DEBUG 1\n");
	// if(sis==0 && mode != 'B') sis = new sis_typ(Chain,MaxLen);
	if(sis==0 && mode != 'B') sis = new sis_typ(Chain,MaxRes);
	if(vsifp){
	  fprintf(vsifp,"~$=1.\n");
	  for(i=1; i <= nChn; i++){
	     fprintf(vsifp,"File%d=%s:%c  //\n",i,psd->RtnPath(1),Chain[i-1]);
	  } fprintf(vsifp,"\n1-10000.W15\n\n");
	  fprintf(vsifp,"%d-%d.Y80\n",MinRes,MaxRes);
	}
    {
	i=GetChainNumberPDB(pdb,Chain[0]);
	e_type Sq=GetPDBSeq(i,pdb);
	a_type AB=AminoAcidAlphabetPDB(pdb); StrtMtrx=MinRes; EndMtrx=MaxRes;
// PutSeq(stderr,Sq,AB);
	// set_typ useSB=0;
	if(mode=='S' && PlotGrph){	// Create contact matrix...
	  this->CreateMtrx(pdb);
	} // else { useSB=MakeSet(MaxRes+4); FillSet(useSB); }
	Int4 NumVSI=0;
// MinRes=410;
	char setI=0,setJ=0;
	for(nI=MinRes; nI <= MaxRes; nI++) {
	   if(PtrnSet && !MemberSet(nI,PtrnSet[0])){
	      if(!show_all && TopDC_Set && !MemberSet(nI,TopDC_Set)) continue;
	   }
	   if(PtrnSet){
		for(Int4 ii=1; PtrnSet[ii]; ii++){
		   if(MemberSet(nI,PtrnSet[ii])) setI=ii; 
		}
	   }
	   // if(!MemberSet(nI,useSB)) continue;
// if(nI >= 411) break;
// if(nI>=144) break; nI=144;
// MinRes=262;
	   // for(nJ=MinRes; nJ <= MaxRes; nJ++)
	   for(nJ=nI+1; nJ <= MaxRes; nJ++)
	   {
	     if(PtrnSet && !MemberSet(nJ,PtrnSet[0])){
	        if(!show_all && TopDC_Set && !MemberSet(nJ,TopDC_Set)) continue;
	     }
	     if(PtrnSet){
		for(Int4 jj=1; PtrnSet[jj]; jj++){
		   if(MemberSet(nJ,PtrnSet[jj])) setJ=jj; 
		}
	     }
	     // if(!MemberSet(nJ,useSB)) continue;
// if(nJ>=147) break; nJ=147;
	     if(abs(nI-nJ) < MinSpacing) continue;
	     if(mode=='s' && nJ < nI) continue;  // only need to check one way.
	     Int4	cI,cJ;
	     float	HA_dmax=2.5,dmax=3.6; 
	     double	dIJ,dJI,dII,cut=2.5,cutX=3.0,Cut=0.01;
	     double	d=BigDist,dd,D=BigDist,DD=BigDist,Dd=BigDist;
#if 1
	     cI=GetChainNumberPDB(pdb,Chain[0]);
	     char rI=psd->GetResChar(1,cI,nI),rJ=psd->GetResChar(1,cI,nJ);
	     if(rI==0 || rJ==0) continue;
#if 1
	     if(this->InvalidHbondPair(rI,rJ,mode)) continue;
#else
	     if(mode == 's'){
	        if(strchr("GAFVILMP",rI) && strchr("GAFVILMP",rJ)) continue;
	     } else if(mode == 'S'){
	        if(strchr("GAFVILMP",rI) != NULL) continue;
	        if(strchr("GAFVILMP",rJ) != NULL) continue;
		if(strchr("DE",rI) &&  strchr("DE",rJ)) continue;
		if(strchr("RK",rI) &&  strchr("RK",rJ)) continue;
	     }
#endif
#endif
	     for(i=0; Chain[i]; i++){
	       double	td=BigDist,tD=BigDist,cd=BigDist,cD=BigDist;
	       // find residues relatively near each other.
	       cI=GetChainNumberPDB(pdb,Chain[i]);
	       j=i+1;
	       if(Chain[j]==0) j=0;
	       cJ=GetChainNumberPDB(pdb,Chain[j]);
	       dIJ=DistancePDB(nI,"CA",cI,nJ,"CA",cJ,pdb);
	       dJI=DistancePDB(nI,"CA",cJ,nJ,"CA",cI,pdb);
	       dII=DistancePDB(nI,"CA",cI,nJ,"CA",cI,pdb);
	       if(0) fprintf(stderr,
			"%d -> %d%c vs %d%c: dIJ=%lf; dJI=%lf; dII=%lf\n",
		  	N,nI,Chain[i],nJ,Chain[j],dIJ,dJI,dII);
	       if(dIJ > 30.0 && dJI > 30.0 && dII > 30.0){
		  // d=D=DD=Dd=30.0; break;
		  // d=D=DD=Dd=30.0; continue;
		  continue;
	       }
	       for(k=0,p=1; k <= 1; k++,p=nPDB){ 
		 if(mode != 'B' && nChn > 1){
	           td=this->GetContactsFast(efp,nI,nJ,HA_dmax,cI,cJ,p);
	           tD=this->GetContactsFast(efp,nI,nJ,HA_dmax,cJ,cI,p);
		 } 
	         cd=this->GetContactsFast(efp,nI,nJ,HA_dmax,cI,cI,p);
	         cD=this->GetContactsFast(efp,nJ,nI,HA_dmax,cI,cI,p);
		 
	         if(td > 0.0) d=MINIMUM(double,d,td);	// trans
	         if(tD > 0.0) D=MINIMUM(double,D,tD);	// trans
	         if(cd > 0.0) DD=MINIMUM(double,DD,cd);	// cis
	         if(cD > 0.0) Dd=MINIMUM(double,Dd,cD);	// cis
		 dd= td; dd=MINIMUM(double,tD,dd);
		 dd=MINIMUM(double,cd,dd); dd=MINIMUM(double,cD,dd);
		 if(verbose && dd < cutX) fprintf(stderr,
		   "%d -> %d%c vs %d%c: td=%lf; tD=%lf; cd=%lf; cD=%lf; dd=%lg\n",
		      p,nI,Chain[i],nJ,Chain[j],td,tD,cd,cd,dd);
	       }
	     }
	     if((d < cutX && d > Cut) || (D < cutX && D > Cut) ||
		(DD < cutX && DD > Cut) || (Dd < cutX && Dd > Cut)) {
		char Str[150],str[10],StrI[100],StrJ[100];
		Int4 os=OffSetSeq(Sq);
		char rI=AlphaChar(ResSeq(nI-os,Sq),AB);
		char rJ=AlphaChar(ResSeq(nJ-os,Sq),AB);
		if(mode=='s') sprintf(str,"sc2bb");
		else if(mode=='S') sprintf(str,"sc2sc");
		else sprintf(str,"bb2bb");
		char cII=0,cJJ=0;
		if(0 && mode=='B'){
		   sprintf(Str,"%c%d vs %c%d: %.2lf %.2lf (%s)\n",
				rI,nI,rJ,nJ,DD,Dd,str);
		} else if(PtrnSet){
		   cII=SbGrpCode[setI]; cJJ=SbGrpCode[setJ];
		   // if(!isalpha(cII)) cII='-'; if(!isalpha(cJJ)) cJJ='-';
		   if(d < 9999999.00){
		     d=MINIMUM(double,d,D); DD=MINIMUM(double,Dd,DD);
		     sprintf(Str,
			"%c%d(%c) vs %c%d(%c): %.2lf %.2lf (%s)\n",
				rI,nI,cII,rJ,nJ,cJJ,DD,d,str);
		   } else {
		     DD=MINIMUM(double,Dd,DD);
		     sprintf(Str,"%c%d(%c) vs %c%d(%c): %.2lf (%s)\n",
				rI,nI,cII,rJ,nJ,cJJ,DD,str);
		   }
		} else {
		   if(d < 9999999.00){
		     d=MINIMUM(double,d,D); DD=MINIMUM(double,Dd,DD);
		     sprintf(Str,
			"%c%d vs %c%d: %.2lf %.2lf (%s)\n",
				rI,nI,rJ,nJ,DD,d,str);
		   } else {
		     DD=MINIMUM(double,Dd,DD);
		     sprintf(Str,"%c%d vs %c%d: %.2lf (%s)\n",
				rI,nI,rJ,nJ,DD,str);
		   }
		} this->GetSeqContext(StrI,nI-os-1,3,Sq,AB); 
		this->GetSeqContext(StrJ,nJ-os-1,3,Sq,AB);
#if 0
PutSeq(stderr,Sq,AB);
fprintf(stderr,"%s\n%s\n%s\nnI=%d; nJ=%d; os=%d\n",Str,StrI,StrJ,nI,nJ,os);
#endif
		// if(verbose){ fprintf(stderr,"%s\n",Str); }
		if(d <= cutX){		// trans: I vs J
		   d=this->RunOnePairFast(nI,nJ,TRUE,cut,ofp,Str,StrI,StrJ);
		}
		if(D <= cutX){		// trans: J vs I
		   D=this->RunOnePairFast(nJ,nI,TRUE,cut,ofp,Str,StrI,StrJ);
		}
		if(DD <= cutX){		// cis: I vs J
		   Dd=DD=this->RunOnePairFast(nI,nJ,FALSE,cut,ofp,Str,StrI,StrJ);
		} else if(Dd <= cutX){ 	// cis: J vs I.
		   DD=Dd=this->RunOnePairFast(nJ,nI,FALSE,cut,ofp,Str,StrI,StrJ);
		}
	        if(d < cut || D < cut || DD < cut || Dd < cut){
		  // PutSeqRegion(ofp,nI-os-1,3,Sq,AB); fprintf(ofp,"\n");
		  // PutSeqRegion(ofp,nJ-os-1,3,Sq,AB); fprintf(ofp,"\n\n");
		  // fflush(ofp);
// fprintf(stderr,"============= DEbUG CUT=============\n");
// exit(1);
		  if(pmlfp){
		   Int4 ri=AlphaCode(rI,AB),rj=AlphaCode(rJ,AB);
// fprintf(stderr,"============= DEbUG PML =============\n");
		   this->PutResPairPyMOL(ri,rI,nI,rj,rJ,nJ);
		  }
	          if(vsifp){
// fprintf(stderr,"============= DEbUG VSI =============\n");
		    if(NumVSI > 0) fprintf(vsifp,","); NumVSI++;
		    if(PtrnSet){
		       fprintf(vsifp,"%c%d.%c,%c%d.%c",rI,nI,cII,rJ,nJ,cJJ);
		    } else {
		       fprintf(vsifp,"%c%d.R,%c%d.R",rI,nI,rJ,nJ);
		    }
		    fflush(vsifp);
		  }
		} // end if(d < cut || D < cut || DD < cut || Dd < cut)
	     } // end if((d < cutX && d > Cut) || (D < cutX && D > Cut)...
	  } // end for(nJ=nI+1; nJ <= MaxRes; nJ++)
	} // end for(nI=MinRes; nI <= MaxRes; nI++)
	// if(useSB) NilSet(useSB); 
	NilSeq(Sq); 
    }
	if(vsifp){ fprintf(vsifp,"\n\n"); }
	if(pmlfp) this->PutTailPyMOL();
	return 0;
}

double	spc_typ::RunOnePairFast(Int4 nI,Int4 nJ, BooLean trans,double cut,
		FILE *outfp,char *Msg,char *StrI, char *StrJ)
{
	double	dd,Dd;
	float	HA_dmax=2.5,dmax=3.6; 
	FILE	*efp=0,*ofp=0;
	Int4	i,j,z,N,cI,cJ,nChn;
	for(nChn=0 ; Chain[nChn]; ) nChn++; 
	double	*Sum; NEW(Sum, nChn+3,double);
	double	*Value[9]; Value[0]=Value[1]=Value[2]=Value[3]=Value[4]=0;
	tri_typ	*tri=0;

	assert(mode != 'D');
	assert(psd != 0);
	if(0 && cut > 0.0) ofp=tmpfile(); 
	if(verbose) efp=stderr;
	Int4 nPDB=psd->NumPDB(),Mid=nPDB/2;
	if(tri==0){ tri=new tri_typ(Chain,nPDB); }
	Int4 *NN=0; NEW(NN, nChn +3, Int4);
	for(N=1; N <= nPDB; N++){
// if(N > 1) return 0.0;
	  pdb_typ pdb = psd->RtnPDB(N);
	  if(trans) j=1; else j=0;
	  for(i=0 ; Chain[i]; i++,j++){
	   if(Chain[j]==0) j=0;
	   if(ofp){
	     if(N==1 && i==0){
	       fprintf(ofp,"index\t");
	       for(Int4 x=0,y=1; Chain[x];y++,x++){
		if(Chain[y]==0) y=0; 
		if(trans) fprintf(ofp,"%c%c",Chain[x],Chain[y]);
		else fprintf(ofp,"%c",Chain[x]);
		if(y != 0) fprintf(ofp,"\t");
	       } fprintf(ofp,"\n"); 
	     }
	   }
	   if(ofp && i==0) fprintf(ofp,"%d\t",N);
	   cI=GetChainNumberPDB(pdb,Chain[i]);
	   cJ=GetChainNumberPDB(pdb,Chain[j]);
	   if(cI == 0 || !IsProteinPDB(cI,pdb)){
		// if(efp) fprintf(stderr,"chain '%c' absent; skipping...\n",Chain[i]); 
		if(ofp){ fprintf(ofp,"-"); if(Chain[i+1]) fprintf(ofp,"\t"); }
		continue;
	   } if(cJ == 0 || !IsProteinPDB(cJ,pdb)){
		// if(efp) fprintf(stderr,"chain '%c' absent; skipping...\n",Chain[j]); 
		if(ofp){ fprintf(ofp,"-"); if(Chain[i+1]) fprintf(ofp,"\t"); }
		continue;
	   }
	   if(efp) fprintf(efp,"============ %d%c:%d%c ==================\n",
				nI,Chain[i],nJ,Chain[j]);
	   dd=this->GetContactsFast(efp,nI,nJ,HA_dmax,cI,cJ,N);
	   if(ofp){
	      if(dd >= BigDist){
	        fprintf(ofp,"...."); fflush(ofp); 
	        // fprintf(ofp,"%.1lf",dd);
	      } else fprintf(ofp,"%.2lf",dd);
	   }
	   tri->AddValue(N,dd,i);
	   if(N==1){
		if(i==0) NEW(Value[0],nChn+3,double);
		Value[0][i]=dd;
	   } else if(N==Mid){
		if(i==0) NEW(Value[1],nChn+3,double);
		Value[1][i]=dd;
	   } else if(N==nPDB){
		if(i==0) NEW(Value[2],nChn+3,double);
		Value[2][i]=dd;
	   }
	   if(ofp && Chain[i+1]) fprintf(ofp,"\t"); 
	   if(dd < this->UnDefHBond){ Sum[i] += dd; NN[i]++; }
	  } if(ofp) fprintf(ofp,"\n"); 
	  // tri->Put(stderr,N);
	}
	NEW(Value[3],nChn +3, double);
	double	rtn=DBL_MAX;
	char	nhits=0;
// ofp=stdout;
	if(1 || efp && nChn > 0){
	   if(ofp) fprintf(ofp,"avg.\t");
	   for(Int4 x=0; Chain[x];x++){
	     dd=Sum[x]/(double) NN[x]; 
	     if(ofp) fprintf(ofp,"%.2lf",dd);
	     Value[3][x]=dd;
	     if(ofp && Chain[x+1]) fprintf(ofp,"\t");
	     rtn=MINIMUM(double,rtn,dd);
	     if(PlotGrph && Mtrx){
		if(dd <= 2.5){
		   Mtrx[nI][nJ]++; Mtrx[nJ][nI]++; nhits++;
		}
	     }
	     if(dd <= 2.5){
		Int4 y,r;
		if(trans){	// x = Ct & y = Rt or x = Lt & y = Ct
	   	   if(Chain[x+1]==0) y=0; else y=x+1;
		   if(sis){
		     sis->AddSite(Ct,x,nI); sis->AddSite(Rt,x,nJ);
		     sis->AddSite(Lt,y,nI); sis->AddSite(Ct,y,nJ);
		   }
		} else {	// x = Ct & x = Ct
		   if(sis){ sis->AddSite(Ct,x,nI); sis->AddSite(Ct,x,nJ); }
		}
	     }
	   } if(ofp) fprintf(ofp,"\n"); 
	} free(Sum); free(NN);
#if 1
	if(nhits > 0 && PlotGrph && Mtrx){
		if(mode=='S'){ AddSet(nI,IsSC[nJ]); AddSet(nJ,IsSC[nI]); }
		else if(mode=='s'){ AddSet(nI,IsBB[nJ]); AddSet(nJ,IsBB[nI]); }
		Mtrx[nI][0]++; Mtrx[nJ][0]++; 
		JoinWdgraph(nI,nJ,nChn-nhits,wdg);
		JoinWdgraph(nJ,nI,nChn-nhits,wdg);
	}
#endif
	if(ofp && cut > 0){
	   if(rtn <= cut){ 
		if(Msg) fprintf(outfp,"%s",Msg);
		char c;
		if(ofp){
		    rewind(ofp); 
		    while((c=fgetc(ofp)) != EOF) fprintf(outfp,"%c",c); 
		}
	   }
	} if(ofp) fclose(ofp);
	char cmd[200],str[10],CT='C';
	if(trans) CT='T';
	if(mode == 'S') sprintf(str,"sc2sc");
	else if(mode == 's') sprintf(str,"sc2bb");
	else if(mode == 'B') sprintf(str,"bb2bb");
	else print_error("This should not happen");
	sprintf(cmd,"sparc %s %s %s %d:%d%c\n",str,argv[2],argv[3],nI,nJ,CT);
	keytyp key=0;
	char   **msgF,**msgS,**msgB;
	if(mode != 'B'){
	  msgF=tri->RtnResults(key,Msg,cmd,trans,Value,'F');
	  if(msgF){
	   if(rphF==0) rphF = new rph_typ(rpheap_size,nChn);
	   for(z=0; msgF[z]; ) z++;
	   msgF[z] = AllocString(StrI); z++; msgF[z] = AllocString(StrJ);
	   rphF->Insert(key,msgF);
	  }
	  msgS=tri->RtnResults(key,Msg,cmd,trans,Value,'S');
	  if(msgS){
#if 0
	   for(z=0; msgS[z]; z++) fprintf(stderr,"*%d*->%s",z,msgS[z]);
	   fprintf(stderr,"\n");
#endif
	   for(z=0; msgS[z]; ) z++;
	   msgS[z] = AllocString(StrI); z++; msgS[z] = AllocString(StrJ);
	   if(rphS==0) rphS = new rph_typ(rpheap_size,nChn);
	   rphS->Insert(-key,msgS);
	  }
	} else {
	  msgB=tri->RtnResults(key,Msg,cmd,trans,Value,'B');
	  if(msgB){
	   if(rphF==0) rphF = new rph_typ(rpheap_size,nChn);
	   for(z=0; msgB[z]; ) z++;
	   msgB[z] = AllocString(StrI); z++; msgB[z] = AllocString(StrJ);
	   rphF->Insert(key,msgB);
	  }
	}
	for(i=0; i<=3; i++) if(Value[i]) free(Value[i]);
	delete tri; tri=0;
	return rtn;
}

double	spc_typ::GetContactsFast(FILE *fptr, Int4 resI,Int4 resJ, float HA_dmax,
		Int4 cI, Int4 cJ, Int4 X)
// Move this routine to libpdb.a at some point:
{
	if(cI==0 || cJ==0){ print_error("chain not found!"); }
	assert(psd != 0);
	pdb_typ P=psd->RtnPDB(X);
	res_typ ResI=psd->RtnResI(X,cI,resI);
	res_typ ResJ=psd->RtnResI(X,cJ,resJ);
	double Dd,dd=BigDist;
	if(ResI != 0  && ResJ != 0){
	   dd=this->GetHBonds(fptr,ResI,ResJ,cI,cJ,HA_dmax,P);
	   // I == donor; J == acceptor.
	   Dd=this->GetHBonds(fptr,ResJ,ResI,cJ,cI,HA_dmax,P);
	   // J == donor; I == acceptor.
	   dd = MINIMUM(double,dd,Dd);
	} return dd;
} 

