/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "spc_typ.h"
#include "spc_usage.h"

double	spc_typ::RunTwoPairs(Int4 nI,Int4 nJ,Int4 nK,Int4 nL,
		BooLean trns,BooLean trns2,double cut,FILE *outfp)
{
	char	ct='C',ct2='C';
	if(trns) ct='T';
	if(trns2) ct2='T';
	fprintf(stderr,"\n%d:%d%c %d:%d%c\n\n",nI,nJ,ct,nK,nL,ct2);
	BooLean	noMainChn=TRUE; 
	char	pdbid[200];
	double	dd,Dd;
	float	HA_dmax=2.5,dmax=3.6; 
	FILE	*ifp,*efp=0;
	Int4	i,j,k,l,N,cI,cJ;
	Int4	nChn;
	for(i=0 ; Chain[i]; ) i++; nChn=i; 
  	Int4 	*XY,*xy,*xY,*Xy;
	for(i=0 ; Chain[i]; i++){
		NEW(XY,nChn+3,Int4); NEW(xy,nChn+3,Int4);
		NEW(Xy,nChn+3,Int4); NEW(xY,nChn+3,Int4);
	}
#if 1
	char  rI,rJ,rK,rL;
#endif
	pdb_typ	pdb0;
	FILE *ofp=0;
	if(cut > 0.0) ofp=tmpfile(); else ofp=outfp;
	ifp=open_file(argv[2],"","r");
	for(N=0; fscanf(ifp,"%s\n",pdbid) == 1; ){
	  // fprintf(stderr,"%d.%s\n",N+1,pdbid);
	  pdb_typ pdb = MakePDB(pdbid); N++; 
	  if(trns) j=1; else j=0;
	  if(trns2) l=1; else l=0;

	  if(N == 1){
	      fprintf(ofp,"index");
	      for(Int4 x=0,y=1; Chain[x];y++,x++){
		if(Chain[y]==0) y=0; 
		if(trns) fprintf(ofp,"\t%c%c",Chain[x],Chain[y]);
		else fprintf(ofp,"\t%c",Chain[x]);
		if(trns2) fprintf(ofp,"\t%c%c",Chain[x],Chain[y]);
		else fprintf(ofp,"\t%c",Chain[x]);
	      } fprintf(ofp,"\n"); 
	  }

	  for(i=k=0 ; Chain[i] && Chain[k]; i++,j++,k++,l++){
	    if(Chain[j]==0) j=0;
	    if(i==0) fprintf(ofp,"%d\t",N);
	    cI=GetChainNumberPDB(pdb,Chain[i]); cJ=GetChainNumberPDB(pdb,Chain[j]);
	    if(cI == 0 || !IsProteinPDB(cI,pdb)){
		fprintf(ofp,"-"); if(Chain[i+1]) fprintf(ofp,"\t"); continue;
	    } if(cJ == 0 || !IsProteinPDB(cJ,pdb)){
		fprintf(ofp,"-"); if(Chain[i+1]) fprintf(ofp,"\t"); continue;
	    } 

	    dd=this->GetContactsPDB(efp,nI,nJ,HA_dmax,cI,cJ,pdb,rI,rJ);
double ee=dd;
	    if(dd >= BigDist){ fprintf(ofp,"-"); } else fprintf(ofp,"%.2lf",dd);
	    if(Chain[i+1]) fprintf(ofp,"\t"); 
	    else fprintf(ofp,"\t");

	    if(Chain[l]==0) l=0;
	    // if(k==0) fprintf(ofp,"-\t");
	    cI=GetChainNumberPDB(pdb,Chain[k]); cJ=GetChainNumberPDB(pdb,Chain[l]);
	    if(cI == 0 || !IsProteinPDB(cI,pdb)){
		fprintf(ofp,"-"); if(Chain[k+1]) fprintf(ofp,"\t"); continue;
	    } if(cJ == 0 || !IsProteinPDB(cJ,pdb)){
		fprintf(ofp,"-"); if(Chain[k+1]) fprintf(ofp,"\t"); continue;
	    } 
	    dd=this->GetContactsPDB(efp,nK,nL,HA_dmax,cI,cJ,pdb,rK,rL);
if(dd <= 2.5 && ee <= 2.5) XY[i]++;
else if(dd <= 2.5 && ee > 2.5) Xy[i]++;
else if(dd > 2.5 && ee <= 2.5) xY[i]++;
else if(dd > 2.5 && ee > 2.5) xy[i]++;
	    if(dd >= BigDist){ fprintf(ofp,"-"); } else fprintf(ofp,"%.2lf",dd);
	    if(Chain[k+1]) fprintf(ofp,"\t"); 
	  } fprintf(ofp,"\n"); 
	  if(N > 1) NilPDB(pdb); else pdb0=pdb;
	}
	double rtn=DBL_MAX;
	if(cut > 0){
	   if(rtn <= cut){ 
		char c; rewind(ofp); 
		while((c=fgetc(ofp)) != EOF) fprintf(outfp,"%c",c); fclose(ofp);
	   }
	}
	// compute mutual information...
	a_type	AB=AminoAcidAlphabetPDB(pdb0);
	char CT,CT2,Msg[200];
	double	twotail;
	if(trns) CT='T'; else CT='C';
	if(trns2) CT2='T'; else CT2='C';
	sprintf(Msg,".%c%d:%c%d%c_%c%d:%c%d%c\n",rI,nI,rJ,nJ,CT,rK,nK,rL,nL,CT2);
	for(i=0, j=1; Chain[i]; i++){
	  char **str=this->ExactTest(XY[i],xY[i],Xy[i],xy[i],Msg,Chain[i],AB,twotail);
	  if(str){
	     fprintf(stderr,"%d",j); j++;
	     for(Int4 x=0; str[x]; x++){
		fprintf(stderr,"%s",str[x]); free(str[x]);
	     } fprintf(stderr,"\n"); free(str);
	  }
	} NilPDB(pdb0);
	return rtn;
}

Int4	spc_typ::RunAllTwoPairsFast(FILE *ofp)
{
	Int4	N,i,j,k,x,p,MinRes,MaxRes,nI,nJ,nK,nL;
	char	pdbid[200];
	FILE	*efp=0;
	Int4	nChn,MaxLen=0;

  // fprintf(stderr,"DEBUG: RunAllTwoPairsFast()\n");
	assert(mode != 'D');
	for(i=0 ; Chain[i]; ) i++; nChn=i; 
	// 1. open up one of the structures for reference.
	// fprintf(stderr,"Done.\n"); // exit(1);
	pdb_typ	pdb=psd->RtnPDB(1); 
	Int4	nPDB=psd->NumPDB();
	MinRes=999999; MaxRes=0;
	for(i=0; Chain[i]; i++){
	        j=GetChainNumberPDB(pdb,Chain[i]);
		if((x=MinResPDB(j,pdb)) > 0){ MinRes=MINIMUM(Int4,MinRes,x); }
		if(i==0) MaxRes=MAXIMUM(Int4,MaxRes,MaxResPDB(j,pdb));
		else MaxRes=MINIMUM(Int4,MaxRes,MaxResPDB(j,pdb));
		Int4 Len=MaxRes-MinRes+1;
		MaxLen = MAXIMUM(Int4,Len,MaxLen);
	} // Only need to look at one; they are all the same.
	char in_mode=mode; mode='S';
	char rph_mode=0;
	set_typ *PrSet=this->RunAllPairsPrep();
	if(rphF){
	    FILE *rfp=open_file(argv[2],".flp","w");
	    if(PDB_ID) rph_mode='F'; 
	    if(rph_mode) rphF->PutHeader(rfp,rph_mode,PDB_ID);
	    rphF->Put(rfp); fclose(rfp); delete rphF; rphF=0; 
	}
	if(rphS){ 
	    if(PDB_ID) rph_mode='S'; 
	    if(rph_mode) rphF->PutHeader(stderr,rph_mode,PDB_ID);
	    rphS->Put(stderr); delete rphS; rphS=0; 
	}
	mode=in_mode; 
	// return 0;

//fprintf(stderr,"DEBUG 1\n");
	// if(sis==0) sis = new sis_typ(Chain,MaxLen);
	i=GetChainNumberPDB(pdb,Chain[0]);
	e_type Sq=GetPDBSeq(i,pdb);
	a_type AB=AminoAcidAlphabetPDB(pdb); StrtMtrx=MinRes; EndMtrx=MaxRes;
	set_typ useSB=0;
	{ useSB=MakeSet(MaxRes+4); FillSet(useSB); }
	Int4 NumVSI=0;
	char	rI,rJ,rK,rL;
	Int4	prI[4],prK[4];
// MinRes=410;
	
	Int4 c0=GetChainNumberPDB(pdb,Chain[0]);
	long long NN=0;
	char CT,CT2,Msg[200];	// last argument...
mode='S';
#if 0	// find residue pairs with > 10 H-bonds and > 10 distant.
	// look only at these pairs to speed up the search.
	// H-bond < 2.5; close <= 4.0; dist= > 4.0  
#endif
  for(nI=MinRes; nI < MaxRes; nI++) {
    //if(!MemberSet(nI,useSB)) continue;
    if(PrSet[nI] == 0) continue;
    for(nJ=nI+1; nJ < MaxRes; nJ++) {
      //if(!MemberSet(nJ,useSB)) continue;
      if(PrSet[nJ] == 0) continue;
      for(nK=nJ+1; nK < MaxRes; nK++){
        if(PrSet[nK] == 0) continue;
        for(nL=nK+1; nL <= MaxRes; nL++){
         if(PrSet[nL] == 0) continue;
// fprintf(stderr,"nI=%d; nJ=%d; nK=%d; nL=%d\n",nI,nJ,nK,nL);
	 for(Int4 p=1; p <=3; p++){	// possible correlated pairs 
	  switch (p){
	   case 1: prI[1]=nI; prI[2]=nJ; prK[1]=nK; prK[2]=nL; break;
	   case 2: prI[1]=nI; prI[2]=nK; prK[1]=nJ; prK[2]=nL; break;
	   case 3: prI[1]=nI; prI[2]=nL; prK[1]=nJ; prK[2]=nK; break;
	   default: print_error("This should not happen");
	  }
	  if(abs(prI[1]-prI[2]) < MinSpacing) continue;
	  if(abs(prK[1]-prK[2]) < MinSpacing) continue;
	  if(!MemberSet(prI[2],PrSet[prI[1]])) continue;
	  if(!MemberSet(prK[2],PrSet[prK[1]])) continue;
	  
	  Int4	cI,cJ;
	  cI=GetChainNumberPDB(pdb,Chain[0]);
	  rI=psd->GetResChar(1,cI,prI[1]); rJ=psd->GetResChar(1,cI,prI[2]);
	  rK=psd->GetResChar(1,cI,prK[1]); rL=psd->GetResChar(1,cI,prK[2]);
	  if(rI=='X' || rJ=='X' || rK=='X' || rL=='X') continue;
#if 1
	  if(this->InvalidHbondPair(rI,rJ,'S')) continue;
	  if(this->InvalidHbondPair(rK,rL,'S')) continue;
#else
	  if(SkipWeakHBonds){
	    if(strchr("GAFVILMP",rI) && strchr("GAFVILMP",rJ)) continue;
	    if(strchr("GAFVILMP",rK) && strchr("GAFVILMP",rL)) continue;
	    if(mode == 'S'){
	        if(strchr("GAFVILMP",rI) != NULL) continue;
	        if(strchr("GAFVILMP",rJ) != NULL) continue;
		if(strchr("DE",rI) &&  strchr("DE",rJ)) continue;
		if(strchr("RK",rI) &&  strchr("RK",rJ)) continue;
	        if(strchr("GAFVILMP",rK) != NULL) continue;
	        if(strchr("GAFVILMP",rL) != NULL) continue;
		if(strchr("DE",rK) &&  strchr("DE",rL)) continue;
		if(strchr("RK",rK) &&  strchr("RK",rL)) continue;
	    }
	  } else {
	    if(strchr("GAVILP",rI) && strchr("GAVILP",rJ)) continue;
	    if(strchr("GAVILP",rK) && strchr("GAVILP",rL)) continue;
	    if(mode == 'S'){
		if(strchr("GAVILP",rI) &&  strchr("GAVILP",rJ)) continue;
		if(strchr("DE",rI) &&  strchr("DE",rJ)) continue;
		if(strchr("RK",rI) &&  strchr("RK",rJ)) continue;
		if(strchr("GAVILP",rK) &&  strchr("GAVILP",rL)) continue;
		if(strchr("DE",rK) &&  strchr("DE",rL)) continue;
		if(strchr("RK",rK) &&  strchr("RK",rL)) continue;
	    }
	  }
#endif
	  BooLean trns=FALSE,trns2=FALSE;
	  double dd,cut=2.5;
//ofp=stdout; 
	  Int4 end=4;
	  if(nChn==1) end=1;
	  for(Int4 ct=1; ct <= end; ct++){
	    switch(ct){
		case 1: CT='C'; CT2='C'; trns=trns2=FALSE; break;
		case 2: CT='T'; CT2='C'; trns=TRUE; trns2=FALSE; break;
		case 3: CT='C'; CT2='T'; trns=FALSE; trns2=TRUE; break;
		case 4: CT='T'; CT2='T'; trns=trns2=TRUE; break;
	    }
	    NN++; // continue;
	    sprintf(Msg,".%c%d:%c%d%c_%c%d:%c%d%c\n",
			rI,prI[1],rJ,prI[2],CT,rK,prK[1],rL,prK[2],CT2);
	    // fprintf(ofp,"%s",Msg);
	    dd=RunTwoPairsFAST(prI[1],prI[2],prK[1],prK[2],trns,trns2,cut,ofp,Msg); 
	    fflush(ofp);
	  }
	 }
        }
      }
    } // end for(nJ=nI+1; nJ <= MaxRes; nJ++)
  } // end for(nI=MinRes; nI <= MaxRes; nI++)
  mode=in_mode;
  if(rphC){
// fprintf(stderr,"DEBUG: NN=%lld\n",NN);
	char c;
	FILE *xfp=open_file(argv[2],".tab","w");
	rphC->PutHeader(xfp,'p',PDB_ID);
	rphC->Put(xfp); fclose(xfp);
	// xfp=open_file(argv[2],Msg,"r");
	xfp=open_file(argv[2],".tab","r");
	while((c=fgetc(xfp)) != EOF) fprintf(stdout,"%c",c); fclose(xfp);
  } else if(mode == 'p') fprintf(stderr,"---> No correlated interactions found.\n");
  // fprintf(stderr,"NN = %lld; mode=%c.\n",NN,mode);
  for(i=MinRes; i <= MaxRes; i++) if(PrSet[i]) NilSet(PrSet[i]);
  free(PrSet);
  if(useSB) NilSet(useSB); NilSeq(Sq); 
  return 0;
}

double	spc_typ::RunTwoPairsFAST(Int4 nI,Int4 nJ,Int4 nK,Int4 nL,
		BooLean trns,BooLean trns2,double cut,FILE *outfp, char *Msg)
{
	// fprintf(stderr,"\n%d:%d%c %d:%d%c\n\n",nI,nJ,trns,nK,nL,trns2);
	// fprintf(stderr,"--> %s\n",Msg);
	BooLean	noMainChn=TRUE; 
	assert(psd != 0);
	double	dd,Dd,ee;
	float	HA_dmax=2.5,dmax=3.6; 
	FILE	*ifp,*efp=0;
	Int4	i,j,k,l,N,cI,cJ,nChn;
	for(i=0 ; Chain[i]; ) i++; nChn=i; 
  	Int4	*XY,*xy,*xY,*Xy;
	double rtn=DBL_MAX;
	for(i=0 ; Chain[i]; i++){
		NEW(XY,nChn+3,Int4); NEW(xy,nChn+3,Int4);
		NEW(Xy,nChn+3,Int4); NEW(xY,nChn+3,Int4);
	}

	FILE *ofp=0;
	if(cut > 0.0) ofp=tmpfile(); else ofp=outfp;
	Int4 nPDB=psd->NumPDB(),Mid=nPDB/2;
	a_type	AB=0;
	for(N=1; N <= nPDB; N++){
	  pdb_typ pdb = psd->RtnPDB(N);
	  AB=AminoAcidAlphabetPDB(pdb);
	  if(trns) j=1; else j=0;
	  if(trns2) l=1; else l=0;

	  if(N == 1){
	      fprintf(ofp,"index");
	      for(Int4 x=0,y=1; Chain[x];y++,x++){
		if(Chain[y]==0) y=0; 
		if(trns) fprintf(ofp,"\t%c%c",Chain[x],Chain[y]);
		else fprintf(ofp,"\t%c",Chain[x]);
		if(trns2) fprintf(ofp,"\t%c%c",Chain[x],Chain[y]);
		else fprintf(ofp,"\t%c",Chain[x]);
	      } fprintf(ofp,"\n"); 
	  }

	  for(i=k=0 ; Chain[i] && Chain[k]; i++,j++,k++,l++){
	    if(Chain[j]==0) j=0;
	    if(i==0) fprintf(ofp,"%d\t",N);
	    cI=GetChainNumberPDB(pdb,Chain[i]); cJ=GetChainNumberPDB(pdb,Chain[j]);
	    if(cI == 0 || !IsProteinPDB(cI,pdb)){
		{ free(XY); free(xy); free(Xy); free(xY); return rtn; }
		fprintf(ofp,"-"); if(Chain[i+1]) fprintf(ofp,"\t"); continue;
	    } if(cJ == 0 || !IsProteinPDB(cJ,pdb)){
		{ free(XY); free(xy); free(Xy); free(xY); return rtn; }
		fprintf(ofp,"-"); if(Chain[i+1]) fprintf(ofp,"\t"); continue;
	    } 

	    dd=this->GetContactsFast(efp,nI,nJ,HA_dmax,cI,cJ,N);
	    if(dd >= BigDist){ 
		{ free(XY); free(xy); free(Xy); free(xY); return rtn; }
		fprintf(ofp,"-"); 
	    } else fprintf(ofp,"%.2lf",dd);
	    if(Chain[i+1]) fprintf(ofp,"\t"); 
	    else fprintf(ofp,"\t");

	    if(Chain[l]==0) l=0;
	    // if(k==0) fprintf(ofp,"-\t");
	    cI=GetChainNumberPDB(pdb,Chain[k]); cJ=GetChainNumberPDB(pdb,Chain[l]);
	    if(cI == 0 || !IsProteinPDB(cI,pdb)){
		{ free(XY); free(xy); free(Xy); free(xY); return rtn; }
		fprintf(ofp,"-"); if(Chain[k+1]) fprintf(ofp,"\t"); continue;
	    } if(cJ == 0 || !IsProteinPDB(cJ,pdb)){
		{ free(XY); free(xy); free(Xy); free(xY); return rtn; }
		fprintf(ofp,"-"); if(Chain[k+1]) fprintf(ofp,"\t"); continue;
	    } 
 ee=dd;
	    dd=this->GetContactsFast(efp,nK,nL,HA_dmax,cI,cJ,N);
if(dd <= 2.5 && ee <= 2.5) XY[i]++;
else if(dd > 2.5 && ee <= 2.5) xY[i]++;
else if(dd <= 2.5 && ee > 2.5) Xy[i]++;
else if(dd > 2.5 && ee > 2.5) xy[i]++;
	    if(dd >= BigDist){
		{ free(XY); free(xy); free(Xy); free(xY); return rtn; }
		fprintf(ofp,"-"); 
	    } else fprintf(ofp,"%.2lf",dd);
	    if(Chain[k+1]) fprintf(ofp,"\t"); 
	  } fprintf(ofp,"\n"); 
	}
	if(cut > 0){
	   if(rtn <= cut){ 
		if(Msg) fprintf(outfp,"%s",Msg);
		if(0){
		  char c; rewind(ofp); 
		  while((c=fgetc(ofp)) != EOF) fprintf(outfp,"%c",c); fclose(ofp);
		}
	   }
	}
	// compute mutual information...
	N=nPDB;
	for(i=0 ; Chain[i]; i++){
	  double twotail;
	  char **tstr=this->ExactTest(XY[i],xY[i],Xy[i],xy[i],Msg,Chain[i],AB,twotail);
	  if(tstr){
	    keytyp k=-log10(twotail);
	    if(rphC==0) rphC = new rph_typ(rpheap_size,nChn);
	    rphC->Insert(k,tstr);  tstr=0;
// rphC->PutHeader(stderr,'p',PDB_ID);
	  }
	} free(XY); free(xy); free(Xy); free(xY);
	return rtn;
}

char	**spc_typ::ExactTest(Int4 XY,Int4 xY,Int4 Xy,Int4 xy,char *Msg, char chn,
				a_type AB,double &tt)
{
	  //ExactTest(Int4 XY,Int4 xY,Int4 Xy,Int4 xy,...
	  //ExactTest(Int4 RI,Int4 bI,Int4 Ro,Int4 bo,...
	  //FisherExactTest(0, red_in,black_in,red_out,black_out,1tail);
	  long double onetail,twotail=FisherExactTest(0,XY,xY,Xy,xy,onetail);
	  if(twotail > 0.0001) return 0;
	  char	**tstr=0,Str[200],rI,rJ,rK,rL,ctI,ctK;
	  Int4	x,pI,pJ,pK,pL,N=XY+xY+Xy+xy;
	  if(sscanf(Msg,".%c%d:%c%d%c_%c%d:%c%d%c\n",
			&rI,&pI,&rJ,&pJ,&ctI,&rK,&pK,&rL,&pL,&ctK)!=10)
		print_error("this should not happen");
	  NEWP(tstr,25,char); x=0;
	  tstr[x]=AllocString(Msg); x++;
#if 1
	  char grpI=0,grpJ=0,grpK=0,grpL=0;
	  if(show_all) grpI=grpJ=grpK=grpL='W';
	  else grpI=grpJ=grpK=grpL=' ';
	  if(PtrnSet){
	      if(TopDC_Set){
		if(MemberSet(pI,TopDC_Set)) grpI='G';
		if(MemberSet(pJ,TopDC_Set)) grpJ='G';
		if(MemberSet(pK,TopDC_Set)) grpK='G';
		if(MemberSet(pL,TopDC_Set)) grpL='G';
	      }
              for(Int4 ii=1; PtrnSet[ii]; ii++){
                 if(MemberSet(pI,PtrnSet[ii])) grpI=SbGrpCode[ii];
                 if(MemberSet(pJ,PtrnSet[ii])) grpJ=SbGrpCode[ii];
                 if(MemberSet(pK,PtrnSet[ii])) grpK=SbGrpCode[ii];
                 if(MemberSet(pL,PtrnSet[ii])) grpL=SbGrpCode[ii];
              }
	      char St[100],str[20]; St[0]=0;
	      if(!isspace(grpI)){ sprintf(str,"%c%d(%c) ",rI,pI,grpI); strcat(St,str); }
	      if(!isspace(grpJ)){ sprintf(str,"%c%d(%c) ",rJ,pJ,grpJ); strcat(St,str); }
	      if(!isspace(grpK)){ sprintf(str,"%c%d(%c) ",rK,pK,grpK); strcat(St,str); }
	      if(!isspace(grpL)){ sprintf(str,"%c%d(%c) ",rL,pL,grpL); strcat(St,str); }
	      if(St[0] != 0){
	        sprintf(Str, "  Constrained: %s\n",St);
// fprintf(stderr,"%s",Str);
	        tstr[x]=AllocString(Str); x++;
	      }
          }
#endif
	  sprintf(Str,"       |    %c%c   |  %c<-->%c |\n",rK,rL,rK,rL);
// fprintf(stderr,"%s",Str);
	  tstr[x]=AllocString(Str); x++;
	  sprintf(Str,"-------|---------|---------|----\n");
	  tstr[x]=AllocString(Str); x++;
	  // sprintf(Str,"  %c%c   |%8ld |%8ld | %ld\n",rI,rJ,XY,xY,XY+xY);
	  // ^ sprintf bug with %ld...
	  sprintf(Str,"  %c%c   |%8ld |%8ld | %d\n",rI,rJ,XY,xY,XY+xY);
// fprintf(stderr,"%s\t sum=%ld=%d\n",Str,XY+xY,XY+xY);
	  tstr[x]=AllocString(Str); x++;
	  // sprintf(Str,"%c<-->%c |%8ld |%8ld | %ld\n",rI,rJ,Xy,xy,Xy+xy);
	  sprintf(Str,"%c<-->%c |%8ld |%8ld | %d\n",rI,rJ,Xy,xy,Xy+xy);
// fprintf(stderr,"%s\t sum=%ld=%d\n",Str,XY+xY,XY+xY);
	  tstr[x]=AllocString(Str); x++;
	  sprintf(Str,"-------|---------|---------|----\n");
	  tstr[x]=AllocString(Str); x++;
	  sprintf(Str,"       |%8ld |%8ld | %ld\n",XY+Xy,xY+xy,N);
	  tstr[x]=AllocString(Str); x++;
	  sprintf(Str,"%c: Two-tail Fisher exact test = %.3Lg\n",chn,twotail);
	  tstr[x]=AllocString(Str); x++;
	  sprintf(Str,"sparc sc2sc %s %s %d:%d%c_%d:%d%c\n",
				argv[2],argv[3],pI,pJ,ctI,pK,pL,ctK);
	  tstr[x]=AllocString(Str); x++;
	  sprintf(Str,"sele (resi %d and resn %s) or (resi %d and resn %s)\n",
				pI,AARes[AlphaCode(rI,AB)],
				pJ,AARes[AlphaCode(rJ,AB)]);
	  tstr[x]=AllocString(Str); x++;
	  sprintf(Str,"sele (resi %d and resn %s) or (resi %d and resn %s)\n",
				pK,AARes[AlphaCode(rK,AB)],
				pL,AARes[AlphaCode(rL,AB)]);
	  tstr[x]=AllocString(Str); x++;
	  tt=twotail;
	  return tstr;
}


