/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "spc_typ.h"

int	spc_typ::psd_typ::IsSameSeq(e_type E1, e_type E2,Int4 &Start,
		Int4 MinOverlap, Int4 &NumX,Int4 &NumM,BooLean IgnoreX)
// find out whether or not E1 and E2 are the same sequence.
// return 1 if seq E1 lacks an N-terminal extension.
// return 2 if seq E2 lacks an N-terminal extension.
{
        Int4    st,sp,sb,end,lenSb,lenSp,test,numX,numM,Overlap;
        int	rtn=0;
        unsigned char   *sup,*sub;      // superseq and subseq
        BooLean IsSub=FALSE;

   if(LenSeq(E1) < MinOverlap || LenSeq(E2) < MinOverlap) return 0;
#if 0
char sqid[20];
const char keyid[]="1H65_A";
StrSeqID(sqid, 8, E1);
fprintf(stderr,"sqid=%s; key=%s\n",sqid,keyid);
rtn=strcmp(sqid,"1H65_A");
if(rtn==0) { PutSeq(stderr,E1,AB); PutSeq(stderr,E2,AB); }
#endif
   for(rtn=1; rtn <= 2; rtn++){
      if(rtn==1){	// 1. start from sequence E1 and inch along seq. E2.
   	sup=SeqPtr(E2); sub=SeqPtr(E1); 
	lenSp=LenSeq(E2); lenSb=LenSeq(E1); 
      } else { 		// 2. if failed: start from sequence E2 and inch along seq. E1.
	sup=SeqPtr(E1); sub=SeqPtr(E2);
	lenSp=LenSeq(E1); lenSb=LenSeq(E2); 
      }
      end=lenSp - MinOverlap + 1;
      if(IgnoreX){ // ignore 'X' residues (in pdb files)
#if 0
	      1                lenSb
          sb  +---------+------+                         +---------+------+  sb
              |--MinOL--|                                |--MinOL--|
          sp  +---------+-----+  --> from..to -->  +-----+---------+         sp
             st=1             lenSp                      st=end    lenSp

             st=1             lenSp                      st=end    lenSp
          sp  +---------+------+                    +------+---------+  sb
              |--MinOL--|                                  |--MinOL--|
          sb  +---------+-----+  --> from..to -->          +---------+-----+ sp
	      1                                            1
#endif
        for(st=1; st<= end; st++){
	  if((lenSp-st+1) < MinOverlap) break;
	  Int4 ndummy=0;	// 'X' residues for both sequences
          for(numM=numX=0,IsSub=TRUE,sp=st,sb=1; sb <= lenSb && sp <= lenSp; sb++,sp++){
            if(sup[sp]==0 && sub[sb]==0){
		// if(numM == 0 && numX == 0) ndummy++;
		continue;  // don't count as 'X';
	    } else if(sup[sp]==0 || sub[sb]==0){
#if 0
		if(numM==0) { PutSeq(stderr,E1,AB); PutSeq(stderr,E2,AB); }
#endif
		numX++; continue; 
	    } else if(sup[sp] != sub[sb]){ IsSub=FALSE; break; 
	    } else numM++;
          }
          if(IsSub){
#if 0
		// Overlap=lenSb-st+1-numX;
		Int4 stop=MINIMUM(Int4,lenSb,lenSp);
		Overlap=stop-st+1-numX;
fprintf(stderr,"Overlap=%d < %d? st=%d; lenSp=%d; lenSb=%d;rtn=%d;numX=%d;numM=%d\n",
			Overlap,MinOverlap,st,lenSp,lenSb,rtn,numX,numM);
		if(Overlap < MinOverlap) continue; // can only get shorter from here...
#else
if(0) fprintf(stderr,"minOL=%d; st=%d; lenSp=%d; lenSb=%d;rtn=%d;numX=%d;numM=%d\n",
			MinOverlap,st-1,lenSp,lenSb,rtn,numX,numM);
		if(numM < MinOverlap) continue;
#endif
		// fprintf(stderr,"ndummy=%d\n",ndummy);
		Start=st-1; // Start=st-1+ndummy; 
		NumX=numX; NumM=numM; return rtn; 
	  }
        }
      } else {
        for(st=1; st<= end; st++){
	  if((lenSp-st+1) < MinOverlap) break;
          for(IsSub=TRUE,sp=st,sb=1; sb <= lenSb && sp <= lenSp; sb++,sp++){
            if(sup[sp] != sub[sb]){ IsSub=FALSE; break; }
          }
          if(IsSub){
		Overlap=lenSb-st+1;
		if(Overlap < MinOverlap) continue; // can only get shorter ...
		Start=st-1; return rtn; 
	  }
        }
      }
   } return 0;
}

void spc_typ::psd_typ::Init(char *name,char *chain)
{
	Int4 N,NN,c,i,j,k,x,y,z;
	char pdbid[200];
	a_type	AB=0;
	res_typ *resN1;
	Chn=AllocString(chain);
	FILE *ifp=open_file(name,"","r");
	if(fscanf(ifp,"%s\n",pdbid) != 1) print_error("Fatal: input file error");
        else rewind(ifp);
	for(N=0; fscanf(ifp,"%s\n",pdbid) == 1; ) N++;
	rewind(ifp); nPDB=N;
	NEW(PDB,nPDB+3, pdb_typ);
	NEWP(path,nPDB+3, char);
	NEWPP(res_all,nPDB+3, res_typ);
	NEWP(nres_all,nPDB+3, Int4);
	for(i=0; Chn[i]; ) i++; nChn=i;	// number of adjacent identical chains.
	Int4 first_X=0, first_Y=0, first_Z=0;
	// WARNING: the number of chains can be much higher than nChn + 2!!!
	// ASSUME less than 200 chains.
	e_type	*fstE=0; NEW(fstE, 209, e_type); 
	for(N=0; fscanf(ifp,"%s\n",pdbid) == 1; ){
	  N++; PDB[N]=MakePDB(pdbid);
	  if(N==1) assert(nChainsPDB(PDB[1]) <= 200);
	  path[N]=AllocString(pdbid);
#if 1	// check input chains
	  if(N==1){
		if(0) fprintf(stderr,"pdbid=%s; chain=%s\n",pdbid,Chn);
		for(c=0; Chn[c]; c++){
		  BooLean found=FALSE;
	          j=GetChainNumberPDB(PDB[N],Chn[c]);
		  if(j == 0){
		    fprintf(stderr," --> chain '%c' does not exist\n",Chn[c]);
		    print_error("Input error: exiting...");
		  }
		}
	  } 
#endif
#if 1
          x=HIDorHIEorHIP2HIS_PDB(PDB[N]);
	  if(N==1 && x > 0){
	      fprintf(stderr,"%d histidine heteroatoms changed to HIS.\n",x);
	      first_X=x;
	  }
          y=ChangeMSE2MET_PDB(PDB[N]); 
	  if(N==1 && y > 0){
	      fprintf(stderr,"%d MSE atoms changed to MET.\n",y);
	      first_Y=y;
	  }
          z=ChangePO3toAtmPDB(PDB[N]);
	  if(N==1 && z > 0){
	      fprintf(stderr,"%d phosphorylated amino acids changed.\n",z);
	      first_Z=z;
	  } k=x+y+z;
	  if(k > 0){
	    FILE *tfp=tmpfile(); PutPDB(tfp,PDB[N]); rewind(tfp);
	    NilPDB(PDB[N]); PDB[N]=MakePDB(tfp); fclose(tfp);
#if 0
	    pdb_typ pp=PDB[N];
            e_type Sq=GetPDBSeq(1,pp);
            a_type AB=AminoAcidAlphabetPDB(pp); PutSeq(stderr,Sq,AB);
            // exit(1);
#endif
	  }
#if 0
	    pdb_typ pp=PDB[N];
            e_type Sq=GetPDBSeq(1,pp);
            a_type AB=AminoAcidAlphabetPDB(pp); PutSeq(stderr,Sq,AB);
            // exit(1);
#endif
#endif
#if 1
	  if(N==1 && PtrnSq){
	     e_type Sq=GetPDBSeq(1,PDB[N]);
             a_type AB=AminoAcidAlphabetPDB(PDB[N]); 
	     // PutSeq(stderr,PtrnSq,AB); PutSeq(stderr,Sq,AB);
	     Int4 Start=0;
#if 1
	     if(OverlappingSeqs(Start,Sq,PtrnSq,30,0))
#else
	     if(IsSameSeq0(Sq,PtrnSq,&Start,TRUE))
#endif
	     {
		if(0) AlnSeqSW(stderr,11,2,Sq,PtrnSq,AB);
		NilSeq(Sq);
             } else {
		fprintf(stderr,"=========");
		PutSeqID(stderr,PtrnSq);
	        PutSeq(stderr,PtrnSq,AB); PutSeq(stderr,Sq,AB);
		fprintf(stderr," vs MD simulation sequence =========\n");
		AlnSeqSW(stderr,11,2,Sq,PtrnSq,AB);
		fprintf(stderr,"========= FATAL: ");
		print_error("input/source sequences mismatch. =========\n");
	     }
	  }
#endif
	  NEWP(res_all[N],nChainsPDB(PDB[N])+3, res_typ);
	  NEW(nres_all[N],nChainsPDB(PDB[N])+3, Int4);
	  if(N%100 == 0) fprintf(stderr,"%d%s.\n",N,Chn);
	  for(c=0; Chn[c]; c++){
	      j=GetChainNumberPDB(PDB[N],Chn[c]);
	      res_all[N][j]=MakeResPDB(j,&nres_all[N][j],PDB[N]);
	      resN1=res_all[N][j];
	      if(N == 1){
		fstE[j]=GetPDBSeq(j,PDB[N]);	
// PutSeq(stderr,fstE[j],AminoAcidAlphabetPDB(PDB[N]));
		if(fstE[j] == 0){
		   fprintf(stderr,"chain '%c' is not a polypeptide\n",Chn[c]);
		   print_error("Input error: exiting...\n");
		}
	      } else {
		Int4	Start,MinOverlap=10,NumX,NumM;
		BooLean	IgnoreX=TRUE;
	        k=GetChainNumberPDB(PDB[1],Chn[c]);
		e_type pdbE=GetPDBSeq(j,PDB[N]);	
		if(pdbE==0){
		  print_error("Fatal: structures are different(1)");
		} else if(this->IsSameSeq(fstE[k],pdbE,Start,MinOverlap,
						NumX,NumM,IgnoreX)){
		  NilSeq(pdbE);
		} else  {
		  fprintf(stderr,"Start=%d\n",Start);
		  AB=AminoAcidAlphabetPDB(PDB[N]);
		  PutSeq(stderr,pdbE,AB);
		  PutSeq(stderr,fstE[k],AB);
		  AlnSeqSW(11,1,fstE[k],pdbE,AB);
		  print_error("Fatal: chains are not identical (1)");
		} 
	      }
	  }
	} assert(N == nPDB);
	for(c=0; Chn[c]; c++){
	  j=GetChainNumberPDB(PDB[1],Chn[c]); NilSeq(fstE[j]);
	} free(fstE);
}

void	spc_typ::psd_typ::Free()
{
	Int4 i,j,c;
	for(i=1; i <= nPDB; i++){
	   free(path[i]);
	   for(c=1; c <= nChainsPDB(PDB[i]); c++){
		for(j=1; j <= nres_all[i][c]; j++) NilRes(res_all[i][c][j]);
		free(res_all[i][c]); 
	   } free(res_all[i]); free(nres_all[i]);
	   NilPDB(PDB[i]);
	} free(res_all); free(nres_all); free(PDB); free(path); free(Chn);
}

res_typ	spc_typ::psd_typ::RtnResI(Int4 p,Int4 c,Int4 r)
{
	Int4	j,x,y;
	assert(p > 0 && p <= nPDB);
	assert(c > 0 && c <= nChainsPDB(PDB[p]));
	for(j=nres_all[p][c]; j >= 1; j--){ 
	  if(ResidueID(res_all[p][c][j]) == r) return res_all[p][c][j];
	} return 0;
}

char	spc_typ::psd_typ::GetResChar(Int4 p,Int4 c, Int4 r)
{
	assert(p > 0 && p <= nPDB);
	assert(c > 0 && c <= nChainsPDB(PDB[p]));
	a_type AB=AminoAcidAlphabetPDB(PDB[p]);
	res_typ ResI=RtnResI(p,c,r);
	if(ResI == 0) return 0;
	return GetCharResidue(ResI,AB);
}

res_typ *spc_typ::psd_typ::RtnResAll(Int4 i,Int4 j,Int4 &n)
{	// not used right now.
	assert(i > 0 && i <= nPDB);
	assert(j >= 0 && j < nChn);
	Int4 c=GetChainNumberPDB(PDB[i],Chn[j]);
	assert(c > 0 && c <= nChainsPDB(PDB[i]));
	n=nres_all[i][c];
	return res_all[i][c]; 
}



