/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined (_RPM_TYP_)
#define _RPM_TYP_

#include "sma.h"
#include "cmsa.h"
#include "residues.h"
#include "gpsi_typ.h"
#include "editcma.h"
#include "table.h"
#include "sset.h"
#include "wdigraph.h"
#include "selexCMSA.h"
#include "dheap.h"
#include "swaln.h"
#include "tax_typ.h"
#include "set_typ.h"
#include "hat_typ.h"
#include "hpt_typ.h"


class rpm_typ {         // residue pattern match type.
public:
          rpm_typ( ){ assert(!"Illegal constructor"); }
	  // rpm_typ(Int4 , Int4 *, set_typ **,sst_typ ***,cma_typ ,swt_typ *);
          // rpm_typ(Int4 ,set_typ *, sst_typ **, cma_typ , Int4 *,swt_typ *);
	  // rpm_typ(char *argv1,cma_typ in_cma,swt_typ *SWT);
	  rpm_typ(int ac, char *av[]){
			argc=ac; argv=av; Init();
		}

          ~rpm_typ( ){ Free( ); }
	Int4	RunPttrnMtch(){
		  return RunMtchXCS( );
		  for(Int4 i=1; i <= NumPttrns; i++) RunPttrnMtch(i);
		}
	Int4    RunPttrnMtch(Int4 X){
		   if(X < 1 || X > NumPttrns) print_error("RunPttrnMtch() input error");
		   return this->RunPttrnMtch(HptPttrn[X],stdout);
		}
	Int4    RunMtchXCS(){
		   sprintf(str,"%s.xcs",argv[1]);
		   FILE *fp=fopen(str,"r");
		   if(fp != NULL){
		     Int4 rtn=0,X,i,j,x,N=Hpt->NumSets();
		     HeatMap=TRUE;
		     set_typ setX=MakeSet(N+3); ClearSet(setX);
		     char Str[1003];
		     // char **PtnX=new char *[N+3];
		     // for(X=1; X <= N; X++) PtnX[X]=0;
		     this->FreeHptPttrn(); 
		     NEWP(HptPttrn,Hpt->NumSets() +3, char);
		     for(X=1; fgets(str,900,fp)!=NULL; X++){
			if(sscanf(str,"%d.%[^:]:%s",&x,tmp_str,Str) != 3){
			  print_error("rpm_typ::RunMtchXCS() syntax error");
			} // PtnX[X]=Str; 
		        if(x < 1 || x > NumPttrns) print_error("RunMtchXCS() input error");
			fprintf(stderr,"%d.%s:%s\n",x,tmp_str,Str);
			HptPttrn[x]=AllocString(Str);
			fprintf(stderr,"%d.%s == %s\n",x,tmp_str,Hpt->SetName(x));
			assert(strcmp(tmp_str,Hpt->SetName(x))==0);
			sprintf(tmp_str,"%s_xc%d",argv[1],x); HM=x;
               		FILE *txtfp=open_file(tmp_str,".txt","w");
		        rtn+=this->RunPttrnMtch(Str,stdout,txtfp); fclose(txtfp);
			AddSet(x,setX);	
		     } fclose(fp); // return rtn;
		     j=this->TurnIntoPyMOL(setX,argv[1]); NilSet(setX);
		     return rtn;
		   } return 0;
		}
	Int4	RunPttrnMtch(char *Ptn,FILE *ofp=NULL,FILE *txtfp=NULL);
	Int4    PutHeatMaps(char *prefix=0);
	Int4    OutputCrossConserved();
	BooLean	Continue(){
		   if(PrintCMA || PrintSets) return FALSE;
		   else return TRUE; 
		}
private:
	Int4	TurnIntoPyMOL(set_typ st=0,char *prefix=0);
	Int4	EmitSimSeqs(FILE *fp=stdout);
	Int4	CntSimSeqs(FILE *fp=stdout);
	Int4	PrintOneCMA(FILE *fp=stdout) {
		   for(Int4 f=1; f <= Number; f++){
                     char *str1=NameCMSA(IN_CMA[f]);
                     if(strcmp(str1,print_file_name)==0) PutCMSA(fp,IN_CMA[f]);
          	   } return 0;
		}
	Int4	PrintAllSets( )
		{
		  for(Int4 f=1; f <= Number; f++){
                   FILE *fp = open_file(NameCMSA(IN_CMA[f]),".seq","w");
                   PutSeqSetEs(fp,TrueDataCMSA(IN_CMA[f]));
                   fclose(fp);
                   fp = open_file(NameCMSA(IN_CMA[f]),".cma","w");
                   PutCMSA(fp,IN_CMA[f]); fclose(fp);
          	  } return 0;
		}
	//============================ rpm_typ.cc ===========================
	Int4    GetPttrnInfo(char *Pttrn); // must call within RunPttrnMtch()!!!
	static const Int4 MaxPttrnPositions=300;
	Int4	ParsePttrns(char*, set_typ);
	int	argc;
	char	**argv;
	Int4	Number,NumPttrns;
	cma_typ	*IN_CMA,qcma;
	hpt_typ	*Hpt;
	char	**HptPttrn;
	void	Init();
	void	FreeHptPttrn(){	
		   if(HptPttrn){
		     for(Int4 i=1; i <= NumPttrns; i++){ 
			if(HptPttrn[i]) free(HptPttrn[i]); 
		     } free(HptPttrn); HptPttrn=0;
		   }
		}
	void	Free(){	
#if 1
		   this->FreeHptPttrn();
#else
		   for(Int4 i=1; i <= NumPttrns; i++){ free(HptPttrn[i]); }
		   free(HptPttrn); 
#endif
		   delete Hpt;
		   for(Int4 i=1; i <= Number; i++) TotalNilCMSA(IN_CMA[i]);
		   free(IN_CMA); NilAlpha(AB);
		   if(0) fprintf(stderr,"\ttime: %d seconds (%0.2f minutes)\n",
                        time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
		}
	Int4	GetHptPttrns();
        BooLean InvertResSet[MaxPttrnPositions];
        char    Residue[MaxPttrnPositions];
        char    residue_str[MaxPttrnPositions][40];
        sst_typ Residues[MaxPttrnPositions];
        Int4    Position[MaxPttrnPositions],Position0[MaxPttrnPositions];
	Int4    GetSeqInfo(cma_typ cma, FILE *ofp, Int4 NumResidues, 
                UInt4 *NumMatch, UInt4 *Match, UInt4 &TotalMatch,
                UInt4 *NumDeleted, UInt4 *Deleted, UInt4 &TotalDeleted,
		UInt4 *NumMisMatch, UInt4 *MisMatch, UInt4 &TotalMisMatch);
	Int4	HM,time1,MinNumSeq,MaxMisMatches,Simulated;
	BooLean SortByScore,PrintSets,HeatMap,PrintCMA;
	char	mode,str[1000],tmp_str[103],query_cma[200],print_file_name[500];;
	UInt4	seed;
	a_type	AB;
};



#endif

