#if !defined (_PROBE_)
#define _PROBE_
#include "stdinc.h"
#include "gibbs.h"
#include "binomial.h"
#include "afnio.h"
#include "purge.h"
#include "goscan.h"
#include "mheap.h"
#include "msaheap.h"
#include "random.h"
#include "set_typ.h"
#include "histogram.h"
#include "seqset.h"
#include "guide.h"
#include "residues.h"
#include "oscan2msa.h"
#include "watchgibbs.h"
#include "cmsa.h"
#include "sma.h"
// #include "gseq.h"
// #include "gsqset.h"
#include "gsq_typ.h"
#include "cluster.h"
#include "blosum62.h"

class prb_typ {
public: 
	prb_typ(int argc, char *argv[], a_type);
	prb_typ(char *PRB_USAGE,int argc, char *argv[], a_type);
	BooLean	use_msa(){ return input_msa; } // start with an msa search
	BooLean	Gapped(){ return use_gseq; } // start with an msa search
	BooLean	doBreed(){ return use_breed; } // start with an msa search
	BooLean	GibbsSearch(){ return (cma_purge > 0); } // optimize using cma_alignment.
	cma_typ	optbreed(cma_typ); 
	void	align(); 	// create and optimize alignment
	void	gapped_align();	// create and optimize gapped alignment
	void	purge(); 	// purge database 
	void	search();  // scan search
	e_type	**search(Int4,Int4,Int4,BooLean,char *); 	// scan search

	void	gapped_srch();	// new 7/8/09 (AFN)
	BooLean	doGappedSrch(){ return improve; } // start with an msa search

	BooLean	doImprove(){ return improve; } // start with an msa search
	cma_typ	Improve(cma_typ); 
	cma_typ	BestCMA( ){ return bestmsa; } 
	Int4	Maxrun(){ return maxrun; }
	Int4	AlignMode(){ return align_mode; }
	BooLean	Go(){ return go; }
	~prb_typ();
private:
	void	Init(char *PRB_USAGE,int argc, char *argv[], a_type);
	Int4	SampleConfig( );
	BooLean	create_align(); 	

	BooLean	do_gapped_srch; 		// NEW Gapped search options 7/8/09 (AFN)
	Int4	Gap_o,Gap_x;
	void	setup_next_srch();
	Int4	MinSeqLen;
	double	trim_info;
	Int4	MinCol,MaxCol;

	void	create_population();
	void	make_binomials(ss_type);
	void	Recombine();
	void	optimize();
	BooLean	Record( );
	double	Breed();
	BooLean	Refine();
	BooLean	Delete();
	BooLean	Delete(char);
	BooLean	Add(Int4);
	BooLean	Split(Int4);
	BooLean	Fuse(Int4);
	BooLean	SFR(Int4,Int4); 
	BooLean SFL(Int4,Int4); 
	BooLean FSR(Int4);
	BooLean FSL(Int4);
	BooLean	gibbs(cma_typ);
	BooLean	gibbs(cma_typ,char);
	BooLean SSF(Int4, Int4); // NOT VERY USEFUL...
	BooLean SFF(Int4, Int4); // NOT VERY USEFUL...
	void	read_input_data();
	void	free_input_data();
	BooLean	use_breed,input_msa,weight,combine,repeats,force,fix,go,flag,noseg;
        BooLean report_gaps,useSA,UseRepset,UseLabeled,mask_nonglobular,improve;
	double	improve_cut;
	char	*Argv[3],method,mode,*guide,aafreq;
	Int4	max_motif_width;
	Int4	*num,number,item,*counts,run,maxbreed,align_mode;
        Int4    avecol,aveblk,minseq,cycle,maxlenModels;
        Int4    maxseq,inc,maxrun,cutoff,over,under;
        Int4    maxcycle,mhpsz,maxrpts,maxseqleng; // for gapped scan
        Int4    left_flank,right_flank,minblk,maxblk;
        Int4    cardB,oldcardB;	// number of sequence detected
        char    str[300],*name,options[300];
	Int4	limit;
        float   minmap;
        double  map,bestmap,pseudo,Ecut,ecut,temperature;
        double  *freq,repeatEval,breedVar;
        UInt4	seed;
	time_t	time1;
        UInt4 min_rpt;
        unsigned short  *nsize;
        wg_type WG;		// WatchGibbs object
        a_type  A;
        ss_type data;
        cma_typ bestmsa,cmsa,cmsa_in;
        mah_typ maH;
        set_typ DBS_hits;	// keep track of database hits
        gd_type Guide;
	Int4	patience;	// how Int4 am I willing to wait for an improvement?
	Int4	cma_purge;	// realignment purge cutoff in percent identity.

	Int4	MinGoodBlks,MaxBadBlks;
	bn_type	BlkDist,ColDist;
	gss_typ	gss2,gss;
	Int4	gapopen,gapextend;
	double	indel_penalty,pernats;
	BooLean	use_gseq,dont_delete;
};

#endif


