/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "scc_typ.h"

h_type	NumPartlyMatchingSeqCMSA(FILE *ofp, cma_typ cma, set_typ sqset, sst_typ *Pattern,
		Int4 NumPttrnPos)
{
	double	*data;
	// UInt4	n1= CardSet(sqset);
	// NEW(data,n1+3,double);

	Int4	i,j,k,s;
	if(cma && LengthCMSA(1,cma) != NumPttrnPos){
		print_error("NumPartlyMatchingSeqCMSA input error.");
	}
	h_type	HG=0;
	HG=Histogram("# Matching seqs", 0,NumPttrnPos+1,1.0);

	//************************** interpret pattern **************************
	char    output_name[300],checkin[200],temp_name[300];

	//************************** allocate arrays,etc. **************************
	UInt4	TotalMatch=0,TotalMisMatch=0;
	if(nBlksCMSA(cma) != 1) print_error("cma file error; not single block.");
	if(LengthCMSA(1,cma) != NumPttrnPos) print_error("FATAL: cma lengths not the same!");

	//************************** compute pattern matches **************************
	// if output file then create this here.
	Int4 hits=0,miss=0,del=0,NumOkaySeq=0,sq;
	for(i=0,sq=1; sq <= NumSeqsCMSA(cma); sq++){
		if(!MemberSet(sq,sqset)) continue;
		for(hits=miss=del=0,j=1; j <= NumPttrnPos; j++){
			Int4 r1 = ResidueCMSA(1,sq,j,cma);
			if(MemSset(r1,Pattern[j])){ hits++; }
			else if(r1 != 0) miss++;
			else { del++; }
		} 
		i++; // data[i]=(double)hits;
		IncdHist((double)hits,HG);
		TotalMatch += hits; TotalMisMatch += miss;	
		// if((miss + del) > MaxMisMatches){ NumOkaySeq++; } 
	}
	// fprintf(stderr,"found %d perfect matches in file %d.\n",n,i);
	if(ofp) PutHist(ofp,60,HG); 
#if 1
	return HG;
#elif 0
	double mean=MeanHist(HG);
        double  min=MinimumHist(HG);
	double	*xvalT, *yvalT,*ProbT=0, P=0.0;
	Int4	TotalT;
	Int4 NumBinsT = RtnHistArray(&xvalT,&yvalT,&TotalT,HG);
	if(TotalT > 0){
	  NEW(ProbT,NumBinsT+5,double);
	  double tiny=0.0000000001;
	  for(i=0; i<=NumBinsT+1; i++){
              // ProbT[i] = yvalT[i]/(double) TotalT;
	      ProbT[i] = ((double) yvalT[i] + tiny)/((double)TotalT + (NumBinsT+2)*tiny);
              // if(ProbT[i] > 0.0) fprintf(stdout,"%.2f: prob[%d]=%.3f\n",xvalT[i],i,ProbT[i]);
          } // fprintf(stdout,"total prob = %.3f\n",P);
	} NilHist(HG);
	return ProbT;
#else
	NilHist(HG);
	// return NumOkaySeq;
	assert(i == n1);
	return data;
#endif
}

