/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined (_GTH_TYP_)
#define _GTH_TYP_

#include "alphabet.h"
#include "dheap.h"
#include "cmsa.h"
#include "sset.h"
#include "ptrn_typ.h"
#include "clique.h"
#include "wdigraph.h"
#include "tax_typ.h"
#include "tree2hpt.h"
#include "probability.h"
#include "bpps_typ.h"
#include "swt_typ.h"
#include "dsets.h"
#include "rst_typ.h"

class gth_typ {         // graph/tree/hpt type or graph to hpt type.
public:
        	gth_typ( ){ assert(!"Illegal constructor"); }
		gth_typ(Int4 num_sets,double min_lpr){ Init(num_sets,min_lpr); }
		// Int4    AddEdge(double lpr, sst_typ *sst, Int4 i, Int4 j);
		Int4    AddEdge(double lpr, sst_typ *sst, Int4 i, Int4 cardI, Int4 j, Int4 cardJ, Int4 OverLap);
		Int4    MkDistinct(Int4 i);
		Int4	RtnRoot(){ return Root; }
		sst_typ	**RtnEdgeSST(){ 
			   if(EdgeSST == 0) return 0;
			   sst_typ **rtn=EdgeSST; EdgeSST=0; return rtn;
			}
		double	*RtnEdgeLPR(){ 
			   if(EdgeLPR == 0) return 0;
			   double *rtn=EdgeLPR; EdgeLPR=0; return rtn;
			}
		wdg_typ	RtnTree(){ 
			   if(Tree == 0) RtnShortestPathTree(stderr);
			   wdg_typ tree=Tree; Tree=0; return tree; 
			}
		Int4    LinkToRoot(double lpr, sst_typ *sst, Int4 i);
		void    PrintNewickTree(FILE *fp,set_typ *set);
		void    PutSetsGraph(FILE *fp);
		wdg_typ	RtnShortestPathTree(FILE *fp);
		set_typ	RtnTreeLeaves( ){ set_typ leaves=Leaves; Leaves=0; return leaves; }
		~gth_typ( ){ Free( ); }
private:
	void	Init(Int4,double);
	void	Free();
	//=================================================================================
	set_typ RtnLeafSet(wdg_typ G);
	void    TreeDFS(FILE *fp, Int4 v, set_typ *set, wdg_typ G);
	void    ComputeSubOnly( );
	set_typ RtnSubTreeNodeSet(Int4 subroot, wdg_typ T);
	set_typ RtnSubTreeSeqSet(Int4 subroot, set_typ *set,wdg_typ T);
	Int4    *RtnSubTreeNodes(Int4 subroot, Int4 &size, wdg_typ T);
	Int4    TreeDFS(Int4 *SubTreeNodes, Int4 &number, Int4 v, wdg_typ T);
	//=================================================================================
	char	State;	// current stage or state: 'I' == initialize; 'C' == compute; 'T' == tree. 'O' == Optimize.
	wdg_typ Grph;		// node n corresponds to Set[n] of Hyperpartition.
	wdg_typ Tree;		// Tree corresponding to Hyperpartition.
	Int4	Root;		// Root node of graph.
	
	Int4	MaxNumEdges;	// (n choose 2).
	double  MinLPRforEdge;
	double	*EdgeLPR;	// EdgeLPR[e] = real lpr associated with integer edge weight in Graph.
	sst_typ	**EdgeSST;	// EdgeSST[e] = pattern associated with edge e in Graph.
	//------------- New edge and Node properties ----------------------------
	Int4	*NodeSize;	// Number of sequences in Node.
	Int4	*EdgeOverLap;	// overlap between sets.
	//-----------------------------------------------------------------------
	set_typ Leaves;		// leaf nodes.
	set_typ SuperSet;	// nodes that are supersets 
	set_typ SubSet;		// nodes that are subsets.
	set_typ SuperOnly;	// nodes that are supersets only
	set_typ SubOnly;		// nodes that are subsets only.
	set_typ Both;		// Both = SuperSet U SubSet
	set_typ Distinct;	// = don't intersect with anything 
	set_typ Orphan;	// not sure about these.
	set_typ Reject;		// useless sets that need to be ignored.
	set_typ InGraph;	// All sets that have been added to the graph.
	//-----------------------------------------------------------------------
	set_typ	*NodeSet;	// NodeSet[n] = set of sequence ids corresponding to each node.
};

#endif

