/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if 0
#include "hat_typ.h"
#include "mgs_typ.h"
#include "cma_gmb.h"
#include <time.h>
#include "cdd2cma.h"
#include "ftc_typ.h"
#include "mgs_usage.h"
#else
#include "mapgaps_usage.h"
#include "mapgaps.h"
#endif

cma_typ	MinColPurgeCMSA(Int4 percent_ident, Int4 mincol, cma_typ cma)
{
	a_type AB=AlphabetCMSA(cma);
	assert(nBlksCMSA(cma) == 1);
	assert(mincol >= 0 && mincol <= 100);
	double	fr,MinCol=(double)mincol/100.0;
	cma_typ	xcma=0;
	FILE	*fp=0;
	e_type	qE,sE;

	// -mincol= option
	Int4	i,j,k,s,J,I,n,r,Len,na;
	Int4    N=NumSeqsCMSA(cma);
        BooLean *skip;
      if(mincol > 0){
	h_type HG=0; // HG=Histogram("fraction aligned",0,1,0.025);
	NEW(skip,N+3,BooLean);
        for(J=1; J <= N; J++){
	   sE=TrueSeqCMSA(J,cma); if(!PdbSeq(sE)) skip[J]=TRUE; 
	}
        for(Len=LengthCMSA(1,cma),n=0,J=1; J <= N; J++){
		for(na=0,s=1 ; s <= Len;s++){ 
		   r=ResidueCMSA(1,J,s,cma); if(r != UndefAlpha(A)) na++; 
		} fr=(double)na/(double)Len;
		if(fr >= MinCol){ skip[J]=FALSE; n++; }
		if(HG) IncdHist(fr, HG);
	} 
	if(n <= 0) print_error("Alignment is too fragmented to be used");
	fp=tmpfile(); PutSelectCMSA(fp,skip,cma); 
	rewind(fp); xcma=ReadCMSA(fp,AB); fclose(fp);
	if(HG){ PutHist(stderr,60,HG); NilHist(HG); } free(skip);
      } else xcma=cma;

	// -U= option...
        set_typ InSet=MakeSet(NumSeqsCMSA(xcma)+4); FillSet(InSet);
        set_typ Set=RtnFastRepSetCMSA(0, percent_ident,InSet,xcma);
	N=NumSeqsCMSA(xcma); 
	for(i=1; i <= N; i++) if(PdbSeq(TrueSeqCMSA(i,xcma))) AddSet(i,Set);	// keep pdb seqs.
	fp=tmpfile(); PutInSetCMSA(fp,Set,xcma);
	NilSet(Set); NilSet(InSet); 
	if(mincol > 0) TotalNilCMSA(xcma);
	rewind(fp); xcma=ReadCMSA(fp,AB); fclose(fp);
	return xcma;
}

BooLean	IsValidConsensusCMSA(Int4 sq, cma_typ cma)
{
	if(sq < 1 || sq > NumSeqsCMSA(cma)) return FALSE;
	gsq_typ *gsq = gsqCMSA(sq,cma);
	if(gsq->Gapped( )) return FALSE;
	if(LenSeq(gsq->FakeSeq()) != LenSeq(gsq->TrueSeq())) return FALSE;
	return TRUE;
}

static void     PrintError()
{ fprintf(stderr,"%s",MGS_VERSION); print_error(USAGE_START); }

int run_mapgaps(int argc, char *argv[])
// this is the same routine as the public version, except for the usage...
// 
{
   time_t  time1=time(NULL);
   BooLean success,seqs_out=TRUE,FromFA=FALSE,AddCsq=TRUE;
   Int4    i,mincol=0,percent_ident=100;
   FILE    *fp=0,*ifp=0,*tfp=0;
   char    str[300];
   TurnOffLicenseStatement();
   a_type  AB=MkAlpha(AMINO_ACIDS,GBLAST_BLOSUM62);

   if(argc < 2) PrintError(); 
   if(argc == 2 && argv[1][0]=='-'){
	 mgs_typ mgs(argc,argv,USAGE_MGS);
   }
   //=========== check for input template file ============
   sprintf(str,"%s.tpl",argv[1]); fp=fopen(str,"r"); 
   if(fp == NULL){
	  fprintf(stderr,"template alignment %s.tpl not found\n",argv[1]); exit(1);
   } else {	// make sure that it is cmaformat
	cma_typ cma=ReadCMSA(fp,AB); fclose(fp);
	if(cma==0){
	  fprintf(stderr,"template alignment \"%s.tpl\" not in cma format.\n",argv[1]);
	  exit(1);
	} else TotalNilCMSA(cma);
   }

   if(argc == 2){	// create profiles.
      char IsTplCMA=0;
      TurnOffLicenseStatement();
      sprintf(str,"%s.cma",argv[1]);
      // if(!FromFA && (fp=fopen(str,"r")) != 0)
      if((fp=fopen(str,"r")) == NULL){
         sprintf(str,"%s.mma",argv[1]);
         if((fp=fopen(str,"r")) == NULL) IsTplCMA=0;
	 else { fclose(fp); print_error("mapgaps input error"); }
      } else { fclose(fp); IsTplCMA='c'; }
      if(IsTplCMA){
#if 0
	fprintf(stderr,"======== looking for %s.xpa =========\n",argv[1]);
        sprintf(str,"%s.xpa",argv[1]);
        if((fp=fopen(str,"r"))){   // running with an *.xpa file...
	  Int4 Nx;
	  cma_typ *xma=MultiReadCMSA(fp,&Nx,AB);  fclose(fp);
	  fp=open_file(argv[1],"_Out.xpa","w"); 
	  for(i=1; i <= Nx; i++){
		PutCMSA(fp,xma[i]); TotalNilCMSA(xma[i]); 
	  } free(xma); fclose(fp); }
	// sprintf(str,"%s",argv[1]);
#endif
	      main_setup_gapmaps(argc,argv,USAGE_START,0); 
      } else {		// create a cma file from tpl; add concensus.
	fprintf(stderr,"WARNING: %s.cma file does not exist;",argv[1]);
        fprintf(stderr," creating from %s.tpl.\n\n",argv[1]);
	sprintf(str,"%s.tpl",argv[1]);
	cma_typ cma=ReadCMSA2(str,AB);
	if(nBlksCMSA(cma) > 1) print_error("Template alignment input error");
        Int4 i,j,x,z,r,N=NumSeqsCMSA(cma);
#if 1
        e_type sE=0,fE=0;
	z=LengthCMSA(1,cma);
        for(Int4 sq=1; sq <= N; sq++){
            fE=FakeSeqCMSA(sq,cma);
	    for(i=1,x=0; i <= z; i++){ r=ResidueCMSA(1,sq,i,cma); if(r > 0) x++; }
            double d=(double)x/(double)z;
            // if(d < 0.66)
            if(d <= 0.50) {
              fprintf(stderr,"FATAL: Seq %d in %s.tpl contains %d/%d deletions...\n",
			sq,argv[1],z-x,z);
              print_error("    ..edit template alignment to eliminate poor quality seqs.\n");
            }
	}
#else
	sprintf(str,"%s.cma",argv[1]);
	FILE *pfp=fopen(str,"r");
	if(pfp==NULL){	// Then create fake profiles, one for each template sequence.
          e_type sE=0,fE=0;
	  z=LengthCMSA(1,cma);
          for(Int4 sq=1; sq <= N; sq++){
            fE=FakeSeqCMSA(sq,cma);
	    for(i=1,x=0; i <= z; i++){
	       r=ResidueCMSA(1,sq,i,cma);
	       if(r > 0) x++;
	    }
            double d=(double)x/(double)z;
            if(d < 0.66){
                  fprintf(stderr,"FATAL: Sequence %d in %s.tpl contains %d/%d deletions...\n",
			sq,argv[1],z-x,z);
                  print_error("    ..edit template alignment to eliminate poor quality seqs.\n");
            }
	  }
	} else {	// Then create profiles from the *mma file
	    Int4 Number;
	    cma_typ *IN_CMA=MultiReadCMSA(pfp,&Number,AB); fclose(pfp);
	    if(N != Number) print_error("Template (*.tpl) and hiMSAs (*.cma) are incompatible");
            for(i=1; i <= Number; i++){
		if(i==1) continue;
		
	    }
	}
#endif
	cma_typ cma0 = AddConsensusCMSA(cma); TotalNilCMSA(cma);
	BooLean AddX2Ends=TRUE;
	double	fractDeleted=0.75;
	cma=RemoveOverhangsCMSA(cma0,AddX2Ends); TotalNilCMSA(cma0);
	Int4 col_del=RmGappyColumnsCMSA(fractDeleted, cma);
        if(col_del > 0) fprintf(stderr,"\n %d columns removed",col_del);
	cma0=RmWrinklesCMSA(cma); NilCMSA(cma); cma=cma0;
	// sprintf(str,"%s_Out",argv[1]);
	sprintf(str,"%s",argv[1]);
	fp=open_file(str,".tpl","w"); 
	PutCMSA(fp,cma); TotalNilCMSA(cma); fclose(fp);
	char *tmp=argv[1]; argv[1]=AllocString(str);
	main_setup_gapmaps(argc,argv,USAGE_START,0); free(argv[1]); argv[1]=tmp;
      } 
   } else if(argc > 2 && argv[2][0] == '-'){
      print_error(USAGE_START); 
   } else if(argc >= 3){	// perform mapgaps search.
     sprintf(str,"%s.mpa",argv[1]);
     if((fp=fopen(str,"r")) == 0){   // running without an *.mpa file...
        fprintf(stderr,"**********************************************************************\n");
        fprintf(stderr,"** No %s.mpa file provided. Searching with <in_file>.tpl alone **\n",
                        argv[1]);
        fprintf(stderr,"**********************************************************************\n");
        success=matblast_srch(argc,argv,USAGE_MGS);
     } else {
        fclose(fp); TurnOffLicenseStatement();
	Int4	x,z,Number;
	for(Int4 arg = 3; arg < argc; arg++){
	   if(argv[arg][0] != '-') print_error(USAGE_MGS);
	   switch(argv[arg][1]) {
		case 'R': if(sscanf(argv[arg],"-Refine=%d:%d",&x,&z) == 2){
                      if(x < 10 || x > 100) print_error(USAGE_MGS);
                      if(z < 25 || z > 100) print_error(USAGE_MGS);
                      mincol=z; percent_ident=x;  argv[arg][1]=' '; } break;
		default: break;
	   }
	}
	cma_typ tcma=0,xcma=0,cma=0,*in_cma;
	char *pdbaa=0;
	{ 
          mgs_typ mgs(argc,argv,USAGE_MGS);
#if 0	// DEBUG:
	  success=mgs.Run(); 
	  exit(1);
#endif
	  tfp=tmpfile(); success=mgs.Run(seqs_out,tfp); rewind(tfp);
	  cma=ReadCMSA(tfp,AB); fclose(tfp);
	  // fp=open_file(argv[2],"_A.mma","w"); PutCMSA(fp,cma); fclose(fp); exit(1);
	  if(mincol > 0 || percent_ident < 100){
	    xcma=MinColPurgeCMSA(percent_ident,mincol,cma);
	    TotalNilCMSA(cma); cma=0;
	  } else { xcma=cma; cma=0; }
	  if(mgs.RtnPDBAA()){ pdbaa=AllocString(mgs.RtnPDBAA()); }
	}
	if(xcma && pdbaa){
	   Int4 Argc=0;
	   char **Argv;  NEWP(Argv,argc+2,char);
	   Argv[0]=argv[0]; Argv[1]=argv[1]; Argv[2]=pdbaa;  Argc=3;
	   for(Int4 arg = 3; arg < argc; arg++){
	     if(argv[arg][0] != '-') print_error(USAGE_MGS);
	     if(argv[arg][1] == 'R' && sscanf(argv[arg],"-Refine=%d:%d",&x,&z) == 2) continue;
	     if(argv[arg][1] == 'p' && strncmp("-pdbaa=",argv[arg],7) == 0) continue;
	     Argv[Argc] = argv[arg]; Argc++;
	   }
	   {
             mgs_typ mgs(Argc,Argv,USAGE_MGS);
	     tfp=tmpfile(); success=mgs.Run(seqs_out,tfp); rewind(tfp);
	     free(Argv); free(pdbaa);
	   }
#if 0
	  in_cma=MultiReadCMSA(tfp,&Number,AB); 
rewind(tfp); cma=ReadCMSA(tfp,AB); 
	  fclose(tfp);
	  fp=open_file("junk",".mma","w"); 
	  for(Int4 i=1; i <= Number; i++) PutCMSA(fp,in_cma[i]);
	  fclose(fp);
#else
	   cma=ReadCMSA(tfp,AB); fclose(tfp);
#endif
	   if(mincol > 0){	// remove pdbaa fragments...
	     tcma=MinColPurgeCMSA(100,mincol,cma); TotalNilCMSA(cma); cma=tcma;
	   }
#if 0
	   fp = open_file(tfp,matstr,"w");
	   in_cma=MultiReadCMSA(fp,&Number,AB); 
#endif
	   cma_typ IN_CMA[4]; IN_CMA[1]=cma; IN_CMA[2]=xcma; 
	   tfp=tmpfile(); PutMergedCMSA(tfp,2,IN_CMA); rewind(tfp);
	   TotalNilCMSA(xcma); TotalNilCMSA(cma);
	   cma=ReadCMSA(tfp,AB); fclose(tfp);
	   if(cma != 0){
             Int4 N=NumSeqsCMSA(cma); 
	     BooLean *skip; NEW(skip,N+3,BooLean);
             for(Int4 i=1;i < N; i++) {
               if(skip[i]) continue;
               for(Int4 j=i+1;j <= N; j++) {
                  if(skip[j]) continue;
                  if(IdentSeqs(TrueSeqCMSA(i,cma),TrueSeqCMSA(j,cma))) skip[j]=TRUE;
               }
              } 
	      fp=open_file(argv[2],"_A.mma","w"); 
	      PutSelectCMSA(fp,skip,cma); free(skip);
	      fclose(fp); TotalNilCMSA(cma); 
	   } 
	} else if(xcma != 0){
	   fp=open_file(argv[2],"_A.mma","w"); PutCMSA(fp,xcma); fclose(fp);
	   TotalNilCMSA(xcma); 
	} 
     }
  } else { print_error(USAGE_START); } // will print out usage
  NilAlpha(AB);
  double runtime = difftime(time(NULL),time1);
  fprintf(stderr,"time = %0.2f minutes (%0.1f seconds)\n",runtime/60.0,runtime);
  if(success) return 0; else return 1;
}

