/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "hmm_gpxdrop.h"
#define CC_MAT 0
#define CC_INS 1
#define CC_DEL 2

#define DEL_(k) \
data.last = (data.last < 0) ? (data.sapp[-1] -= (k)) : (*data.sapp++ = -(k));

#define INS_(k) \
data.last = (data.last > 0) ? (data.sapp[-1] += (k)) : (*data.sapp++ = (k));

#define REP_ \
{ data.last = *data.sapp++ = 0; }

#define MININT INT4_MIN/2
#define REPP_ \
{ *data.sapp++ = MININT; data.last = 0; }

typedef struct DP {
  Int4 CC, DD, FF;
  char CCstate;
} *dp_ptr, dp_node;

typedef struct {
  Int4 * sapp;
  Int4  last;	
} data_t;

#define	CHUNKSIZE	2097152

sap_typ hmmGXEBToGSeqAlign(gxeb_typ edit_block, e_type sE, e_type qE)
{
        gxes_typ curr, esp;
        Int2 numseg;
        Int4 index,start1,start2,length1,length2;
        Int4Ptr length, start;
        dsp_typ dsp;
        sap_typ sap;

        numseg=0;
        start1 = edit_block->start1; start2 = edit_block->start2;
        length1 = edit_block->length1; length2 = edit_block->length2;
        esp = edit_block->esp;
        for(curr=esp; curr; curr=curr->next) { numseg++; }
        start = (Int4*) GMemNew((2*numseg+1)*sizeof(Int4));
        length = (Int4*) GMemNew((numseg+1)*sizeof(Int4));
        for(index=0,curr=esp; curr; curr=curr->next) {
           switch(curr->op_type) {
                case GAPXALIGN_SUB: case GAPXALIGN_DECLINE:
                  start[2*index] = get_current_pos(&start2, curr->num);
                  start[2*index+1] = get_current_pos(&start1,curr->num);
                  break;
                case GAPXALIGN_INS:
                  start[2*index] = -1; start[2*index+1] =  get_current_pos(&start1, curr->num);
                  break;
                case GAPXALIGN_DEL:
                  start[2*index] = get_current_pos(&start2, curr->num); start[2*index+1] = -1;
                  break;
                default: break;
           } length[index] = curr->num; index++;
        }
        sap = GSeqAlignNew();
        sap->dim =2; // only two dimention alignment.
        dsp = GDenseSegNew(); // Denseg Object is only type for GSeqAlign.
        dsp->dim = 2; dsp->numseg = numseg;
        dsp->subject_id = SeqI(sE); dsp->sE=sE;
        dsp->query_id=0; dsp->qE=qE;
        dsp->starts = start; dsp->lens = length;
        sap->segs = dsp; sap->next = NULL;
        if(IsSplitGSeqAlign(sap)) FixSplitsGSeqAlign(sap); // AFN: fixes gapxdrop bug.
        return sap;
}

sap_typ hmmGXEBToGSeqAlign(Int4 score,gxeb_typ edit_block, e_type sE, e_type qE)
{
	gxes_typ	curr, esp;
	Int2		numseg;
	Int4		begin1,begin2,index,start1,start2,length1,length2;
	Int4Ptr		length, start;
	dsp_typ		dsp;
	sap_typ	sap;

	numseg=0;
	start1 = edit_block->start1; start2 = edit_block->start2;
	length1 = edit_block->length1; length2 = edit_block->length2;
	esp = edit_block->esp;
	for(curr=esp; curr; curr=curr->next) { numseg++; }
	start = (Int4*) GMemNew((2*numseg+1)*sizeof(Int4));
	length = (Int4*) GMemNew((numseg+1)*sizeof(Int4));

	for(index=0,curr=esp; curr; curr=curr->next) {
	   switch(curr->op_type) {
		case GAPXALIGN_SUB: case GAPXALIGN_DECLINE:
		  begin1 = get_current_pos(&start1, curr->num);
		  begin2 = get_current_pos(&start2, curr->num);
		  start[2*index] = begin1; start[2*index+1] = begin2;
		  break;
		case GAPXALIGN_DEL:
		  begin1 = -1; begin2 = get_current_pos(&start2, curr->num);
		  start[2*index] = begin1; start[2*index+1] = begin2;
		  break;
		case GAPXALIGN_INS:
		  begin1 = get_current_pos(&start1, curr->num); begin2 = -1;
		  start[2*index] = begin1; start[2*index+1] = begin2;
		  break;
		default: break;
	   } length[index] = curr->num; index++;
	}
	sap = GSeqAlignNew();
	sap->dim =2; // only two dimention alignment.
	dsp = GDenseSegNew(); // Denseg Object is only type for GSeqAlign.
	dsp->dim = 2; dsp->numseg = numseg;
	dsp->subject_id = SeqI(sE); dsp->sE=sE;
	dsp->query_id=0; dsp->qE=qE;
	dsp->starts = start; dsp->lens = length;
	sap->segs = dsp; sap->next = NULL;
	if(IsSplitGSeqAlign(sap)) FixSplitsGSeqAlign(sap); // AFN: fixes gapxdrop bug.
	sap->score = score;
	return sap;
}
Int4 hmmTracebackALIGN(unsigned char * B, Int4 M, Int4 N, Int4 * S, Int4 * pei, Int4 * pej, Int4 **sapp, 
	gxd_typ gxd, Int4 query_offset, Boolean reversed)
{ 
  gab_typ gap_align = gxd->gab;
  data_t data;
  register Int4 i, ip1, j;
  Int4 cb, j_r, s, k;
  unsigned char st, std, ste;
  Int4 decline_penalty;
  register Int4 c, d, e, t, tt, f, tt_start;
  Int4 best_score = 0;
  register Int4 *matMatrix, *insMatrix;
  register dp_ptr dp, dyn_prog;
  unsigned char **state, *stp, *tmp;
  unsigned char *state_array;
  register Int4 X;
  gxdsa_typ state_struct;
  BooLean pi=FALSE,pd=FALSE;

  shm_typ *hmm = gxd->hmm;
  Int4 hmmPos, bhmmPos, bbhmmPos;
  *pei = *pej = 0;
  data.sapp = *sapp = S;
  data.last= 0;
  decline_penalty = gap_align->decline_align;
  X = gap_align->x_parameter;
  insMatrix = hmm->InsEmit(1);

  if(reversed) hmmPos = M+1; 
  else hmmPos = query_offset+1;

  if (X < -hmm->MatToIns(hmmPos)) X = -hmm->MatToIns(hmmPos);

  if(N <= 0 || M <= 0) { *pei = *pej; return 0; }
  GapXDropPurgeState(gap_align->state_struct);

  j = (N + 2) * sizeof(dp_node);
  dyn_prog = (dp_ptr)malloc(j);

  state = (unsigned char**) malloc(sizeof(unsigned char *)*(M+1));
  dyn_prog[0].CC = 0;
  dyn_prog[0].FF = -hmm->Getf_ox();
  dyn_prog[0].DD = hmm->MatToDel(hmmPos);
  c = hmm->MatToIns(hmmPos) + insMatrix[B[1]];
  dyn_prog[0].CCstate = CC_MAT;

  /* Protection against divide by zero. */
  if (-hmm->InsToIns(hmmPos) > 0) state_struct = GapXDropGetState(&gap_align->state_struct, X/-hmm->InsToIns(hmmPos)+5);
  else state_struct = GapXDropGetState(&gap_align->state_struct, N+3);

  state_array = state_struct->state_array;
  state[0] = state_array;
  stp  = state[0];
  for(i = 1; i <= N; i++) {
    if(c < -X) break;
    dyn_prog[i].CC = c;
    dyn_prog[i].DD = c + hmm->MatToDel(hmmPos);
    dyn_prog[i].FF = c - hmm->Getf_ox();
    c += (hmm->InsToIns(hmmPos) + insMatrix[B[i+1]]);
    stp[i] = 1;
  }
  for(Int4 nn = 1; nn <= N+1; nn++) {
    dyn_prog[nn].CCstate = CC_INS;
  }
  state_struct->used = i+1;
  tt = 0;  j = i;
  for(j_r = 1; j_r <= M; j_r++) {
    if(reversed) { hmmPos = M - j_r + 1; bhmmPos = hmmPos; bbhmmPos = hmmPos - 1; }
    else         { hmmPos = j_r + query_offset + 1; bhmmPos = hmmPos - 1; bbhmmPos = hmmPos; }
     /* Protection against divide by zero. */
    if (-hmm->InsToIns(hmmPos) > 0) {
      state_struct = GapXDropGetState(&gap_align->state_struct, j-tt+5+X/-hmm->InsToIns(hmmPos));
    }
    else {
      state_struct = GapXDropGetState(&gap_align->state_struct,N-tt+3);
    }
    state_array = state_struct->state_array + state_struct->used + 1;
    state[j_r] = state_array - tt + 1;
    stp = state[j_r];
    tt_start = tt; 
    if(reversed) matMatrix = hmm->MatEmit(hmmPos);
    else         matMatrix = hmm->MatEmit(hmmPos);
    e = c = f = MININT;
    for (ip1 = tt+1, cb = i = tt, dp = &dyn_prog[i-1]; i < j; ip1++, i++) {
        d = (++dp)->DD;
        if (d < f) { d = f; std=83; } else std = 42;
        if (e < f) { e = f; ste = 83; } else ste = 41;
        if (c < d || c < e) {
            if (d < e) { c = e; st = ste; } else { c = d; st = std; }
            if (best_score - c > X) {
                if(dp->CCstate == CC_MAT)      c = dp->CC + matMatrix[B[ip1]] + hmm->MatToMat(bhmmPos);
                else if(dp->CCstate == CC_INS) c = dp->CC + matMatrix[B[ip1]] + hmm->InsToMat(bhmmPos);
                else                           c = dp->CC + matMatrix[B[ip1]] + hmm->DelToMat(bhmmPos);
                f = dp->FF;
                if (tt == i) tt++; else { dp->CC = MININT; }
            } else {
              cb = i;
              e +=  (hmm->InsToIns(bbhmmPos) + insMatrix[B[ip1]]);
              dp->DD = d + hmm->DelToDel(bbhmmPos);
              d = dp->FF; dp->FF = f - decline_penalty; f = d;
              if(dp->CCstate == CC_MAT)      d = dp->CC + matMatrix[B[ip1]] + hmm->MatToMat(bhmmPos);
              else if(dp->CCstate == CC_INS) d = dp->CC + matMatrix[B[ip1]] + hmm->InsToMat(bhmmPos);
              else                           d = dp->CC + matMatrix[B[ip1]] + hmm->DelToMat(bhmmPos);
              dp->CC = c; 
              if (st == ste) dp->CCstate = CC_INS;
	      else           dp->CCstate = CC_DEL;
              c = d;
            }
            st += 5;
        } 
        else {
            st = 0;
            if (best_score - c > X){
                if(dp->CCstate == CC_MAT)      c = dp->CC + matMatrix[B[ip1]] + hmm->MatToMat(bhmmPos);
                else if(dp->CCstate == CC_INS) c = dp->CC + matMatrix[B[ip1]] + hmm->InsToMat(bhmmPos);
                else                           c = dp->CC + matMatrix[B[ip1]] + hmm->DelToMat(bhmmPos);
                f= dp->FF;
                if (tt == i) tt++; else { dp->CC =  MININT; }
            } else {
                cb = i;
                if (c > best_score) { best_score = c; *pei = j_r; *pej = i; }
                if ((c += hmm->MatToDel(bbhmmPos)) > (d += hmm->DelToDel(bbhmmPos))) { dp->DD = c; } 
                else { dp->DD = d; if (std == 83) st += 60; else st += 30; } 
                if ((c += (hmm->MatToIns(bbhmmPos) + insMatrix[B[ip1]] - hmm->MatToDel(bbhmmPos))) > 
                        (e += (hmm->InsToIns(bbhmmPos) + insMatrix[B[ip1]]))) { e = c; } 
                else { if (ste > 50) st += 20; else st += 10; }
                c -= (hmm->MatToIns(bbhmmPos) + insMatrix[B[ip1]]); 
                d = dp->FF;
                if (f < c - hmm->Getf_open()) { dp->FF = c - hmm->Getf_open() - decline_penalty; } 
                else { dp->FF = f - decline_penalty; st += 5; }
                f = d;
                if(dp->CCstate == CC_MAT)      d = dp->CC + matMatrix[B[ip1]] + hmm->MatToMat(bhmmPos);
                else if(dp->CCstate == CC_INS) d = dp->CC + matMatrix[B[ip1]] + hmm->InsToMat(bhmmPos);
                else                           d = dp->CC + matMatrix[B[ip1]] + hmm->DelToMat(bhmmPos);
                dp->CC = c; dp->CCstate = CC_MAT; c = d;      
            }
        }
        stp[i] = st;
    }
    if (tt == j) { j_r++; break; }
    if (cb < j-1) { j = cb + 1; } 
    else {
        while (e >= best_score - X && j <= N) {
          dyn_prog[j].CC = e; 
          dyn_prog[j].DD = e + hmm->MatToDel(bbhmmPos); dyn_prog[j].FF = e - hmm->Getf_open() - decline_penalty;
          e += (hmm->InsToIns(bbhmmPos) + insMatrix[B[j+1]]); stp[j] = 1;
	  dyn_prog[j].CCstate = CC_INS;
	  j++;
        }
      }
    if (j <= N) {
      dyn_prog[j].DD = dyn_prog[j].CC= dyn_prog[j].FF = MININT;
      j++; 
    }
    state_struct->used += (MAX(i, j) - tt_start + 1);
  }
  i = *pei; j = *pej;
  tmp = (unsigned char*) malloc(i+j);
  for (s=0, c = 0; i> 0 || j > 0; c++) {
      t = state[i][j]; k  = t %5;
      if (s == 1) 
          if ((t/10)%3 == 1) k = 1; else if ((t/10)%3 == 2) k = 3;
      if (s == 2)
          if ((t/30) == 1) k = 2; else if ((t/30) == 2) k = 3;
      if (s == 3 && ((t/5)%2) == 1) k = 3;
      if (k == 1) { j--; } else if (k == 2) { i--; } else { j--; i--; }
      tmp[c] = s = k;
  }
  c--;
  while (c >= 0) {
      if (tmp[c] == 0) { pi=pd=FALSE;REP_ }
      else if (tmp[c] == 1 && (!pd)) { pi=TRUE; INS_(1) }
      else if (tmp[c] == 3) { pi=pd=FALSE; REPP_ }
      else if(!pi) { pd=TRUE; DEL_(1) }
      else if(pi || pd) REP_
      c--;
  }
  GMemFree(tmp); GMemFree(state); GMemFree(dyn_prog);
  *sapp = data.sapp;
  return best_score;
}

Int4 hmmScoreOnlyALIGN(unsigned char * B, Int4 M, Int4 N, Int4 * pei, Int4 * pej, 
	gxd_typ gxd, Int4 query_offset, Boolean reversed)
{ 
  gab_typ gap_align = gxd->gab;
  register Int4 i, ip1, j;
  Int4 cb, j_r;
  unsigned char st, std, ste;
  Int4 decline_penalty;
  register Int4 c, d, e, tt, f;
  Int4 best_score = 0;
  register Int4 *matMatrix, *insMatrix;
  register dp_ptr dp, dyn_prog;
  register Int4 X;

  shm_typ *hmm = gxd->hmm;
  Int4 hmmPos, bhmmPos, bbhmmPos;
  *pei = *pej = 0;
  decline_penalty = gap_align->decline_align;
  X = gap_align->x_parameter;
  insMatrix = hmm->InsEmit(1);

  if(reversed) hmmPos = M+1; 
  else hmmPos = query_offset+1;

  if (X < -hmm->MatToIns(hmmPos)) X = -hmm->MatToIns(hmmPos);
  if(N <= 0 || M <= 0) { *pei = *pej; return 0; }

  j = (N + 2) * sizeof(dp_node);
  dyn_prog = (dp_ptr)malloc(j);

  dyn_prog[0].CC = 0;
  dyn_prog[0].FF = -hmm->Getf_ox();
  dyn_prog[0].DD = hmm->MatToDel(hmmPos);
  c = hmm->MatToIns(hmmPos) + insMatrix[B[1]];
  dyn_prog[0].CCstate = CC_MAT;

  for(i = 1; i <= N; i++) {
    if(c < -X) break;
    dyn_prog[i].CC = c;
    dyn_prog[i].DD = c + hmm->MatToDel(hmmPos);
    dyn_prog[i].FF = c - hmm->Getf_ox();
    c += (hmm->InsToIns(hmmPos) + insMatrix[B[i+1]]);
  }

  for(Int4 nn = 1; nn <= N+1; nn++) {
    dyn_prog[nn].CCstate = CC_INS;
  }

  tt = 0;  j = i;
  for(j_r = 1; j_r <= M; j_r++) {
    if(reversed) { hmmPos = M - j_r + 1; bhmmPos = hmmPos; bbhmmPos = hmmPos - 1; }
    else         { hmmPos = j_r + query_offset + 1; bhmmPos = hmmPos - 1; bbhmmPos = hmmPos; }
     /* Protection against divide by zero. */

    if(reversed) matMatrix = hmm->MatEmit(hmmPos);
    else         matMatrix = hmm->MatEmit(hmmPos);
    e = c = f = MININT;
    for (ip1 = tt+1, cb = i = tt, dp = &dyn_prog[i-1]; i < j; ip1++, i++) {
        d = (++dp)->DD;
        if (d < f) { d = f; std=83; } else std = 42;
        if (e < f) { e = f; ste = 83; } else ste = 41;
        if (c < d || c < e) {
            if (d < e) { c = e; st = ste; } else { c = d; st = std; }
            if (best_score - c > X) {
                if(dp->CCstate == CC_MAT)      c = dp->CC + matMatrix[B[ip1]] + hmm->MatToMat(bhmmPos);
                else if(dp->CCstate == CC_INS) c = dp->CC + matMatrix[B[ip1]] + hmm->InsToMat(bhmmPos);
                else                           c = dp->CC + matMatrix[B[ip1]] + hmm->DelToMat(bhmmPos);
                f = dp->FF;
                if (tt == i) tt++; else { dp->CC = MININT; }
            } else {
              cb = i;
              e +=  (hmm->InsToIns(bbhmmPos) + insMatrix[B[ip1]]);
              dp->DD = d + hmm->DelToDel(bbhmmPos);
              d = dp->FF; dp->FF = f - decline_penalty; f = d;
              if(dp->CCstate == CC_MAT)      d = dp->CC + matMatrix[B[ip1]] + hmm->MatToMat(bhmmPos);
              else if(dp->CCstate == CC_INS) d = dp->CC + matMatrix[B[ip1]] + hmm->InsToMat(bhmmPos);
              else                           d = dp->CC + matMatrix[B[ip1]] + hmm->DelToMat(bhmmPos);
              dp->CC = c; 
              if (st == ste) dp->CCstate = CC_INS;
              else           dp->CCstate = CC_DEL;
              c = d;
            }
            st += 5;
        } 
        else {
            st = 0;
            if (best_score - c > X){
                if(dp->CCstate == CC_MAT)      c = dp->CC + matMatrix[B[ip1]] + hmm->MatToMat(bhmmPos);
                else if(dp->CCstate == CC_INS) c = dp->CC + matMatrix[B[ip1]] + hmm->InsToMat(bhmmPos);
                else                           c = dp->CC + matMatrix[B[ip1]] + hmm->DelToMat(bhmmPos);
                f= dp->FF;
                if (tt == i) tt++; else { dp->CC =  MININT; }
            } else {
                cb = i;
                if (c > best_score) { best_score = c; *pei = j_r; *pej = i; }
                if ((c += hmm->MatToDel(bbhmmPos)) > (d += hmm->DelToDel(bbhmmPos))) { dp->DD = c; } 
                else { dp->DD = d; if (std == 83) st += 60; else st += 30; } 
                if ((c += (hmm->MatToIns(bbhmmPos) + insMatrix[B[ip1]] - hmm->MatToDel(bbhmmPos))) > 
                        (e += (hmm->InsToIns(bbhmmPos) + insMatrix[B[ip1]]))) { e = c; } 
                else { if (ste > 50) st += 20; else st += 10; }
                c -= (hmm->MatToIns(bbhmmPos) + insMatrix[B[ip1]]); 
                d = dp->FF;
                if (f < c - hmm->Getf_open()) { dp->FF = c - hmm->Getf_open() - decline_penalty; } 
                else { dp->FF = f - decline_penalty; st += 5; }
                f = d;
                if(dp->CCstate == CC_MAT)      d = dp->CC + matMatrix[B[ip1]] + hmm->MatToMat(bhmmPos);
                else if(dp->CCstate == CC_INS) d = dp->CC + matMatrix[B[ip1]] + hmm->InsToMat(bhmmPos);
                else                           d = dp->CC + matMatrix[B[ip1]] + hmm->DelToMat(bhmmPos);
                dp->CC = c; dp->CCstate = CC_MAT; c = d;      
            }
        }
    }
    if (tt == j) { j_r++; break; }
    if (cb < j-1) { j = cb + 1; } 
    else {
        while (e >= best_score - X && j <= N) {
          dyn_prog[j].CC = e; 
          dyn_prog[j].DD = e + hmm->MatToDel(bbhmmPos); dyn_prog[j].FF = e - hmm->Getf_open() - decline_penalty;
          e += (hmm->InsToIns(bbhmmPos) + insMatrix[B[j+1]]);
          dyn_prog[j].CCstate = CC_INS; j++;
        }
      }
    if (j <= N) {
      dyn_prog[j].DD = dyn_prog[j].CC= dyn_prog[j].FF = MININT;
      j++; 
    }
  }
  GMemFree(dyn_prog);
  return best_score;
}

Boolean hmmPerformGappedAlignmentWithTraceback(gxd_typ gxd,shm_typ *shm,shm_typ *rshm)
{
	gab_typ gap_align = gxd->gab;
	Boolean found_start, found_end;
	Int4	q_length=0, s_length=0, score_right, middle_score, score_left,
		private_q_length, private_s_length, tmp;
	Int4 include_query, index;
	Int4		*tback, *tback1, *p, *q;
	unsigned char	*q_left=NULL, *s_left=NULL;
	unsigned char	*query, *subject, *query_var, *subject_var;

	if (gap_align == NULL) return FALSE;
	found_start = FALSE;
	found_end = FALSE;
	query = gap_align->query;
	subject = gap_align->subject;
	tback = tback1 = (Int4*) 
		malloc((gap_align->subject_length+gap_align->query_length)*sizeof(Int4));
	include_query = gap_align->include_query;
//shm->Put(stdout);
//rshm->Put(stdout);
	score_left = 0;
	if (gap_align->q_start != 0 && gap_align->s_start != 0) {
		found_start = TRUE;
		q_left = (unsigned char *) 
			malloc((gap_align->q_start+2)*sizeof(unsigned char));
		s_left = (unsigned char *) 
			malloc((gap_align->s_start+2)*sizeof(unsigned char));
		q_length = reverse_seq(query, query+gap_align->q_start, q_left);
		s_length = reverse_seq(subject, subject+gap_align->s_start, s_left);

		gxd->hmm=rshm;
		score_left = hmmTracebackALIGN(s_left-1, q_length, s_length, 
			tback, &private_q_length, &private_s_length, 
			&tback1, gxd, gap_align->q_start, TRUE);

		gxd->hmm=shm;
	        for(p = tback, q = tback1 - 1; p < q; p++, q--)
			{ tmp = *p; *p = *q; *q = tmp; }
		gap_align->query_start = q_length - private_q_length;
		gap_align->subject_start = s_length - private_s_length;

	} else { q_length = gap_align->q_start; s_length = gap_align->s_start; }

	middle_score = 0;

	query_var = query+gap_align->q_start;
	subject_var = subject+gap_align->s_start;
	for (index=0; index<include_query; index++) {
		query_var++;
		subject_var++;
		if (!(gap_align->positionBased))  /*AAS*/
		  middle_score += gap_align->matrix[*query_var][*subject_var];
		else {
		  if(index) middle_score += gxd->hmm->MatToMat(gap_align->q_start+2 + index);
		  if(gap_align->q_start+2 + index <= gxd->hmm->GetLength()) 
			middle_score += gxd->hmm->MatEmit(gap_align->q_start+2 + index)[*subject_var];
		}

		*tback1 = 0;
		tback1++;
	}

	score_right = 0;
	if ((gap_align->q_start+include_query) < gap_align->query_length 
		&& (gap_align->s_start+include_query) < gap_align->subject_length)
	{
		found_end = TRUE;
		score_right = hmmTracebackALIGN(subject+gap_align->s_start+include_query,
			gap_align->query_length-q_length-include_query,
			gap_align->subject_length-s_length-include_query,
			tback1, &private_q_length, &private_s_length,
			&tback1, gxd, gap_align->q_start+include_query,
			FALSE);
		gap_align->query_stop = gap_align->q_start
				+ private_q_length+include_query;
		gap_align->subject_stop = gap_align->s_start
				+ private_s_length+include_query;
	}
	if (found_start == FALSE) {	/* Start never found */
		gap_align->query_start = gap_align->q_start;
		gap_align->subject_start = gap_align->s_start;
	}
	if (found_end == FALSE) {
		gap_align->query_stop = gap_align->q_start + include_query - 1;
		gap_align->subject_stop = gap_align->s_start + include_query - 1;
	}

	gap_align->edit_block = TracebackToGXEB(query, subject, 
		gap_align->query_stop - gap_align->query_start + 1, 
		gap_align->subject_stop-gap_align->subject_start + 1,
		tback, gap_align->query_start, gap_align->subject_start);
        gap_align->edit_block->length1 = gap_align->query_length;
	gap_align->edit_block->length2 = gap_align->subject_length;
	tback = (Int4*) GMemFree(tback);
	q_left = (unsigned char*) GMemFree(q_left);
	s_left = (unsigned char*) GMemFree(s_left);
	gap_align->score = score_right+score_left+middle_score;
	return TRUE;
}
Boolean hmmPerformGappedAlignment(gxd_typ gxd,shm_typ *shm,shm_typ *rshm)
{
	gab_typ gap_align = gxd->gab;
        Boolean         found_start, found_end;
        Int4            q_length=0, s_length=0, middle_score;
        Int4            score_right, score_left, private_q_start, private_s_start;
        Int4            include_query, index;
        unsigned char   *q_left=NULL, *s_left=NULL;
        unsigned char   *query, *subject, *query_var, *subject_var;

        if (gap_align == NULL) return FALSE;
        found_start = FALSE; found_end = FALSE;

        query = gap_align->query;
        subject = gap_align->subject;
        include_query = gap_align->include_query;
        score_left = 0;
        if (gap_align->q_start != 0 && gap_align->s_start != 0) {
                found_start = TRUE;
                q_left = (unsigned char *) malloc((gap_align->q_start+2)*sizeof(unsigned char));
                s_left = (unsigned char *) malloc((gap_align->s_start+2)*sizeof(unsigned char));

                q_length = reverse_seq(query, query+gap_align->q_start, q_left);
                s_length = reverse_seq(subject, subject+gap_align->s_start, s_left);
		gxd->hmm = rshm;
		score_left = hmmScoreOnlyALIGN(s_left-1, q_length, s_length, 
			&private_q_start, &private_s_start, 
			gxd, gap_align->q_start, TRUE);
		gxd->hmm = shm;
                gap_align->query_start = q_length - private_q_start;
                gap_align->subject_start = s_length - private_s_start;
        } else {
                q_length = gap_align->q_start;
                s_length = gap_align->s_start;
        }
        middle_score = 0;
        query_var = query+gap_align->q_start;
        subject_var = subject+gap_align->s_start;
        for (index=0; index<include_query; index++) {
                query_var++;
                subject_var++;
                if (!(gap_align->positionBased))  /*AAS*/
                  middle_score += gap_align->matrix[*query_var][*subject_var];
                else {
		  if(index) middle_score += gxd->hmm->MatToMat(gap_align->q_start + 2 + index);
		  if(gap_align->q_start + 2 + index <= gxd->hmm->GetLength()) 
			middle_score += gxd->hmm->MatEmit(gap_align->q_start + 2 + index)[*subject_var];		 
		}
        }
        score_right = 0;
        if (gap_align->q_start+include_query < gap_align->query_length 
                && gap_align->s_start+include_query < gap_align->subject_length)
        {
                found_end = TRUE;
		score_right = hmmScoreOnlyALIGN(subject+gap_align->s_start+include_query,
			gap_align->query_length-q_length-include_query,
			gap_align->subject_length-s_length-include_query,
			&(gap_align->query_stop), &(gap_align->subject_stop),
			gxd, gap_align->q_start+include_query,
			FALSE);
                gap_align->query_stop += gap_align->q_start+include_query;
                gap_align->subject_stop += gap_align->s_start+include_query;
        }

        if (found_start == FALSE) {     /* Start never found */
                gap_align->query_start = gap_align->q_start;
                gap_align->subject_start = gap_align->s_start;
        }
        if (found_end == FALSE) {
                gap_align->query_stop = gap_align->q_start + include_query - 1;
                gap_align->subject_stop = gap_align->s_start + include_query - 1;
        }
        q_left = (unsigned char*) GMemFree(q_left);
        s_left = (unsigned char*) GMemFree(s_left);
        gap_align->score = score_right+score_left+middle_score;
        return TRUE;
}

