#include <stdlib.h>
#include <stdio.h>

#include "dca_typ.h"

parse_options *dca_typ::new_parse_options(char option, char* argument, int index)
// Constructor for parse_options objects 
{
	parse_options *opt = (parse_options *)malloc(sizeof(parse_options));
	if(opt == NULL) {
		perror("Cannot malloc option!");
	}

	opt->option = option;
	opt->argument = argument;
	opt->index = index;
	opt->next = NULL;

	return opt;
}

int dca_typ::findopt(char opt, const char* options)
// Find the index of an option character opt in options definition options
{
	int opti;
	opti = 0;

	while((options[opti] != 0) && (options[opti] != opt)) { opti++; }
	return opti;
}

parse_options *dca_typ::parseopt(int argc, char *argv[], const char *options)
// Parse an array of command line arguments
{
	int argi, argii, opti;
	char *arg;

	parse_options *head=NULL, *tail=NULL, *newopt;
	for(argi = 1; argi < argc; argi++) {
	   arg = argv[argi];
	   if(arg[0] == '-'){
	     /* Handle option */
	     for(argii=1; arg[argii] != 0; argii++) {
		opti = findopt(arg[argii], options);
		if(options[opti] == 0) {
		   printf("Unknown option %c at argument index %d\n",
				arg[argii], opti);
		   return NULL;
		}
		if(options[opti+1] == ':') {
		   /* The current option expects an argument */
		   if(arg[argii+1] == 0) {
			/* Argument is separate token */
			if(argi + 1 >= argc) {
			   printf("Option %c lacks an argument!\n",arg[argii]);
			   return NULL;
			}
			newopt = new_parse_options(options[opti], argv[argi+1], argi);
			argi++;
		   } else {
			/* Argument is fused with option */
			newopt = new_parse_options(options[opti], &(arg[argii+1]), argi);
			while(arg[argii+1] != 0) { argii++; }
		   }
		} else {
			/* The current option expects no argument */
			newopt = new_parse_options(options[opti], NULL, argi);
		}
		if(head == NULL) { head = tail = newopt; }
		else { tail->next = newopt; tail = newopt; }
	     }
	   } else { // Handle positional argument 
		newopt = new_parse_options(0, argv[argi], argi);
		if(head == NULL) { head = tail = newopt; }
		else { tail->next = newopt; tail = newopt; }
	   }
	} return head;
}

