#if !defined (SPARC_USAGE)
#define SPARC_USAGE

#define SPRC_VERSION "\
  ----------------------------------------------------\n\
     SPARC v0.3 (July 15, 2021)\n\
     www.igs.umaryland.edu/labs/neuwald/software/sparc/\n\
     Copyright 2020-2021 The University of Maryland\n\
     Freely distributed under the MIT License\n\
  ----------------------------------------------------\n"

#define USAGE_SPARC_DARC "\
   Search Procedures for Analysis of Residue Constraints (SPARC)\n\
   Usage: sparc rank <infile> <pdb_directory> [options]\n\
   Input:  <infile> MSA in cma format with NCBI pdb ids for corresponding structures\n\
           <pdb_directory> path to the pdb structural coordinate directory\n\
            Files in this directory need the syntax <pdbid>_H.pdb to be recognized\n\
             where <pdbid> is the lowercase version of the pdb identifier (e.g., '1abc')\n\
   Output: \n\
           <prefix>.sprc SPARC output file showing STARC S-scores.\n\
   Temporary output: \n\
           <prefix>_sprc_X.in  input aln file for CCMpred\n\
           <prefix>_sprc_X.mst input file for STARC algorithm\n\
           <prefix>_sprc_X.dca CCMpred output DCA file (input for STARC algorithm)\n\
           <prefix>_sprc_X file of DCA scores in EVC format\n\
   Options: \n\
      -D=<real>       Maximum distance (in Angstroms) between scored residues (default: 3.0).\n\
      -I              Optimize over ICA P-values instead of unified P-values\n\
      -inCCM=<int>    Run CCMpred using <int> (>= 250) randomly chosen aligned sequences\n\
      -m=<int>        Minimum sequence separation between paired residues (default: 5)\n\
      -pdbaa=<str>    Retrieve from the NCBI pdbaa fsata file sequences identical\n\
                        to pdb seqs in the MSA (path=<str>)\n\
      -ptrn=<str>     BPPS search pattern for -mds option (path=<str>)\n\
      -sbsmpl=<int1>:<int2> Run CCM subsamplng with <int1> samples of size <int2>\n\
			(default: 5:1000);\n\
                        Note: <int1> range: 5-1000; <int2> range: 50-10000; \n\
		        Size needs to be < 1/3rd size of foregroud sequence set.\n\
      -seed=<int>     Seed for random number generator\n\
      -thrds=<int>    Number of threads to use for CCMpred step (default: 1).\n\
      -dev=<int>      GPU device number to be used for CCMpred (default: -1 = none)\n\
   References:\n\
      Neuwald, A.F. & Altschul, S.F. 2018. Statistical Investigations of Protein Residue\n\
        Direct Couplings. PLoS Computational Biology 14(12):e1006237. PMID: 30596639.\n\
      Seemayer S., Gruber M. & Söding J. 2014. CCMpred--fast and precise prediction of\n\
        protein residue-residue contacts from correlated mutations.\n\
        Bioinformatics 30(21):3128-30.\n\
   Funding provided by the National Institutes of Health, National Institute of \n\
	General Medical Sciences grant R01GM125878.\n\
\n"

//      -v              Verbose output.\n\

#endif

