/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "c2a_typ.h"

Int4	*PtrnStr2Ints(Int4 id, char *Str)
{
	Int4	i,j,x,*iarray,s;
	char	c,res[22];
	for(i=0,j=1; Str[i] != 0; i++) if(Str[i]==',') j++;
	NEW(iarray,j+3,Int4); iarray[0]=j;
	if(sscanf(Str,"%d: ",&x) != 1) print_error("pattern parsing error 1");
	if(x != id) print_error("pattern identifier error");
	Str=&Str[0]; Str=strchr(Str,':'); assert(Str != NULL);
	Str++; while(*Str == ' ') Str++;
	for(i=0; *Str !='\n'; ){
	   if(sscanf(Str,"%[A-Z]%d",res,&x) != 2) print_error("pattern parsing error 2");
	   i++; iarray[i]=x;
	   /// fprintf(stderr,"%s%d\n",res,x); fflush(stderr);
	   for( ; *Str != ','; Str++) if(*Str == '\n') break;
	   if(*Str == '\n') break; else Str++;
	   // fprintf(stderr,"%s",Str); fflush(stderr);
	} assert(i == j);
	return iarray;
}

Int4	*RenumberList(FILE *fp, Int4 *list)
// LELTPLDPAaDARHLHHAYGDEEvmrwwtrpacadpaeteRYLT----ScaaapgARLWTIRAPDgTVPGMAGLLGGtdVPGLTWLLRRDSWGHGYATEAAAAVvGHALEDgGLDRVEAWIEAGNRRSLAVAARVGLTERARLaqhYPhRPGpHEMVVLGKARA
{
	char	c,Str[5005];
	Int4	i,j,col,sq,*col2sq; NEW(col2sq,5005,Int4);
	Int4	*pos2col; NEW(pos2col,5005,Int4);
	for(i=1,sq=col=0; (c=fgetc(fp)) != '\n'; i++){
	   BooLean indel=FALSE,ins=FALSE;
	   if(isupper(c)){ sq++; col++; }
	   else if(islower(c)){ sq++; indel=TRUE; ins=TRUE; }
	   else if(c == '-'){ col++; indel=TRUE; }
	   if(!indel) col2sq[col]=sq; 
	   if(!ins) pos2col[i]=col;
// fprintf(stderr,"%d. %c: col=%d; sq=%d; col2sq[%d]=%d\n",i,c,col,sq,col,col2sq[col]);
	}
	Int4 *List=0; NEW(List,list[0]+3,Int4);
	for(j=0,i=1; i <= list[0]; i++) {
#if 1
	    if(col2sq[list[i]] > 0){ j++; List[j]=col2sq[list[i]]; }
#else
	    if(pos2col[list[i]] > 0){ j++; List[j]=pos2col[list[i]]; }
#endif
	} List[0]=j;
	free(col2sq); free(pos2col);
	return List;
}

char	**run_cma2aln(Int4 argc,char *argv[],Int4 &NumIn, char *infile,FILE *lgfp,
		double cut,double pdb_cut)
{ 
	Int4	arg,i,j,time1,Number,pos[4],r,file,NN=0,sq,MaxInSeq=0;
	char	c,PutAln=FALSE,PutCCM=FALSE,ShowPDB=FALSE;
	char	**seq_ids=0;
	BooLean	PutFlank=TRUE,*skip=0;
	time1=time(NULL); 
	char	Str[5003],*ptrnfile=0;
// fprintf(stderr,"running cma2aln\n");
// for(arg=0; arg < argc; arg++) fprintf(stderr,"%s ",argv[arg]); fprintf(stderr,"\n");
	if(argc < 2) print_error(USAGE_C2A_TYP_START);
	TurnOffLicenseStatement();
	for(arg = 2; arg < argc; arg++){
	   if(argv[arg][0] != '-') print_error(USAGE_C2A_TYP_START);
	   switch(argv[arg][1]) {
             case 'M': 
		if(sscanf(argv[arg],"-M=%d",&MaxInSeq)!=1) print_error(USAGE_C2A_TYP_START); 
		break;
             case 'm': if(strcmp("-mst",argv[arg])==0){ PutAln=TRUE; } break;
             case 'c': if(strcmp("-ccm",argv[arg])==0){ PutCCM=TRUE; } break;
             case 'p': 
		if(strcmp("-pdb",argv[arg])==0){ ShowPDB=TRUE; } 
		else if(sscanf(argv[arg],"-ptrn=%s",Str)!=1) print_error(USAGE_C2A_TYP_START); 
		else { ptrnfile=AllocString(Str); }
		break;
             case 'T': if(argv[arg][2]==0){ PutFlank=TRUE; }
		 else print_error(USAGE_C2A_TYP_START); break;
             case 'x': break;
	     default: print_error(USAGE_C2A_TYP_START);
	   }
	}
	a_type	AB=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
	//************************** Open multiple cma file **************************
	if(!(PutAln || PutCCM)){ PutAln=PutCCM=TRUE; }
	if(ShowPDB){ PutCCM=FALSE; }

    FILE *fp=0;
    if(infile) fp=open_file(infile,"","r"); else fp=open_file(argv[1],"","r");
    cma_typ *IN_CMA=MultiReadCMSA(fp,&Number,AB); fclose(fp); fp=0;
    if(Number > 1 && strcmp("Random",NameCMSA(IN_CMA[Number]))==0){
	TotalNilCMSA(IN_CMA[Number]);  Number--; 
    }
#if 1	// 
    if(MaxInSeq > 0){
	assert(Number==1);
	cma_typ cma=IN_CMA[1];
	Int4 Nsq=NumSeqsCMSA(cma);
	NEW(skip,Nsq+5,BooLean);
	dh_type	dH=dheap(Nsq,4); // keep first sequence (csq) in.
	for(sq=2; sq <= NumSeqsCMSA(cma); sq++){
		skip[sq]=TRUE;
		insrtHeap(sq,(keytyp)Random(),dH);
	}
	for(i=2; i <= MaxInSeq && (sq=delminHeap(dH)) != 0; i++){ skip[sq]=FALSE; }
	Nildheap(dH);
    }
#endif
// fprintf(stderr,"DEBUG 5b; %d files\n",Number);
    Int4 **Ptrn=0;
    char **pStr=0;
    if(ptrnfile){
	NEWP(Ptrn,Number+3,Int4);
	NEWP(pStr,Number+3,char);
	fp=open_file(ptrnfile,"","r");
	for(i=Number; i >= 1; i--){
	    assert(fgets(Str,5000,fp) != NULL);
	    pStr[i]=AllocString(Str);
	    Ptrn[i]=PtrnStr2Ints(i,Str);
	} fclose(fp); fp=0; free(ptrnfile); ptrnfile=0;
    }
   Int4	II=0;
   if(Number == 1) NEWP(seq_ids,NumSeqsCMSA(IN_CMA[1])+5, char);
   else print_error("FATAL: alignment file input error");
   for(file=1; file <= Number; file++){
	BooLean	found=TRUE;
	if(PutAln && PutCCM){ found=FALSE; }
	cma_typ cma=IN_CMA[file];
	// fprintf(stderr,"------------- %d. %s --------------\n",file,NameCMSA(cma));
	if(nBlksCMSA(cma) != 1) print_error("cma file error; not single block.");
	if(PutAln){
	   char str[20];
	   create_gsq_cmsa(cma);   // create gsq objects for cma if not present...
	   FILE *afp=0;
	   for(sq=1; sq <= NumSeqsCMSA(cma); sq++){
		e_type E=TrueSeqCMSA(sq,cma);
		StrSeqID(str,10,E);
		if(strlen(str) != 6) continue;
		if(str[4] != '_') continue;
		if(!isdigit(str[0])) continue;
		II++; // fprintf(stderr,"---- %d. %s ----\n",II,str);
		if(seq_ids) seq_ids[II]=AllocString(str);
		if(ShowPDB) continue;
		found=TRUE;
	   	if(afp==0){
		   if(Number == 1) afp=open_file(argv[1],"_X.mst","w");
		   else afp=open_file(NameCMSA(cma),"_X.mst","w");
		}
           	gsq_typ *gsq=gsqCMSA(sq,cma);
           	assert(gsq != 0);    // this should not happen...
		double FractDel=(double) gsq->NumDel( )/(double) LengthCMSA(1,cma);
if(lgfp==0) lgfp=stderr;
		if(FractDel > pdb_cut){
		    if(lgfp) fprintf(lgfp,
			"%s has too many deletions (%.1lf%c); skipping...\n",
				str,100.0*FractDel,'%');
		    continue;
		} else fprintf(afp,"%s: ",str);
           	Int4    *sites=GetPosSitesCMSA(sq,cma);
           	gsq->Put_ccm_format(afp,PutFlank,nBlksCMSA(cma),sites,LengthsCMSA(cma),AB);
// gsq->Put_cma_format(stderr,0,nBlksCMSA(cma),sites,LengthsCMSA(cma),AB);
	        if(Ptrn){
		  FILE *tfp=tmpfile();
        	  gsq->Put_ccm_format(tfp,PutFlank,nBlksCMSA(cma),sites,LengthsCMSA(cma),AB);
		  rewind(tfp);
		  Int4 *List=RenumberList(tfp,Ptrn[file]);
		  fclose(tfp);
#if 0
		  // fprintf(stderr,"%s",pStr[file]);
		  fprintf(stderr,"#R=");
		  for(i=1; i < List[0]; i++){ fprintf(stderr,"%d,",List[i]); } fprintf(stderr,"%d\n",List[i]);
#endif
		  fprintf(afp,"#R=");
		  for(i=1; i < List[0]; i++){ fprintf(afp,"%d,",List[i]); } fprintf(afp,"%d\n",List[i]);
		}
           	free(sites); 
           } if(afp) fclose(afp); afp=0;
	} fp=0;
// if(found) fprintf(stderr,"found=TRUE\n"); else fprintf(stderr,"found=FALSE\n");
	if(!found){
	    fprintf(stderr,
		"WARNING: failed to find sequences with NCBI pdb identifiers.\n");
	}
        if(found && PutCCM) {
	   if(Number == 1) fp=open_file(argv[1],".in","w");
	   else fp=open_file(NameCMSA(cma),".in","w");
	   char *seq=ConsensusSeqCMSA(1,cma);
	   fprintf(fp,"%s\n",seq); free(seq);
#if 0	   // randomly sample a subset of the sequences
#endif
	   for(NN=0,sq=1; sq <= NumSeqsCMSA(cma); sq++){
		if(skip && skip[sq]) continue;
#if 1
           	gsq_typ *gsq=gsqCMSA(sq,cma);
           	assert(gsq != 0);    // this should not happen...
		double FractDel=(double) gsq->NumDel( )/(double) LengthCMSA(1,cma);
		if(FractDel > cut){
			fprintf(stderr,"Seq #%d has too many deletions and needs to be removed:\n",sq);
			PutSeqInfo(stderr,TrueSeqCMSA(sq,cma));
			fprintf(stderr,"\n");
		}
		if(FractDel > cut) continue;
#endif
		assert(PosSiteCMSA(1, sq, pos, cma));
                for(j=1; j <= LengthCMSA(1,cma); j++){
		    r=ResidueCMSA(1,sq,j,cma);
		    if(IsDeletedCMSA(sq,pos[1]+j-1,cma)){
			assert(r==0); c='-'; 
		    } else c=AlphaChar(r,AB);	
		    fprintf(fp,"%c",c);
		} fprintf(fp,"\n");
		NN++;
           } // fprintf(fp,"\n");
        } if(fp) fclose(fp); fp=0;
	if(cma) TotalNilCMSA(cma); 
     } NilAlpha(AB); free(IN_CMA);
	if(skip) free(skip);
	NumIn=NN;
	if(0) fprintf(stderr,"\ttime: %d seconds (%0.2f minutes)\n",
                        time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	char **X=0; 
	if(seq_ids){
#if 1	   // eliminate redundancies...
	   // set_typ setR=MakeSet(II+5);
	   for(i=1; i <= II; i++){
	      if(seq_ids[i] == 0) continue;
	      for(j=i+1; j <= II; j++){
		// if(MemberSet(j,setR)) continue;  // already removed...
		if(seq_ids[j] && strcmp(seq_ids[i],seq_ids[j]) == 0){
		    free(seq_ids[j]); seq_ids[j]=0;
		    // AddSet(j,setR);  // remove j;
		}
	      }
	   }
#endif
	   NEWP(X,II +5,char);
	   for(j=0,i=1; i <= II; i++){
		// if(!MemberSet(i,AddSet)){ j++; X[j]=seq_ids[i]; } 
		if(seq_ids[i]){ j++; X[j]=seq_ids[i]; }
	   } free(seq_ids); 
	} return X;
}

