/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cmc_typ.h"
#include "blosum62.h"

cmc_typ::cmc_typ(Int4 argc, char *argv[])
{
	passed_in_cma=0; passed_in_hsw=0; passed_in_mcma=0; num_passed_in_sets=0; passed_in_sets=0; 
	passed_in_sma=0; passed_in_hpt=0; AB=0; ownAB=TRUE; Init(argc, argv); 
}

#if 1	// new afn 11/2/2012.
cmc_typ::cmc_typ(cma_typ in_cma, cma_typ in_mcma, hsw_typ hsw, Int4 NumInSets, set_typ *InSet, 
			hpt_typ *in_hpt, cma_typ *in_sma, Int4 argc, char *argv[])
//			hpt_typ *in_hpt, cma_typ *in_sma, set_typ labeled, Int4 argc, char *argv[])
{
	passed_in_cma=in_cma; passed_in_hsw=hsw; passed_in_mcma=in_mcma;
	passed_in_sma=in_sma; passed_in_hpt=in_hpt; num_passed_in_sma=in_hpt->NumSets()-1;
	num_passed_in_sets=NumInSets; passed_in_sets=InSet;
	AB=AlphabetCMSA(in_cma); ownAB=FALSE;
	// Make sure that sets are disjoint.
	for(Int4 i=1; i <= NumInSets; i++){
	   for(Int4 j=i+1; j <= NumInSets; j++){
		Int4 X=CardInterSet(InSet[i],InSet[j]);
		if(X != 0) print_error("cmc_typ input error: sequence sets not disjoint");
	   }
	} Init(argc, argv); 
}

#endif

cmc_typ::cmc_typ(cma_typ in_cma, cma_typ in_mcma, hsw_typ hsw, Int4 NumInSets, set_typ *InSet, 
			Int4 argc, char *argv[])
{
	passed_in_cma=in_cma; passed_in_hsw=hsw; passed_in_mcma=in_mcma;
	passed_in_sma=0; passed_in_hpt=0; 
	num_passed_in_sets=NumInSets; passed_in_sets=InSet;
	AB=AlphabetCMSA(in_cma); ownAB=FALSE;
	// Make sure that sets are disjoint.
	for(Int4 i=1; i <= NumInSets; i++){
	   for(Int4 j=i+1; j <= NumInSets; j++){
		Int4 X=CardInterSet(InSet[i],InSet[j]);
		if(X != 0) print_error("cmc_typ input error: sequence sets not disjoint");
	   }
	} Init(argc, argv); 
}

cmc_typ::cmc_typ(cma_typ in_cma, cma_typ in_mcma, hsw_typ hsw, Int4 argc, char *argv[])
{
	passed_in_cma=in_cma; passed_in_hsw=hsw; passed_in_mcma=in_mcma;
	num_passed_in_sets=0; passed_in_sets=0;  
	passed_in_sma=0; passed_in_hpt=0;
	AB=AlphabetCMSA(in_cma); ownAB=FALSE;
	Init(argc, argv); 
}

cmc_typ::cmc_typ(cma_typ in_cma, Int4 argc, char *argv[])
{
	passed_in_cma=in_cma; passed_in_hsw=0; passed_in_mcma=0; num_passed_in_sets=0;
	passed_in_sma=0; passed_in_hpt=0; 
	passed_in_sets=0; AB=AlphabetCMSA(in_cma); ownAB=FALSE; Init(argc, argv); 
}

cmc_typ::cmc_typ(cma_typ in_cma,Int4 NumInSets, set_typ *InSet, Int4 argc, char *argv[])
{
	passed_in_mcma=0; passed_in_cma=in_cma; num_passed_in_sets=NumInSets;
	passed_in_sma=0; passed_in_hpt=0; passed_in_sets=InSet; passed_in_hsw=0; 

	AB=AlphabetCMSA(in_cma); ownAB=FALSE;
	// Make sure that sets are disjoint.
	for(Int4 i=1; i <= NumInSets; i++){
	   for(Int4 j=i+1; j <= NumInSets; j++){
		Int4 X=CardInterSet(InSet[i],InSet[j]);
		if(X != 0) print_error("cmc_typ input error: sequence sets not disjoint");
	   }
	} Init(argc, argv); 
}

void	cmc_typ::Free()
{
	// Note: ElmntSetCMA[i]'s freed up above...
	if(cfp) fclose(cfp); if(ifp) fclose(ifp);
	for(Int4 g=1; g <= Hpt->NumSets(); g++){
		if(WorstToBest[g]) free(WorstToBest[g]);
		if(GrpSet[g]) NilSet(GrpSet[g]);
	}
	for(Int4 g=0; g < MAX_NUM_ELMENTARY_SETS; g++){
		if(BestSet[g]) NilSet(BestSet[g]);
		if(InitSet[g]) NilSet(InitSet[g]);
		if(best_sst[g]) free(best_sst[g]);
		if(sst_str[g]) free(sst_str[g]); sst_str[g]=0;
	} if(checkpoint==0 && Labeled) NilSet(Labeled);
	for(Int4 i=1; i <= NumDisplayCMA; i++){
		if(DisplayCMA && DisplayCMA[i]) TotalNilCMSA(DisplayCMA[i]); 
		if(SeedCMA[i]) TotalNilCMSA(SeedCMA[i]); 
	}
	for(Int4 n=1; n <= Hpt->NumBPPS(); n++){
		if(che && che[n]) delete che[n]; 
		if(sqd && sqd[n]) delete sqd[n];
		if(chn && chn[n]) delete chn[n]; 
		if(QryCMAs[n]) TotalNilCMSA(QryCMAs[n]);
		if(SetFG && SetFG[n]) NilSet(SetFG[n]);
		if(SetBG && SetBG[n]) NilSet(SetBG[n]);
		if(RelateFGs && RelateFGs[n]) free(RelateFGs[n]);
                if(RelateBGs && RelateBGs[n]) free(RelateBGs[n]);
                if(PttrnPos && PttrnPos[n]) NilSet(PttrnPos[n]);
// fprintf(stderr,"cmc->Free %d_4\n",n);
	}
	if(QryCMAs) free(QryCMAs);
	if(RelateFGs) free(RelateFGs);
        if(RelateBGs) free(RelateBGs);
        if(PttrnPos) free(PttrnPos);
        if(SetFG) free(SetFG);
        if(SetBG) free(SetBG);
	if(DisplayCMA) free(DisplayCMA);
	if(chn && chn[0]) delete chn[0]; 
	if(chn) free(chn);
	if(sqd) free(sqd);
	if(che) free(che); 
	if(SST) free(SST); 
	if(outfp) fclose(outfp);
   	if(MaxNumCol) free(MaxNumCol);
   	if(SFBG) free(SFBG);
   	if(program_name) free(program_name);
   	if(infile) free(infile);
	if(TrueMainCMA && !passed_in_cma) TotalNilCMSA(TrueMainCMA);
	if(MainCMA && !passed_in_mcma) TotalNilCMSA(MainCMA);
	if(dummyCMA) TotalNilCMSA(dummyCMA);
	if(ownAB && AB) NilAlpha(AB);
	if(BestHpt) delete BestHpt;
	if(InitHpt) delete InitHpt;
	if(Hpt) delete Hpt;
}

