/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cmc_typ.h"
// #include "blosum62.h"
// #include "rst_typ.h"
// #include "swt_typ.h"

#if 0
	// NumBPPS == 1 (single category)...
	// assert(Level == 1);
#endif

char	*cmc_typ::FindSeedPattern(Int4 Level)
{
	Int4 i,j;
	char *pttrn=0;

	Int4 Length=LenSeq(che[Level]->KeyE());
	sst_typ *sst_Best; NEW(sst_Best, Length +4, sst_typ);
	dh_type dH = dheap(Length+5,4);
	e_type  cE1=che[Level]->KeyE();
	double	*FG=0,*BG=0;
     if(checkpoint == 0){
	UInt4	wtFactor=che[Level]->GetWtFactor();
	NEW(FG, Length +4, double); NEW(BG, Length +4, double);
	for(j=1; j <= Length; j++){
	   unsigned char r,r1=ResSeq(j,cE1);
	   sst_typ Bsst = 0;
	   double score,best_score=-99999.9,best_n,best_d;
	   double n,d;
           for(Int4 s=1; SST[Level][j][s]; s++){
		sst_typ xsst = SST[Level][j][s];
	        double	r1_f=0,r1_n=0,r2_f=0,r2_n=0;
		// double  **ColResFreqsCMSA(Int4 t, BooLean *skip, cma_typ cma);
		// double  **ColResFreqsCMSA(Int4 t, BooLean *skip, Int4 ***observed, cma_typ cma);
		for(r=1; r <= nAlpha(AB); r++){
		   if(MemSset(r,xsst)){
			r1_f += che[Level]->GetResWtFG(j,r);
			r2_f += che[Level]->GetResWtBG(j,r);
		   } else {
			r1_n += che[Level]->GetResWtFG(j,r);
			r2_n += che[Level]->GetResWtBG(j,r);
		   }
		}
		double p,q;
		n=((double)(r1_f+1*wtFactor)/(double)(r1_f+r1_n + 2*wtFactor));
		d=((double)(r2_f+1*wtFactor)/(double)(r2_f+r2_n + 2*wtFactor)); 
		score = n*log((n)/d) + (1-n)*log((1-n)/(1-d));
		// if(score > best_score && n >= 0.8 && d <= 0.2)
		if(score > best_score)
			{ best_score=score; Bsst=xsst; best_n=n; best_d=d; }
	   }
	   // if(best_score > 0.0 && best_n >= 0.8 && best_d <= 0.2) 
	   if(best_score > 0.0) {
	      sst_Best[j]=Bsst; insrtHeap(j,(keytyp)-best_score,dH);
	      FG[j]=best_n; BG[j]=best_d;
	   }
	}
     } else {
	assert(Level <= checkpoint->num_ssts);
	for(j=1; j <= Length; j++){
		sst_Best[j]=checkpoint->sst[Level][j];
		if(sst_Best[j]) insrtHeap(j,(keytyp)j,dH);
	}
	SeedPttrnLen=ItemsInHeap(dH);	// this is the only routine in which this is used...
     }
	char tmp_str[3003];
	char str0[100];
	tmp_str[0]=0;
	// 4. Remove all columns and replace with new patterns
	Int4 MinCol=che[Level]->RtnMinNumColumns();
	che[Level]->SetMinNumColumns(0);
	// remove all patterns... 
	for(j=1; j <= Length; j++){ che[Level]->RemoveColumn(j); }

	che[Level]->SpeakUp();
	che[Level]->BeQuiet( );
	tmp_str[3000]=0;
	for(i=0; !emptyHeap(dH); ){
		double score=-(double)minkeyHeap(dH);
		j=delminHeap(dH); 
#if 0		// this eliminates too many otherwise good patterns...
		sst_typ	nsst[4];
		nsst[1]=sst_Best[j]; nsst[2]=0;
		if(che[Level]->AddBestColumn(-999999999999.9,j,nsst))
#else
		if(che[Level]->AddColumn(j,sst_Best[j]))
#endif
		{
		  i++;
		  if(i > 1) strncat(tmp_str,",",200);
		  PutSST(str0,sst_Best[j],AB);  // copies pattern to str.
		  strncat(tmp_str,str0,22);
		  sprintf(str0,"%d",j);
		  strncat(tmp_str,str0,22);
		  assert(tmp_str[3000]==0);  // don't over-extend string

		}
#if 0		// turn this on to see pattern info...
		   fprintf(stderr,"%d: sst[%d]: ",i,j);
                   PutSST(stderr,sst_Best[j],AB);
                   if(FG) fprintf(stderr,"%d (%.3f)(%.3f/%.3f)\n",j,score,FG[j],BG[j]);
                   else fprintf(stderr,"%d (%.3f)\n",j,score);
#endif
		// BooLean AddBestColumn(double best_map,Int4 j,sst_typ *sstJ);
		if(i >= SeedPttrnLen){ while(!emptyHeap(dH)) delminHeap(dH); }
	}

	che[Level]->SetMinNumColumns(MinCol);
	che[Level]->BeQuiet( );
	if(FG) free(FG); if(BG) free(BG); 
	Nildheap(dH);
	// fprintf(stderr,"%d: %s\n",Level,tmp_str);
	free(sst_Best);
	return AllocString(tmp_str);
}

void	cmc_typ::PartitionSingleSeedAlnCMSA(Int4 NumSeedAln, cma_typ *seed_cma,
		char *TypeOfSet)
// Partition the alignment cma based on sequence scores against a single seed cma file.
{
	assert(NumSeedAln == 1);
#if 0	// this is done in the calling environment...
	// 1. Create the Main alignment by adding in Random sequences.
	cma_typ TmpCMA[3]; TmpCMA[1]=TrueMainCMA;
	FILE *tfp = tmpfile(); // open_file(infile,"_part.mma","w");
	PutRandomCMA(tfp,blosum62freq,LengthCMSA(1,TrueMainCMA),NumRandom,AB);
	rewind(tfp); TmpCMA[2]=ReadCMSA(tfp,AB); fclose(tfp);
  	tfp = tmpfile(); PutMergedCMSA(tfp,2,TmpCMA);
	TotalNilCMSA(TmpCMA[2]); // destroy the temporary Random sequence alignment.
	rewind(tfp); MainCMA=ReadCMSA(tfp,AB); fclose(tfp);
#endif

        Int4    i,j,n,s,I,J,N=NumSeqsCMSA(MainCMA),M=NumSeqsCMSA(TrueMainCMA);
	BooLean	*skip=0;
	FILE	*ofp=0;

	// 2. Create set representation for partitions...
	for(i=1; i <= NumSeedAln; i++){ InitSet[i] = MakeSet(N+1); ClearSet(InitSet[i]); }
	InitSet[i] = MakeSet(N+1); ClearSet(InitSet[i]);  // One more For Random Sequence set
	InitSet[0]=InitSet[i]; 	// Let 0 point to Random sequence set as well

	cma_typ *SeedCMA;
	NEW(SeedCMA, NumSeedAln +3, cma_typ);
	dh_type dH = dheap(N+3,4);
	for(i=1; i <= NumSeedAln; i++){ SeedCMA[i] = AddConsensusCMSA(seed_cma[i]); }
#if 1
	if(ofp){
	  fprintf(stdout,"   ");
	   for(j=1; j <= NumSeedAln; j++) fprintf(stdout," %5d",j); fprintf(stdout,"\n");
	}
	Int4 *MinScoreNonID;
	NEW(MinScoreNonID,NumSeedAln+3,Int4);
	for(i=1; i <= NumSeedAln; i++){
	  e_type Ei=FakeSeqCMSA(1,SeedCMA[i]);
	  if(ofp) fprintf(stdout,"%2d: ",i);
	  MinScoreNonID[i]=INT_MIN;
	  assert(MinScoreNonID[i] < 0);
	  for(j=1; j <= NumSeedAln; j++){
	     e_type Ej=FakeSeqCMSA(1,SeedCMA[j]);
	     assert(LenSeq(Ei) == LenSeq(Ej));
	     Int4 score=0;
	     for(s=1; s <= LenSeq(Ej); s++){
		unsigned char ri=ResSeq(s,Ei);
		unsigned char rj=ResSeq(s,Ej);
		score += valAlphaR(ri,rj,AB);
	     } if(ofp) fprintf(stdout,"%5d ",score);
	     if(i != j && TypeOfSet[j] != '?' && score > MinScoreNonID[i]) MinScoreNonID[i]=score;
	  } if(ofp) fprintf(stdout," %s%c\n",NameCMSA(SeedCMA[i]),TypeOfSet[i]);
	}
	if(ofp){
	  fprintf(stdout,"---");
	  for(j=1; j <= NumSeedAln; j++) fprintf(stdout,"------",j); fprintf(stdout,"\n");
	  fprintf(stdout,"   ");
	  for(j=1; j <= NumSeedAln; j++) fprintf(stdout," %5d",MinScoreNonID[j]);
	fprintf(stdout,"\n");
	}
#endif
	h_type HG=Histogram("partitions", 0,NumSeedAln,1.0);
	h_type sHG=Histogram("best scores", -100,5000,25.0);
	for(J=1; J <= M; J++){
	   Int4 BestScore = -99999999,BestN=0;
	   for(n=1; n <= NumSeedAln; n++){
		Int4 Score=PseudoAlnScoreTwoCMSA(1,SeedCMA[n],J,TrueMainCMA);
		if((TypeOfSet[n] == '?')){
		    if(Score > BestScore){ BestScore=Score; BestN=n; }
		} else if(Score >= MinScoreNonID[n] && Score > BestScore){
			BestScore=Score; BestN=n; 
		}
	   }
	   if(BestN == 0){
		print_error("Hyperpartition lacks a miscellaneous set (indicator: '?')");
	   	// assert(BestN != 0);
	   }
	   if(BestScore > 0) insrtHeap(J,-(keytyp)BestScore,dH);
	   else AddSet(J,InitSet[0]);       		// then add to random Set.
	   IncdHist((double)BestN,HG);
	   IncdHist((double)BestScore,sHG);
// Int4    RtnHistArray(double **xval, double **yval, Int4 *Total, h_type H)
//	xval = bin value; yval = number in bin.
	}
        if(efp) PutHist(stdout,50,HG);
        // if(efp) PutHist(stdout,50,sHG);
        PutHist(stdout,50,sHG);
	NilHist(sHG); NilHist(HG); 

	HG=Histogram("partitions", 0,NumSeedAln,1.0);
	// changed for Single seed_cma
	// Int4 Cnt=0,Limit=(Int4) ceil(2.0*(double)M/3.0);
	Int4 Cnt=0,Limit=(Int4) ceil(1.0*(double)M/3.0);
	// for(n=1; n <= NumSeedAln; n++) // old ...
	for( ; (J=delminHeap(dH)) != 0; Cnt++) {	// put 2/3rds of seqs. in FG.
	   if(Cnt <= Limit) AddSet(J,InitSet[1]); 	// Set representation.
	   else AddSet(J,InitSet[0]);       		// Random Set.
        }
	// assert(Cnt > 0);	// if none get put in will not work...
	if(0 && Cnt <= 0){
		fprintf(stderr,"Partition initialization failed (seed alignment: '%s')\n",
			NameCMSA(seed_cma[n]));
		fprintf(stderr,"input alignment lacks sequences matching this seed alignment\n");
		print_error(" Try modifying the hyperpartition and/or seed alignment.");
	}
	Nildheap(dH);
	for(J=M+1; J <= N; J++) AddSet(J,InitSet[0]); 	// Random Set.
        if(efp) PutHist(stdout,50,HG);
	NilHist(HG); free(MinScoreNonID);
	for(i=1; i <= NumSeedAln; i++){ TotalNilCMSA(SeedCMA[i]); }
	InitSet[0]=0;
	return;
}


