/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cmc_typ.h"

cma_typ cmc_typ::RtnCsqAsCMSA(Int4 n, char *name,sst_typ *xsst)
// return the consensus sequence corresponding to the FG for column n.
// if(xsst != 0) then redefine incompatible sets at pattern positions to match keyE.
{
        // UpdateCSQ( );        // Obtain a csq that best corresponds to current partitioning.
        unsigned char r;
        e_type  keyE=che[n]->KeyE( );
        FILE *fp=tmpfile();
        fprintf(fp,"[0_(1)=%s(1){go=10000,gx=2000,pn=1000.0,lf=0,rf=0}:\n",name);
        fprintf(fp,"(%d)",LenSeq(keyE));
        for(Int4 i=1; i <= LenSeq(keyE); i++) fprintf(fp,"*");
        fprintf(fp,"\n\n$1=%d(%d):\n",LenSeq(keyE),LenSeq(keyE));
        fprintf(fp,">%s consensus\n{()",name);
        for(Int4 i=1; i <= LenSeq(keyE); i++){
            r=ResSeq(i,keyE);
            if(xsst && xsst[i]){ if(!MemSset(r,xsst[i])){ xsst[i] = SsetLet(r); } }
            fprintf(fp,"%c",AlphaChar(r,AB));
        } fprintf(fp,"()}*\n\n_0].\n"); rewind(fp);
        cma_typ cma=ReadCMSA(fp,AB); fclose(fp);
        return cma;
}

set_typ *cmc_typ::CopyOfBestTreeSets( )
// Return significant sets only...
{
        Int4    g;
        if(!DidRestoreBest) RestoreBest();
        // assert(DidRestoreBest);
        assert(IsTreeHpt);
        assert((Hpt->NumSets()-1) == Hpt->NumBPPS());
        CalcTotalLPR(0,FALSE);  // Calculates all Map[n].
        //  fprintf(outfp,"============ Best FD-table ============\n");
        // PutHyperPartition(outfp); fflush(outfp);
        // PutHyperPartition( );
        set_typ *RtnSet; NEW(RtnSet,Hpt->NumSets()+2,set_typ);
        for(g=1; g<= Hpt->NumSets(); g++){
           RtnSet[g]=MakeSet(SetN(BestSet[g])); ClearSet(RtnSet[g]);
           CopySet(RtnSet[g],BestSet[g]);  // copies BestSet[g] to RtnSet[g].
        } return RtnSet;
}

set_typ	*cmc_typ::CopyOfPartitionSets()
{
	// Copy and return each partition set within the hpt.
	Int4	c,r,g;
  	assert(DidRestoreBest);
	set_typ *RtnSet; NEW(RtnSet,Hpt->NumBPPS()+2,set_typ);
	set_typ Set=MakeSet(SetN(BestSet[1]));
	for(c=1; c<= Hpt->NumBPPS(); c++){
	   ClearSet(Set);
	   for(r=1; r<= Hpt->NumSets(); r++){
	     if(Hpt->RtnHyperPartition(r,c) == '+'){ UnionSet(Set,BestSet[r]); }
	   }
	   if(CardSet(Set) > 0){ RtnSet[c]=CopySet(Set);  }
	}  NilSet(Set);
	return RtnSet;
}

cmc_typ	*cmc_typ::OptimizeDisplaySet(hsw_typ HSW,Int4 argc, char *argv[])
// Create a new cmc_typ with SMA sequences optimally defined given the current state.
{
     Int4     i,j,r,N,n,sq,*P=0,Argc;
     cma_typ  *in_sma,cma=TrueMainCMA;
     cmc_typ  *rtn_cmc;  
     set_typ  *set,*InSets,*in_set;
     char     *tmp[3],**Argv;

     this->RestoreBest();
     if(Hpt->IsTree(P)){ this->IsTreeHpt=TRUE; free(P);} else { if(P) free(P); return 0; }
     // Int4 num_failed=this->RemoveFailed( );
     // nLPR=CalcTotalLPR(0,FALSE);
     // fprintf(stderr,"%d failed nodes\n",num_failed);
#if 1	// Skip hierarchies with failed nodes. (Have curators edit Hpt and rerun?)
     for(n=0,i=1; i <= Hpt->NumBPPS(); i++){
	if(IsFailedBPPS[i] || IsFailedSet[i]) n++;
        // fprintf(stderr,"%d: failed = %d %d; Map=%.2f\n", i,IsFailedBPPS[i],IsFailedSet[i],Map[i]);
     } if(n > 0) return 0;
#endif

     // this->PutHyperPartition(stderr);
     set=this->CopyOfBestTreeSets(); // return significant nodes...
#if 0
     num_failed=this->RemoveFailed( );
     fprintf(stderr,"%d failed nodes\n",num_failed);
     for(i=1; i <= Hpt->NumBPPS(); i++){
        fprintf(stderr,"%d: failed = %d %d; Map=%.2f\n",
			i,IsFailedBPPS[i],IsFailedSet[i],Map[i]);
     }
#endif

     // 1. Get sequence sets & patterns.
     // hpt_typ *hpt=Hpt->Copy(); assert(Hpt->NumBPPS() == hpt->NumBPPS());
     // this->PutSARPHpt(stderr);
     hpt_typ *hpt=this->MkSARPHpt(); // assert(Hpt->NumBPPS() == (hpt->NumBPPS() + num_failed));
     // hpt_typ *hpt=InitHpt->Copy();
     // char **pttrn= this->RtnCopyOfPttrns( );
     sst_typ **xsst=this->RtnCopyOfSSTs();
     NEW(in_sma, hpt->NumBPPS()+3, cma_typ);
     N = NumSeqsCMSA(TrueMainCMA);
FILE *sfp=open_file(argv[1],".sma","w");
     for(i=1; i <= hpt->NumBPPS(); i++){
	 cma_typ tmp_sma[4]; 
	 tmp_sma[1]=this->RtnCsqAsCMSA(i,hpt->ElmntSetName(i),xsst[i]);  
	 // ^ redefines Csq-incompatible xsst[i].
	 // if(i==13) PutCMSA(stderr,tmp_sma[1]);
	 char *pttrn=SST2ArgStrAlpha(xsst[i],this->RtnLengthMainCMSA(),AB);
	 if(pttrn){ tmp[0]=pttrn; hpt->ReSetArgv(i,1,tmp); free(pttrn); }
	 if(xsst[i]) free(xsst[i]);
// fprintf(stderr,"%d: %s\n",i,pttrn[i]); 
	 // if(pttrn[i]){ tmp[0]=pttrn[i]; hpt->ReSetArgv(i,1,tmp); free(pttrn[i]); }

	 FILE *fp=0;
	 Int4 card=CardSet(set[i]);
	 if(card > 0){	
	   fp=tmpfile(); PutInSetCMSA(fp,set[i],cma);  // if only one sequence stop here.
	   if(card > 1){	// PutBestRepsCMSA() requires at least two sequences.
		rewind(fp); cma_typ setcma=ReadCMSA(fp,AB); fclose(fp); fp=tmpfile();
		PutBestRepsCMSA(fp,10,TRUE,setcma,TRUE,tmp_sma[1]); TotalNilCMSA(setcma);
	   } rewind(fp); tmp_sma[2]=ReadCMSA(fp,AB); fclose(fp);
	   fp=tmpfile(); PutMergedCMSA(fp,2,tmp_sma); 
	   rewind(fp); in_sma[i] = ReadCMSA(fp,AB); fclose(fp); fp=0;
	   TotalNilCMSA(tmp_sma[1]); TotalNilCMSA(tmp_sma[2]);
	   RenameCMSA(hpt->ElmntSetName(i),in_sma[i]); 
	 } else { in_sma[i] = tmp_sma[1]; }
PutCMSA(sfp,in_sma[i]);
     } // hpt->Put(stderr); 
// fprintf(stderr,"\n\n");
     free(xsst);
     // free(pttrn);
fclose(sfp);
     // hpt->Put(stderr,FALSE);
     // Put rejected sequences into main set.
     Int4 NumSets=this->Hpt->NumSets(); // assert(NumSets == hpt->NumSets());
     set[0]=set[NumSets];   // pass in set[NumSets] == RandomSet; will be recognized.
    
     NEWP(Argv, argc + 10, char);
     for(Argc=0, i=0; i < argc; i++){ Argv[i]=AllocString(argv[i]); Argc++; }
     // Argv[Argc] = AllocString("-nocsq"); Argc++;    // Use the consensus sequences provided!
     Argv[Argc] = AllocString("-tree"); Argc++;

     rtn_cmc=new cmc_typ(TrueMainCMA,MainCMA,HSW,hpt->NumSets(),set,hpt,in_sma,Argc,Argv);
     for(i=0; i < Argc; i++){ free(Argv[i]); } free(Argv);

     free(in_sma); free(set); rtn_cmc->IsTreeHpt=TRUE;
     rtn_cmc->SaveBest=TRUE;       // Start saving the best configuration immediately.
     rtn_cmc->StoreBest();       // Start saving the best configuration immediately.
     rtn_cmc->RestoreBest();       // Start saving the best configuration immediately.
// this->PutHyperPartition(stderr);
// rtn_cmc->PutHyperPartition(stderr); // exit(1);
     assert(this->TheSame(rtn_cmc));
     return rtn_cmc;
}


char    **cmc_typ::RtnCopyOfPttrns( )
{
        sst_typ **xsst=this->RtnCopyOfSSTs();
        char    **pttrn; NEWP(pttrn,Hpt->NumBPPS()+3,char);
        Int4    i;
        for(i=1; i <= Hpt->NumBPPS(); i++){
	   if(xsst[i]) pttrn[i]=SST2ArgStrAlpha(xsst[i],this->RtnLengthMainCMSA(),AB);
        } for(i=1; i <= Hpt->NumBPPS(); i++){ free(xsst[i]); } free(xsst);
        return pttrn;
}

BooLean	cmc_typ::ChecksOut()
// check to see whether anything worthwhile was found.
{
	// new routine for defining previously identified sets.
	if(DidRestoreBest == FALSE) return FALSE;
	Int4	n,g;
	for(n=0,g=1; g<= Hpt->NumSets(); g++){
		if(Hpt->TypeOfSet(g) != '?' && g != RandomSet && CardSet(BestSet[g]) > 0) n++;
	} if(n > 0) return TRUE; else return FALSE;
}

set_typ	cmc_typ::CopyOfSeedSets()
{
	set_typ RtnSet;
	Int4	g;
	assert(DidRestoreBest);
	RtnSet=MakeSet(SetN(BestSet[1])); ClearSet(RtnSet); 
	for(g=1; g<= Hpt->NumSets(); g++){
		if(Hpt->TypeOfSet(g) && g != RandomSet) UnionSet(RtnSet,BestSet[g]);
	} return RtnSet;
}

hpt_typ	*cmc_typ::MkSARPHpt(){
	Int4 x;
	for(x= 1; x <= Hpt->NumSets(); x++){
		if(IsFailedSet[x]) Hpt->DeleteRow(x); 
	}
	for(Int4 x= 1; x <= Hpt->NumBPPS(); x++){
		if(IsFailedBPPS[x]) Hpt->DeleteBPPS(x);
	} return Hpt->Copy(); 
}

void	cmc_typ::PutSARPHpt(FILE *fp){
	Int4 x;
	for(x= 1; x <= Hpt->NumSets(); x++){
		if(IsFailedSet[x]) Hpt->DeleteRow(x); 
	}
	for(Int4 x= 1; x <= Hpt->NumBPPS(); x++){
		if(IsFailedBPPS[x]) Hpt->DeleteBPPS(x);
	} Hpt->Put(fp,FALSE,TRUE); 
}

void	cmc_typ::TransferAllSeqs(Int4 from, Int4 to)
{
	if(from == to) return;
	assert(from > 1 && from < Hpt->NumSets() && to > 0 && to <= Hpt->NumSets());
	Int4 n,sq,num_sq = NumSeqsCMSA(MainCMA);
	char **HP=HyperPartition;
	for(sq=1; sq <= num_sq; sq++){
	     if(MemberSet(sq,GrpSet[from])) {
		if(MemberSet(sq,Labeled)){ DeleteSet(sq,Labeled); } 
		// ^ remove these from Untouchable set.
		DeleteSet(sq,GrpSet[from]); AddSet(sq,GrpSet[to]);
		for(n=1; n<= Hpt->NumBPPS(); n++){ che[n]->SetPartition(HP[to][n],sq); }
	     }
	}
}

set_typ	*cmc_typ::CopyOfSeqSets_Private()
{
	set_typ *RtnSet;
	Int4	i,g;
  	assert(DidRestoreBest);
	NEW(RtnSet,Hpt->NumSets()+2,set_typ);
	for(g=1,i=0; g <= Hpt->NumSets(); g++){
	   if(IsFailedSet[g]) continue; else i++;
	   if(CardSet(BestSet[g]) > 0){
		RtnSet[i]=MakeSet(SetN(BestSet[g])); ClearSet(RtnSet[i]); 
		CopySet(RtnSet[i],BestSet[g]);  // copies BestSet[g] to RtnSet[i].
	   } 
	} return RtnSet;
}

#if 1
// make a constructor that can read such input files...
// use *.amc file suffix convention

Int4	cmc_typ::ReadPttrnSets(FILE *fp,set_typ *&set, sst_typ **&sst, Int4 &Len)
{
	Int4    k,i,N,rtn;
	rtn=fread(&N,sizeof(Int4),1,fp);
	if(rtn != 1) return 0;
	rtn=fread(&Len,sizeof(Int4),1,fp);
	if(rtn != 1) print_error("ReadPttrnSets() input error 1");
	NEW(set,N+3,set_typ); NEWP(sst,N+3,sst_typ);
	for(i=1; i <= N; i++){
	   set[i]=ReadSet(fp);
	   NEW(sst[i],Len+4,sst_typ);
	   rtn=fread(sst[i],sizeof(sst_typ),Len+2,fp); 
	   if(rtn != Len+2) print_error("ReadPttrnSets() input error 2");
	} return N;
}

void	cmc_typ::WritePttrnSets(FILE *fp)
// Writes files to <infile>.amc for passage to scc_typ.
{
	Int4	i,g,rtn,N,Len;
  	assert(DidRestoreBest);
	for(N=0,i=1; i < Hpt->NumSets(); i++){
	   if(!IsFailedSet[i] && CardSet(BestSet[i]) > 0) N++;
	} Len=LengthCMSA(1,MainCMA);
	rtn=fwrite(&N,sizeof(Int4),1,fp);
        if(rtn != 1) seterror("WritePttrnSets() error 1");
	rtn=fwrite(&Len,sizeof(Int4),1,fp);
        if(rtn != 1) seterror("WritePttrnSets() error 2");
	for(g=1,i=0; g < Hpt->NumSets(); g++){
	   if(IsFailedSet[g]) continue; 
	   if(CardSet(BestSet[g]) > 0){
		i++; WriteSet(fp,BestSet[g]); 
	        if(g <= Hpt->NumBPPS()){
		  bpps_typ *bpps=che[g]->BPPS();
		  sst_typ *tmpsst=bpps->RtnSST();
		  Int4 k=bpps->LenPattern( ); assert(k == Len);
		  rtn=fwrite(tmpsst,sizeof(sst_typ),k+2,fp);
        	  if(rtn != k+2) print_error("WritePttrnSets() input error 3");
		}
	   }
	} assert(i == N);
}
#endif

sst_typ	**cmc_typ::RtnCopyOfSSTs( )
// to be called after sampling is completed.
{
	Int4 n,i,j;
	sst_typ **sst;
	
	assert(DidRestoreBest);
	NEWP(sst,Hpt->NumBPPS()+3,sst_typ);
	for(n=1; n<= Hpt->NumBPPS(); n++){
		bpps_typ *bpps=che[n]->BPPS();
		sst_typ *tmpsst=bpps->RtnSST();
		Int4 k=bpps->LenPattern( );
		NEW(sst[n],k+3,sst_typ);
		for(i=1; i <= k; i++) sst[n][i]=tmpsst[i];
	} return sst;
}

double  **cmc_typ::RtnCopyOfLPRs( )
// to be called after sampling is completed.
{
	  Int4 n,i;

	  assert(DidRestoreBest);
	  double total,**lpr; NEWP(lpr,Hpt->NumBPPS()+3,double);
	  for(total=0.0, n=1; n<= Hpt->NumBPPS(); n++){
		double *tmplpr=che[n]->SubMap( ); 
		Int4 k=che[n]->LengthPattern();
		NEW(lpr[n],k+3,double);
		for(i=0; i <= k; i++) lpr[n][i]=tmplpr[i];
		// lpr[n][0] = total lpr.
	  } return lpr;
}

