/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cmc_typ.h"
#include "blosum62.h"

#if 0
#define WEIGHT_RANDOM_SEQUENCES_MANUALLY 0	// look at Junk/cmp_typ3_14_11.cc if want to add this...
#define DISTINCT_TRIPARTITION_NULL_MODEL 0	// look at Junk/cmp_typ3_14_11.cc if want to add this...

#endif

void	cmc_typ::GetSeedAlns()
{
	char      str[2003],*strp;
	Int4      line,i,j;
	FILE *tfp = 0;

	if(checkpoint){ // new afn 8/25/2022.
	  // already set to DisplayCMA;
	} else if(passed_in_sma){ // new afn 11/2/12.
          // DisplayCMA=passed_in_sma;
          NumDisplayCMA=num_passed_in_sma;
          NEW(DisplayCMA,NumDisplayCMA +3, cma_typ);
          for(i=0; i <= NumDisplayCMA; i++) DisplayCMA[i]=passed_in_sma[i];
        } else {
          tfp = open_file(infile,".sma","r");
          DisplayCMA=MultiReadCMSA(tfp,&NumDisplayCMA,0,AB); fclose(tfp); tfp=0;
        }
	if(efp) fprintf(efp,"%d alignments in %s.sma\n",NumDisplayCMA,infile);

	// 1. Discard unused display CMA files && reorder consistent with Hyperpartition.
	Int4	NumFound=0;
	BooLean *found;
	cma_typ *DisplayCMA2; NEW(DisplayCMA2,Hpt->NumSets()+ 2, cma_typ);
	NEW(found,Hpt->NumSets() + 2, BooLean);
	for(i=1; i <= NumDisplayCMA; i++){
	   char *NameDisplay = NameCMSA(DisplayCMA[i]);
	   for(j=1; j <= Hpt->NumSets(); j++){	// includes Random?
		char *NameSet=Hpt->ElmntSetName(j);
		if(strcmp(NameDisplay,NameSet) == 0){
			if(found[j]){
				fprintf(stderr,"--> \"%s\" == \"%s\"\n",NameDisplay,NameSet);
				print_error("Fatal: duplicate name in *sma or *hpt file");
			} found[j]=TRUE;  NumFound++;
			DisplayCMA2[j]=DisplayCMA[i]; DisplayCMA[i]=0;
		}
	   } if(DisplayCMA[i] != 0){ TotalNilCMSA(DisplayCMA[i]); DisplayCMA[i]=0; }
	}
	if(NumFound != (Hpt->NumSets()-1)){
	   fprintf(stderr,"NumFound = %d; Hpt->NumSets( ) = %d\n",
			NumFound,Hpt->NumSets());
	   for(j=1; j <= Hpt->NumSets(); j++){     // includes Random.
             if(!found[j]) fprintf(stderr,"Not in sma file: \"%s\"\n",Hpt->ElmntSetName(j));
           } print_error("*.sma and *.hpt files are inconsistent");
	} free(found); 
#if 0
        for(i=1; i <= Hpt->NumSets(); i++){     // original array will be freed elsewhere.
            DisplayCMA[i]=DisplayCMA2[i]; // keep the original array; free DisplayCMA2.
        } free(DisplayCMA2);
#else
	free(DisplayCMA); DisplayCMA=DisplayCMA2; 
#endif
	NumDisplayCMA=NumFound;       // reset due to discarded files.
	if(passed_in_sets && checkpoint){
	   print_error("-rchkpt option disallowed when passing in sets");
	}
	if(efp) fprintf(efp,"levels = %d\n",Hpt->NumBPPS());
}

void	cmc_typ::GetMainCMA( )
//****** 1. Create the Main alignment by adding in Random sequences. ******
{
   if(checkpoint){
	MainCMA=checkpoint->main_cma;
	num_passed_in_sets=checkpoint->num_sets;
	passed_in_sets=checkpoint->set;
   } else {	// implies that passed_in_cma != 0 && passed_in_sets != 0
	if(passed_in_mcma) MainCMA=passed_in_mcma;
	else {   // Then create a Main alignment by adding in Random sequences.
	   MainCMA=AddRandomCMSA(TrueMainCMA,NumRandom);
	} 
   } SetSize=NumSeqsCMSA(MainCMA)+1;
}

void    cmc_typ::InitAsNull( )
{
        Iteration=0;
        MaxNumCol=0; SFBG=0;
	this->SetsMode=0;
        //======== Strings: ========
        program_name=0; // what program is calling this object?
	infile=0;
        RelateFGs=0; RelateBGs=0;
        //======== file pointers ========
        outfp=0;
        efp=0; // efp=stderr;
        //======== Sets: ========
        Labeled=0; SetFG=0; SetBG=0;
	PttrnPos=0;
        //======== CMAs: ========
        MainCMA=0; dummyCMA=0; TrueMainCMA=0; QryCMAs=0;
        //======== Other objects =======
        MainHSW=0; SetSize=0;
	sqd=0; che=0; SST=0; chn=0;
        // initialize static arrays to zero to avoid core dumps
	InitHpt=0; BestHpt=0; 
        for(Int4 g=0; g < MAX_NUM_ELMENTARY_SETS; g++){
                SeedCMA[g] =0; MinSeed2CsqScore[g]=0; sst_str[g]=0; 
                IsFailedSet[g]=0; IsFailedBPPS[g]=0;
                InitSet[g]=0; SubLPR[g]=0; Map[g]=0;
                WorstToBest[g]=0;  Index1stBest[g]=0; GrpSet[g]=0;
		BestSet[g]=0; best_sst[g]=0;
		IsFailedBestSet[g]=0; IsFailedBestBPPS[g]=0;

                // borrowed from Hpt.
		HyperPartition[g]=0;
	}
}

void    cmc_typ::InitDefaults( )
// -N=20 -col=30:50 -A=48:2 -Am=40:10 -Ri=0.03 -Rim=0.4 -rho=0.003 -ppb=100 -tree -sets
{
        GlobalA0=48.0; GlobalB0=2.0; GlobalRi=0.01; RejectRi=0.5;
        MiscGlobalA0=42.0; MiscGlobalB0=8.0; MiscGlobalRi=0.01;
	DefaultMaxCol=25; DefaultMinCol=5;
        // Global_rho=0.00001;
        Global_rho=0.0001;
        ppb_increase=100000;
        // SeedPttrnLen=15;
        SeedPttrnLen=25;
        MinTemperature=50.0;
        temperature=300;
        // temperature=600;
        PutIntermediateFiles=FALSE;
        GlobalN=25;      // contrast setting.
	PruneIter=3;
	NumberRounds=3;
	MaximumIter=2;
	fixed_cutoff=0;
}

void    cmc_typ::InitFlags( )
{
        SemiConvergedState=0;
        DidRestoreBest=FALSE;
        SaveSets=FALSE;
        NoSeeds=FALSE;
        IsTreeHpt=FALSE;
	NoFailureMode=FALSE;
        IsTreePMC=FALSE;
        ShowIndels=FALSE;
}

char	cmc_typ::GetSetsMode(Int4 r)
// return the sets mode for row 'r' based on the Hpt pattern.
{
	Int4	i,j,n,x;
	FILE	*efp=0; // efp=stderr;
	rst_typ	*rst[9];
#if 0
	char	mode=' ',modes[]=" MLGR ";	// 'M' mode is non-symmetric.
#else
	char	mode=' ',modes[]=" LGR ";
#endif
	for(j=1; isupper(modes[j]); j++){
	  rst[j]=new rst_typ(modes[j],AB);
	} rst[j]=0;
	BooLean	pass[10];
	for(i=0; i < 9; i++) pass[i]=TRUE;
	assert(r > 0 && r <= Hpt->NumBPPS());
	// char	*sst_str=Hpt->RtnPttrn(r);
	char    **Arg=Hpt->Argv(r),*S,res[32]; 
	BooLean	okay; // efp=stderr;
	for(i=0; i < Hpt->nArg(r); i++){
	   S=strstr(Arg[i],"-P="); 
	   if(S != 0){ // efp=stderr;
	    S+=3; // char *ptr=(char *)rawmemchr(S,'\0');
	    if(efp) fprintf(efp,"%d ==> '%s'\n",i,S);
	    for(okay=TRUE,n=1; okay; n++){
#if 1
	     j=std::sscanf((const char*)S,
		"%20[ABCDEFGHIJKLMNOPQRSTUVWXYZ]%8ld%*[,\0]", res,&x);
#else
	     char Str[30];
	     for(j=0; isalnum(S[j]); j++) Str[j]=S[j]; Str[j]='\0';
	     j=std::sscanf(Str,"%20[ABCDEFGHIJKLMNOPQRSTUVWXYZ]%8ld%*[,\0]", res,&x);
#endif
	     assert(j==2);
	     sst_typ usst,zsst,xsst;
	     for(j=0,usst=0; res[j]; j++){
	        zsst=SsetLet(AlphaCode(res[j],AB));
		usst=UnionSset(zsst,usst);
	     }
	     char *pttrn=GetPatternFromSST(usst,AB);
	     assert(x > 0 && x <= LengthCMSA(1,TrueMainCMA));
	     AddSet(x,PttrnPos[r]);
	     if(efp) fprintf(efp,"arg(%d.%d) = '%s' =? '%s%d'\n",r,n,res,pttrn,x); 
	     for(j=1; isupper(modes[j]); j++){
	       if(!rst[j]->IsLegalSet(usst)){
		   if(efp) fprintf(efp,"    illegal (%c)\n",modes[j]); pass[j]=FALSE;
	       }
	     } free(pttrn);
	  
	     while(S[0] != ','){ S++; if(S[0] == 0){ okay=FALSE; break; } }
	     if(okay){
	        // sscanf(S,",%[A-Z]%d",res,&x); fprintf(stderr,"  next pttrn='%s'\n",res); 
		S++;
	     }
	    }
	   }
	}
	for(j=1; isupper(modes[j]); j++){
	    if(pass[j]){
		if(efp) fprintf(efp,"%c mode is okay\n",modes[j]);
		if(isspace(mode)) mode=modes[j];
	    } else if(efp) fprintf(efp,"%c mode failed \n",modes[j]);
	}
	if(isspace(mode)){ if(r==1) mode='R'; else mode='G'; }
	if(efp) fprintf(stderr,"%d. rst mode = '%c'\n",r,mode);
	for(j=1; rst[j]; j++) delete rst[j];
	return mode;
}


void	cmc_typ::Init(Int4 argc, char *argv[])
{
	Int4	m,n,i,j,f,g,b,r,s,x;
	Iteration=0;
	checkpoint=0;   // recover checkpoint...
	InitAsNull(); InitFlags(); InitDefaults( );
	if(AB==0){
	   AB=MkAlphabet(AMINO_ACIDS,GBLAST_BLOSUM62,SREL26_BLSM62); ownAB=TRUE;
	} else ownAB=FALSE;
	ReadMainArg(argc, argv);
	if(checkpoint && checkpoint->hpt) Hpt=checkpoint->hpt;
	else if(passed_in_hpt) Hpt=passed_in_hpt;
	else Hpt = new hpt_typ(infile);	// create Arg file typ for output...
	InitHpt=Hpt; Hpt=InitHpt->Copy();
// efp=stderr;
	if(efp) Hpt->Put(efp);
	// if(efp) Hpt->PutHyperPartition(efp);
#if 1
	Int4 *P;
	this->IsTreeHpt=Hpt->IsTree(P); if(P) free(P);
	if(efp){ fprintf(stderr,"IsTreeHpt=%d\n",this->IsTreeHpt); Hpt->Put(stderr); }
// exit(1);
#endif

	if(passed_in_cma != 0){ TrueMainCMA = passed_in_cma; }
	else {
	  FILE *tfp = open_file(infile,".mma","r");
	  TrueMainCMA = ReadCMSA(tfp,AB); fclose(tfp);
	} 
#if 1	// find the settings for sst_typ.
	NEW(this->SetsMode, Hpt->NumBPPS() +3, char);
	NEW(this->PttrnPos, Hpt->NumBPPS() +3, set_typ);
	for(n=1; n <= Hpt->NumBPPS(); n++){ 
		PttrnPos[n]=MakeSet(LengthCMSA(1,TrueMainCMA)+3);
		ClearSet(PttrnPos[n]);
		this->SetsMode[n]=this->GetSetsMode(n);
		// if(n >= Hpt->NumBPPS()){ Hpt->Put(stderr); exit(1); }
	}
#endif
// TotalNilCMSA(TrueMainCMA); NilAlpha(AB); exit(1);
	// NumRandom=Hpt->NumberRandom(); if(NumRandom==0) NumRandom=5000;
	NumRandom=1+(NumSeqsCMSA(TrueMainCMA)/3); 
	Hpt->ChangeNumRandom(NumRandom);
	if(efp) Hpt->PutHyperPartition(efp);

	// 2. Read in arguments and seed pattern strings for each run in <infile>.hpt
	GetSeedAlns();
	GetMainCMA();
	this->FillUpHpt( );
} 

