/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cmc_typ.h"

set_typ	cmc_typ::DiffSets(set_typ set1, set_typ set2, set_typ setI, set_typ setJ)
{
	IntersectNotSet(set1,set2,setI); // setI = set1 intersect not set2
	IntersectNotSet(set2,set1,setJ);
	UnionSet(setI,setJ);	// setI = setI U setJ.
	return setI;
}

BooLean	cmc_typ::TheSame(cmc_typ *cmc2)
{
   Int4 i,j,k,x,y,z,ok;
   for(i=1; i<=Hpt->NumBPPS(); i++){
	assert(this->che[i]); assert(cmc2->che[i]); 
	if(! this->che[i]->TheSamePattern(cmc2->che[i])){
	    sst_typ **xsst=this->RtnCopyOfSSTs();
	    sst_typ **ysst=cmc2->RtnCopyOfSSTs();
	    char *pttrnX=SST2ArgStrAlpha(xsst[i],this->RtnLengthMainCMSA(),AB);
	    char *pttrnY=SST2ArgStrAlpha(ysst[i],cmc2->RtnLengthMainCMSA(),AB);
	    fprintf(stderr,"%d(this): %s\n",i,pttrnX);
	    fprintf(stderr,"%d(other): %s\n",i,pttrnY);
	    assert(this->che[i]->TheSamePattern(cmc2->che[i]));
	}
	assert(this->che[i]->TheSameWeights(cmc2->che[i]));
	// if(this->che[i]->TheSameSets(cmc2->che[i]) != TRUE){
	if(this->che[i]->TheSame(cmc2->che[i]) != TRUE){
	   Int4 m=0,n=SetN(this->che[i]->RtnFG_Set());
	   set_typ setI=MakeSet(n),setJ=MakeSet(n),setK=MakeSet(n); 
	   set_typ label1=this->Labeled,label2=cmc2->Labeled;
   	   if(m==0) {
	     ok=TRUE; fprintf(stderr,"checking for seq. set overlap...\n");
	     for(j=1; j < Hpt->NumSets(); j++){
		set_typ tG,G1=this->GrpSet[j],G2=cmc2->GrpSet[j];
   	        for(k=j+1; k<=Hpt->NumSets(); k++){
		    tG=this->GrpSet[k]; x=CardInterSet(G1,tG);
		    if(x > 0){
		  	IntersectSet1(G1,tG,setJ); // modifies setJ to G1 intersect tG 
			fprintf(stderr,"%d & %d(1): ",j,k);
			PutSet(stderr,setJ); ok=FALSE;
		    } tG=cmc2->GrpSet[k]; x=CardInterSet(G2,tG);
		    if(x > 0){
		  	IntersectSet1(G2,tG,setJ); // modifies setJ to G1 intersect tG 
			fprintf(stderr,"%d & %d(2): ",j,k);
			PutSet(stderr,setJ); ok=FALSE;
		    }
		}
	     } if(ok) fprintf(stderr,"no overlap found.\n\n");
	   }
   	   for(j=1; j<=Hpt->NumBPPS(); j++){
		set_typ set1=this->che[j]->RtnFG_Set();
		set_typ set2=cmc2->che[j]->RtnFG_Set();
		set_typ setB1=this->che[j]->RtnBG_Set();
		set_typ setB2=cmc2->che[j]->RtnBG_Set();
		set_typ RmSet1=this->che[j]->RtnRmSet( );
		set_typ RmSet2=cmc2->che[j]->RtnRmSet( );
		set_typ Gold1=this->che[j]->RtnGoldSet( );
		set_typ Gold2=cmc2->che[j]->RtnGoldSet( );

		if(Hpt->TypeOfSet(j) == '!'){
   	   	    for(k=j+1; k<=Hpt->NumBPPS(); k++){
			if(Hpt->TypeOfSet(k) == '!'){
			   set_typ s1=this->che[k]->RtnFG_Set();
			   set_typ s2=cmc2->che[k]->RtnFG_Set();
			   x=CardInterSet(set1,s1);
			   if(x > 0){
				IntersectSet1(set1,s1,setJ); // modifies setJ to G1 intersect tG
                                fprintf(stderr,"FG %d & %d(1; %d seqs): ",j,k,x); PutSet(stderr,setJ);
			   }
			   x=CardInterSet(set2,s2);
			   if(x > 0){
				IntersectSet1(set2,s2,setJ); // modifies setJ to G1 intersect tG
                                fprintf(stderr,"FG %d & %d(2; %d seqs): ",j,k,x); PutSet(stderr,setJ);
			   }
			}
		    }
		}

		fprintf(stderr,"%2d(\"%s\"): labeled & FG = %d/%d vs %d/%d\n",j,Hpt->ElmntSetName(j),
			CardInterSet(label1,set1), CardSet(set1),CardInterSet(label2,set2),CardSet(set2));
		fprintf(stderr,"    labeled & BG = %d/%d vs %d/%d\n",CardInterSet(label1,setB1),
				CardSet(setB1),CardInterSet(label2,setB2),CardSet(setB2));
		fprintf(stderr,"    labeled & Rm = %d/%d vs %d/%d\n\n",CardInterSet(label1,RmSet1),
				CardSet(RmSet1),CardInterSet(label2,RmSet2),CardSet(RmSet2));
	   }

   	   for(j=1; j<=Hpt->NumBPPS(); j++){
		set_typ set1=this->che[j]->RtnFG_Set();
		set_typ set2=cmc2->che[j]->RtnFG_Set();
		set_typ setB1=this->che[j]->RtnBG_Set();
		set_typ setB2=cmc2->che[j]->RtnBG_Set();
		set_typ RmSet1=this->che[j]->RtnRmSet( );
		set_typ RmSet2=cmc2->che[j]->RtnRmSet( );
		set_typ Gold1=this->che[j]->RtnGoldSet( );
		set_typ Gold2=cmc2->che[j]->RtnGoldSet( );

		IntersectNotSet(set1,set2,setI); // setI = set1 intersect not set2
		IntersectNotSet(set2,set1,setJ);
		UnionSet(setI,setJ);	// setI = setI U setJ.

		if(m > 0 || CardSet(setI) > 0){

		  fprintf(stderr,"%d) BestSet vs InitSets:",j);
		  PutSet(stderr,DiffSets(this->BestSet[j],cmc2->InitSet[j],setK,setJ)); 
		  fprintf(stderr,"%d) GrpSets:",j);
		  PutSet(stderr,DiffSets(this->GrpSet[j],cmc2->GrpSet[j],setK,setJ)); 
		  if(CardSet(setK) > 0) fprintf(stderr,"  GrpSet1=%d GrpSet2=%d\n",
			CardSet(this->GrpSet[j]), CardSet(cmc2->GrpSet[j]));

	          if(m==0){
		     fprintf(stderr,"%d: Lbd1=%d; Lbd2=%d;",j,
				CardSet(this->Labeled),CardSet(cmc2->Labeled));
		     fprintf(stderr," Rand1=%d; Rand2=%d\n",this->NumRandom,cmc2->NumRandom);
		  } m++;

		  fprintf(stderr,"%d: FG1=%d; FG2=%d;",j,CardSet(set1),CardSet(set2));
		  PutSet(stderr,setI);
		  if(CardInterSet(Gold1,setI) > 0) fprintf(stderr,"diff in Gold1\n");
		  if(CardInterSet(Gold2,setI) > 0) fprintf(stderr,"diff in Gold2\n");

		  set1=this->che[j]->RtnBG_Set(); set2=cmc2->che[j]->RtnBG_Set();
		  x=CardSet(set1); y=CardSet(set2);
		  fprintf(stderr," BG1=%d; BG2=%d;",x,y);
		  if(x != y){
			PutSet(stderr,DiffSets(set1,set2,setI,setJ)); 
		  	if(CardInterSet(Gold1,setI) > 0) fprintf(stderr,"diff in Gold1\n");
		  	if(CardInterSet(Gold2,setI) > 0) fprintf(stderr,"diff in Gold2\n");
		  }

		  x=CardSet(RmSet1); y=CardSet(RmSet2);
		  fprintf(stderr," RmSet1=%d; RmSet2=%d;",x,y);
		  if(x != y){
			PutSet(stderr,DiffSets(RmSet1,RmSet2,setI,setJ)); 
		  }

		  fprintf(stderr," Gold1=%d; Gold2=%d\n",CardSet(Gold1),CardSet(Gold2));

		  fprintf(stderr," Fg1=%d; Fg2=%d;",
				CardSet(this->SetFG[j]),CardSet(cmc2->SetFG[j]));
		  fprintf(stderr," Bg1=%d; Bg2=%d\n",
				CardSet(this->SetBG[j]),CardSet(cmc2->SetBG[j]));

		  IntersectSet1(Gold2,setI,setJ); // modifies setJ to Gold2 intersect setI */
		  PutSet(stderr,setJ);
		  IntersectSet1(cmc2->Labeled,setI,setJ); PutSet(stderr,setJ);

		  fprintf(stderr," Odd man out: ");
		  PutSet(stderr,setI);
		  for(Int4 sq=1; sq <= NumSeqsCMSA(MainCMA); sq++){
			if(MemberSet(sq,setI)){
				e_type E=TrueSeqCMSA(sq,this->MainCMA);
				PutSeqInfo(stderr,E); fprintf(stderr,"\n---------------------------\n");
			}
		  }
		}

	   } assert(!"cmc->TheSame() failed");
	} // assert(this->che[i]->TheSameCardSet(cmc2->che[i]));
   } return TRUE;
}

BooLean	cmc_typ::ConsistencyCheck()
{
	Int4	i,j,sq;
	set_typ SetI,SetJ,SetU,SetX,SetY,SetRm,FG,BG,Rm,U;
	// SetI=MakeSet(SetSize); SetJ=MakeSet(SetSize); 

	// 1. Make sure that GrpSets are disjoint.
	SetX=MakeSet(SetSize); SetY=0;
	SetU=MakeSet(SetSize); ClearSet(SetU);
	for(i=1; i<=Hpt->NumSets(); i++){
	   SetI=GrpSet[i];
	   UnionSet(SetU,SetI);	// SetU = SetU U SetI.
	   for(j=i+1; j<=Hpt->NumSets(); j++){
	   	SetJ=GrpSet[j];
		IntersectSet1(SetI,SetJ,SetX); // modifies SetX to SetI intersect SetJ 
		assert(CardSet(SetX) == 0);
	   }
	}
	// 2. Make sure that GrpSets include all of the sequences.
	if(CardSet(SetU) != SetSize-1){
		fprintf(stderr,"CardSet(SetU) = %d != %d\n",CardSet(SetU),SetSize-1);
		SetY=MakeSet(SetSize); FillSet(SetX); 
		IntersectNotSet(SetX,SetU,SetY); // SetY = SetX intersect not SetU
		PutSet(stderr,SetY);
		return FALSE;
	}
	
	// look at BestSets...
	U=MakeSet(SetSize); ClearSet(U);
	for(i=1; i<=Hpt->NumSets(); i++){
	   SetI=BestSet[i];
	   UnionSet(U,SetI);	// U = 'U' U SetI.
	   for(j=i+1; j<=Hpt->NumSets(); j++){
	   	SetJ=BestSet[j];
		IntersectSet1(SetI,SetJ,SetX); // modifies SetX to SetI intersect SetJ 
		assert(CardSet(SetX) == 0);
	   }
	}
	if(CardSet(U) != SetSize-1){
		fprintf(stderr,"CardSet(U) = %d != %d\n",CardSet(U),SetSize-1);
		if(SetY==0) SetY=MakeSet(SetSize); FillSet(SetX); 
		IntersectNotSet(SetX,U,SetY); // SetY = SetX intersect not U
		PutSet(stderr,SetY);
	}

	UInt4    Nfg,Nbg,Nf,Nb,Nr,num_sq = NumSeqsCMSA(MainCMA);
	for(i=1; i<=Hpt->NumBPPS(); i++){
	   // if(IsFailedBPPS[i]) continue;  // These che[i] objects have been discarded and can be ignored.
	   FG=che[i]->RtnFG_Set(); BG=che[i]->RtnBG_Set(); Rm=che[i]->RtnRmSet();
           // set_typ che[i]->Gld=RtnGoldSet( );
	   for(Nf=Nb=Nr=0,sq=1; sq <= num_sq; sq++){
		assert(MemberSet(sq,FG) || MemberSet(sq,BG) || MemberSet(sq,Rm));
		assert(!(MemberSet(sq,FG) && MemberSet(sq,BG)));
		assert(!(MemberSet(sq,FG) && MemberSet(sq,Rm)));
		assert(!(MemberSet(sq,BG) && MemberSet(sq,Rm)));
		if(MemberSet(sq,FG)) Nf++; else if(MemberSet(sq,BG)) Nb++;
		else { assert(MemberSet(sq,Rm)); Nr++; }
	   } assert(Nf == che[i]->RtnCardFG()); assert(Nb == che[i]->RtnCardBG());
	   assert(Nf == CardSet(FG)); assert(Nb == CardSet(BG));
	   for(Nfg=Nbg=0,j=1; j <= Hpt->NumSets(); j++){
		// if(IsFailedSet[j]) continue;
		if(MemberSet(j,SetFG[i])) Nfg += CardSet(GrpSet[j]);
		if(MemberSet(j,SetBG[i])) Nbg += CardSet(GrpSet[j]);
	   } if(Nf != Nfg || Nb != Nbg){
		// PutSetRelations(stderr);
		fprintf(stderr,"FG set (%d): ",i); PutSet(stderr,SetFG[i]); 
		fprintf(stderr,"\nBG set (%d): ",i);PutSet(stderr,SetBG[i]);
		fprintf(stderr,"\n%d: Nf = %d; Nfg = %d; Nb = %d; Nbg = %d\n",i,Nf,Nfg,Nb,Nbg);
		assert(Nf==Nfg); assert(Nb==Nbg);
	   }
	}

	assert(CardSet(SetU) == SetSize-1);
	assert(CardSet(U) == SetSize-1);
	if(SetY) NilSet(SetY); NilSet(SetX); NilSet(SetU); NilSet(U);
	return TRUE;
}

void    cmc_typ::PutSetRelations(FILE *fp)
{
	Int4	n,m;
        fprintf(fp,"\n FG Set Relationships:\n     ");
        for(n=1; n<= Hpt->NumBPPS(); n++){ fprintf(fp,"%2d ",n); } fprintf(fp,"\n");
        for(n=1; n <= Hpt->NumBPPS(); n++){
           fprintf(fp,"%3d: ",n);
           for(m=1; m<= Hpt->NumBPPS(); m++){ fprintf(fp," %c ",RelateFGs[n][m]); }
	   fprintf(fp,"\n");
	   // NilSet(SetX[n]);
	} fprintf(fp,"\n");
        fprintf(fp,"\n BG Set Relationships:\n     ");
        for(n=1; n<= Hpt->NumBPPS(); n++){ fprintf(fp,"%2d ",n); } fprintf(fp,"\n");
        for(n=1; n <= Hpt->NumBPPS(); n++){
           fprintf(fp,"%3d: ",n);
           for(m=1; m<= Hpt->NumBPPS(); m++){ fprintf(fp," %c ",RelateBGs[n][m]); }
	   fprintf(fp,"\n");
	   // NilSet(SetX[n]);
	} fprintf(fp,"\n");
}

void	cmc_typ::PutFixedSeqs(FILE *fp)
// DEBUG: print out an alignment of labeled sequeces ...
{
	Int4 num_sq = NumSeqsCMSA(MainCMA);
        char tmp[100]; 
        set_typ tmpSet=CopySet(Labeled); ClearSet(tmpSet);
        for(Int4 g=1; g<=Hpt->NumSets(); g++){
                if(strcmp("Random",Hpt->ElmntSetName(g)) == 0) continue;
                IntersectSet1(InitSet[g],Labeled,tmpSet);
                if(CardSet(tmpSet) > 0){
                  sprintf(tmp,"%s",NameCMSA(MainCMA)); ReNameCMSA(Hpt->ElmntSetName(g),MainCMA);
                  // PutSeqsInSetCMSA(fp,Labeled, MainCMA);
                  // PutInSetCMSA(fp,Labeled, MainCMA);
                  PutInSetCMSA(fp,tmpSet, MainCMA);
                  ReNameCMSA(tmp,MainCMA);
                }
        } NilSet(tmpSet);
}

