/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "chn_typ.h"

Int4	chn_typ::BugFixA(Int4 start,Int4 gstart,Int4 gend)
// Fixes Kannan's bug: afn: 8/21/10.
// NOTE: if there is a deletion at the start of file
// then jj index may be incorrect as that is not counted as a residue...
// can check for '-' characters using MA array.
{ 
        Int4 ii,jj;
        for(ii=gstart,jj=start; ii < gend && jj < End; ii++){
		if(GNULL[ii] != '_'){ jj++; } 
	} return jj;
        // while(GNULL[gstart] == '_'){ gstart++; }
}

Int4	chn_typ::AddPageBreaks(FILE *fptr,Int4 &loops_on_page,Int4 &lines_on_page)
// only for tabloid portrait and fontsize '8' (default) for now.
// Need to add a routine with a table for various page setups and fontsizes.
// Need exact accounting of lengths left on page given size minus margins...
{
       Int4 total_lines;
       if(PageSetUp == 'P'){
        if((fontsize <= 16 && fontsize >= 12) && loops_on_page > 0 && lines_on_page > 0){
	 if(fontsize == 16) total_lines = 160 - loops_on_page*10;
	 else if(fontsize == 14) total_lines = 185 - loops_on_page*10;
	 else if(fontsize == 12) total_lines = 215 - loops_on_page*10;
	 else total_lines =100;	// this setting should not be inputable.
        }
       } else if(PageSetUp == 'L'){
        if(fontsize == 12 && loops_on_page > 0 && lines_on_page > 0){
	 if(fontsize == 12) total_lines = 180;
	 else total_lines =100;	// this setting should not be inputable.
        }
       }
       Int4 lines_left = total_lines-lines_on_page;
       Int4 lines_in_loop=(Int4)floor((double)lines_on_page/(double)loops_on_page);
       if(verbose){
	   fprintf(stderr,"****** lines_on_page=%3d; in loop =%3d; left=%3d *****\n",
		lines_on_page,lines_in_loop,lines_left);
       }
       if(lines_left <= lines_in_loop){
	  fprintf(fptr,"\n\\par \\page \n");
     	  lines_on_page=0; loops_on_page=0;
       } loops_on_page++;
}

char	*chn_typ::GetColorCodes(Int4 &color,Int4 &colorB,char *color_font,
					double *&fract_seqs)
// Get color code and subgroup name for this analysis 
{
	char *AlignName;
	fract_seqs=FractSeqAln[Analysis];;
	if(fract_seqs && Analysis > 0) {
	   if(MCMA[Analysis-1]){
		AlignName=NameCMSA(MCMA[Analysis-1]); // These are off by one...
		if(strcmp(AlignName,"BackGround")==0){ // antiquated convention...
		    color=colorB=0; return AlignName;
	   	// if(AlignName[0] == 'B') continue;	// Old code...
		}
	   } else AlignName=0; 
	   color=this->clr->get_font_color_code(color_font[ColorCode[Analysis]]);
	   if(use_sfbg && Analysis == 1){	// 'U' option.
		colorB = this->clr->get_font_color_code(color_font[ColorCode[AnalysisList[1]]]);
	   } else if(Analysis == NumAnalysis) colorB = this->clr->get_font_color_code('L'); 
	   else if(ColorCode[Analysis+1] == 0){ colorB=color; }
	   else colorB = this->clr->get_font_color_code(color_font[ColorCode[Analysis+1]]);
	} else {
	   AlignName=0;
	   color=this->clr->get_font_color_code(color_font[ColorCode[Analysis]]);
	   if(use_sfbg && Analysis == 1){	// 'U' option.
		colorB = this->clr->get_font_color_code(color_font[ColorCode[AnalysisList[1]]]);
	   } else if(Analysis == NumAnalysis) colorB = this->clr->get_font_color_code('L'); 
	   // if(Analysis == NumAnalysis) colorB = this->clr->get_font_color_code('L'); 
	   else if(Analysis == 0) colorB = this->clr->get_font_color_code('L'); 
	   else colorB = this->clr->get_font_color_code(color_font[ColorCode[Analysis+1]]);
	} return AlignName;
}

void	chn_typ::OutPutTickMarks(FILE *fptr,Int4 gstart,Int4 start,Int4 gend,
		Int4 color, Int4 *pos_key_seq, Int4 gapsize, Int4 &lines_on_page)
// Output tick marks below MSA
// This prints out before the next file, so need one 'dummy' run after done printing
{
	//************************ output tick marks **************************
	Int4	i,j;
	char	last_gnull=0;
	BooLean	PrintTickMarks=FALSE;
	if(anal_index==1) PrintTickMarks=TRUE;
#if 1	// print tick marks below all alignments: AFN 6-9-2017.
	else if(!BG_CMA && anal_index > 1 && anal_index < (NumAnalIndex-1)) PrintTickMarks=TRUE;
#endif
	else if(!BG_CMA && anal_index > NumAnalysis && NumAnalysis >= 2) PrintTickMarks=TRUE;
	// BG_CMA is a block based motif file....
	else if(BG_CMA && anal_index > (NumAnalysis+1) && NumAnalysis >= 2) PrintTickMarks=TRUE;
	else if(anal_index == 2){	// if anal_index==1 was a background alignment...
		Int4 tmpAnal=AnalysisList[1]; // look at previous
		assert((MCMA[tmpAnal -1]) != 0 && tmpAnal > 0);
		char *AlignName=NameCMSA(MCMA[tmpAnal -1]); // These are off by one...
		assert(AlignName);
	   	if(strcmp(AlignName,"BackGround")==0) PrintTickMarks=TRUE;; // antiquated
	}
	if(PrintTickMarks){
	 if(Seq4numbering > 0){	  // checked for possible segmentation fault above...
	  assert(Seq4numbering <= nseqSMA(MA));
	  fprintf(fptr,"{\\b\\f2\\fs%d\\cf1 position",fontsize);
	  fprintf(fptr,"\\tab  \\tab }"); 
	  Int4 site,site0=0;
	  Int4 spaces=0;
          char *gseq2=gseqSMA(1,Seq4numbering,MA); // pointer set to [0,1,...] array
// fprintf(stderr,"%s\n",gseq2);
	  site=sq_index[anal_index][1];
	  last_gnull=0;
	  for(i=gstart; GNULL[i]=='_'; i++) ; // skip insertions at start..
	  for(spaces=0,j=start; i < gend && j < End; i++){
		assert(i < glengthSMA(1,MA));
		if(pos_key_seq) site=pos_key_seq[i];
		if(GNULL[i] != '_'){
			j++;
			if(anal_index > NumAnalysis) sq_index[anal_index][1]++;
		}
		if(gnull_insrt_len && maxlen_gnull <= gnull_insrt_len[i] 
							&& !isupper(gseq2[i]))
		{
		   if(GNULL[i] == '_' && last_gnull != '_'){
			// spaces += 2 + (Int4) ceil(log10(gnull_insrt_len[i]));
			spaces += 2 + (Int4) ceil(log10((double)gnull_insrt_len[i]+0.00001));
		   }
		} else if(!isalpha(gseq2[i])) spaces++;
		else {
		   if(site%10 == 0){	// print out position.
		   	if(spaces > 4){
			  fprintf(fptr,"{\\f3\\fs%d\\cf1 ",gapsize);
			  for(Int4 sp=5; sp <= spaces; sp++) fprintf(fptr," ");
			  fprintf(fptr,"}\n"); spaces=4;
			}
		   	if(spaces == 4){
			  assert(site < 100000);
			  fprintf(fptr,"{\\f3\\fs%d\\cf1 %5d}\n",gapsize,site);
			  spaces=0;
		   	} else if(site < 10000 && spaces == 3){
			  fprintf(fptr,"{\\f3\\fs%d\\cf1 %4d}\n",gapsize,site);
			  spaces=0;
		   	} else if(site < 1000 && spaces == 2){
			  fprintf(fptr,"{\\f3\\fs%d\\cf1 %3d}\n",gapsize,site);
			  spaces=0;
		   	} else if(site < 100 && spaces == 1){
			  fprintf(fptr,"{\\f3\\fs%d\\cf1 %2d}\n",gapsize,site);
			  spaces=0;
		   	} else if(site < 10 && spaces == 0){
			  fprintf(fptr,"{\\f3\\fs%d\\cf1 %d}\n",gapsize,site);
			  spaces=0;
			} else spaces++;
		   } else if(site%5 == 0){
		   	if(spaces > 0){
			  fprintf(fptr,"{\\f3\\fs%d\\cf1 ",gapsize);
			  for(Int4 sp=1; sp <= spaces; sp++) fprintf(fptr," ");
			  fprintf(fptr,"}\n");
			  spaces=0;
			} fprintf(fptr,"{\\f3\\fs%d\\cf1 .}\n",gapsize);
		   } else spaces++;
	   	   site++;
		} last_gnull=GNULL[i];
	  }
	  if(spaces > 0){
		fprintf(fptr,"{\\f3\\fs%d\\cf1 ",gapsize);
		for(Int4 sp=1; sp <= spaces; sp++) fprintf(fptr," "); fprintf(fptr,"}\n");
	  } fprintf(fptr,"\n{\\f2\\fs%d \\tab }{\\f3 \n\\par }",fontsize);
	  lines_on_page++;
#if 1	// Get rid of this!!!!!!!!!!!
	 } else {	// NOTE: eventually merge this with the above!!!!
	  if(anal_index==1) fprintf(fptr,"{\\b\\f2\\fs%d\\cf1 position",fontsize);
	  // else fprintf(fptr,"{\\b\\f2\\fs%d\\cf%d position",fontsize,color);
	  else fprintf(fptr,"{\\b\\f2\\fs%d\\cf%d SubFamily",fontsize,color);
	  fprintf(fptr,"\\tab  \\tab }"); 
	  Int4 site,site0=0;
	  last_gnull=0;
	  for(site=sq_index[anal_index][1],i=gstart,j=start; i < gend && j < End; i++){
		if(GNULL[i] == '_'){
#if 1	// hide null option.
		  if(gnull_insrt_len && maxlen_gnull <= gnull_insrt_len[i]){
		   if(i > gstart && last_gnull != '_'){
			 fprintf(fptr,"{\\f3\\fs%d\\cf1    }\n",gapsize);
		   }
		  } else {
#endif
		   if(i > gstart) fprintf(fptr,"{\\f3\\fs%d\\cf1  }\n",gapsize);
		   // don't increment at start because true start site is a position ahead.
		  }
		} else {
		   j++; site0++;
		   if(site%10 >= 6){	// don't print anything yet.
		   } else if(site%10 == 0){
		   	if(site0 < 5){
			  fprintf(fptr,"{\\f3\\fs%d\\cf1 ",gapsize);
			  for(Int4 sp=1; sp <= site0; sp++) fprintf(fptr," ");
			  fprintf(fptr,"}\n");
			} else {
			  fprintf(fptr,"{\\f3\\fs%d\\cf1 %5d}\n",gapsize,site);
			}
		   } else if(site%5 == 0) fprintf(fptr,"{\\f3\\fs%d\\cf1 .}\n",gapsize);
		   else fprintf(fptr,"{\\f3\\fs%d\\cf1  }\n",gapsize);
		   if(anal_index > NumAnalysis) sq_index[anal_index][1]++;
		   site++;
		}
		last_gnull=GNULL[i];
	  } fprintf(fptr,"\n{\\f2\\fs%d \\tab }{\\f3 \n\\par }",fontsize);
	  lines_on_page++;
#endif
	 }
	}
}

void	chn_typ::PutConstraintBars(FILE *fptr,Int4 gstart,Int4 start,Int4 gend,
			 Int4 &lines_on_page)
{
	//****************** output histogram at top of figure **********************
	fprintf(fptr,"{\\f3 \n\\par }"); lines_on_page++;
   if(!verbose && !StdAlignmentOnly){  // This truncates a StdAlignmentOnly; Why?!?
	// then put histogram of superalignment above subalignment.
	// if(rtf[Analysis]->Printable() && Hist[Analysis]) 
// NOTE: I may want to delete this option and revert back to original...
	//========== Print out the histogram above each alignment. ============
	if(rtf[Analysis]->Printable()){
	    // for cross conserved values...
	    if(Analysis==0 && Xconserved){
		double *value=Xconserved; 
		double *pval=0; NEW(pval,rtf[Analysis]->Length()+3,double);
		double *old_value=rtf[Analysis]->SwapValue(value,pval);
	        rtf[Analysis]->PutLine(fptr,start,End,gstart,gend,GNULL,Tab[1],Tab[2],
					Tab[3],maxlen_gnull,gnull_insrt_len);
		value=rtf[Analysis]->SwapValue(old_value,pval); 
		if(status && status[Analysis]==0){
		   NEW(status[Analysis],rtf[Analysis]->Length()+3,char);
		   for(Int4 z=1; z <= rtf[Analysis]->Length(); z++){
			if(value[z] > 0) status[Analysis][z]='!';
			else status[Analysis][z]='*';
			// if(status[0][z]=='!') fprintf(stderr,"cross site=%d\n",z);
		   }
		} free(pval);
// assert(Analysis != 0);
	    } else rtf[Analysis]->PutLine(fptr,start,End,gstart,gend,GNULL,
			Tab[1],Tab[2],Tab[3],maxlen_gnull,gnull_insrt_len);
	}
   } else {	  // otherwise put sub-alignment histogram.
	if(rtfQ[Analysis] && rtfQ[Analysis]->Printable() && Hist[Analysis]){
	    fprintf(fptr,"\n{\\f3 \n\\par }");
	    lines_on_page++;
	    // rtfQ[Analysis]->PutLine(fptr,start,End,gstart,gend,GNULL,tab1,tab2,tab3);
	    rtfQ[Analysis]->PutLine(fptr,start,End,gstart,gend,GNULL,
				Tab[1],Tab[2],Tab[3],maxlen_gnull,gnull_insrt_len);
	}
   }
}

void	chn_typ::PrintDots(FILE *fptr, Int4 gstart,Int4 start,Int4 gend, 
		  	Int4 gapsize, Int4 &lines_on_page,Int4 *pos_key_seq)
// Print out dots for BPPS selected columns 
{
	Int4 i,j;
	char last_gnull=0;
      if(NumAnalysis!=3){ // getting this will trigger the next conditional statement...
	if(status && status[Analysis]){	// BPPS generated hierarchical alignment.
	  // fprintf(fptr,"{\\b\\f2\\fs%d\\cf%d Subfamily",fontsize,color);
	  char family_str[200];
#if 1
	  // AlignName=NameCMSA(MCMA[Analysis-1]); // These are off by one...
	  if(Analysis > 0){
	    // fprintf(stderr,"%d.%s\n",Analysis,status[Analysis]+1);
	    strcpy(family_str,NameCMSA(MCMA[Analysis-1]));
	  } else 
#endif
	  // fprintf(stderr,"%d.%s\n",Analysis,status[Analysis]+1);
	  switch(Analysis){
	   // case 0: strcpy(family_str,"Intermediate"); break;
	   // case 0: strcpy(family_str,"Cross-Conserved"); break;
	   case 0: strcpy(family_str,"CrossConserved"); break;
	   case 1: strcpy(family_str,"Family"); break;
	   case 2: strcpy(family_str,"Superfamily"); break;
	   case 3: strcpy(family_str,"Main set"); break;
	   case 4: strcpy(family_str,"motifs"); break;
	   default: strcpy(family_str,"Unknown"); break;
	  }
	  fprintf(fptr,"{\\b\\f2\\fs%d\\cf%d %s",fontsize,1,family_str); // black
	  fprintf(fptr,"\\tab  \\tab }"); 
	  Int4 site,site0=0;
	  char last_gnull=0;
	  for(i=gstart; GNULL[i]=='_'; i++) ; // skip insertions at start..
	  for(site=sq_index[anal_index][1],j=start; i < gend && j < End; i++){
		if(GNULL[i] == '_'){
		  if(gnull_insrt_len && maxlen_gnull <= gnull_insrt_len[i]){
		   if(last_gnull != '_'){
#if 0
			  fprintf(fptr,"{\\f3\\fs%d\\cf1    }\n",gapsize);   // always 3 spaces...
#else		// fix problem with -hide option and dots '*' = '3f below.
			  Int4 spaces = 2 + (Int4) ceil(log10((double) gnull_insrt_len[i]+0.00001));
			  fprintf(fptr,"{\\f3\\fs%d\\cf1 ",gapsize);
			  for(Int4 sp=1; sp <= spaces; sp++) fprintf(fptr," ");
			  fprintf(fptr,"}\n");
#endif
		   }
		  } else {
			fprintf(fptr,"{\\f3\\fs%d\\cf1  }\n",gapsize);
		  }
		} else {
		   j++; site0++;
#if 0		// Tracking down source of CrossConserved..
                if(Analysis==0){
                  if(status[0][j] == '!' || status[0][j]=='?'){ // dots printed out here!
                        fprintf(stderr,"j= %d; i=%d; site=%d\n",j,i,site0);
                  }
                }
#endif
		   if(status[Analysis][j] == '!'){	// dots printed out here!
			fprintf(fptr,"{\\f3\\fs%d\\cf1 \\u9679\\'3f}\n",gapsize);
		   } else if(status[Analysis][j] == '?'){
			fprintf(fptr,"{\\f3\\fs%d\\cf%d \\u9679\\'3f}\n",
				gapsize,this->clr->get_font_color_code('L'));
		   } else {	// status == '*' or "." or "^"...
			fprintf(fptr,"{\\f3\\fs%d\\cf1  }\n",gapsize);
		   } if(anal_index > NumAnalysis) sq_index[anal_index][1]++;
		   site++;
		}
		last_gnull=GNULL[i];
	  } fprintf(fptr,"\n{\\f2\\fs%d \\tab }{\\f3 \n\\par }",fontsize);
	  lines_on_page++;
	}
      } else if(NumAnalysis==3){ // this accesses the next conditional statement...
	// Print out dots for selected columns...
	if(status && status[Analysis]){	// BPPS generated hierarchical alignment.
	  // fprintf(fptr,"{\\b\\f2\\fs%d\\cf%d Subfamily",fontsize,color);
	  // fprintf(stderr,"DEBUG: fs = %d\nAnalysis=%d\nSTATUS=%s\n",fontsize,Analysis,status[Analysis]+1);
	  switch(Analysis){
	   case 0: // conventional alignment.
	     fprintf(fptr,"{\\b\\f2\\fs%d\\cf%d Intermediate",fontsize,1); // black
	     break;
	   case 1: // family
	     fprintf(fptr,"{\\b\\f2\\fs%d\\cf%d Query set",fontsize,1); // black
	     break;
	   case 2: // superfamily
	     fprintf(fptr,"{\\b\\f2\\fs%d\\cf%d Foreground",fontsize,1); // black
	     break;
	   case 3: // main set
	     fprintf(fptr,"{\\b\\f2\\fs%d\\cf%d Background",fontsize,1); // black
	     break;
	   case 4: // motifs
	     fprintf(fptr,"{\\b\\f2\\fs%d\\cf%d motifs",fontsize,1); // black
	     break;
	   default: // unknown alignment.
	     fprintf(fptr,"{\\b\\f2\\fs%d\\cf%d Unknown",fontsize,1); // black
	     break;
	  } 
	  fprintf(fptr,"\\tab  \\tab }"); 
	  Int4 site,site0=0;
#if 1	// crs file HERE...
	  unsigned char *qseq = seqSMA(1,1,MA); // query seq
	  char crs_color=' ';
	  // ColorString=" CyPBGRcmbgr";
	  switch(Analysis){
		case 0: crs_color='G'; break;
		case 1: crs_color='B'; break;
		case 2: crs_color='Y'; break;
		case 3: crs_color='M'; break;
	   	default: // unknown alignment.
	     	break;
	  }
#endif
	  last_gnull=0;
	  for(site=sq_index[anal_index][1],i=gstart,j=start; i < gend && j < End; i++){
		if(GNULL[i] == '_'){
		  if(gnull_insrt_len && maxlen_gnull <= gnull_insrt_len[i]){
		   if(last_gnull != '_'){
			 fprintf(fptr,"{\\f3\\fs%d\\cf1    }\n",gapsize);
		   }
		  } else {
			 fprintf(fptr,"{\\f3\\fs%d\\cf1  }\n",gapsize);
		  }
		} else {
		   j++; site0++;
	// OUTPUT *crs file HERE...
	// (Later make a heap structure to output only the strongest sites...)
		// new format for VSI...
		   if(output_vsi && status[Analysis][j] == '!'){
		     Int4 bar_height = rtf[Analysis]->BarHeight(j);
		     if(bar_height >= 4){
		       if(pos_key_seq){
			 pcr->append(AlphaChar(qseq[j],AB),pos_key_seq[i],crs_color,bar_height);
		       } else {
			 pcr->append(AlphaChar(qseq[j],AB),site,crs_color,bar_height);
		       }
		     }
		   }
		   if(status[Analysis][j] == '!'){
			// fprintf(fptr,"{\\f3\\fs%d\\cf1 *}\n",gapsize);
			fprintf(fptr,"{\\f3\\fs%d\\cf1 \\u9679\\'3f}\n",gapsize);
		   } else if(status[Analysis][j] == '?'){
			fprintf(fptr,"{\\f3\\fs%d\\cf%d \\u9679\\'3f}\n",
				gapsize,this->clr->get_font_color_code('L'));
		   } else {	// status == '*' or "." or "^"...
			fprintf(fptr,"{\\f3\\fs%d\\cf1  }\n",gapsize);
		   }
		   if(anal_index > NumAnalysis) sq_index[anal_index][1]++;
		   site++;
		}
		last_gnull=GNULL[i];
	  } fprintf(fptr,"\n{\\f2\\fs%d \\tab }{\\f3 \n\\par }",fontsize);
	  lines_on_page++;
	} // End of "if(status[Analysis])" section.
      }  // End of "else if(NumAnalysis==3)..." section.
}

void	chn_typ::OutPut2ndary(FILE *fptr,Int4 gstart,Int4 start,Int4 gend,
		Int4 gapsize,Int4 color, char *ss_struct,Int4 &lines_on_page)
//**************** output secondary structure... *******************
{
	Int4	i,j;
	char	str[100];
	if(ss_struct && gnull_insrt_len){
	  fprintf(fptr,"{\\b\\f2\\fs%d\\cf%d pred. structure",fontsize,color);
	  fprintf(fptr,"\\tab  \\tab }"); 
	  strcpy(str,"\\b");
	  for(i=gstart,j=start; i < gend && j < End; i++){
		if(GNULL[i] == '_')
        		fprintf(fptr,"{%s\\f3\\fs%d\\cf1  }\n",str,gapsize);
		else {
			j++;
        		fprintf(fptr,"{%s\\f3\\fs%d\\cf1 %c}\n",str,gapsize,ss_struct[j]);
		}
	  } fprintf(fptr,"\n{\\f2\\fs%d \\tab }{\\f3 \n\\par }",fontsize);
	  lines_on_page++;
	}
}

void	chn_typ::PageOfCHA(FILE *fptr, const char *ColorFont)
// Create an alignment figure for publication:
// Use this routine when have only one gapped 'block'.
// Main loop for each 'page' of contrast alignment 
{
    Int4   i,j,n,N,next_start,start,gstart=0,gend;
    char   r,c,str[50];
    FILE   *efp=0; // efp=stderr;

    assert(ntypSMA(MA)==1);
    Int4 *pos_key_seq=this->PosOfKeySq();
    //*************** find gstart site ********************
    Begin = MINIMUM(Int4,Begin,glengthSMA(1,MA));
    next_start=Begin; 
    this->GetSqStartEnd( );
    for(gstart=0,j=0; j < Begin; gstart++){ 
	if(GNULL[gstart] != '_') j++; 
	else if(gstart > glengthSMA(1,MA)) print_error("Print range outside of MSA.");
    } // FIX PROBLEM WITH GAPS AT START...WITH -B OPTION
    while(GNULL[gstart] == '_'){ gstart++; }
    this->GetSqIndices(gstart);
    char *color_font=this->clr->GetFontColors(ColorFont,NumAnalysis);

    // Int4	fontsize=rtf[1]->FontSize();
    // assert(fontsize > 4 && fontsize < 50);
    // Int4	gapsize=fontsize-4;
    Int4	gapsize=fontsize;
    Int4 loop=0,lines_on_page=0,loops_on_page=0;
    char last_gnull=0;
    char **conserved=0; NEWP(conserved,lengthSMA(1,MA)+3,char);
    //=============  Loop for fancy formating of page... ===============
    //=============  Loop for fancy formating of page... ===============
    for( ; gstart < glengthSMA(1,MA) && next_start < End; gstart=gend,loop++){
#if 0	// avoid duplicate inserts at ends... --> cut off due to issues: AFN 12_20_22.
      if(loop > 0 && GNULL[gend] == '_'){
	 while(GNULL[gstart] == '_'){ gstart++; }
      }
#endif
      //==== computed lengths precisely with conpressed inserts. ====
      for(gend=gstart+1; GEND[gend]==0 && gend < glengthSMA(1,MA); j++) gend++;
      gend=MINIMUM(Int4,glengthSMA(1,MA),gend);
      Tab[3]=GEND[gend];
      if(efp) fprintf(efp,"====> gend = %d; Tab = %d ====\n",gend,Tab[3]);
      if(efp && gnull_insrt_len) this->DiagnosisA(efp,next_start,gstart,gend);
      start=next_start;
      next_start=this->BugFixA(start,gstart,gend);
      if(efp) fprintf(efp,"====> next_start=%d; start= %d; ====\n",next_start,start);
      this->AddPageBreaks(fptr,loops_on_page,lines_on_page);

      //============ loop for various types of alignments.... ===============
      // 0=Query SubFamily A alignment with standard background frequencies.
      // 1=Family A alignment with Family B background frequencies.
      // 2=Family B alignment with Family C background frequences.
      // 3=Family C alignment with standard background frequences.
      //**************** Loop over each level of the hierarchy *******************
      char *AlignName=0;
      Int4 analysis;
      for(anal_index=0; anal_index <= NumAnalIndex; anal_index++){
	// if(StdAlignmentOnly) if(anal_index >=1) break;
	Analysis=AnalysisList[anal_index];
	analysis=BackGrnd[Analysis];
        Int4	color,colorB;
	double *fract_seqs;
	AlignName=this->GetColorCodes(color,colorB,color_font,fract_seqs);
	if(AlignName && strcmp(AlignName,"BackGround")==0) continue; // antiquated

	//============== find conserved positions? ==================
	for(i=gstart,j=start; i < gend && j < End; i++){
	  if(GNULL[i] != '_'){
		j++; if(conserved[j]) free(conserved[j]);
		// double *res_evals=rtf[Analysis]->ResEvalues(j);
  		// conserved[j]=rtfQ[analysis]->Conserved(res_evals); 
  		// conserved[j]=rtf[analysis]->Conserved(res_evals); 
  		conserved[j]=rtf[analysis]->Conserved(j); // AFN: 7/27/07 (fixes bug).
	  }
	}

        double	**wtfreq=Freq[Analysis];	// background freq (= WtFrq[] )
	char	*ss_struct=SecondStrct[Analysis];
	if(Analysis==0){
	  // fprintf(stderr,"=== DEBUG === Analysis=%d\n",Analysis);
	  // next_start=j; // WARNING: assumes always call Analysis==0 first!!!
          fprintf(fptr,"\\pard \\widctlpar \\sl180\\slmult1 ");
	  lines_on_page++;
          fprintf(fptr,"\\widctlpar\\tqr\\tx%d\\tx%d\\tx%d\\adjustright \\fs%d\\cgrid ",
                Tab[1],Tab[2],Tab[3],fontsize);
	}
	this->OutPutTickMarks(fptr,gstart,start,gend,color,pos_key_seq,gapsize,
			lines_on_page);

	if(StdAlignmentOnly){	// e.g.,within GISMO.
	  if(anal_index >=1){ 
	    for(i=gstart,j=start; i < gend && j < End; i++){
		if(GNULL[i] != '_'){ j++; sq_index[anal_index][1]++; }
	    } break;
	  }
	}
	if(!BG_CMA && anal_index > NumAnalysis) continue; 
	if(BG_CMA && anal_index > NumAnalysis+1) continue; 
	if(!SuperAln[Analysis] && anal_index > 0) continue;
	// ^ AFN 5_7_10; omite last alignment from output.
	this->PutConstraintBars(fptr,gstart,start,gend,lines_on_page);
	this->PrintDots(fptr,gstart,start,gend,gapsize,lines_on_page,pos_key_seq);
	if(0){	// need to fix gstart if using this.
	  this->OutPut2ndary(fptr,gstart,start,gend,gapsize,color,
				ss_struct,lines_on_page);
	  if(verbose && gnull_insrt_len){ // output pvalue ... relative entropy
	    rtfQ[Analysis]->PutBarHeights(fptr,start,End,gstart,gend,GNULL,
						color,colorB,rtfQ[analysis]);
	    rtfQ[Analysis]->PutLineBinomial(fptr,start,End,gstart,gend,GNULL,
						color,colorB,rtfQ[analysis]);
	    if(!fract_seqs) rtf[Analysis]->PutLineRelEntropy(fptr,start,End,gstart,
				gend,GNULL,color,colorB,rtf[analysis]);
	  }
	}

	//**************** SEQUENCE ALIGNMENT... *******************
	//**************** SEQUENCE ALIGNMENT... *******************
	//**************** SEQUENCE ALIGNMENT... *******************
	for(N=0, n=1; n<= nseqSMA(MA); n++){
		char id_str[30];
		Int4 res_printed=0; 
		Int4 colorK=color;
		char tmp_str[200],kingdom,king_color;

		if(n==1 && Seq4numbering == 2) continue;
		if(Analysis==0){
		   if(Kingdom){
                        switch(Kingdom[n]){
			   case 'b': case 'B': king_color='m'; break;
			   case 'a': case 'A': king_color='B'; break;
			   case 'f': case 'F': king_color='y'; break;
			   case 'd': case 'D': king_color='y'; break;
			   case 'e': case 'E': case 'p': case 'P': king_color='C'; break;
			   case 'm': case 'M': king_color='R'; break;
			   case 'v': case 'V': case 'g': case 'G': king_color='G'; break;
			   default: king_color='D'; break;
                        } colorK=this->clr->get_font_color_code(king_color);
		   } 
		   if(StdAlignmentOnly){
		     if(ShowStdAlnPhyla && Phylum && Phylum[n]){
			strncpy(id_str,Phylum[n],28);
			//sprintf(id_str,"%s",Phylum[n]); 
		     } else {
			strncpy(id_str,seqidSMA(n,MA),28);
			// sprintf(id_str,"%s",seqidSMA(n,MA));
		     }
		   } else if(Phylum && Phylum[n]){
			if(Class && Class[n]){
			  char Str[200];
			  sprintf(Str,"%s;%s",Phylum[n],Class[n]);
			  strncpy(id_str,Str,28);
			} else {
			  strncpy(id_str,Phylum[n],28);
			  //sprintf(id_str,"%s",Phylum[n]); 
			}
		   } else if(n==1) sprintf(id_str,"consensus"); 
		   else sprintf(id_str,"unknown"); 
		} else {
			strncpy(id_str,seqidSMA(n,MA),28);
			// sprintf(id_str,"%s",seqidSMA(n,MA)); 
		}
		id_str[14]=0; // end at 14
		if(n < nseqSMA(MA)){
		  fprintf(fptr,"{\\b\\f2\\fs%d\\cf%d %s }",fontsize,colorK,id_str);
		  fprintf(fptr,"{\\f2\\fs%d\\cf1 \\tab %d\\tab }",
				fontsize,sq_index[anal_index][n]);
		  strcpy(str,"\\b");
	        } else {	// underline last sequence...
		  fprintf(fptr,"{\\b\\f2\\fs%d\\ul\\cf%d %s }",fontsize,colorK,id_str);
		  fprintf(fptr,"{\\f2\\fs%d\\ul\\cf1 \\tab %d\\tab }",
						fontsize,sq_index[anal_index][n]);
	 	  strcpy(str,"\\b\\ul");
		}
        	char *gseq= gseqSMA(1,n,MA);
		unsigned char *seq = seqSMA(1,n,MA);
		char	state,laststate;
Int4 char_printed=0;
		for(i=gstart; GNULL[i]=='_'; i++) ; // skip insertions at start.
// fprintf(stderr,"#### End0=%d; gstart=%d; gend=%d\n",End,gstart,gend);
		for(laststate=last_gnull=0,j=start; i < gend && j < End; i++){
		   if(GNULL[i] == '_'){
		     state='i';
		     c = gseq[i];
		     if(isalpha(c)){ res_printed++; sq_index[anal_index][n]++; }
		     else { assert(isprint(c)); }

		     if(gnull_insrt_len && maxlen_gnull <= gnull_insrt_len[i]){
		       if(last_gnull != '_'){
			 // Int4 numdots = 2 + (Int4) ceil(log10(gnull_insrt_len[i]));
			 Int4 numdots = 2 + (Int4) ceil(log10((double) gnull_insrt_len[i]+0.00001));
			 if(state == laststate){  // always false because GNULL[i] != last_gnull
			    assert(!"this should not happen");
#if 0	// state == laststate) is always false because GNULL[i] != last_gnull
			    if(isalpha(c)){
				// fprintf(fptr,"(x)");
				fprintf(fptr,"(%d)",gnull_insrt_len[i]);
			    } else {
				fprintf(fptr,"...");
				// fprintf(fptr,"---");
			    }
#endif
			 } else {
char_printed += maxlen_gnull;
			   if(laststate != 0) fprintf(fptr,"}\n");
			   sprintf(tmp_str,"{%%s\\f3\\fs%%d\\cf15 (%%%dd)",numdots-2);
			   if(isalpha(c)){
			     Int4 num_Res=0;
			     for(Int4 col=i+gnull_insrt_len[i]-1; col >= i; col--){
				if(isalpha(gseq[col])) num_Res++;
			     }
			     fprintf(fptr,tmp_str,str,gapsize,num_Res);  
			   } else {
			     // fprintf(fptr,"{%s\\f3\\fs%d\\cf16 ...",str,gapsize);  
			     fprintf(fptr,"{%s\\f3\\fs%d\\cf15 ",str,gapsize);  
			     for(Int4 d = 1; d <= numdots; d++) fprintf(fptr,".");
			   }
			   // fprintf(fptr,"{%s\\f3\\fs%d\\cf8 (x)",str,gapsize);  
			 }
		       } // else skip over the rest...
		     } else {
			  if(state == laststate) fprintf(fptr,"%c",c);
			  else {
			    if(laststate != 0) fprintf(fptr,"}\n");
			    if(state=='i'){
			    	  fprintf(fptr,"{%s\\f3\\fs%d\\cf15 %c",str,gapsize,c);  
			    } else {
				  fprintf(fptr,"{%s\\f3\\fs%d\\cf8 %c",str,gapsize,c);  
			    }
			  }
		     } laststate = state;

		   } else { 	// i.e., (GNULL[i] != '_')
			j++; r = seq[j]; 
			this->DebugProblem(i,j,n,gseq,seq,gstart,start,id_str,r);
			if(r==0 && gseq[i] == '-'){ c = '-'; }
			else {
			  c=AlphaChar(r,AB); res_printed++;
			  sq_index[anal_index][n]++; 
			}
			// New multiple Residues...
			if(NumResidues==1 && Residue[1] && j == Position0[1]){
			   if(MemSset(AlphaCode(c,AB),Residues[NumResidues])) state = '!';
			   else state = ' '; 
#if 1			// Added feature to allow first status == '^' position to be ignored
			} else if(rtf[analysis]->IgnoreResPos(j)){
				state = '!';
#endif
			} else {
			   state = rtf[analysis]->ConservedState(conserved[j], r,c); 
			}
			rtf[analysis]->PutConservedState(fptr, state, laststate, c, str);
			laststate = state;
		   }
		   last_gnull=GNULL[i];
		} 
		// if(n==1) next_start=j; // turning this off was causing a core dump!
		// but I haven't checked this out rigorously yet...
		if(n < nseqSMA(MA)){
		  fprintf(fptr,"}\n{\\f2\\fs%d ",fontsize);
		  if(res_printed == 0) fprintf(fptr,"\\tab  }{\\f3 \n\\par }");
		  else {
		    if(Seq4numbering > 0 && Seq4numbering == n){ 
		      fprintf(fptr,"\\tab %d*}{\\f3 \n\\par }",sq_index[anal_index][n]-1);
		    } else fprintf(fptr,"\\tab %d}{\\f3 \n\\par }",sq_index[anal_index][n]-1);
		  }
		} else {
		  fprintf(fptr,"}\n{\\f2\\fs%d\\ul ",fontsize);
		  if(res_printed == 0) fprintf(fptr,"\\tab  }{\\f3 \n\\par }");
		  else {
		    if(Seq4numbering > 0 && Seq4numbering == n){ 
			fprintf(fptr,"\\tab %d*}{\\f3 \n\\par }",sq_index[anal_index][n]-1);
		    } else fprintf(fptr,"\\tab %d}{\\f3 \n\\par }",sq_index[anal_index][n]-1);
		  }
		} lines_on_page++;
	}  /********************* END SEQUENCE ALIGNMENT *******************************/
	   /********************* END SEQUENCE ALIGNMENT *******************************/
	   /********************* END SEQUENCE ALIGNMENT *******************************/

	//*********** output super-alignment info at bottom of figure **********
	//*********** output super-alignment info at bottom of figure **********
	//*********** output super-alignment info at bottom of figure **********
	BooLean UnderLine=TRUE;
	if(!HideIndelInfo && gnull_insrt_len == 0){	// if don't abstract out inserts.
		UnderLine=FALSE; // ten show indels
	}
	for(i=gstart; GNULL[i]=='_'; i++) ; // skip insertions at start.
	Int4 GStrt=i;
	if(SuperAln[Analysis]){
	 if(show_marg_prob){
	   if(AlignName && AlignName[0]=='C'){
	     if(MargProb[Analysis]){
	  	put_marg_prob(fptr,GStrt,start,gend,color,gapsize,GNULL,Analysis);
	     }
	   }
	 }
   	 if(verbose){ 	// then put another histogram above super-alignment consensus.
	  if(AlignName && (AlignName[0]=='C' || AlignName[0]=='S' || AlignName[0]=='F')
		&& rtf[Analysis] && rtf[Analysis]->Printable() && Hist[Analysis])
	  { // Print another histogram above consensus...
	    fprintf(fptr,"{\\b\\f2\\fs%d\\cf%d %s }{\\f3 \n\\par }\n",
						fontsize,color,AlignName);
	    lines_on_page++;
	    // fprintf(fptr,"{\\f3 \n\\par }\n"); // one carriage 
	    // fprintf(fptr,"{\\f2\\fs%d %s}\n",fontsize,AlignName);
	    // fprintf(fptr,"{\\f3 \n\\par }\n");
	    // rtf[Analysis]->PutLine(fptr,start,End,gstart,gend,GNULL,tab1,tab2,tab3);
	    rtf[Analysis]->PutLine(fptr,start,End,GStrt,gend,GNULL,
				Tab[1],Tab[2],Tab[3], maxlen_gnull,gnull_insrt_len);
	  }
	  rtf[Analysis]->PutBarHeights(fptr,start,End,GStrt,gend,GNULL,
						color,colorB,rtf[analysis]);
   	 }

	 rtf[Analysis]->PutAlnSummary(fptr,start,End,GStrt,gend,GNULL,
			wtfreq,WtNumSeq[Analysis],color,rtf[Analysis],verbose,
			WtNumSq[Analysis],NumSqMain[Analysis],PatternOnlyMode,
			MaxConcensusLines,maxlen_gnull,gnull_insrt_len,UnderLine,TRUE); 
	 lines_on_page+=MaxConcensusLines;
	}

	//**************** output fraction of sequences aligned... *******************
	//**************** output fraction of sequences aligned... *******************
	//**************** output fraction of sequences aligned... *******************
	if(fract_seqs){
	  if(verbose){
	    rtf[Analysis]->PutLineRelEntropy(fptr,start,End,GStrt,gend,GNULL,
						color,colorB,rtf[analysis]);
	  }
	  if(!HideIndelInfo && gnull_insrt_len == 0){	// if don't abstract out inserts.
// fprintf(stderr,"===> DEBUG 1B: %d; HideIndelInfo=%d\n",maxlen_gnull,HideIndelInfo); 
	    if(Analysis > 0 && MCMA[Analysis-1]){
	       this->PutIndelInfo(fptr,GStrt,start,gend,gapsize,color,lines_on_page);
	    } else if(BG_CMA && Analysis == NumAnalysis+1){
	       this->PutMotifsBG(fptr,GStrt,start,gend,gapsize,color);
	    }
          } else if(HideIndelInfo && gnull_insrt_len != 0){
// fprintf(stderr,"===> DEBUG XXX: %d; HideIndelInfo=%d\n",maxlen_gnull,HideIndelInfo); 
	    if(Analysis > 0 && MCMA[Analysis-1]){
	       this->PutIndels(fptr,GStrt,start,gend,gapsize,color,lines_on_page);
// fprintf(stderr,"===> DEBUG 0\n");
	    }
	  }
#if 0	  // see omitted below.
#else 
	  if(!HideIndelInfo){
	    fprintf(fptr,"\n{\\f2\\fs%d ",fontsize);
	    // if(gnull_insrt_len == 0)
	    if(Analysis > 0){	// omit last return
	    	fprintf(fptr,"}");	
		// fprintf(fptr,"}\n{\\f3\\fs%d \\tab }{\\f2 \n\\parG }",fontsize);
	    } else fprintf(fptr,"}\n{\\f2\\fs%d \\tab }{\\f3 \n\\par }",fontsize);
	    lines_on_page++;
	  }
	  // NOTE: PERHAPS SHOULD PRINT OUT CMA DIVERSITY AT END OF THIS LINE!
#endif
#if 1	// put BackGround below alignment...
	 // if(anal_index > 1)
	 if(anal_index > 2)	// no background shown for root node...
	 {
	   Int4 tmpAnal=AnalysisList[anal_index-1]; // look at previous
	   assert((MCMA[tmpAnal -1]) != 0 && tmpAnal > 0);
	   AlignName=NameCMSA(MCMA[tmpAnal-1]); // These are off by one...
	   assert(AlignName);
	   if(strcmp(AlignName,"BackGround")==0){
             double	**tmp_wtfreq=Freq[tmpAnal];	// background freq (= WtFrq[] )
	     color = 15; // dk grey
	     // color = 16; // lt grey
	     // ignore returned next_start here as this was set above....
	     // fprintf(fptr,"{\\f3 \n\\par }");
	     rtf[Analysis]->PutAlnSummary(fptr,start,End,GStrt,gend,GNULL,
			tmp_wtfreq,WtNumSeq[tmpAnal],color,rtf[tmpAnal],verbose,
			WtNumSq[tmpAnal],NumSqMain[tmpAnal],PatternOnlyMode,
			MaxConcensusLines,maxlen_gnull,gnull_insrt_len,TRUE,FALSE); 
	     lines_on_page+=MaxConcensusLines;
	   }
	 }
#endif
	}
	//**************** output marginal probability... *******************
	if(MargProb[Analysis] && SuperAln[Analysis] 
			&& !(AlignName && AlignName[0]=='C')){
	   for(i=gstart; GNULL[i]=='_'; i++) ; // skip insertions at start.
	   Int4 GStrt=i;
	   put_marg_prob(fptr,GStrt,start,gend,color,gapsize,GNULL,Analysis);
	} // end of output marginal probability.
     } // end of main Analysis loop
     PutCHA_RTNS(fptr,4);
   } // end of 'fancy-formating-of-page' loop...
   free(color_font);
   // PutCHA_RTNS(fptr,2);
   if(pos_key_seq) free(pos_key_seq);
   for(j=1; j<=lengthSMA(1,MA); j++) if(conserved[j]) free(conserved[j]);
   free(conserved);
   for(anal_index=0; anal_index <= NumAnalIndex; anal_index++) free(sq_index[anal_index]);
}

void	chn_typ::PutIndels(FILE *fptr,Int4 gstart,Int4 start,Int4 gend,
			Int4 gapsize, Int4 color, Int4 &lines_on_page)
// Use this when omitting large insertions; i.e., when HideIndelInfo==TRUE
{
	Int4 i,j;
	char str[100];
//fprintf(stderr,"===> DEBUG 1: %d\n",maxlen_gnull); 
	for(char XX=1; XX >=0; XX--){
	  // if(!verbose && XX==0) break;  // always output deletions.
	  if(XX){
	    fprintf(fptr,"{\\b\\f2\\fs%d\\cf%d insertions\\tab \\tab }",
		fontsize,color);
	    strcpy(str,"\\b");
	  } else {
	    fprintf(fptr,"{\\b\\f2\\fs%d\\ul\\cf%d deletions\\tab \\tab }",
		fontsize,color);
	    strcpy(str,"\\b\\ul");
	  }
	  char	indel;
	  cma_typ tmp_cma=MCMA[Analysis-1];
	  char	state,laststate,last_gnull=0; 
	  Int4	k,numspace;
// fprintf(stderr,"#### End=%d; gstart=%d; gend=%d\n",End,gstart,gend);
	  for(laststate=last_gnull=0,i=gstart,j=start; i < gend && j < End; i++){
	     if(GNULL[i] == '_'){	// insert region
		state=' ';
	        if(last_gnull != '_'){          // first insert position
                  if(laststate != 0) fprintf(fptr,"}\n");
                  fprintf(fptr,"{%s\\f3\\fs%d\\cf15 ",str,gapsize);
		  if(gnull_insrt_len && gnull_insrt_len[i] >= maxlen_gnull){
                    numspace=2+(Int4) ceil(log10((double)gnull_insrt_len[i]+0.00001));
                    for(k=1; k <= numspace; k++) fprintf(fptr," ");
                  } else {
		    for(k=i; GNULL[k]=='_'; k++) fprintf(fptr," ");
		  }
 		} laststate = state;
	     } else {
		j++;
		Int4 hits=0;
		for(Int4 n_0=1; n_0 <= NumSeqsCMSA(tmp_cma); n_0++){
			if(XX){ if(InsertionCMSA(1,n_0,j,tmp_cma) > 0) hits++; }
			else { if(IsDeletedCMSA(1,n_0,j,tmp_cma)) hits++; }
		}
		state='X';
		double fract_hits=(double)hits/(double)NumSeqsCMSA(tmp_cma);
		if(fract_hits < 0.10){
			indel=FractionToCharPBC(10.0*fract_hits);
			state = 'L';
			if(indel=='0') indel=' ';
			else if(indel=='?') indel='!';
		} else {
			indel=FractionToCharPBC(fract_hits);
			state = 'B'; 
			if(indel=='?') indel='!';
		}
		if(state == laststate) fprintf(fptr,"%c",indel);
		else { 
		   if(laststate != 0) fprintf(fptr,"}\n");
	       	   if(state == 'R') fprintf(fptr,"{%s\\f3\\cf6 %c",str,indel);
	       	   else if(state == 'Y') fprintf(fptr,
				"{%s\\f3\\cf6\\highlight7 %c",str,indel);
	       	   else if(state == 'B') fprintf(fptr,"{%s\\f3\\cf1 %c",str,indel);
	       	   else if(state == 'D') fprintf(fptr,"{%s\\f3\\cf15 %c",str,indel);
	       	   else fprintf(fptr,"{%s\\f3\\cf15 %c",str,indel);
		} laststate = state;
	     } last_gnull=GNULL[i]; 
	  } fprintf(fptr,"}\n{\\f2\\fs%d ",fontsize);
	  fprintf(fptr,"}\n{\\f2\\fs%d \\tab }{\\f3 \n\\par }",fontsize);
	  // don't output res diversity.
	  lines_on_page++;
	 }
}


void	chn_typ::PutMotifsBG(FILE *fptr,Int4 gstart,Int4 start,Int4 gend,
			Int4 gapsize, Int4 color)
// Special case for BG motif model... 
{
	Int4	i,j;
	char	str[100];
	fprintf(fptr,"{\\b\\f2\\fs%d\\ul\\cf%d deletions\\tab \\tab }",
		fontsize,color);
	strcpy(str,"\\b\\ul");
	char	indel;
	cma_typ tmp_cma=MCMA[Analysis-1];
	char	state,laststate;
	for(laststate=0,i=gstart,j=start; i < gend && j < End; i++){
	   if(GNULL[i] == '_'){
		state=' ';
		if(state == laststate) fprintf(fptr," ");
                else {
                   if(laststate != 0) fprintf(fptr,"}\n");
                   fprintf(fptr,"{%s\\f3\\fs%d\\cf1  ",str,gapsize);
                } laststate = state;
	   } else {
		j++;
		Int4 hits=0;
		state='X';
		if(NullFreqBG[j]==NullFreqBG[0]){  // then deleted...
				indel=FractionToCharPBC(0.99);
				state = 'B'; 
				if(indel=='?') indel='!';
		} else {
				indel=FractionToCharPBC(0.0);
				state = 'L';
				if(indel=='0') indel=' ';
				else if(indel=='?') indel='!';
		}
		if(state == laststate) fprintf(fptr,"%c",indel);
		else { 
		   if(laststate != 0) fprintf(fptr,"}\n");
	           if(state == 'B') fprintf(fptr,"{%s\\f3\\cf1 %c",str,indel);
		   // else fprintf(fptr,"{%s\\f3\\cf16 %c",str,indel);
		   else fprintf(fptr,"{%s\\f3\\cf15 %c",str,indel);
		} laststate = state;
	   }
	} fprintf(fptr,"}\n{\\f2\\fs%d ",fontsize);
	fprintf(fptr,"}\n");	// for outputing res diversity.
}

void	chn_typ::PutIndelInfo(FILE *fptr,Int4 gstart,Int4 start,Int4 gend, Int4 gapsize,
                        Int4 color, Int4 &lines_on_page)
{
	Int4 i,j;
	char str[100];
	for(char XX=1; XX >=0; XX--){
	  // if(!verbose && XX==0) break;  // always output deletions.
	  if(XX){
	    fprintf(fptr,"{\\b\\f2\\fs%d\\cf%d insertions\\tab \\tab }",
		fontsize,color);
	    strcpy(str,"\\b");
	  } else {
	    fprintf(fptr,"{\\b\\f2\\fs%d\\ul\\cf%d deletions\\tab \\tab }",
		fontsize,color);
	    strcpy(str,"\\b\\ul");
	  }
	  char	indel;
	  cma_typ tmp_cma=MCMA[Analysis-1];
	  char	state,laststate;
	  for(laststate=0,i=gstart,j=start; i < gend && j < End; i++){
		   if(GNULL[i] == '_'){
			  state=' ';
			  if(state == laststate) fprintf(fptr," ");
                          else {
                            if(laststate != 0) fprintf(fptr,"}\n");
                            fprintf(fptr,"{%s\\f3\\fs%d\\cf1  ",str,gapsize);
                          } laststate = state;
		   } else {
			j++;
			Int4 hits=0;
			for(Int4 n_0=1; n_0 <= NumSeqsCMSA(tmp_cma); n_0++){
				if(XX){ if(InsertionCMSA(1,n_0,j,tmp_cma) > 0) hits++; }
				else { if(IsDeletedCMSA(1,n_0,j,tmp_cma)) hits++; }
			}
			state='X';
			double fract_hits=(double)hits/(double)NumSeqsCMSA(tmp_cma);
#if 0
			if(fract_hits < 0.10){
				indel=FractionToCharPBC(10.0*fract_hits);
				if(indel < '5') state = 'L';
				else state = 'D';
				if(indel=='0') indel=' ';
				else if(indel=='?') indel='!';
			} else {
				indel=FractionToCharPBC(fract_hits);
				if(indel < '6') state = 'R';
				else state = 'Y'; 
				if(indel=='?') indel='!';
			}
#else
			if(fract_hits < 0.10){
				indel=FractionToCharPBC(10.0*fract_hits);
				state = 'L';
				if(indel=='0') indel=' ';
				else if(indel=='?') indel='!';
			} else {
				indel=FractionToCharPBC(fract_hits);
				state = 'B'; 
				if(indel=='?') indel='!';
			}
#endif
			if(state == laststate) fprintf(fptr,"%c",indel);
			else { 
			   if(laststate != 0) fprintf(fptr,"}\n");
	        	   if(state == 'R') fprintf(fptr,"{%s\\f3\\cf6 %c",str,indel);
	        	   else if(state == 'Y') fprintf(fptr,
					"{%s\\f3\\cf6\\highlight7 %c",str,indel);
	        	   else if(state == 'B') fprintf(fptr,"{%s\\f3\\cf1 %c",str,indel);
	        	   else if(state == 'D') fprintf(fptr,"{%s\\f3\\cf15 %c",str,indel);
	        	   else fprintf(fptr,"{%s\\f3\\cf15 %c",str,indel);
			} laststate = state;
		   }
	  } fprintf(fptr,"}\n{\\f2\\fs%d ",fontsize);
	  fprintf(fptr,"}\n{\\f2\\fs%d \\tab }{\\f3 \n\\par }",fontsize);
	  // don't output res diversity.
	  lines_on_page++;
	 }
}

void	chn_typ::DebugProblem(Int4 i,Int4 j,Int4 n,char *gseq, unsigned char *seq,
				Int4 gstart,Int4 start,char *id_str, Int4 r)
{
	if(r!=0 && gseq[i] == '-'){
		Int4 jx=MAXIMUM(Int4,1,j-5);
		fprintf(stderr,"context: '");
		for( ; jx <= j; jx++){
			fprintf(stderr,"%c",AlphaChar(seq[jx],AB));
		}
		fprintf(stderr,"'\n %s(%s)(%d): %c%d(%d)\n",
				seqidSMA(n,MA),id_str,n,AlphaChar(r,AB),i,j);
		fprintf(stderr,"%s\n",gseq);
		fprintf(stderr,"j=%d; start=%d; i=%d; gstart=%d\n",
					j,start,i,gstart);
		fprintf(stderr,"gnull=%s\n",GNULL);
		fprintf(stderr,"glength=%d\n",glengthSMA(1,MA));
		// fprintf(fptr,"%s", MA->gseq[n][1]);
		FILE *dbfp=open_file("debug_out",".msa","w");
		PutSMA(dbfp,MA); fclose(dbfp);
		dbfp=open_file("debug_out",".rtf","w");
		SMA2RTF(dbfp,-2.0,1.8,2.5,MA); fclose(dbfp);
		// MA created by:
		// PutAlnCMSA(fp,CMA[1]); rewind(fp); 
		//MA=ReadSMA(fp); fclose(fp);
		// need to make sure that the array is not over flow;
		// ...appears to be a bug.
#if 0
    		for(j=0; j < glengthSMA(1,MA); j++){
		    fprintf(stderr,"gnull[%d] = %c %d\n",j,GNULL[j],
			gnull_insrt_len[j]);
    		}
#endif
		assert(!( r!=0 && gseq[i] == '-'));
	}
}


