/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "chn_typ.h"

Int4	chn_typ::GetCharPerLine()
{
        double  total_units,scale_factor=1.0;
	units_per_char=0.0;	
	Tab[1]=15*fontsize*6;
	Tab[2]=Tab[1]+(fontsize*6);
        switch(fontsize){
           case 12: {    // font 6
              switch(PageSetUp){
		case 'L': char_per_line=270; break;
		case 'P': char_per_line=152; break;
		case 'l': char_per_line=152; break;
		case 'p': char_per_line=108; break;
		default: print_error("chn_typ: PageSetUp input error"); break;
	      } units_per_char=21200.0/294.0; // =72.109;
	   } break;
           case 14: {    // font 7
              switch(PageSetUp){
		case 'L': char_per_line=232; break;
		case 'P': char_per_line=131; break;
		case 'l': char_per_line=131; break;
		case 'p': char_per_line=90; break;
		default: print_error("chn_typ: PageSetUp input error"); break;
	      } units_per_char=21200.0/252; // =84.127;
	   } break;
           case 16: {    // font 8
              switch(PageSetUp){
		case 'L': char_per_line=201; break;
		case 'P': char_per_line=113; break;
		case 'l': char_per_line=113; break;
		case 'p': char_per_line=77; break;
		default: print_error("chn_typ: PageSetUp input error"); break;
	      } units_per_char=21200.0/220.0;
	   } break;
           case 18: {     // font 9
              switch(PageSetUp){
		case 'L': char_per_line=175; break;
		case 'P': char_per_line=98; break;
		case 'l': char_per_line=98; break;
		case 'p': char_per_line=66; break;
		default: print_error("chn_typ: PageSetUp input error"); break;
	      } units_per_char=21200.0/196.0;
	   } break;
           case 20: {       // font 10
              switch(PageSetUp){
		case 'L': char_per_line=158; break;
		case 'P': char_per_line=86; break;
		case 'l': char_per_line=86; break;
		case 'p': char_per_line=58; break;
		default: print_error("chn_typ: PageSetUp input error"); break;
	      } units_per_char=21200.0/176.0;
	   } break;
           case 22: {	       // font 11
              switch(PageSetUp){
		case 'L': char_per_line=142; break;
		case 'P': char_per_line=77; break;
		case 'l': char_per_line=77; break;
		case 'p': char_per_line=50; break;
		default: print_error("chn_typ: PageSetUp input error"); break;
	      } units_per_char=21200.0/160.0;
	   } break;
           case 24: {	    // font 12
              switch(PageSetUp){
		case 'L': char_per_line=127; break;
		case 'P': char_per_line=69; break;
		case 'l': char_per_line=69; break;
		case 'p': char_per_line=45; break;
		default: print_error("chn_typ: PageSetUp input error"); break;
	      } units_per_char=21200.0/147.0;
	   } break;
	   default: print_error("chn_typ: PageSetUp input error"); break;
        }
        double dd=((double)char_per_line+1.5)*units_per_char;
	Int4 x=(Int4)ceil(dd);
	Tab[3]= Tab[2] + x;
	fprintf(stderr,"'%c': tab1=%d; tab2=%d; tab3=%d; char/line=%d\n",
			PageSetUp, Tab[1],Tab[2],Tab[3],char_per_line);
	return char_per_line;
}

Int4 *chn_typ::GetSqStartEnd( )
// find the gap start and end sites
{
    char   last=0,state=0;
    Int4   total,i,j,k,x,n,next_start,loop=0,gstart,gend,start;
    Int4   *PrintLen; NEW(PrintLen,strlen(GNULL)+9,Int4);
    double dd;
    FILE   *efp=0; // efp=stderr;

    NEW(GEND,strlen(GNULL)+9,Int4);	// store Tab[3] at GEND[x] != 0;

    this->GetCharPerLine();
    // gap2number: maxlen_gnull if insert is > maxlen_gnull then print # e.g., (12) 
    Begin = MINIMUM(Int4,Begin,glengthSMA(1,MA));
    next_start=Begin; 
    if(efp){
	fprintf(efp,"cpl=%d;fs=%d\ngnull=%s\n Begin=%d; End=%d\n",
			char_per_line,fontsize,GNULL,Begin,End);
    }
    for(gstart=i=j=0; i < Begin; j++,gstart++){
        if(GNULL[gstart] == '*'){ i++; }
	if(efp) fprintf(efp,"%3d.%3d: %c \n",j,gstart,GNULL[gstart]);
    } 
    while(GNULL[gstart] == '_'){ gstart++; }
    if(efp) fprintf(efp,"gstart=%d\n",gstart);
    for(total=loop=0,i=Begin,j=gstart; j <= glengthSMA(1,MA) && i <= End; j++){
      x=j-1;	// WARNING: GNULL starts at 0 not 1.
      if(gnull_insrt_len ==0){
        if(GNULL[x] =='*') i++; 
	total++;
	if(total >= char_per_line){
        	dd=((double)total+1.2)*units_per_char;
		GEND[j]= Tab[2] + (Int4)ceil(dd); total=0;
	}
	// don't do anything.
      } else if(j > 0){
         if(GNULL[x] =='*') i++; 
         BooLean Prnt=FALSE;
	 state=GNULL[x];
	 if(last=='*' && state=='_'){	// start of insert region.
	    Prnt=TRUE; 
	    if(gnull_insrt_len[x] <= maxlen_gnull){
#if 1
	       PrintLen[x]=gnull_insrt_len[x];
#else
	       for(n=0,k=j; GNULL[k-1] == '_'; k++) n++;
	       PrintLen[x]=n;
#endif
	    } else {
	       if(gnull_insrt_len[x] < 10){
	          PrintLen[x]=3;	// e.g., '(2)'
	       } else if(gnull_insrt_len[x] < 100){
	          PrintLen[x]=4;	// e.g., '(37)'
	       } else if(gnull_insrt_len[x] < 1000){
	          PrintLen[x]=5;	// e.g., '(257)'
	       } else if(gnull_insrt_len[x] < 10000){
	          PrintLen[x]=6;	// e.g., '(3257)'
	       } else if(gnull_insrt_len[x] < 100000){
	          PrintLen[x]=7;	// e.g., '(32567)'
	       } else {
		  print_error("Fatal: insert > 100,000 residues");
	       }
	    }
	 } else if(state=='*'){ PrintLen[x]=1; Prnt=TRUE; }
	 last=state; total += PrintLen[x];
	 if(efp && Prnt) fprintf(efp,"%3d(%d): %c  %d (+ %d = %d)\n", j,i,GNULL[x],
				gnull_insrt_len[x],PrintLen[x],total);
	 if(total >= char_per_line){
      		if(efp) fprintf(efp,"===== page break %d ====\n",loop); loop++;
        	dd=((double)total+1.5)*units_per_char;
		GEND[j]= Tab[2] + (Int4)ceil(dd); total=0;
      		if(state == '_'){ // avoid duplicate inserts at ends and starts...
		   while(GNULL[x] == '_'){ j++; x++; }
		   { j--; x--; } // back up one for next page.
		}
	 }
      }
    } if(efp) fprintf(efp,"===== DONE ====\n");
    if(total > 0 && GEND[j-1]==0){	// set Tab[3] for short end region.
      dd=((double)total+1.5)*units_per_char;
      GEND[j-1]= Tab[2] + (Int4)ceil(dd);
    } free(PrintLen);
    return 0;
}

void    chn_typ::DiagnosisA(FILE *fp,Int4 start,Int4 gstart, Int4 gend)
{
        // diagnosis of insert numbers e.g. '(34)'... AFN: 10_7_22
       if(gnull_insrt_len){
        Int4 ii,jj;
        fprintf(fp,"=== Start = %d ===; cpl = %d; fontsize=%d\n",
                        start,char_per_line,fontsize);
        for(ii=gstart,jj=start; ii < gend && jj < End; ii++){
            if(GNULL[ii] != '_'){
                jj++;
                if(ii < gend && GNULL[ii+1] == '_' && gnull_insrt_len[ii+1] > 0){
                     fprintf(fp,"column %d: %d\n",jj,gnull_insrt_len[ii+1]);
                }
            }
        }
        fprintf(fp,"=== end=%d (%d==gend=%d; End=%d) ===\n",jj,ii,gend,End);
       }
}

