/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "chn_typ.h"

void    chn_typ::PutCHA_RTNS(FILE *fptr,unsigned short numRtns)
{
        fprintf(fptr,"\\pard \\widctlpar \\sl180\\slmult1 {\\f3");
        for(unsigned short i=1; i <=numRtns; i++) fprintf(fptr,"\n\\par");
        fprintf(fptr," }\n");
}

void	chn_typ::PutCHA_TAIL(FILE *fptr)
{ fprintf(fptr,"\\pard \\widctlpar \\sl180\\slmult1  {\\f3\n\\par}}\n"); }

void	chn_typ::PutCHA_HEADER(FILE *fptr)
{
    fprintf(fptr,"{\\rtf1\\ansi \\deff4\\deflang1033");
    fprintf(fptr,"{\\fonttbl{\\f0\\froman\\fcharset0\\fprq2 Tms Rmn;}\n");
    fprintf(fptr,"{\\f1\\fswiss\\fcharset0\\fprq2 Arial;}\n");
    fprintf(fptr,"{\\f2\\fswiss\\fcharset0\\fprq2 Arial Narrow;}\n");
    fprintf(fptr,"{\\f3\\fmodern\\fcharset0\\fprq1 Courier New;}\n");
    fprintf(fptr,"{\\f4\\froman\\fcharset0\\fprq2 Times New Roman;}\n");
    fprintf(fptr,"{\\f5\\fswiss\\fcharset0\\fprq2 System;}\n");
    fprintf(fptr,"{\\f6\\fmodern\\fcharset0\\fprq1 Courier New;}}\n");
    this->clr->PutRtfColorTbl(fptr);
    fprintf(fptr,"{\\stylesheet{\\widctlpar \\f4\\fs%d \\snext0 Normal;}",fontsize);
    fprintf(fptr,"{\\*\\cs10 \\additive Default Paragraph Font;}}\n");
#if 1	// Test header
{
    fprintf(fptr,"{\\header \\pard\\plain \\qr \\widctlpar \\b\\f2\\fs%d \n",fontsize+2);
    time_t time0=time(0);
    struct tm *tp;	// the returned tp is static; don't try to free this. Is not thread safe!
    if(tp=localtime(&time0)){
       char min_str[10];
       if(tp->tm_min < 10) sprintf(min_str,":0%d",tp->tm_min);
       else sprintf(min_str,":%d",tp->tm_min);
       fprintf(fptr,"{%s (%d%s - %d/%d/%d) page }\n", output_name,
                tp->tm_hour,min_str,tp->tm_mon+1,tp->tm_mday,tp->tm_year+1900);
    } else fprintf(fptr,"{ %s page }\n",output_name); // NEW: filename at top.
    // fprintf(fptr,"{\\field{\\*\\fldinst { PAGE }}}{ \\par }}\n",fontsize+2);
    fprintf(fptr,"{\\field{\\*\\fldinst { PAGE }}}{ \\par }}\n");
}
#endif

    switch(PageSetUp){
	  case 'l': // 8.5" x 11" landscape.
	   // fprintf(fptr,"\\paperw15840\\paperh12240\\margl720\\margr720");
	   fprintf(fptr,"\\paperw15840\\paperh12240\\margl1440\\margr1440");
    	   fprintf(fptr,"\\margt1080\\margb1080 ");
    	   fprintf(fptr,"\\widowctrl\\ftnbj\\aenddoc\\formshade \\fet0\\sectd ");
    	   // fprintf(fptr,"\\lndscpsxn\\psz1\\linex0\\endnhere \n");
    	   fprintf(fptr,"\\lndscpsxn\\psz1\\linex0\\headery360\\endnhere \n"); // header high up
    	   // page_width=12000.0;
	   break;
	  case 'L': // 11" x 17" landscape
	   // fprintf(fptr,"\\paperw24480\\paperh15840\\margl720\\margr720");
	   fprintf(fptr,"\\paperw24480\\paperh15840\\margl1440\\margr1440");
	   fprintf(fptr,"\\margt1080\\margb1080 ");
	   fprintf(fptr,"\\widowctrl\\ftnbj\\aenddoc\\formshade \\fet0\\sectd ");
    	   // fprintf(fptr,"\\lndscpsxn\\psz1\\linex0\\endnhere \n");
    	   fprintf(fptr,"\\lndscpsxn\\psz1\\linex0\\headery360\\endnhere \n");
	   // print_error("PutCHA_HEADER( ) 11\" x 17\" landscape not yet implemented");
	   break;
	  case 'p': // 8.5" x 11" portrait.
	   // fprintf(fptr,"\\paperw12240\\paperh15840\\margl720\\margr720");
	   fprintf(fptr,"\\paperw12240\\paperh15840\\margl1440\\margr1440");
    	   fprintf(fptr,"\\margt1080\\margb1080 ");
    	   fprintf(fptr,"\\widowctrl\\ftnbj\\aenddoc\\formshade \\fet0\\sectd ");
           // fprintf(fptr,"\\linex0\\endnhere\\sectdefaultcl \n");
           fprintf(fptr,"\\linex0\\headery360\\endnhere\\sectdefaultcl \n");
	   // page_width=7000.0;
	   break;
	  case 'P': // 11" x 17" portrait.
	   //fprintf(fptr,"\\paperw15840\\paperh24480\\margl720\\margr720");
	   fprintf(fptr,"\\paperw15840\\paperh24480\\margl1440\\margr1440");
           fprintf(fptr,"\\margt1080\\margb1080 ");
           fprintf(fptr,"\\widowctrl\\ftnbj\\aenddoc\\formshade \\fet0\\sectd ");
           // fprintf(fptr,"\\linex0\\endnhere\\sectdefaultcl \n");
           fprintf(fptr,"\\linex0\\headery360\\endnhere\\sectdefaultcl \n");
            // page_width=12000.0;
	   break;
	  default: print_error("PutCHA_HEADER( ) PageSetUp input error");
    }
    fprintf(fptr,"\\pard\\plain \\widctlpar \\f3\\fs%d \n",fontsize);
    fprintf(fptr,"\\pard \\widctlpar \\sl180\\slmult1 ");
#if 1
    if(StdAlignmentOnly) fprintf(fptr,"{\\b\\f2\\fs%d\\cf1 %s }{\\f3 \n\\par }\n",
		fontsize+4,NameCMSA(IN_CMA[1])); // top.
    else fprintf(fptr,"{\\b\\f2\\fs%d\\cf1 %s }{\\f3 \n\\par }\n",
		fontsize+4,output_name); // NEW: filename at top.
#else
    time_t time0=time(0);
    struct tm *tp;
    if(tp=localtime(&time0)){
       fprintf(fptr,"{\\b\\f2\\fs%d\\cf1 %s (%d:%d - %d/%d/%d) }{\\f3 \n\\par }\n",
		fontsize+2,output_name,
                tp->tm_hour,tp->tm_min,tp->tm_mon+1,tp->tm_mday,tp->tm_year+1900);
    } else 
    fprintf(fptr,"{\\b\\f2\\fs%d\\cf1 %s }{\\f3 \n\\par }\n",
		fontsize+2,output_name); // NEW: filename at top.
#endif
}

char    chn_typ::FractionToCharPBC(double fract)
{
    const char rtn[]="0123456789!!!";
    Int4 f = (Int4) floor(10.0*fract);
    if(f >= 0 && f <= 10) return rtn[f]; else return '?';
}

void	chn_typ::InitAnalysis()
{
    NumAnalIndex=NumAnalysis;
    assert(NumAnalysis < MAX_ALN_CHN_TYP);
    if(BG_CMA){ 
      AnalysisList[0]=0; anal_index=NumAnalysis+1; 
      for(Analysis=1; Analysis <= NumAnalysis+1; Analysis++){
	   AnalysisList[Analysis] = anal_index; anal_index--;
      } NumAnalIndex=NumAnalysis+2; AnalysisList[NumAnalIndex]=1;
      assert(Analysis==NumAnalysis+2);
    } else {
      AnalysisList[0]=0; anal_index=NumAnalysis; 
      for(Analysis=1; Analysis <= NumAnalysis; Analysis++){
	   AnalysisList[Analysis] = anal_index; anal_index--;
      } NumAnalIndex=NumAnalysis+1; AnalysisList[NumAnalIndex]=1;
    }
    //*************** Show insert lengths only ********************
    GNULL=gnullSMA(1,MA);
    if(maxlen_gnull < INT4_MAX){
       gnull_insrt_len = gnullInsrtLenSMA(1,MA);
#if 0
       for(j=0; j < glengthSMA(1,MA); j++){
	fprintf(stdout,"gnull[%d] = %c %d\n",j,GNULL[j],gnull_insrt_len[j]);
       }
#endif
    } else gnull_insrt_len=0;
}

Int4 chn_typ::ClassifyResPos()
// Classify residue positions for 3-tier hierarchies.
{
    if(NumAnalysis!=3 && status){	// 'status' is Generated by BPPS procedure...
     for(Int4 na=1; na <= NumAnalysis; na++){
      if(status[na]){
	Int4 NumCols = rtf[na]->FixSetStatus(status[na],rtfQ[na]);
	double FractHighlite;
	if(PatternOnlyMode) FractHighlite = 1.01*(double)NumCols/(double) rtf[na]->Length();
	else FractHighlite = 1.1*(double)NumCols/(double) rtf[na]->Length();
	if(FractHighlite > 1.0) FractHighlite = 1.0;
	if(FractHighlite <= 0.0) FractHighlite = 0.10;
	if(InputFraction) FractHighlite=FractHighlight;
	rtf[na]->ReInit(FractHighlite,-cbp_cut);
	if(extra_files) fprintf(stderr,"fixed status = %s\n",status[na]+1);
      }
     }
    } else if(NumAnalysis==3 && status && status[2]){	// 'status' Generated by BPPS
      Int4 NumCols = rtf[2]->FixSetStatus(status[2],rtfQ[2]);
      double FractHighlite;
      if(PatternOnlyMode) FractHighlite = 1.01*(double)NumCols/(double) rtf[2]->Length();
      else FractHighlite = 1.1*(double)NumCols/(double) rtf[2]->Length();
      if(FractHighlite > 1.0) FractHighlite = 1.0;
      if(FractHighlite <= 0.0) FractHighlite = 0.10;
      if(InputFraction) FractHighlite=FractHighlight;
      rtf[2]->ReInit(FractHighlite,-cbp_cut);
      if(extra_files) fprintf(stderr,"fixed status = %s\n",status[2]+1);
      for(anal_index=0; anal_index <= NumAnalIndex; anal_index++){
	   Analysis=AnalysisList[anal_index];
	   if(status[2] && status[Analysis] == 0){
	    if(Analysis == 3){ // main set.
	        // use ave col_prob for '!' in status[2][j] to find
	        //  cutoff for main set histogram.
	        // Get mainset status using columns in 
	        // status[Analysis] = rtf[Analysis]->DeriveStatus(status[2],rtfQ[Analysis],'M');
	        status[Analysis] = rtf[Analysis]->DeriveStatus(status[2],rtf[Analysis],'M');
		if(status[Analysis] !=0){
		   // fprintf(stderr,"DEBUG: status = %s\n",status[Analysis]+1);
		   NumCols = rtf[Analysis]->FixSetStatus(status[Analysis],rtfQ[Analysis]);
#if 0
		   fprintf(stderr,"Fixed status = %s\n",status[Analysis]+1);
		   fprintf(stderr,"NumCols = %d\n",NumCols);
#endif
      		   if(PatternOnlyMode) FractHighlite = 
				1.01*(double)NumCols/(double) rtf[Analysis]->Length();
      		   else FractHighlite = 1.1*(double)NumCols/(double) rtf[Analysis]->Length();
      		   if(FractHighlite > 1.0) FractHighlite = 1.0;
      		   if(FractHighlite <= 0.0) FractHighlite = 0.10;
      		   if(InputFraction) FractHighlite=FractHighlight;
      		   rtf[Analysis]->ReInit(FractHighlite,-cbp_cut);
		}
	    } else if(Analysis == 1){ // Family set.
	        status[Analysis] = rtf[Analysis]->DeriveStatus(status[2],rtfQ[Analysis],'F');
		if(status[Analysis] !=0){
		   NumCols = rtf[Analysis]->FixSetStatus(status[Analysis],rtfQ[Analysis]);
      		   FractHighlite = 1.5*(double)NumCols/(double) rtf[Analysis]->Length();
      		   if(FractHighlite > 1.0) FractHighlite = 1.0;
      		   if(FractHighlite <= 0.0) FractHighlite = 0.10;
      		   if(InputFraction) FractHighlite=FractHighlight;
      		   rtf[Analysis]->ReInit(FractHighlite,-cbp_cut);
		}
	    }
	   }
      }
      if(status[4]){ free(status[4]); status[4]=0; }
      if(BG_CMA && use_bg_cma){	// then determine status based on Main Set (Analysis=3).
	        // status[4] = rtf[4]->DeriveStatus(status[3],rtfQ[4],'M');
	        status[4] = rtf[4]->DeriveStatus(status[3],rtf[4],'M');
#if 0
	        for(i=1; i <= rtf[0]->Length(); i++){
	           if(status[4][i] == '?') { status[4][i]='!'; }
	       	}
	fprintf(stderr,"Raw status = %s\n",status[4]+1);
#endif
		// fprintf(stderr,"status = %s\n",status[4]+1);
		NumCols = rtf[4]->FixSetStatus(status[4],rtfQ[4]);
#if 0
	fprintf(stderr,"Fixed status = %s\n",status[4]+1);
	fprintf(stderr,"NumCols = %d\n",NumCols);
#endif
      		if(PatternOnlyMode) FractHighlite = 
				1.01*(double)NumCols/(double) rtf[4]->Length();
      		else FractHighlite = 1.1*(double)NumCols/(double) rtf[4]->Length();
      		if(FractHighlite > 1.0) FractHighlite = 1.0;
      		if(FractHighlite <= 0.0) FractHighlite = 0.10;
      		if(InputFraction) FractHighlite=FractHighlight;
      		rtf[4]->ReInit(FractHighlite,-cbp_cut);
      }
      if(status[0] == 0){	// Intermediate Categories...
	char	*tmp_status;
        Int4    i,n;
        NEW(tmp_status,rtf[0]->Length()+3,char);
        for(i=1; i <= rtf[0]->Length(); i++){
	   tmp_status[i]='*';
           for(n=1; n<=4; n++){
                if(status[n] && status[n][i] != '*') { tmp_status[i]='!'; break; }
	   }
        }
        if(extra_files) fprintf(stderr,"tmp status = %s\n",tmp_status+1);
	status[0] = rtf[0]->DeriveStatus(tmp_status,rtfQ[0],'I');
        if(extra_files) fprintf(stderr,"intermediate status = %s\n",status[0]+1);
	free(tmp_status);
      }
    }
}

Int4	*chn_typ::PosOfKeySq()
{
// Numbering based on an aligned sequence 
    Int4 i,*pos_key_seq=0;
    if(pos_key_seq ==0 && Seq4numbering > 0){
	if(nseqSMA(MA) < Seq4numbering){
	   print_error("Sequence for numbering doesn't exist");
	}
        NEW(pos_key_seq,glengthSMA(1,MA)+3,Int4); // residue number at each position.
	Int4 current_pos=startSMA(1,Seq4numbering,MA);
	// ^ block 1, sequence 'Seq4numbering'.
        char *gseq=gseqSMA(1,Seq4numbering,MA); 
// fprintf(stderr,"seq %d(%d): %s\n",Seq4numbering,current_pos,gseq); exit(0);
	if(!isalpha(gseq[0])) current_pos++; // gap at start --> true start is 1 ahead;
	for(i=0; i < glengthSMA(1,MA); i++){
	   if(isalpha(gseq[i])){ pos_key_seq[i]=current_pos; current_pos++; }
	   else pos_key_seq[i]=current_pos;
        }
    }
    return pos_key_seq;
}

Int4	chn_typ::GetSqIndices(Int4 gstart)
// Get sequence indices... 
{
    Int4 i,j,n;
    for(anal_index=0; anal_index <= NumAnalIndex; anal_index++){
        NEW(sq_index[anal_index],nseqSMA(MA)+2,Int4);
        for(n=1; n<= nseqSMA(MA); n++) {
	   sq_index[anal_index][n]=startSMA(1,n,MA);
           char *gseq= gseqSMA(1,n,MA);
	   // Repair problem with gaps at beginning...
	   // If gap at start then true start is one position ahead of startSMA();
	   if(!isalpha(gseq[0])) sq_index[anal_index][n]++; // 
	   // FIX PROBLEM WITH GAPS AT START...WITH -B OPTION
	   // for(i=0,j=0; j < (Begin + leng_start_gap); i++)
	   for(i=0; i<gstart; i++) if(isalpha(gseq[i])){ sq_index[anal_index][n]++; }
	}
    } return n;
}

void	chn_typ::PutCHA(FILE *fptr, const char *ColorFont)
// Create an alignment figure for publication:
// Use this routine when have only one gapped 'block'.
{
	Int4	i,j,n,N;
	char	r,c,str[50];
    Int4	next_start,start;
    Int4	gstart=0,gend;
    Int4	color,colorB;

    assert(ntypSMA(MA)==1);
    this->InitAnalysis();
    this->ClassifyResPos();
    this->PageOfCHA(fptr, ColorFont);
   // fprintf(fptr,"\\pard \\widctlpar \\sl180\\slmult1 {\\f3\n\\par\n\\par }\n");
}

