
/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cps_typ.h"
#include "compass_usage.h"

int	cps_typ::Prepare()
{
	Int4	arg,i,j,k,x;
	//===============================================================
	//==== routine for obtaining MSAs with the same sequence set ====
	//===============================================================
	cma_typ *eqcma=RtnCommonCMSA(cmaA,cmaB);
	cma_typ cmaI=eqcma[1],cmaJ=eqcma[2]; free(eqcma);
	Int4 N,*list,I,J,nI=NumSeqsCMSA(cmaI),nJ=NumSeqsCMSA(cmaJ);
	BooLean *skip; NEW(skip,nJ+3,BooLean);
	NEW(list, nJ+3,Int4); 
	assert(nJ == nI);
	e_type  sqI,sqJ;
	for(N=0,I=1; I <= nI; I++){
	    sqI=TrueSeqCMSA(I,cmaI);
	    for(J=1; J <= nJ; J++){
	   	sqJ=TrueSeqCMSA(J,cmaJ);
		if(IsTheSameSeqID(sqI,sqJ)){
		   Int4 rtn,AdjstI,MinOverlap=10,NumX,NumM;
	           rtn=this->IsSameSeq(sqI,sqJ,&AdjstI,MinOverlap,NumX,NumM);
	           if(rtn == 0 || NumX > NumM){
		      StrSeqID(str,20,sqI);
		      // fprintf(stderr,"Seqs fail to match %s; skipping\n",str);
		      if(efp){
		 	AlnSeqSW(efp,11,1,sqI,sqJ,AB); 
			fprintf(efp,"%s: rtn=%d; Adjst=%d\n",str,rtn,AdjstI);
		      } 
	   	   } else { N++; list[I]=J; break; }
		}
	    }
	}
	assert(N == nJ);
	// PutSelectOneCMSA(stderr,skip,list,cmaJ);
	FILE *tfp=tmpfile(); PutSelectOneCMSA(tfp,skip,list,cmaJ); rewind(tfp); 
	TotalNilCMSA(cmaJ);  cmaJ=ReadCMSA(tfp,AB); fclose(tfp);
	free(list); free(skip);
	  //========== end fill in sequence sets ===========
	WriteCMSA("msa1",cmaI); WriteCMSA("msa2",cmaJ);
#if 1	// find pdbIDs and common columns:
	char **pdb_ids; NEWP(pdb_ids,nI+5, char);
	char **Oper[4],rtn;
	NEWP(Oper[1],nI+5, char); NEWP(Oper[2],nJ+5, char);
        gss_typ *gssI=gssCMSA(cmaI);
        gss_typ *gssJ=gssCMSA(cmaJ);
	for(I=1; I <= nI; I++){
		sqI=TrueSeqCMSA(I,cmaI); sqJ=TrueSeqCMSA(I,cmaJ);
		StrSeqID(str,10,sqI);
		if(strlen(str) != 6) continue;
                if(str[4] != '_') continue;
                if(!isdigit(str[0])) continue;
		pdb_ids[I]=AllocString(str);
		Oper[1][I]=gssI->Operation(I);
		Oper[2][I]=gssJ->Operation(J);
		Int4 Start,MinOverlap=10;
		rtn=IsSameSeqFast(sqI,sqJ,&Start,MinOverlap);
		if(rtn == 1){	// sqI lacks an N-terminal extension.
		   Start *=-1;  
		} else if(rtn == 2){ ; // sqJ lacks an N-terminal extension.
		} else { ; }
#if 0
		fprintf(stderr,"%s (%d):\n %s\n  %s\n\n",
			pdb_ids[I],Start,Oper[1][I],Oper[2][I]);
		AlnSeqSW(stderr,11,1,sqI,sqJ,AB);
		PutSeq(stderr,sqI,AB);
		PutSeq(stderr,sqJ,AB);
#endif
	}
#endif
	return 0;
#if 0	// for each pdbID find the colums in common.
	// find the positions in KeySeq that map to columns in both MSAs.
	// cma2aln
        Int4    sqA,sqB;
        gss_typ *gssA=gssCMSA(cmaA);
        gss_typ *gssB=gssCMSA(cmaA);
        char    *gssA->Operation(sqA);
        char    *gssB->Operation(sqB);
	return 0;
#endif
	WriteCMSA("alnA.cma",eqcma[1]); WriteCMSA("alnB.cma",eqcma[2]);
	return 0;
}

