
/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cps_typ.h"
#include "compass_usage.h"

char **cps_typ::GetKeyPDB(char *file, Int4 &num)
{
	Int4	i,j;
	FILE *tfp=open_file(file,"","r");	
	char	tmp[20],**Rtn; 
	for(i=0; fgets(tmp,20,tfp) != NULL; ) i++;
	num=i; rewind(tfp); NEWP(Rtn, num +3, char);
	for(i=0; fgets(tmp,20,tfp) != NULL; ){
	    i++; Rtn[i]=AllocString(tmp);
	} fclose(tfp);
	return Rtn;
}

void	cps_typ::Init( )
//================================================================
//============= Open input MSAs & set parameters =================
//================================================================
{ 
	Int4	arg,i,j,k,x;
	double	dd;

	if(argc < 3){
		fprintf(stderr,"%s\n",COMPASS_VERSION);
		print_error(USAGE_COMPASS);
	}
	PutCommonMSAs=FALSE;
	UseGoldStd=FALSE;
	PercentID=65;
	MaxXIJ=50;
	SignCut_dS=0.0;
	ccm_wt=0.8; ccm_LF=0.2;
	ArgV=0; ArgC=0; // KeyPDB=0; NumKeyPDB=0; KeyPDBID=0;
	mxD=4.0; // increase distance to 4 Angstroms...
	hpsz=50; minSpace=5; stdev=0;
	pdb_id=0; outfp=0; logfp=0; cutoff=2.0; Seed=18364592; verbose=FALSE;
	gpu_num=-1; thrds=0; time1=time(NULL);
	KeepAllOut=FALSE; CutDel=50.0;
// KeepAllOut=TRUE; CutDel=150.0;
	RtnI=0; RtnJ=0;
	NumRefStrctReject[0]=NumRefStrctReject[1]=NumRefStrctReject[2]=0;
	NumMissingStrct=NumAlignedStrct=NumBadStrct=NumNoMatStrct=0;
	NumBadMstStrct=0; 
	NEW(Str,10005,char);
	name1=BaseName(argv[1]); if(name1 == 0) name1 = AllocString(argv[1]);
	name2=BaseName(argv[2]); if(name2 == 0) name2 = AllocString(argv[2]);
        // fprintf(stderr,"BaseNames='%s' and '%s'\n",name1,name2);
	AB=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
	efp=0;
	if(argc < 3){
		fprintf(stderr,"%s\n",COMPASS_VERSION); print_error(USAGE_COMPASS);
	} else if(argc == 3 || argv[3][0] == '-'){
		arg=3; mode='C'; // check MSAs only.
	} else { arg=4; mode='R'; } // Run COMPASS.
	//==============================================================
	if(strcmp(argv[1],argv[2]) == 0) print_error("FATAL: input files identical"); 
	for( ; arg < argc; arg++){
           if(argv[arg][0] != '-') print_error(USAGE_COMPASS);
	   switch(argv[arg][1]) {
	      case 'c':
                  if(sscanf(argv[arg],"-ccm_wt=%f",&ccm_wt) == 1){
		      if(ccm_wt > 0.9f || ccm_wt  < 0.3f){  // default: 0.8f
                        print_error("-ccm_wt option input out of range (.01-2)");
		      } 
                  } else if(sscanf(argv[arg],"-ccm_LF=%f",&ccm_LF) == 1){
		      if(ccm_LF > 2.0f || ccm_LF  < 0.01f){  // default: 0.8f
                        print_error("-ccm_LF option input out of range (.01-2)");
		      } 
		  } else if(sscanf(argv[arg],"-cut=%lf",&dd) != 1){
			print_error(USAGE_COMPASS);
                  } else if(dd < 0.0) print_error(USAGE_COMPASS); else cutoff=dd;
		  break;
	      case 'd':
                  if(sscanf(argv[arg],"-dScut=%lf",&SignCut_dS) == 1){
			if(SignCut_dS < 0.0 || SignCut_dS > 3.0){
				print_error(USAGE_COMPASS);	
			}
                  } else if(sscanf(argv[arg],"-dev=%d",&x) != 1){
			 print_error(USAGE_COMPASS);
                  } else if(x < 0) print_error(USAGE_COMPASS); else gpu_num=x;
                  break;
	      case 'k':
		  if(strcmp("-keep",argv[arg])==0) { KeepAllOut=TRUE; CutDel=100.0; } 
                  else print_error(USAGE_COMPASS);
		  break;
	      case 'm':
                  if(sscanf(argv[arg],"-maxX=%d",&MaxXIJ) == 1){
			if(MaxXIJ < 0 || MaxXIJ > 100) print_error(USAGE_COMPASS);
                  } else if(sscanf(argv[arg],"-maxD=%lf",&mxD) != 1){
			print_error(USAGE_COMPASS);
                  } else if(mxD < 3.0 || mxD > 9.0) print_error(USAGE_COMPASS); 
                  break;
	      case 'p':
		  if(strcmp("-preMSA",argv[arg])==0) { PutCommonMSAs=TRUE; }
                  else if(sscanf(argv[arg],"-pc=%d",&x) != 1) print_error(USAGE_COMPASS);
                  else if(x < 0 || x > 100) print_error(USAGE_COMPASS); 
		  else PercentID=x;
                  break;
              case 't':
                  if(sscanf(argv[arg],"-thrds=%d",&x) != 1) print_error(USAGE_COMPASS);
                  else if(x < 1) print_error(USAGE_COMPASS); else thrds=x;
                  break;
              case 's':
		  if(strcmp("-std",argv[arg])==0) { UseGoldStd=TRUE; }
                  else if(sscanf(argv[arg],"-seed=%u",&Seed) != 1) print_error(USAGE_COMPASS);
                  break;
              case 'v':
		if(strcmp("-verbose",argv[arg])==0) { verbose=TRUE; }
		else print_error(USAGE_COMPASS);
		break;
              default : print_error(USAGE_COMPASS); break;
	   }
	}
        if(Seed == 18364592){
             Seed = (UInt4) time(NULL);      // else Seed was set above
        } 
#if defined(_OPENMP)
 	 if(thrds > 0){
		Int4 Nt=0;
		Int4 max_thrd=1; max_thrd=omp_get_max_threads();
		if(thrds > max_thrd) Nt=max_thrd; else Nt=thrds;
		sRand_R(Seed,Nt);
	} else
#endif
    	{
		sRandom(Seed);	// this is causing compilation problems...
    	}
	FILE	*fp=0;
        //====================================================================
        // 2. Read in two MSAs in cma format.
        //====================================================================
	fp=open_file(argv[1],"","r"); cmaA=ReadCMSA(fp,AB); fclose(fp);
	fp=open_file(argv[2],"","r"); cmaB=ReadCMSA(fp,AB); fclose(fp);
	if(cmaA==0 || cmaB==0) print_error("Fatal: MSA file format error");

	LenA=LengthCMSA(1,cmaA); LenB=LengthCMSA(1,cmaB);
	if(verbose) efp=stderr;

	//============= Open output files =============
	if(mode=='R' && !PutCommonMSAs){
          sprintf(str,"%s_%s",argv[1],name2);
          logfp=open_file(str,".log","w");
          for(Int4 arg=0; arg < argc; arg++) fprintf(logfp,"%s ",argv[arg]);
          fprintf(logfp,"-seed=%u\n",Seed); fflush(logfp);

          sprintf(str,"%s_%s",argv[1],name2);
          outfp=open_file(str,".cmps","w");
	} else outfp=stderr;
	NN=0; MaxPCID=0; PCALN[1]=PCALN[2]=0;
}

void	cps_typ::Free()
{
	Int4	x,i,j;
        char	c;
	if(outfp && !PutCommonMSAs){
	   fclose(outfp); outfp=0; 
           // sprintf(str,"%s_%s",argv[1],argv[2]);
	   sprintf(str,"%s_%s",argv[1],name2);
           outfp=open_file(str,".cmps","r");
           while((c=fgetc(outfp))!=EOF) fprintf(stdout,"%c",c);
	   if(outfp != stderr) fclose(outfp); outfp=0;
	}
	free(Str);
	if(MaxPCID) free(MaxPCID);
	if(PCALN[1]) free(PCALN[1]);
	if(PCALN[2]) free(PCALN[2]);

        // free up arrays
	free(name2); free(name1); 
        if(RtnI){ free(RtnI[1]); free(RtnI[2]); free(RtnI); }
	if(RtnJ){ free(RtnJ[1]); free(RtnJ[2]); free(RtnJ); }
        for(j=1; j <= NN; j++){
            NilSeq(SEQ[j]);
            NilPDB(PDB[j]); free(ResX[j]); free(ResY[j]); NilSet(UsdSet[j]);
            free(PDBID[j]); delete DCH[1][j]; delete DCH[2][j];
        } free(PDB); free(CHN); free(ResX); free(ResY);
        free(DCH[1]); free(DCH[2]); free(SEQ); free(PDBID);
        free(AdjstX); free(AdjstY); free(UsdSet); 
        for(x=1; x <= NumPDB_ID; x++) if(pdb_id[x]) free(pdb_id[x]); free(pdb_id);

	FILE *fp;
	sprintf(str,"%s_X_sprc_X.dca",argv[1]); fp=fopen(str,"r"); 
	if(fp){ fclose(fp); if(1) std::remove(str); }
	sprintf(str,"%s_X_sprc_X.dca",argv[2]); fp=fopen(str,"r"); 
	if(fp){ fclose(fp); if(1) std::remove(str); }

	sprintf(str,"%s_X_sprc_X.cmps",argv[1]); fp=fopen(str,"r"); 
	if(fp){ fclose(fp); if(1) std::remove(str); }
	sprintf(str,"%s_X_sprc_X.cmps",argv[2]); fp=fopen(str,"r"); 
	if(fp){ fclose(fp); if(1) std::remove(str); }

	sprintf(str,"%s_X_sprc_X",argv[1]); fp=fopen(str,"r"); 
	if(fp){ fclose(fp); if(1) std::remove(str); }
	sprintf(str,"%s_X_sprc_X",argv[2]); fp=fopen(str,"r"); 
	if(fp){ fclose(fp); if(1) std::remove(str); }

	sprintf(str,"%s_X_sprc.in",argv[1]); fp=fopen(str,"r"); 
	if(fp){ fclose(fp); if(1) std::remove(str); }
	sprintf(str,"%s_X_sprc.in",argv[2]); fp=fopen(str,"r"); 
	if(fp){ fclose(fp); if(1) std::remove(str); }

	sprintf(str,"%s_X",argv[1]); fp=fopen(str,"r"); 
	if(fp){ fclose(fp); if(1) std::remove(str); }
	sprintf(str,"%s_X",argv[2]); fp=fopen(str,"r"); 
	if(fp){ fclose(fp); if(1) std::remove(str); }
    if(PutCommonMSAs == FALSE){
	  sprintf(str,"%s_X_sprc_X.mst",argv[1]); fp=fopen(str,"r"); 
	  if(fp){ fclose(fp); if(1) std::remove(str); }
	  sprintf(str,"%s_X_sprc_X.mst",argv[2]); fp=fopen(str,"r"); 
	  if(fp){ fclose(fp); if(1) std::remove(str); }
    } else { 	// make modified msa files for simulation SP_scores
	char sqA[1005],sqB[1005],*sA,*sB;
	sprintf(str,"%s_X_sprc_X.mst",argv[1]); fp=fopen(str,"r"); 
	assert(fgets(sqA,1000,fp) != NULL);
	if(fp){ fclose(fp); if(1) std::remove(str); }

	sprintf(str,"%s_X_sprc_X.mst",argv[2]); fp=fopen(str,"r"); 
	if(fgets(sqB,1000,fp) == NULL){
		print_error("fatal error: mst file is empty!");
	}
	if(fp){ fclose(fp); if(1) std::remove(str); }

	for(i=0; !isspace(sqA[i]); i++) assert(sqA[i] != 0);
	for( ; isspace(sqA[i]); i++) assert(sqA[i] != 0);
	
	set_typ SetA=MakeSet(LengthCMSA(1,cmaA)+5); ClearSet(SetA);
	set_typ SetB=MakeSet(LengthCMSA(1,cmaB)+5); ClearSet(SetB);
	for(j=0; !isspace(sqB[j]); j++) assert(sqB[j] != 0);
	for( ; isspace(sqB[j]); j++) assert(sqB[j] != 0);
	// fprintf(stderr,"1. %s\n2. %s\n",sqA+i,sqB+j);
	Int4	X=0,I=0,J=0;
	do {
	    char A,B,a=sqA[i],b=sqB[j],c=' ';
	    if(a != 0 && !isspace(a)){
	      if(a == '-') A=0; else if(islower(a)) A=toupper(a); else A=a;
	    } else A = -1;
	    if(b != 0 && ! isspace(b)){
	      if(b == '-') B=0; else if(islower(b)) B=toupper(b); else B=b;
	    } else B = -1;
	    if(A == 0 && B == 0){		// both deleted.
		i++; j++; I++; J++;
	    } else if(A > 0 && B == 0){		// only B deleted;
		j++; J++;
	    } else if(A == 0 && B > 0){		// only A deleted
		i++; I++; 
	    } else if(a == A && b == B){	// both aligned
		I++; J++; i++; j++;
		AddSet(I,SetA); AddSet(J,SetB); c='*';
	    } else if(a != A && b == B){	// only A is inserted
		i++; J++; j++;
	    } else if(a == A && b != B){	// only B is inserted
		I++; i++; j++;
	    } else {				// both are inserted
		i++; j++;
	    }
	    if(0 && sqA[i] != 0 && sqB[j] != 0){
	      X++;
	      fprintf(stderr,"%d. %c%d(%d) %c%d(%d)%c\n",X,a,I,i,b,J,j,c);
	    }
	} while(sqA[i] != 0 && sqB[j] != 0);
	// fprintf(stderr,"Size SetA = %d; SetB = %d\n",CardSet(SetA),CardSet(SetB));
	// PutSet(stderr,SetA); PutSet(stderr,SetB);
	cma_typ xcma=0;
	Int4	limit=4,len;
	for(i=LengthCMSA(1,cmaA); i > 0; i--){
	   len=LengthCMSA(1,cmaA);
	   if(!MemberSet(i,SetA)){
	      if(i == 1) xcma=TrimBlkCMSA(cmaA,1,1,0,limit);
              else if(i == len) xcma=TrimBlkCMSA(cmaA,1,0,1,limit);
	      else xcma=ConvertColsToInsertsCMSA(cmaA,1,i,i); 
	      NilCMSA(cmaA); cmaA=xcma;
	   }
	}
	for(i=LengthCMSA(1,cmaB); i > 0; i--){
	   len=LengthCMSA(1,cmaB);
	   if(!MemberSet(i,SetB)){
	      if(i == 1) xcma=TrimBlkCMSA(cmaB,1,1,0,limit);
              else if(i == len) xcma=TrimBlkCMSA(cmaB,1,0,1,limit);
	      else xcma=ConvertColsToInsertsCMSA(cmaB,1,i,i); 
	      NilCMSA(cmaB); cmaB=xcma;
	   }
	}
	fp=open_file(argv[1],"_Z","w");
	PutCMSA(fp,cmaA); fclose(fp);
	fp=open_file(argv[2],"_Z","w");
	PutCMSA(fp,cmaB); fclose(fp);
    }
	TotalNilCMSA(cmaA); TotalNilCMSA(cmaB); NilAlpha(AB);
	fprintf(stdout,"\trun time: %d seconds (%0.2f minutes)\n\n",
                time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	if(logfp){ 
	    fprintf(logfp,"\trun time: %d seconds (%0.2f minutes)\n\n",
                time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	    fclose(logfp);
	}
}

