#if !defined (COMPASS_USAGE)
#define COMPASS_USAGE

#define COMPASS_VERSION "\
  ----------------------------------------------------\n\
     eCOMPASS v1.0 (December 20, 2021)\n\
     Devised and implemented by Andrew F. Neuwald\n\
     www.igs.umaryland.edu/labs/neuwald/compass/\n\
     Copyright 2021 The University of Maryland\n\
     Freely distributed under the MIT License\n\
  ----------------------------------------------------\n"

#define USAGE_COMPASS "\
Usage: ecompass <msa1> <msa2> <pdb_dir> [options]\n\
   or: ecompass <msa1> <msa2> \n\
     The second form confirms that the two files contain the same sequences\n\
        in the same order; if not, it will output files 'msa1' & 'msa2' \n\
        containing sequences shared by both files and in the same order.\n\
	WARNING: Whether msa1 or msa2 is named first can change the output files.\n\
     The input MSA files need to be in cma format; the 'ConvertMSA' program may\n\
        be used to convert from  fasta to cma format. ConvertMSA is available at:\n\
        www.igs.umaryland.edu/labs/neuwald/software/auxiliary/ \n\
   options:\n\
      -cut=<real>     Cutoff for outlier structural alignments (default: 2.0 stdev)\n\
      -ccm_wt=<float> CCMpred sequence reweighting identity threshold (default: 0.8)\n\
      -ccm_LF=<float> CCMpred pairwise regularization coefficients (default: 0.2)\n\
      -dScut=<float>  Discard from the BP calculation |dS| values < <float> (default: 0.0)\n\
      -dev=<int>      GPU device number to be used for CCMpred (default: -1 = none)\n\
      -keep           Keep outliers;  (default: remove outliers)\n\
      -maxD=<float>   Maximum 3D contact distance (default: 4.0; range 3.0 to 9.0)\n\
      -maxX=<int>     Maximum number of pdb 'X' residues (default: 50; range 0 to 100)\n\
      -pc=<int>       Remove all but 1 pdb seq among those sharing >= <int>\% identity\n\
                       (default: 65\%)\n\
      -preMSA         Output common column MSAs as <msa1>_Z and <msa2>_Z only\n\
      -seed=<int>     Provide a seed for the random number generator\n\
      -std            Treat the first MSA as a gold standard (changes output format)\n\
      -thrds=<int>    Number of CPU threads to be used for CCMpred (default: 1)\n\
      -verbose	      Print out diagnostic information (for debugging)\n\
-------------------------------------------------------------------------\n\
   input:\n\
     <msa1> |\n\
     <msa2>     Protein multiple sequence alignments (MSAs)in cma format\n\
     <pdb_dir>  Directory containing pdb files corresponding to proteins in the MSA\n\
   output:\n\
     <msa1>_<msa2>.log    Reported issues encountered during a run\n\
     <msa1>_<msa2>.cmps   Compass summary output file with scores\n\
     <msa1>_<msa2>.missed PDB identifiers in MSA but absent from <pdb_dir>\n\
   NOTE: Temporary files are created and later removed at the end of the run.\n\
   NOTE: Sequence identifiers corresponding to pdb coordinates should be in\n\
       NCBI style pdb format (e.g., '1ABC_A')\n\
     Ideally, the coordinate files should include hydrogen atoms.\n\
       Hydrogens may be added using either the h_add command within PyMOL\n\
           or the Reduce program by J. Michael Word: \n\
           (http:kinemage.biochem.duke.edu/software/reduce.php \n\
                 or https:github.com/rlabduke/reduce.git). \n\
     Names of the coordinate files need to be based on their pdb identifiers\n\
       in lower case (e.g., 1abc) followed by:\n\
            '_H.pdb' if hydrogens are present (e.g., 1abc_H.pdb) \n\
            '.pdb' if hydrogens are absent (e.g., 1abc.pdb).\n\
-------------------------------------------------------------------------\n\
   References: \n\
     Neuwald, A.F., Kolaczkowski, B.D. & Altschul, S.F. 2021. eCOMPASS: evaluative\n\
       Comparison of Multiple Protein Alignments by Statistical Score.\n\
       Bioinformatics 37:3456-63.\n\
     Neuwald, A.F. & Altschul S.F. 2018. Statistical Investigations of Protein\n\
       Residue Direct Couplings. PLoS Computational Biology 14(12):e1006237. \n\
     Seemayer S., Gruber M. & Söding J. CCMpred--fast and precise prediction \n\
       of protein residue-residue contacts from correlated mutations. \n\
       Bioinformatics. 2014. 30(21):3128-30.\n\
   Funding: National Institutes of Health, National Institute of General Medical \n\
       Sciences grant R01GM125878.\n\
   \n\n"

#endif
