/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "seqset.h"
#include "swaln.h"
#include "dheap.h"
#include "residues.h"
#include "set_typ.h"

#define WEIGHTS_USAGE "tweakseq fafile\n\
        -E=<fafile2> print out sq_ids from fafile & defline and seq from fafile2\n\
                     seq in fafile must be subseq of corresponding seq in fafile2\n\
        -e=<fafile2> print out sq_ids from fafile & defline and seq from fafile2\n\
                     seq in fafile must be subseq of another seq in fafile2 (don't need to be in order)\n\
        -F           output residue frequences for each sequence\n\
        -g           output sequences with only gi numbers on defline\n\
        -I=<file>    output sequences with gis given in <file>\n\
        -i           output sequences info line\n\
        -R=<int>     randomly select and output <int> of the sequences\n\
        -r           rename (arbitrarily) and output the sequences\n\
        -v           verbose (for debugging)\n\n"

char    FindSubSeq(Int4 *Start, Int4 *End,e_type E1, e_type E2)
// If E1 is a subseq of E2 return 1; else if E2 < E1 return 2;
// if E1 == E2 return 3; else return 0.
{
        Int4    sp,sb,end,nSb,nSp;
        char    subsq=0;
        unsigned char   *sup,*sub;
        BooLean IsSub=FALSE;

        if(LenSeq(E1)==LenSeq(E2)){ if(IdentSeqs(E1,E2)) return 3; else return 0; }
        if(LenSeq(E1) < LenSeq(E2)){
          sup=SeqPtr(E2); nSp=LenSeq(E2);
          sub=SeqPtr(E1); nSb=LenSeq(E1); subsq=1;
          end=LenSeq(E2)-LenSeq(E1)+1;
        } else {
          sup=SeqPtr(E1); nSp=LenSeq(E1);
          sub=SeqPtr(E2); nSb=LenSeq(E2); subsq=2;
          end=LenSeq(E1)-LenSeq(E2)+1;
        }
        for(Int4 st=1; st<= end; st++){
          for(IsSub=TRUE,sp=st,sb=1; sb <= nSb; sb++,sp++){
            if(sup[sp] != sub[sb]){ IsSub=FALSE; break; }
          } if(IsSub) {
		*Start=st;
		*End=st+sb-2;
		return subsq;
	    }
        } return 0;
}

void	PutSeqsBySeqID(FILE *ofp,ss_type data, char *seq_ids_file)
{
        Int4    i,j,I,J,N=NSeqsSeqSet(data),n;
	char	*ID_E;
	Int4	Number;
 	a_type	A=SeqSetA(data);
	BooLean	*skip,found;
	Int4 	num_names,namelen,NewNumber;
        char	c,*SeqName[100003]; // maximum of 100000 seqids 
        char	str[2000];

        FILE *fp = open_file(seq_ids_file,"","r");
#if 0
        for(namelen=0,n=0,num_names=0; (c=getc(fp)) != EOF; n++){
            if(n==0){
	        if(0 && !(isalnum(c)) && c!='|'){
		   fprintf(stderr,"c=%c\n",c);
		   print_error("PutSeqsBySeqID( ) error1");
		}
	    }
            if(c==',' || c == '\n'){
              num_names++;
	      if(num_names >= 100000) print_error("too many seqids");
              str[namelen]=0;
              SeqName[num_names]=NewString(str);
              fprintf(stderr,"Name %d: %s\n",num_names,SeqName[num_names]);
              namelen=0;
            } else if(isalnum(c) || c=='_' || c=='|'){
                        str[namelen]=c; namelen++;
            } else if(c != '\n'){
		str[namelen]=0;
		fprintf(stderr,"c= %c; str=%s\n",c,str);
		print_error("PutSeqsBySeqID() input file error2");
	    }
        } fclose(fp);
#else
        for(namelen=0,n=0,num_names=0; fgets(str,1000,fp) != NULL; n++){
              num_names++;
	      if(num_names >= 100000) print_error("too many seqids");
	      Int4 x=strlen(str); x--;
	      if(x > 0 && str[x] == '\n'){ str[x]=0; }
              SeqName[num_names]=NewString(str);
	}
#endif
 	Number=num_names;
	char seq_id[1000];
#if 1
	for(n=0,J=1; J <= N; J++){
	   e_type E = SeqSetE(J,data);	// get template sequence
	   StrSeqID(seq_id,80,E);
	   // fprintf(stderr,"%d. %s\n",J,seq_id);
	   for(I=1; I <= Number; I++){
		if(SeqName[I]==0) continue;
		// if(I==1) fprintf(stderr,"  %d. '%s'\n",I,SeqName[I]);
		if(strstr(seq_id,SeqName[I])!= NULL){
		   PutSeq(ofp,SeqSetE(J,data),A); 
		   free(SeqName[I]); SeqName[I]=0; break;
		}
	   }
	}
#if 0
	for(I=1; I <= Number; I++){
		if(SeqName[I]) fprintf(stderr,"  %d. '%s'\n",I,SeqName[I]);
	}
#endif
#else
	NEW(skip, N+4,BooLean);
	for(J=1; J <= N; J++) skip[J]=TRUE;
	set_typ Set=MakeSet(Number+1); ClearSet(Set);
	for(n=0,J=1; J <= N; J++){
	   // StrSeqID(char *str, Int4 n, e_type E);
	   // StrSeqID(seq_id,80,E);
	   found=FALSE;
	   for(I = 1; I <= Number; I++){
		if(StringInSeqInfo(SeqName[I],E)){ skip[J]=FALSE; found=TRUE; AddSet(I,Set); }
		// if(strcmp(seq_id,SeqName[I])==0) skip[J]=FALSE;
	   }
#if 0
	   if(!found) {
		PutSeqID(stderr,E);
		fprintf(stderr,": Sequence %d not found in identifier file.\n",J); 
	   } 
#endif
	} 
	for(J=1; J <= N; J++){
		if(!skip[J]) PutSeq(ofp,SeqSetE(J,data),A);
	}
	fprintf(stderr,"\n\n%d identifiers.\n",Number);
	for(I = 1; I <= Number; I++){
		if(!MemberSet(I,Set)) fprintf(stderr,"%s: identifier not found in cma file\n",SeqName[I]);
	} NilSet(Set); free(skip); 
#endif
}

#if 0	// moved to sequence.h
void    PutResFreqSeq(FILE *fptr,e_type E,a_type AB)
{
	Int4 	r,i,j;

	// added phylogenetic info...
	char	c;
	Int4	N,frq[30];
	for(r=0; r <= nAlpha(AB); r++) frq[r]=0;
	for(N=0,j=1; (Int4)j <= (Int4)E->n; j++) {
	   r= E->S[j]; frq[r]++; N++;
	   // fprintf(fptr,"%d: %c\n",r,AlphaChar(r,AB));
	}
	for(r=0; r <= nAlpha(AB); r++){
	   double d=(double)frq[r]/(double)N;
	   fprintf(fptr,"\n%c: %d; %.2lf%c",AlphaChar(r,AB),frq[r],100.0*d,'%');
	} fprintf(fptr,"\nTotal=%d.\n\n",N);
}
#endif

int	main(int argc,char *argv[])
{ 
	ss_type	P1 = NULL,P2=NULL;
	a_type	A;
	e_type	E1,E2;
	BooLean	found,usesubsq=FALSE;
	char	mode=' ',*fafile2=0;
	char	*seqid_file_name;
	Int4	RandOut=0;
	UInt4 seed=18364592;

	if(argc < 2) print_error(WEIGHTS_USAGE);
        for(Int4 arg = 2; arg < argc; arg++){
           if(argv[arg][0] != '-') print_error(WEIGHTS_USAGE);
           switch(argv[arg][1]) {
                case 'v': break;
                case 'g': mode='g'; break;
		case 'I': mode = 'I';
                 if(argv[arg][2] == '=') {  // -I=<file>
                   if(!isgraph(argv[arg][3])) print_error(WEIGHTS_USAGE);
                   seqid_file_name = argv[arg] + 3;
		 } break;
                case 'E': 
		    if(argv[arg][2] != '=') print_error(WEIGHTS_USAGE);
		    fafile2=argv[arg]+3; mode='E'; 
		    break;
                case 'e': 
		    if(argv[arg][2] != '=') print_error(WEIGHTS_USAGE);
		    fafile2=argv[arg]+3; mode='e'; 
		    break;
                case 'F': 
		    if(argv[arg][2] != 0) print_error(WEIGHTS_USAGE);
		     mode='F';
		    break;
                case 'i': 
		    if(argv[arg][2] != 0) print_error(WEIGHTS_USAGE);
		     mode='i';
		    break;
		case 'r': mode = 'r'; break;
		case 'R': mode = 'R';
		    if(sscanf(argv[arg],"-R=%d",&RandOut) == 1){
			if(RandOut < 1) print_error(WEIGHTS_USAGE);
		    } else print_error(WEIGHTS_USAGE);

		    break;
		case 's': if(sscanf(argv[arg],"-s%d",&seed)!=1) 
			print_error(WEIGHTS_USAGE); break;
                default: print_error(WEIGHTS_USAGE);
            }
        }
	if(seed == 18364592)  seed = (UInt4) time(NULL)/2;
	sRandom(seed);
	A = MkAlpha(AMINO_ACIDS,PROT_BLOSUM62); /****/
	P1 = SeqSet(argv[1],A); 
   	switch(mode){
    	 case 'F': {
	   Int4 n;
	   for(n=1; n <= NSeqsSeqSet(P1); n++){
		E1=SeqSetE(n,P1); 
		PutSeqID(stdout,E1);
	        PutResFreqSeq(stdout,E1,A);
	   }
	 } break;
    	 case 'r': {
	   Int4 i,n;
	   char str[200];
	   for(n=1; n <= NSeqsSeqSet(P1); n++){
		E1=SeqSetE(n,P1); 
		if(n > 1){ sprintf(str,"ID%d",n); ChangeInfoSeq(str,E1); }
		PutSeq(stdout,E1,A);
	   } 
	 } break;
    	 case 'R': {
	   Int4 i,n;
	   dh_type dH=dheap(NSeqsSeqSet(P1)+10,4);
	   for(n=1; n <= NSeqsSeqSet(P1); n++){
		insrtHeap(n,(keytyp)Random(),dH);
	   }
	   for(i=1; i <= RandOut; i++){
		n=delminHeap(dH); E1=SeqSetE(n,P1); PutSeq(stdout,E1,A);
	   } Nildheap(dH);
	 } break;
    	 case 'i': {
	   Int4 n;
	   for(n=1; n <= NSeqsSeqSet(P1); n++){
		E1=SeqSetE(n,P1); 
		char *info=StrSeqInfo(E1);
		PutSeqID(stdout,E1);
		fprintf(stdout,"\n\t%d: %s\n",n,info);
		// void ChangeInfoSeq(char *new_info, e_type E);
		free(info);
	   } fprintf(stdout,"\n");
	 } break;
    	 case 'I': {
	  PutSeqsBySeqID(stdout,P1,seqid_file_name);
	 } break;
    	 case 'e': {
	  assert(fafile2);
	  P2 = SeqSet(fafile2,A);
	  assert(NSeqsSeqSet(P1) <= NSeqsSeqSet(P2));
	  Int4	Start,End;
	  char	str[20000],*ptr;
	  for(Int4 n = 1; n <= NSeqsSeqSet(P1); n++){
	   E1 = SeqSetE(n,P1);
	   for(Int4 m = 1; m <= NSeqsSeqSet(P2); m++){
	    E2 = SeqSetE(m,P2);
	    if(IsSubSeq(E1,E2) == 1){	// E1 is subseq of E2
	      assert(FindSubSeq(&Start,&End,E1,E2));
#if 0
	      printf("\n>");
	      StrSeqInfo(str,E2);
	      printf("%s\n",str);
	      Start=MAXIMUM(Int4,Start-40,1);
	      e_type tmpE=MkSubSeq(Start,End,E2);
	      SeqToString(str, tmpE, A);
	      printf("%s\n",str);
#else
	      PutSeq(stdout,E2,A);
#endif
	      break;	// continue...
	    }
	   }
	  } NilSeqSet(P2); 
	} break;
    	 case 'E': {
	  assert(fafile2);
	  P2 = SeqSet(fafile2,A);
	  assert(NSeqsSeqSet(P1) == NSeqsSeqSet(P2));
	  Int4	Start,End;
	  char	str[20000],*ptr;
	  for(Int4 n = 1; n <= NSeqsSeqSet(P1); n++){
	    E1 = SeqSetE(n,P1);
	    E2 = SeqSetE(n,P2);
	    if(!IsSubSeq(E1,E2)){
		// PutSeq(stderr,E1,A); PutSeq(stderr,E2,A);
	        fprintf(stderr,"\nSequence %d is NOT a subseq of fafile2[%d]:\n",n,n);
	    	PutSeqInfo(stderr,E1);
	    	PutSeqInfo(stderr,E2);
		AlnSeqSW(stderr,11,1,E1,E2,A);
		print_error("tweakseq input error 1\n");
	    }
	    assert(FindSubSeq(&Start,&End,E1,E2));
	    printf("\n>");
	    PutSeqID(stdout,E1);
	    StrSeqInfo(str,E2);
	    for(ptr=str; !isspace(ptr[0]); ptr++); 
	    // StrSeqDescript(str,80,E2);
	    printf("%s\n",ptr);
	    Start=MAXIMUM(Int4,Start-40,1);
	    e_type tmpE=MkSubSeq(Start,End,E2);
	    SeqToString(str, tmpE, A);
	    printf("%s\n",str);
	    // PutSeqInfo2(stdout,E2);
	    // PutSeqRegion(stdout,1,LenSeq(E2),E2,A);
	    // PutSeqRegion2(stdout,Start,End,E2,10,A);
	  } NilSeqSet(P2); 
	} break;
    	 case 'g': {
	  char	str[2000],str2[20000];
	  for(Int4 n = 1; n <= NSeqsSeqSet(P1); n++){
	    Int4 gi;
	    E1 = SeqSetE(n,P1);
	    StrSeqInfo(str,E1);
	    if(sscanf(str,"gi|%d|",&gi) != 1){
		PutSeq(stdout,E1,A);
		// print_error("fasta sequence input error");
	    } else {
	       if(PhylumSeq(E1)) fprintf(stdout,">%d <%s(%c)>\n",gi,PhylumSeq(E1),KingdomSeq(E1));
	       else fprintf(stdout,">%d <unknown(X)>\n",gi);
	       SeqToString(str2,E1,A);
	       printf("%s\n",str2);
	    }
	  }
	} break;
    	default:
	  for(Int4 n = 1; n <= NSeqsSeqSet(P1); n++){
	    E1 = SeqSetE(n,P1); PutSeq(stdout,E1,A);
	  }
         break;
        }
	NilSeqSet(P1);
	NilAlpha(A); 
	return 1;
}

