/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "seqset.h"
#include "residues.h"
#include "dheap.h"
#include "histogram.h"
#include "random.h"
#include "set_typ.h"

#define USAGE "usage: seqset dbsfile [options]\n\
     -S=<int>    - randomly sample <int> of the sequences in seqset\n\
        -x        dummy\n\
\n"

int	main(int argc, char *argv[])
{
	time_t	time1=time(NULL);
	char	mask_dbs=' ';
	FILE	*seqfile=NULL;
	Int4	overlap_cutoff=30,start_arg=3;
	UInt4	max_length_input_seqs=300000;
	Int4	Nsample=0;
	

	if(argc < 2) print_error(USAGE);
	//***************************** 1. Read input files *******************************
	start_arg=2;
	a_type	AB=MkAlpha(AMINO_ACIDS,GBLAST_BLOSUM62); // IMPORTANT!!

	for(Int4 arg=0; arg < argc; arg++) { fprintf(stderr,"%s ",argv[arg]); }
	fprintf(stderr,"\n");
	//***************************** 2. Get input options *******************************
        for(Int4 arg = start_arg; arg < argc; arg++){
           if(argv[arg][0] != '-') print_error(USAGE);
           switch(argv[arg][1]) {
	     case 'S':
		Nsample=IntOption(argv[arg],'S',1,INT4_MAX,USAGE);
		break;
             default: print_error(USAGE);
           }
        }

	//***************************** 2. Initialize search *******************************

   ss_type Data=MakeSeqSet(argv[start_arg-1],max_length_input_seqs,AB);
   // ShuffleSeqSet2(Data); 
   // PutSeqSet(stdout,Data);
   Int4	N,s,sq,CardCut;
   N = NSeqsSeqSet(Data);
#if 0
   Int4	w,x,y,z,r,o,p,q,n,score,s0,s1,s2,s3;

   set_typ  ****Set,set;
NEWP3(Set,25,set_typ);
for(w=0; w <= nAlpha(AB); w++){
   NEWPP(Set[w],25,set_typ);
   for(x=0; x <= nAlpha(AB); x++){
     NEWP(Set[w][x],25,set_typ);
     for(y=0; y <= nAlpha(AB); y++){
	NEW(Set[w][x][y],25,set_typ);
        for(z=0; z <= nAlpha(AB); z++){
	   Set[w][x][y][z]=MakeSet(N+2); ClearSet(Set[w][x][y][z]);
	}
     }
   }
}

   Int4	****pttrn;
NEWP3(pttrn,25,Int4);
for(w=0; w <= nAlpha(AB); w++){
   NEWPP(pttrn[w],25,Int4);
   for(x=0; x <= nAlpha(AB); x++){
     NEWP(pttrn[w][x],25,Int4);
     for(y=0; y <= nAlpha(AB); y++) NEW(pttrn[w][x][y],25,Int4);
   }
}

   // PutAlphaR(stderr,AB); exit(1);
   fprintf(stderr,"searching through %d seqs\n",N);
   UInt8 hits=0;
   Int4	cut=1;
   for(sq=1; sq <= N; sq++){
	e_type Sq=SeqSetE(sq,Data); 
// PutSeq(stdout,sE,AB);
	o=ResSeq(1,Sq); p=ResSeq(2,Sq); q=ResSeq(3,Sq);
if(sq % 1000 == 0) fprintf(stderr,"%d seqs (%lu hits)\n",sq,hits);
	for(s=4; s <= LenSeq(Sq); s++){
	  r=ResSeq(s,Sq);
	  Int4  max=valAlphaR(o,o,AB);
	  max+=valAlphaR(p,p,AB);
	  max+=valAlphaR(q,q,AB);
	  max+=valAlphaR(r,r,AB);
	  for(n=0,w=1; w <= nAlpha(AB); w++){
	    s0=valAlphaR(o,w,AB);
	    if(s0 < cut) continue;
	    for(x=1; x <= nAlpha(AB); x++){
	     s1=valAlphaR(p,x,AB); 
	     if(s1 < cut) continue;
	     for(y=1; y <= nAlpha(AB); y++){
	       s2=valAlphaR(q,y,AB);
	       if(s2 < cut) continue;
	       for(z=1; z <= nAlpha(AB); z++){
	          s3=valAlphaR(r,z,AB);
	          if(s3 < cut) continue;
		  score = (s0+s1+s2+s3);
		  // Int4 ct=(Int4) ceil((double)max/2.0);
		  Int4 ct=0;
		  if(score <= ct) continue;
		  pttrn[w][x][y][z] += score;  
		  AddSet(sq,Set[w][x][y][z]);
		  hits++;
#if 0
		  fprintf(stderr,"%d %d %d %d\n",s0,s1,s2,s3);
	          n++; fprintf(stderr,"%d\t%c%c%c%c\t%d\n",n,
		     AlphaChar(w,AB),AlphaChar(x,AB),
		     AlphaChar(y,AB),AlphaChar(z,AB),pttrn[w][x][y][z]);
	          fprintf(stderr,"%d\t%c%c%c%c\t%d\n",n, AlphaChar(o,AB),
		     AlphaChar(p,AB), AlphaChar(q,AB),AlphaChar(r,AB),
		     s0+s1+s2+s3);
#endif
	       }
	     }
	    }
	   }
	   o=p; p=q; q=r;
	}
   } 
   double inc=round((double)N/200.0);
   Int4 MaxScr=0;
   h_type HG=Histogram("number of matching seqs",0,N,inc);
   for(n=0,w=1; w <= nAlpha(AB); w++){
     for(x=1; x <= nAlpha(AB); x++){
       for(y=1; y <= nAlpha(AB); y++){
         for(z=1; z <= nAlpha(AB); z++){
	   double dd=(double) CardSet(Set[w][x][y][z]);
	   IncdHist(dd,HG);
	   Int4 tmp=pttrn[w][x][y][z];
	   if(tmp > MaxScr) MaxScr=tmp;
	 }
       }
     }
   } 
   double mean=MeanHist(HG);
   double stdev=sqrt(VarianceHist(HG));
   Int4	  iCut=(Int4) round(mean+(2.0*stdev)); 
   iCut = (Int4) round((double) N*90.0);
iCut=7500;
   PutHist(stdout,60,HG); NilHist(HG);
   // exit(1);

#if 0
   // h_type HG=Histogram("number of matches",0,10000,25.0);
   HG=Histogram("number of matches",0,50000000,50000.0);
   for(n=0,w=1; w <= nAlpha(AB); w++){
    for(x=1; x <= nAlpha(AB); x++){
     for(y=1; y <= nAlpha(AB); y++){
        for(z=1; z <= nAlpha(AB); z++){
	   n++; 
	   if(CardSet(Set[w][x][y][z]) < iCut) continue;
	   fprintf(stdout,"%d\t%c%c%c%c\t%d (%d)\n",n, AlphaChar(w,AB),
		AlphaChar(x,AB), AlphaChar(y,AB),AlphaChar(z,AB),
		pttrn[w][x][y][z],CardSet(Set[w][x][y][z]));
	   double dd=(double)pttrn[w][x][y][z];
	   IncdHist(dd,HG);
	}
     }
    }
   } fprintf(stdout,"\n");
   mean=MeanHist(HG);
   stdev=sqrt(VarianceHist(HG));
   double Cut=mean+(0.75*stdev); 
   PutHist(stdout,60,HG); NilHist(HG);
#endif
   for(sq=1; sq <= N; sq++){
	e_type Sq=SeqSetE(sq,Data); // PutSeq(stdout,sE,AB);
	// if(LenSeq(Sq) < 1000) continue;
   inc=round((double)LenSeq(Sq)/60.0);
   HG=Histogram("matching positions in sequence",0,LenSeq(Sq),inc);
	o=ResSeq(1,Sq); p=ResSeq(2,Sq); q=ResSeq(3,Sq);
	Int4 nn=0;
	for(s=4; s <= LenSeq(Sq); s++){
	   r=ResSeq(s,Sq); set=Set[o][p][q][r];
	   Int4 card=CardSet(set);
	   if(card >= iCut){
#if 0
	     Int4 tmp=(Int4) 100.0*round((double) pttrn[o][p][q][r]/(double)MaxScr);
	     if(card> 0.0){ IncdMHist(s,card+tmp,HG); nn++; }
#else
	     if(card> 0.0){ IncdMHist(s,card,HG); nn++; }
#endif
	     if(0) fprintf(stdout,"%d\t%c%c%c%c\t%d\n",s-2,
		AlphaChar(o,AB), AlphaChar(p,AB),
		AlphaChar(q,AB),AlphaChar(r,AB),card);
	   } o=p; p=q; q=r;
	}
	if(nn > 10){ PutHist(stdout,60,HG); PutSeq(stdout,Sq,AB); }
	NilHist(HG);
if(sq > 200) exit(1);
   }
#elif 0
   // PutSeqSettFreqs(stdout,Data);
   dh_type   dH=dheap(N,3);
   for(s=1; s <= N; s++){
	insrtHeap(s,(keytyp) Random(),dH);
   }
   for(s=1; s <= Nsample; s++){
	if((sq=delminHeap(dH)) != 0){
		e_type sE=SeqSetE(sq,Data);
		PutSeq(stdout,sE,AB);
	}
   } Nildheap(dH);
#else
   for(s=1; s <= N; s++){
	e_type sE=SeqSetE(s,Data);
	// ProcessSeqPSeg(12,2.2,2.5,100,sE,AB);
	// ProcessSeqPSeg(17,2.2,2.5,100,sE,AB); // better than 12...less aggressive..
        ProcessSeqPSeg(45,3.4,3.75,100,sE,AB);
	fprintf(stdout,"====== %d: ======\n",s);
	PutSeq(stdout,sE,AB);
	PutXSeq(stdout,sE,AB);
   }
#endif
   NilSeqSet(Data); NilAlpha(AB);
   double runtime = difftime(time(NULL),time1);
   fprintf(stderr,"time = %0.2f minutes (%0.1f seconds)\n",runtime/60.0,runtime);
}


