/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "sma.h"
#include "cmsa.h"
#include "residues.h"


#define	USAGE_START	"USAGE: recombine msa1 msa2 [options]\n\
   snfile = file with aligned segments\n\
   options:\n\
     -x         - dummy\n\n"

/**************************** Global Variables ******************************/
int	main(Int4 argc,char *argv[])
{ 
	Int4	arg,i,s,cutoff=-999;
	Int4    time1,*len,t,n;
	char	str[300];
	st_type	S;
	ss_type	data;
	sma_typ MA[3];
	e_type	E;
	a_type	A;
	BooLean	**null;
	char	*null0;
	cma_typ	cmsa[3];
	FILE	*fp;
	UInt4   seed=18364592;

	time1=time(NULL); 
	if(argc < 3) print_error(USAGE_START);
	for(arg = 3; arg < argc; arg++){
	   if(argv[arg][0] != '-') print_error(USAGE_START);
	   switch(argv[arg][1]) {
	     case 'c': cutoff=IntOption(argv[arg],'c',2,5000,USAGE_START); break;
	     case 's': seed=atoi(argv[arg]+2); break;
	     case 'x': break;
	     default: print_error(USAGE_START);
	   }
	}
	if(seed == 18364592) {  /** not provided by user **/
		seed = (UInt4) time(NULL);
	}
	fprintf(stderr,"-s%d\n",seed);
	sRandom(seed);
  for(i=1; i<=2; i++){
	A = MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
	data = SeqSet(argv[i],A);
	sprintf(str,"%s.msa",argv[i]);
	MA[i]=ReadSMA(str);
	if(MA[i]== NULL) print_error(USAGE_START);
#if 0
	PutSMA(stdout, MA[i]);
#endif
	NEW(len,ntypSMA(MA[i])+2,Int4);
	NEWP(null,ntypSMA(MA[i])+2,BooLean);
	for(t=1; t<= ntypSMA(MA[i]); t++) {
	    len[t]=lengthSMA(t,MA[i]);
	    NEW(null[t],len[t]+2,BooLean);
	    null0 = nullSMA(t,MA[i]);
	    for(n=1; n<=len[t]; n++) {
		switch(null0[n-1]){
		 case '.': null[t][n] = TRUE; break;
		 case '*': null[t][n] = FALSE; break;
		 case '^': null[t][n] = FALSE; break;
		 default: print_error("input error"); break;
		}
	    }
	}
	S = MkSites(ntypSMA(MA[i]),len,data,10,5,5.0,9,9);
	for(n=1; n<=nseqSMA(MA[i]); n++){
	   E = SeqSetE(n,data);
	   for(t=1; t<= ntypSMA(MA[i]); t++){
		s = startSMA(t,n,MA[i]); 
		s -= OffSetSeq(E);
		AddSite(t,n,s,S);
	   }
	}
	cmsa[i]=MakeCMSA(S, null);
	for(t=1; t<= ntypSMA(MA[i]); t++) free(null[t]);
	free(null); free(len);
    }
#if 0
	sprintf(str,"%sx%s",argv[1],argv[2]);
	cmsa[0] = IntersectionCMSA(cmsa[1], cmsa[2]);
	if(cmsa[0] != NULL) {
		fprintf(stderr,"recombinant improves map\n");
		WriteMtfCMSA(str, cmsa[0], NULL);
	}
#endif
#if 1
	sprintf(str,"%sx%s",argv[1],argv[2]);
	cmsa[0] = RecombineCMSA(cmsa[1], cmsa[2]);
	if(cmsa[0] != NULL) {
		fprintf(stderr,"recombinant improves map\n");
		WriteMtfCMSA(str, cmsa[0], NULL);
	}
#endif
	NilSMA(MA[1]); 
	NilSMA(MA[2]); 
	if(cmsa[0] != NULL) NilCMSA(cmsa[0]);
	NilCMSA(cmsa[1]);
	NilCMSA(cmsa[2]);
	fprintf(stderr,"\ttime: %d seconds (%0.2f minutes)\n",
                        time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	return 0;
}

