#if !defined (_NUM_ROOTED_TREES_)
#define _NUM_ROOTED_TREES_

/******************
https://oeis.org/A000081
N. J. A. Sloane and Robert G. Wilson v, Table of n, a(n) for n = 0..1000 
	(first 201 terms from N. J. A. Sloane)

# This is the b000081.txt text file.
# A000081: Number of rooted trees with n nodes (or connected functions with a fixed point). 
# Dated 16 September 2014.
 for n=0 to 1000.

 The On-Line Encyclopedia of Integer Sequences:
A000081  Number of unlabeled rooted trees with n nodes (or connected functions with a fixed point).
(Formerly M1180 N0454)

Also, number of planted trees with n+1 nodes.
Also called "Polya trees" by Genitrini (2016). - N. J. A. Sloane, Mar 24 2017 

References:
D. E. Knuth, The Art of Computer Programming, Vol. 1: Fundamental Algorithms, 3d Ed. 1997, pp. 386-388.
D. E. Knuth, The Art of Computer Programming, vol. 1, 3rd ed., Fundamental Algorithms, p. 395, ex. 2.
D. E. Knuth, TAOCP, Vol. 4, Section 7.2.1.6. 
A. Cayley, On the analytical forms called trees, Amer. J. Math., 4 (1881), 266-268.
F. Goebel, On a 1-1-correspondence between rooted trees and natural numbers, J. Combin. Theory, B 29 (1980), 141-143.
F. Harary, G. Prins, The number of homeomorphically irreducible trees, and other species, Acta Math. 101 (1-2) (1959) 141-161, see page 146.
F. Harary & R. W. Robinson, The number of achiral trees, Jnl. Reine Angewandte Mathematik 278 (1975), 322-335. (Annotated scanned copy)
D. Matula, A natural rooted tree enumeration by prime factorization, SIAM Rev. 10 (1968) 273.
N. Pippenger, Enumeration of equicolorable trees, SIAM J. Discrete Math., 14 (2001), 93-115.
Eric Weisstein's World of Mathematics, Rooted Tree (http://mathworld.wolfram.com/RootedTree.html)


 ******************/

#if 0
long double num_rooted_trees[]= { 0, 1, 1, 2, 4, 9, 20, 48, 115, 286, 719, 1842, 4766, 12486, 0};

#else
const long double num_rooted_trees[]= { 0, 1, 1, 2, 4, 9, 20, 48, 115, 286, 719, 1842, 4766, 12486,
	32973.0, 87811.0, 235381.0, 634847.0, 1721159.0, 4688676.0, 12826228.0, 35221832.0, 97055181.0, 268282855.0, 743724984.0,
	2067174645.0, 5759636510.0, 16083734329.0, 45007066269.0, 126186554308.0, 354426847597.0, 997171512998.0, 2809934352700.0,
	7929819784355.0, 22409533673568.0, 63411730258053.0, 179655930440464.0, 509588049810620.0, 1447023384581029.0,
	4113254119923150.0, 11703780079612453.0, 33333125878283632.0, 95020085893954917.0, 271097737169671824.0, 774088023431472074.0,
	2212039245722726118.0, 6325843306177425928.0, 18103111141539779470.0, 51842285219378800562.0, 148558992149369434381.0,
	425976989835141038353.0, 1222179262369751914558.0, 3508609802706585591648.0, 10078062032127180323468.0,
	28963544938490115587690.0, 83281891024323882188934.0, 239588251950971630070883.0, 689586695750027771528858.0,
	1985698827814122851389544.0, 5720475695410470698034352.0, 16486885726043465205200778.0, 47536435298225838513777689.0,
	137116646299836640013582158.0, 395661426200172120893172166.0, 1142146565612503377367247619.0, 3298218689025396468807928287.0,
	9527778769277367435762139714.0, 27533018688066675122704256503.0, 79590547737981375530085744985.0,
	230149693903609741713900061706.0, 665727478405857651614359412994.0, 1926264145029683789201902595481.0,
	5575255070241458769777337977216.0, 16141340753693289446826761342965.0, 46745197819192522341803684458539.0,
	135410903503191503503384705970501.0, 392361462360303212219218458046293.0, 1137187531620128717310046733793377.0,
	3296764685809404767411359346950251.0, 9559850833672724865816863589301148.0, 27728021718947447790064072086211720.0,
	80443073708065346515907947187548704.0, 233430673259657258534788317265918255.0, 677523352768124889000758550090536896.0,
	1966913982276181876912481643993713829.0, 5711352604881678383437989565512293584.0,
	16587575765193708421040000378631758598.0, 48185360814676586544379947795827489489.0,
	140001774817536903942967946008051857304.0, 406851804555194134855599602163662891898.0,
	1182554992433068847214862126968409557746.0,
	3437850734230350035768412388914235959988.0,
	9996120786153335036227014784756370016600.0,
	29070538491469576103323086044968128987841.0,
	84557105785656201807648937916789795631644.0,
	245992006962808524149265893171336435342958.0,
	715754664594286649942853831332902539636094.0,
	2082946825910124637547671590789256847274970.0,
	6062636513439329551550570219718718950653609.0,
	17648704032743316047867540848170516567878799.0,
	51384328351659326880337136395054298255277970.0,
	149628319067134258729492635393764561946446898.0,
	435773555378556621487649875385046928847795784.0,
	1269318644768626173671280060343924144118929962.0,
	3697787471843882919503741671571956271724453863.0,
	10773915272265299096722633935056491599015993526.0,
	31395278668835569642894597448152288487513654760.0,
	91498335510499412949944068493812154667201899996.0,
	266697551736034500974403875918199160381020794943.0,
	777464909926662274252539710352174256524537146568.0,
	2266717902172939745356419584149509390193572111090.0,
	6609491798331308667945916567473795647776350494944.0,
	19274876718267379183082731606601354770476593956958.0,
	56216933934440628266170206911485488532804495696011.0,
	163981098176462436867344900912360872136310147447481.0,
	478377363488119996199466277447107762158096296204095.0,
	1395715099260136164597807553243393964797512026534174.0,
	4072596754913968520526017518234957521901902137340741.0,
	11884849792225446467164827578705271751426641565787989.0,
	34686687769075460871528242699923663407376280719194639.0,
	101246035781088847377087937778977656646151686575253687.0,
	295555143792188587240218693431569299206317678906752121.0,
	862866420343537154875548529258938427404377686664564327.0,
	2519372809120869553578626478943178598917005494455702465.0,
	7356723287883386705604350855255245130679027499828715557.0,
	21484182091313353896032663489738498383361689380505730072.0,
	62747289770322633245796118790042867418654231976047996886.0,
	183278787565756912981879644306583658286139158264360868095.0,
	535389528724822411486938974053646103381419434357851114695.0,
	1564110211480366722758069818159760894039941111859171595236.0,
	4569871869451983708778255281669612956287808901757579609878.0,
	13353013498885489592942759523570855123235636856510317581002.0,
	39020475541213265957998474787559436049343872861180239148852.0,
	114036337004641853533137427749022172120823880607180497864130.0,
	333296558812644455558619006213117966372695811470429353512864.0,
	974214798093723013764874725130574551516668604119508894668187.0,
	2847832221507880420520548184723186941125101511703828642231628.0,
	8325481061039310552833247634534922085844974149124193587562801.0,
	24341033948144688063108681110032370402994477789106884553843327.0,
	71170980989295279294784719273833589739006988591382370804019485.0,
	208113683337131426828568510655009953959752138721026381660024142.0,
	608599501784254797813237611073945468413576947662519911358842496.0,
	1779898969994874521041554973645120797002074042090639521652323074.0,
	5205847632349050570394011275497425392992549427924431609781670549.0,
	15227178705465516721514948412630697076262213358478006662712345209.0,
	44542940708487341767563190577280957619860211909615015424415202093.0,
	130307479125598904840333630192678724658382602962549556836386222377.0,
	381232918388395425149776922776017895077967439104836211313815192673.0,
	1115428205233465380621886784123969995590622406292378681412440069230.0,
	3263793112818154734578269983016579269273711933603470184984927188444.0,
	9550651408538850116424040916940356193332141892140610711711231180087.0,
	27949390940190093667382857231860071787268010804560840421857520526672.0,
	81797551187179507035587781099514557633640102155354491478458500568902.0,
	239406799063525783126549101224527386606953081389948675210572185544275.0,
	700745817095037391960838562107212671547500606165088807342053138645501.0,
	2051219060190061892258360712961316201049377085606328736345704208604469.0,
	6004691699722395562010176501937770799695484293486569081354592657407537.0,
	17579081497593937545146888424324701622177733217707537842079385023766965.0,
	51466910512819379526867651039207765901128239787789578889240931106579694.0,
	150690591774064049630017172325499944645213421290424108131364067556492015.0,
	441235015883543588123335319013488010690511349210208396079341236421864577.0,
	1292049858632540624995827931124102403122248298572552210016059652703638588.0,
	3783674174889366497149526575580637689237319753713179238035512420596655339.0,
	11080848932950313204520480607878821622368070688719159448392642476898572694.0,
	32453151625318245113052241411475169279456647163175178234778031657360858698.0,
	95052811368305002383779036012429067137142055372634872454643924349336979183.0,
	278417804119243218614168906446435758330808103386317314191004723681940564053.0,
	815553964460122382747473424328063818351493112023469328997748289298973344523.0,
	2389085991492006032190423931302317063090110134015476845615010072983508704783.0,
	6998967261207301746138303741473831302593357057506135598276457602765079009986.0,
	20504962113985965815884696788979202172292976747246429719427480947194635784968.0,
	60076765350891234302491783742360686319103080146006962062910380322692095328573.0,
	176025833460614963080434845794616946157436070410895256515594013210194249066978.0,
	515784535078762988301608128087856767358826748814684216271201547836498705178936.0,
	1511409015607900041159301488235729971958523716613241718448335078495912889876963.0,
	4429117845326221366130970974271654324348797332122113792245382972873694999857768.0,
	12979971908218548122180145976356718296679221059955337738439058966237725771195935.0,
	38040946812846442861764234256670584583980056811962244919547226621595005676077260.0,
	111493537176976066435335745886349187632448667337373158475970696359107459823133672.0,
	326789916761822523526030743464037693233289019987943973503498921788243246327298214.0,
	957873040125878901792041495224423540997491805027052844176615704131554957226318913.0,
	2807807792458483718953785223157908401581856461817646854010434101847653403579457661.0,
	8230888166799088807963198014601979481543272519722751229137994609023552635632007796.0,
	24129354817950511717299460210228304745283163603840856459867816388841543557931141504.0,
	70739858467234431559564266564658709745436541520459970557547216246281631302832449376.0,
	207396737550966416328556389633485009757050574351146105129345465627236931090697962413.0,
	608077177443688717836574107418700488202092861491771730612191865603759001191446668526.0,
	1782930160794152846970216072974454098382095138074538367617463100562834823920670332703.0,
	5227916033654835535331788926259684805052400675189698421100307430121096593239076534205.0,
	15329970586605475325711298393513301882694795755167104953322366991550545404075877710457.0,
	44954408805472185592474456617433277756092941408937344120007592731164880684908507788266.0,
	131832145235738495695020231246592576337044821405877380569677331802512218241578369385997.0,
	386623473698223149312414740050144363009251779799980362882635636139586897225620066323014.0,
	1133894902501184506125891637443121385674840567198449928313572004023935942434124081286443.0,
	3325637353100727445008723836048844975808386188140510297691859015010802421393423961130465.0,
	9754259340135479192048940554788220459792997995399371642359379984703603524711449120699026.0,
	28610856011837274539166560736484015136723860529044739177455842354556264495231236483678933.0,
	83923652251978547313034175952442516576387349170958872481363110909719319046063898948260813.0,
	246181094248238937664946453783096993093223917304425695075826209267469373221956432083494518.0,
	722173667862631609254923524147955530758273314821726531037139336204121775298607639111145118.0,
	2118580948321526428594318855482881200883755843660920029149862986332799610070001476391105736.0,
	6215338325734742198735726806241223810712195744984064031663670002809603231639854398599854128.0,
	18234783934028812398853296324648314827933647397817037449605235535915060809574412991460336762.0,
	53499835427738170153357879071133062289230733289058014044642116238867807144660677220522728407.0,
	156971240405062258743768237543461814169368195453647587017012383951957386800452773519762931196.0,
	460578222156708095993733770597903595356736683252263405077976416827472971793315190671767063176.0,
	1351456963504488596422002789746295449731938351295341826859779717345977042076973305252409635382.0,
	3965668464152520144029672670535092587828884512183233885156492750211666290804060417850611485149.0,
	11637127725160846114123003379159108904962545025984245893235180508038119729673954731235173222842.0,
	34149965263422222602566901700637306075789186657290201847590615772539832068919251646703217529937.0,
	100218905522734373115420269448054118430641854060401708020900836845270322566171915695666834292791.0,
	294119505453790140326596796531110520903632330634450587018344085959765518139487399999942855927983.0,
	863202403484960693394687774343486383377684406759058193303242302587108068857289996660072135760402.0,
	2533471127668043441057849443755976142198986230132649247796994297910912701747377329248106807200635.0,
	7435901807980879347727861727520226062017035833376912414107636187293370817314801688339916199195101.0,
	21825568647983875900855213868237622386026676217017351553711210550771843009957701076133698442074665.0,
	64063637144005535733061951453280218096467416252983591356340828063986163313970705784920088476286276.0,
	188049242186629171220959575285874359152490075917649241437945343649405486798899620803329240624206903.0,
	552008070346657544492763248263605214820101233513042366015707099428787188492518565353736362695826341.0,
	1620440106092280687284616256094964287732660301307644969028140499130412925235334253598748030041218370.0,
	4757010736205951296379181392778931809047934415149223874825669806143414483354636665310702400385569088.0,
	13965251076438995774752032033422479190614199812810505773891733085868681291444409335644645628724591364.0,
	40999325451811927063770596217603816365103918802648338103003939083624670481417498747113623204577899657.0,
	120369900517033504925671819164448184800153117767042509643762677736731058201506362919836705237369971856.0,
	353404601623635220609176670417041208351760689925826320004056155642032294637082465712254177358081403991.0,
	1037622761939483154041668615638942457701488689982923774294848664965695365815153868432110065694211568202.0,
	3046629594766245542143382857436982528108709419518573366855711141676957833970503900736015984757445577630.0,
	8945664069572982951794408004295880045337248242210873833705470694239764039217745344914765635722238849494.0,
	26267465141693970255368348730603130715339693277637123753167605607020170623371516269694388058848966495694.0,
	77132300291120444609984710153749754599126964283944344342465884410087222869695424244204620517155225106175.0,
	226499283437381159431545121017941898135109167308916011025978561945665334393766267475850612720439317110592.0,
	665134850482780454163544912336278794181345513227253320211178466914597753784049833657483302111908015408761.0,
	1953281294157946996827100720006687191856428945095867721973278861831620291919961248528379467543852552270568.0,
	5736301753793112977953567685952262266045479073724060586593453798272615320984578202500347479464870273514813.0,
	16846558482549574428805415236999408036094336615425857917586302184871432468051223008638316857692417913856413.0,
	49476879786938850934269889723055524498585894206750535288088850913444941414760625088393857955061392214463224.0,
	145313250088369274676398951609246914870041416398081726358426267710721103474003567558362119016805852880391537.0,
	426795501077660846162499346590784524817875062236672568718561668912538981018490153993775461874982049719997658.0,
	1253562680069498579450268586650789796956266030812283470561822881993190914904006896399792940924019207541141807.0,
	3681999992449444260547554129614648867894306329610539139060089443465870606028933500887192420520688052147921924.0,
	10815159377902582950249361361033531410177914563928325414675164170754918273677854742717869076736308361727514583.0,
	31768256522742882031486357207460419853002419851274482112464216003524492183368403716888821531638433752217831084.0,
	93317922313205069988938627303337636613456827774373928956197103272180123651456137040559854113497424741867908308.0,
	274124511638697640375996606881075283832579753993291597916427257904594133152569250956294926361834776877855255178.0,
	805270370779339607968141343674808599640124166403996522079979011657053649217630048205418502641490391254393876820.0,
	2365628355912799377791003935199973529480039274803489779595159676476147426016220336839350122255002441374040740288.0,
	6949637851051169898940332561492356969672325708949947196358177013302253906847947625910282949769805755588934739424.0,
	20416843583344993505261368781063472918192871885071163668741673699812150087535555637345208816544992889332725729215.0,
	59982658922447976676132145137071584186113229124432758108944942138838132919899693858099382317141318363966109524839.0,
	176227395641943092291362093261108439061593795893863669371958642935505118735484799243882201249080273319629395616446.0,
	517763755754613310897899496398412372256908589980657316271041790137801884375338813698141647334732891545098109934676.0,
	1521248972022847277978322857056267851518885800250734071522473286699635854105564470901696946495207184683673966248731.0,
	4469709477594344667119989432132929330320517306047352068808577704620305737087510583313067606899362514118349513852224.0,
	13133139515950105055088480603191306262112379021905745167835399179058461451594482858602214161270184136636726133766731.0,
	38589397962937310044197520891100204957691663860078393573328989020692134596084285587950028659578299224728944322083642.0,
	113390730066465314781029262842289558723794546353741362167736786743596111124876865665381389593912246514669486140750506.0,
	333193962876677589493965709407669728904500779152636854025997151088267384526712367466771998138504388616314521369162215.0,
	979099078864799238288670360798800792650559527859564996457728657124500797591769826726393167141644271083078589910978032.0,
	2877173347873199810770721188685250155611726656674209038776853748794930572992542087017631928755264854655027918994918745.0,
	8455031062333937428040486813403704679292381819544517734912878490246276031638161276668242833773287839339932836463156711.0,
	24847008178339314459900585830094537316859055746852343269838307622916778937932643423370285767559068047340079718298046039.0,
	73020136497417614505348237612668927028104538496189815851680819786379934271030724800053187046777857832671534718737204174.0,
	214595566965930463634648424183328652910530514037816785140709290711447119382147626597323520798647019039395529174250817655.0,
	630678966643359426726335620540396221912902005520770728905809272617877344228742785713355217319927241456315314039248712681.0,
	1853554549775231006211037183974660628148591850399327566143752375908123950662850887062045414365598057753590020408523409304.0,
	5447681997047870173702526930082166817268836740695205613792839429874286533743889512078615477829570647135803249678485460106.0,
	16011329905523460830328163289823804044985455360769046551586622817834287832795909639035343544950385435574121786541095380616.0,
	47060038244157019827795663903459336414355475797369495612960343381106678675827727814546420724038488741358728175286698988300.0,
	138320416653704315349179888686670019293400957069698793709919867437742322828044238351233250845376917726376972844445243846735.0,
	406564426344927146666650002116882526188455298427875963606863411685746813699363260091496768343385442854236198205539793375317.0,
	1195037327736564935723161855402427178853662794012082842930194681746394618876236761728980599137285194657496837514503815365027.0,
	3512711696129783616181214324848747044568996934065328622322496913011676745335481139830808194225394834618781044013848277675083.0,
	10325531538747089720758401020834171338762310925345307534141583698123873833794825103162810450340500882583053457385775623037836.0,
	30352267295462872268285073818040244377181314917993553750238856727378900790239358059182989446114819216245077902983416514437985.0,
	89223366184758097257202706273988417412145865509570949754961588691183239160097166892364118500432478136530894407956395164305716.0,
	262285783647148946192828987473694184351579073514774790407966445537397060021495554121695532165367466809839439248050315343298309.0,
	771044631857773901453913209968722731494608894215675170114229798738777276887143040697789674788044798006926000445877216692952336.0,
	2266693714284363519431097459996641690888796566861884645710944413972496958546351334901428132739573407351251289016467318487777838.0,
	6663688037538031566777298808460246392177854258151709362217514023245979807922601054312341665906204601108503656504755711017742976.0,
	19590472361688057035770487232482804508718740688438153975329840915844321429331772945809952958331873554344264251153114137668469793.0,
	57594834068139021483352523843948730813954943172132673502947636452317583395944362890695161005018252375147201099238056248347523458.0,
	169328658813118256925662369840263348398326662778734394733857552711725626220989453749761219104065960436808121500916786971504342537.0,
	497835268028655148298350214936349671383466967244170244587192528556776119252238206181201541541485184006076267880454836269734477230.0,
	1463689803356871252517322919097621090318551745147412771940750427722892042756051544607813347101830369224585422243999199354256119567.0,
	4303487767556261397807696207862737037167733898906970040119691449502885443534894368242325117505621454124899746182401054647782960173.0,
	12653194362171821925321140614915466850160022252890774015672374945321300428733266700733110778231286235120368890894313065022836988866.0,
	37203843576933507451999196570602893509160187633749380297492887326621223545902927376316503442787537913433149546975054415586927160051.0,
	109391457422424772205185009222712669643522325093408538100635776740656073494465942392324938231818888635866875075715585319726600408401.0,
	321652491663447740400520805260321817541601431703473830964376130488872264619585801870735363711960786881266359511853807789265850656622.0,
	945797778022718659031420880893287816709192173632376410025702639991028383918155894389759253770152754497141974422254782158615783021512.0,
	2781105489921683424691236392939089917563646582946249794954716536051149333176734488844092725941318021475973254786926133004940702694614.0,
	8177948761980956261668676360023082813661991707324151401792124148756690101819253684420734876563959818522442638135579949024202807932048.0,
	24048002295495452420273211292102698038361075098638970951632758411670517324600612190857584886776733490757466936743880497885901274159685.0,
	70716583106952833234909787207244770062728288975686795552193890195474823679426237185269815644391031505444932373429921029411747576610667.0,
	207955841214649109790565852199850091309449343156056719215269536163081230951602539284177610187185131819508357669975376642363829603376902.0,
	611545140406343949733897151390885070473632914174304645816978630138094266612322500352055540602389850556314171303435196360788720802936540.0,
	1798429445151463538064133785727453029595580348005862463744256037775926060681009055400815547051959468620542587453694829472312489555379892.0,
	5288904538973646077829850733389595378998612146553630833750336163963049369817105965096209734802616504057848284129861602751557037789616554.0,
	15554119848536103517535513925803752780524507265148859075555862731987928822679610011816795789871328911634903572122611574032070492047671562.0,
	45743826713011914063069306250784117891173324158484570240446200271077490784867943666177962822610338546098991086760964214300729432847795851.0,
	134532382955172760090097448939658409655975495508596862226512460753334993749513866425980789832484621231962494890879550462848452689557751620.0,
	395665714024818780680986096757573556576545393379670164013671995119413276272277372304590621575744840518716085632910480837465616402858158811.0,
	1163689715028359639850167629175367007957302887481506806210879867973553320922139129583857043484952748350833334509768647907077570924250979245.0,
	3422576147383622944857356227775850049103274605917399007243634831858078617717357742117463660636199413050333978761449981138834815687258011524.0,
	10066445386349406932147777111492561999781112635274346043215685828832515745153305879084447595834085860311932207772944944506487154304522585688.0,
	29607805311647142016773513094029645767128709997594825094659748411112102127132188201453794236514945497242390037675181886930298056871578148711.0,
	87084988166089176685139739491584680344730724045289054776240084291721977646786563924173935758474833801640555062803055992211924949453522648409.0,
	256145858497201782023806306714528175948597035455691571735683914479616239486343835688795050977352463143087228386306110521632263803325143409101.0,
	753421995134608541606153066804337291844081027313659662599821576411752037897293589875911605223824753980303964595132024263166853383330156483517.0,
	2216134533491124720727975038897493255898098681319972758807401287748150050537670252737217521306511178066506877150697791378228686055686551330828.0,
	6518696684962890945288502898491791238547286737916338461893728065938737883921433152641854426493827713478185950998615883843611295437849011545731.0,
	19174860283127536613505804153717481459030422466270365950608445049299668531629223248319419487597556327180036115965807012104896363407723826569717.0,
	56404061946218538360701236370931765307802439529169350579222576040983214599041526338825447969186476381972335021472232783105642866031911028329840.0,
	165918666581388152092052424239825049047320495687427522839149885966245292904865630829581773120893810362893617393110466943448171730224959232891851.0,
	488075231824469542996319138143426228017589645303778475619914018992048445417455161336665601596645773277607460982930920329604294667317825753238299.0,
	1435770083256063891169158415934800591990794002888753858476463472445526205904561299487936910212921161727801646501046733598701906164297251415665314.0,
	4223666301598984693997626647589286587806035494964633788332844515521062249163691902529310589338233689781490576903669749945426127861669740032990329.0,
	12425126650794066346863315283029752796067894828885934097724014602281086346549490605749776516527305791769122901449318547044741039881976961209079254.0,
	36552622011418669578659539488442496800034864651112729911702140631970070712124739501437892426707927735817513829716449529446946373741921206008332880.0,
	107533230131263642242808477282274702730708391327916697449214723388852252886124164287103670910947186700425262223012179163173464491190974869668395827.0,
	316353943233513108814021145124516400813912814935591983405393395261243019789791810967986887999287081644294194267252728837351844873248343221267880619.0,
	930700993085283660656806356267592334339138538892535494755631162381284517830984540450634277913025046367717752164091481204463717900650288755864875434.0,
	2738125989343481300014745776036931306547497760239337404762180946077809367150356800307958844686527625035603969108877040910036569089432280991004371594.0,
	8055694043469419351257820922453821994750288236579312687536350998584980001330257769573167952196712864382319686837734909161966514538075661784255946092.0,
	23700567546300496657250634311032092420978011861558226372656377026113813256468609112071493378496169268052584447165077076213077963738545685330407988017.0,
	69730172088924521157234925128163261129813029220411932760076716476647309425137780174083538802323815443189565256212638677156026721576618427107035926301.0,
	205158208596447513807755374058419404165680826647806972615668258672976983856583730657164576961240300900275444628877666159732676201988262692805470215974.0,
	603619403492169825567418282196961794784870102830943076265311500052317425314867668471334568298704392947977973939258950706128072924004080128570193688758.0,
	1776002530955291220546001256421804530794783083988877682292486571357463954138098521959621523257443402503537692411373285627232002177479906005981373988181.0,
	5225526165207658859336215908613687715158211728140161364208380215133797792804855284846018393256036754887613928771867057314237512198475341319544026657745.0,
	15375260902012737810912789050511545856612007575706746202075105444650905372198214178496208853192774237168633466350070621161819473322840628917029924106662.0,
	45239828091978269848845235648332207238680277259390476727074939573423127733643617679313653701495140365407603913841728318747563774656717255339969075939246.0,
	133114494225065668124417274698832613102945490655845020467023536919198117191849496622800888437605740602926559396019638991232836304847481377304108813466289.0,
	391683845024364976658766525949408910832188018736402414684438745255057125221879981633706147611032346055690447023875832423756332341623118227287757925672502.0,
	1152528967711361202874700834165872854668354668499643227364831312381395186578027051929797773400557314587214687185485425170439947642525441896453893040009690.0,
	3391359911367741128398306313115214348896639962350307463769745015193201543419164556831568999711786055373821139025453874386298357910386110142811799663197115.0,
	9979337754912950334762232794462591972339644474435971436846256457112923388881984696079884549978887024435264486667565965682597916615221038589166203325340998.0,
	29365360317591828240500562305404734081850452773731971222211900605832077474526095104858589392724624833583558644630260176132067417854658549573291140349315759.0,
	86412124937418608109559834916985865498033233145135860856638757490801091797132686658053979112829130235519940761795200606993766920900260958724148208381109454.0,
	254284413267360457682133600655300667267189158431643959480955878884303572002965575586204923294795021925573338174686264570868300890155006827047764688304065688.0,
	748290904933188994322589038567967117405037722487683330132340998464548199766170788460556548853089591144996853295366868761223465326350109139804271331017807205.0,
	2202048249543361061669025863805724288431640410569517207549512462694302983616821672854205043442480951827227900546171846932601219245467298224867225293318843386.0,
	6480205811605275135839662844375607317292524062596401107542830598787480137755778962047361350260595143493860837334391081105122991694857246217053992411846524037.0,
	19070247953830337411317040324173196705481419246304116060345379703232887944604613761040189976989257616907122263758934967624789863313484015324897145578354652799.0,
	56121519332038714851046360186577994318048727701095031437373581692825828251550244160414327934565300130533191827609049773738367075285927524276429545338032003875.0,
	165161191418845829886514482058026390704955282613697893342227633565607986722635182088913552610345338076797588067068287283138917601678573522139475176292520950305.0,
	486062447869279714525425040295537961738315692972701594562748473729179575302993952047192505235287752949958800410189128599050865891456665754360557003376542167926.0,
	1430479295047616590114768629287926656357398688039415515597427927634798419458530419056232695922315926487104045570925177959942819941484081827599934817833830069660.0,
	4209945706700353920071794976634876073006301250017896765170924861936929630924139247417641326370326416440130050861405748109185755177916363852151616698208705117214.0,
	12390156593694988626018906647539720885888902876190811467411763481694398705722271367886822977886940243985213002784546243207958745801356812864592249500885290820385.0,
	36465522945726687692160311369301442160596005933598756799446713374628702403843983425116745138939254893492090461572015312461150255967597920570994784905108532669568.0,
	107323151469205983670515001714643021396149094146672769101266064201587586183284035147322487071944799115794652742648852733225502842358567438924584022360556735065154.0,
	315870943440506651088048498056958169319987032598918073557978039438651295378803828824003234735633357472390217163611953819801047673592874473128116304228313409852564.0,
	929675097308820559552049481687479548752652266706617686051119387974419575526083170915043929980155381442196861641878823066746475210943851740570778445846427008823008.0,
	2736263695089873830371455117799566550483553842613666309571081671678528296035789080150167184306586101136566172832053153047045081003561947328977270182724130795289746.0,
	8053597096551516325054504673347789246252886314900744133662898697733699019401130916545625125132612794161330088524666061198051210394028554825129973064805620218999048.0,
	23704293784262162681100397580012411382120845511283705953357506442681900067632354911314086337441382802512072033348463547777595947246504939513940823164877221321548374.0,
	69770090322374462809156053862207294304767989635098850119147402894452039297330990531603492448590649279527898362968904378479310335190975183063846057186645048142599012.0,
	205360381658367479410065905689332244724261047630520384950040907970756932080401027497818947826726870798435751099576959696400371912333066965266190134731093071182374423.0,
	604462169080789213396474593177845430809790684832938801074431951188928219731445620688515708747725436462217877640998777785035285305018835556906103220153833663376607016.0,
	1779207678994668671026832644055538366888699113679974136803049765027426426053818135041046175669694571698967634959870726221780044909475129461072605964920996394813982081.0,
	5237079804381151613520861981965031319045428926264801550787206379412234420904042126446013267549216422550045345802787495301427787901340123149465350318856546886355096415.0,
	15415468925994902747839532647355628033983741004551620756880779995369716037774805413045736297570003768554199054976750262345203636904809011284373192476101378173139452684.0,
	45376318917427971090955970000511755662184089527581559368662973545261519935700799572586986078483010205877682724704126000156345659798787673815994848817071853715067386583.0,
	133569324194596307375436232064086230077054173385461531376648302853004875239011061225060703829060152251023460008686659770515243571362334657611349019554076233619398696907.0,
	393177914113730986864965125854517726506261462444780592485351285152069966303160735603614997181196734972464011919233501976374317383982267980934874901864073477730205471075.0,
	1157381115007812913446604266031088014687670021814472204345108064630691874483450759106297650934800186407128230487355506645536798664626493308526622063107015052633608810485.0,
	3406971762202765741321924590202545182346114634882782233686164812334016110200348180475084318289876299409846644253143413788731605206058409840785873509579058140264851869182.0,
	10029182054018805156178835496920189724236151612310772998909948397748103654307806421251158029720694463117377031630563207799959051510653812227846538759811032814982533329683.0,
	29523463718503449464418716532228757503565151310054384583791347815425238593606318258033509797388416488068707490074982511957178094122098221788264311381012646850738947521327.0,
	86910827943050313174790902935481777957236467011705259633529155078979830455603243935127656432320490559303085362802964426144067841061945877916569914913980434947903845742772.0,
	255849885385358279742489617186795267967794320166876519097900363174671510544495790408366540521781217296533549078151269138260988214609529766065984717241473676502578411987538.0,
	753184373499404129683347874252097385071014311572058453117968741617335827338326888394526836492817442126223067511064983643597892309987452640482204762347258928935172035809390.0,
	2217287887534607915348878568131727487267570795506278632248124956334548276481450997930307520876933953384768931886804473020081031949692138280577433391449029249087992964887533.0,
	6527510095243984892495956745856197343576704575992178064797772811316945546546887187209358752320659496233741665830660390113788478861752510238498010294805414200468027221267675.0,
	19216649935490051450882436953289500279224503691002876941345024888420618232888401204533189883042231148140233827498075144926441891096519549812870933332129242453102858574630918.0,
	56573420773917424334084667297820140386272904081751516129067332172174076135286687142003106787480086882735640547840349577149157460593693176453587949245967878003625225547559117.0,
	166552750846678108833704677266645693098353187442893576064862304306596924584361842928369022945713282070769865082921173207566222835605436044887961297772001006432953524744072328.0,
	490338241989656958852356444740144241574615869169499933221432321112573637311987713061145423538689776253368790517481883020545330616643156062426834984111800791045303916012782133.0,
	1443591386779484982437639782856699784474325155527684164296582594267150119807145826129271616839673668360215741446509217994550895418280812862169134933950402682021244168363110245.0,
	4250082257184130786134216517810409026474461493051610458709686634376276961663042412769704212261025717438385513473965590804990749128330431819786929348079874373150688477918980742.0,
	12512811496205616611542062256225163269183043823444925280319977392446831096131117353363131345271854767595795995899871139577731936659047063518250315736691021800355168319226751033.0,
	36839774048593530620959995656601743156922499039795556983750938319038135237026889448225757378674696378409631025805423836315973721610180807334496926249435566732258989728711131209.0,
	108463466291728327837387366228531735879412137219903675269756223887142771232125173745060208418376873381682733720431709175986863413466417622141704392371671614574355980572389761209.0,
	319340825702959348994393760716319738374571287800862715634939713906353157084363267893267852075898636699718160458938673850873858604174558322340514300592314507266709086815692049704.0,
	940220741707893867322695373865920326234384455980334810326222798617424223685416140265699094489497633326382157071944381332869154733717502638420067632369717664779578248691587905186.0,
	2768277405535035050208030009803566884876876193795083108870096458247312828569779596197654534984305189046810237575507078296114311509094341840024712046246059521006931137923304749993.0,
	8150678486971987299060891823145177410059722278076474035627456176092345899135048204042238475833423573714548742439058234546019548528147084902807069808296914059578039828866335402567.0,
	23998398885232413986353779549880646897536264218072165714028475751630442683045937506240899738601426608318160585044519351119486757158938144024708399589100688401381949169400763456730.0,
	70660238960554985940877293594444703764919093940151716339134518138798384533076070615634158606826054885565143071947125188938756948482766054082981772425497837360652328620420470526200.0,
	208052166512227877422345096057684390999017936005126191823508519540687223394114075651321178298768342510933530796600411664248744185223962744573141394922498061122792831594531058059425.0,
	612595310512059161081905046266947866248453292679774397076633693904400274522519616289916762708801990457767684786279801976117163333720183971978316006753200373053971636715134022480674.0,
	1803762508717296423592099571576776478131049755100296134294136530324969745325267125271014540490601145603761445964944733223308990133626194933505828613669517259630609684653398187258531.0,
	5311158775384208281312976735503754431176635730717350564793651422472361313809658793894302957429293241059682287335952027350179485949045068253472276244355585973699335575899381830421077.0,
	15638800262579173028680604517841349739955360880595099071749339902218720734335973897231794825445189050558973438511243273958021432513002836407797738430311594216209739015939191391613367.0,
	46049167060810285725874376241141747107841277688660952954449561736031119356989134594046076832149782062766543179177817203042374552300815014582629862401367194901964908963069298945463488.0,
	135595195611719618253323859653334951336994892076925393744948571070526306661770164122004695347472520449702501709258880487602312498970309063407764593933040155642550643922553039395988488.0,
	399273953878901910102544434386067235237534216238605675522493845031680389526606317446276812531118719846369955182910653689043934757190773306160265571875744143188645607417627827053304033.0,
	1175714281784708949217814473089881290397555138586266340251030941648330154115236715927559599417692048764380946459289284436061566757765494963758526436437482045718483277546623480093799885.0,
	3462076985758759896670347337773646204137564896788060487867919450010648358463199046107953208551693825617225776413488072157297531157222155665554008464066909335782105747870333077511391781.0,
	10194730313081712337002618548490233108726502630392465108333159454576082630702335713502082716595197008779198158205470240187283888227998576437373001671126227790963784085973472114657024929.0,
	30020563175671488531490382717577695518862336792960473722903591159796657925032365950809402463476079766849071052611701062693666347080964708439686781640384374447675298121936988249522931992.0,
	88402791998304534799118405301086212639962011663059961512686732962497437099941387293303529691358461997204812904423178031611186530240287371659239560614833188582984674438825348502165457032.0,
	260325769104329441798709781931142310288520506279116983364077868887951356108845805711209084394111135150988882783953869369984679917181043605150513241780859573218454968099669605669370398767.0,
	766606242445680220666855213566981060311180138761943634180056470507383709881414790280503278338117138386440309332452641032893608824746618052644123552660365531631276220126106657089485186064.0,
	2257519629598447768373933065350577307945190159566241387170437230332887725555282800328820383167327850660693333234817503795873732807701471510931512895926070082310129134568453255256951609142.0,
	6648056353370513241521433949249066477876596298116422609152914750020461515872296242167662640804597107989412775410819424900236290644072022492331933318832608018091119208679857910025915719012.0,
	19577706003640978962866465539607196283735973209473946071638235207840167435327089291299045155619603712478916626840847831792696420309509895363454619382577030693481653486051794852933738582592.0,
	57654451763604912540307922445323486564846871827566260176936532110703763868774881672325953257999119472655985328208440032295512085909897641269171778430025329016342547764699276689123592543099.0,
	169788317932014919435697067978249753719667794373225251639589300461536471719715275999831540174916524315376664186972390737922637600749560594045544167460395298274834900708875979827747440914351.0,
	500019176557215568825518419443075929754390168267234596315567063899372272841205203691126160358040080315516631013477297148476731423348745657766329220488174778833829507789363525285605683937726.0,
	1472547768470296136189188167982693575698654401594044325203068326470672262880169131371744001741339397829813203047688782911799820041984772059535829848121862033259864012847660570601838505083129.0,
	4336666059751526270002338208211078984016780925361937112157076028895576602319329273395887993371628962733254496743253907781212308913283043981188043966827408719676140933051849492675804748998790.0,
	12771632381098943984928026066150652054047086640112677910617667566081108213912718974482365482175292040661567340205268238833259686764332150270471438325270786275460017035172207131599329598358401.0,
	37613232462061222577110016879541835887488182531998373073375373826591924620171044980555546936567051665819643735357961269017338588154327849978786038854846463780709116356855296956617186634732658.0,
	110774222098712553453839937992230075901673420163805260569507762335177621960776773632264873629802795529368529562031282692763378547156556506447544069125393856746522038742273571432230621299677273.0,
	326242505335562398931976065586273665273632105428312684667319580068091800275438181816136245396919002363694254700287093547384595711809159128445637261712002590484897113496586665235916462235418314.0,
	960829091159706756962959911029543754872555766458649216131553841498373791132755963905898397669451564134934371558530516556081380311024801553769400342227661480802604755692534146555639642569943600.0,
	2829798366748283040535182268662047027253551625602600250720575763953662280085816739930660206451733904066992715879480256391438808192747023689715129656131544557679038273886347282355504200435721117.0,
	8334289250599747262283149594663640422441554146808747680146539632226868997760436294608584628439550244788791203122928624259528133986113979474267040450476214528203110484103153651213726375446302932.0,
	24546261600029485035550457560903791414068699465599887987310316673656415327151366745458154847313196195492215417668926097080798538188584793323782814473109315875642634804750709294068234057254374364.0,
	72294597128686215530263917524050322095458782043587402775882650397787011046150328484280026309484131263131806632424070623400362221219277745454599190985651514921999355024074935934371228871396823940.0,
	212926640572381098170830183044282974749119720323952709818926138170643845335178779938977483990473974832417567041755670591117876145532513043071665582614984652009038420836872853892091945319222713049.0,
	627130353772306131048791948150640655695456489542132877653699827599602637757007816260237003058477561862040899958004587485959459589924010301635141383814378802918431506947698553991794885546505338538.0,
	1847095214220769353184491733862014240001758928298713497663335498049624112480995334659375050282585608723417026912983557081165458961091521420297301230157978604857267513958531061064548959393003776190.0,
	5440319043955215938119707068940743583920547746884772169928440659052254667292260657414961652216668867257248319480248380616812487721799527323865812644128861649753921783943399970003733200853894155164.0,
	16023709521235807455942536589966241181658341649231099170288198457759827989762564203876577593533114153801299636661963264888719512985929490040282146628971085862967801607919071597151237690109028561089.0,
	47196016944924076089904806915494980508565877692577994073085843856452162815375193764309957051407105464078816919820753883085996840217915447992276978080244987393201973619350766350104678906351652149983.0,
	139011652931083113291950590147589168763312139813121314321535152831808207573137552311108933611851527751704848965112790796397766657944084466467083841172618936051123119231912656209641535530839138974554.0,
	409449762716594915384445066015759288903421765945022368062871184709435547159412813882414483286288340406983207123136420556260365773521421796945037631781675630419921866696648225733749020425028741485164.0,
	1206017420156661666754049591876310454683182291695570226364302417835048741430171353049093030103538664372483373838403478637831200623057410839909351116417048421487251660938861074285070722249653255335471.0,
	3552303489925724144925619699447692525085397447502764806778338943775338558581213756597037816980793331870043071268195208999774501270952212350374772291831976154411287432982964717907244877224770219357469.0,
	10463333118588785764889058030444019845350135386157989502213130681685165828323779577623391118642565419712410592088834538889315043732030760542493438229912050220214157785215378324876546142264921970554492.0,
	30820063801169007700229700990370634680934904378446034578226951908760358233443816776071012251919395458527195816762750389824668549917194195312209801162234265771324895910375469827894822940828340699477691.0,
	90782155540827201429417899394002360993062846663806579624462523451012522513030726248632095137589210768058271226773692331802636908328840055701793027152375863428843645559889268241195105256228051332018253.0,
	267405851939960175830866176523944300752530855707091805713973213463996981245033772851003960567549082838245959443803096908988052692582148191487500416344484305420007126046122230114529304020690961785884567.0,
	787670839519925490267443284114683397479283621231596426194882595548512383133826584773119768916616854934713801587466071925340974048262813767238615219342273245158755033743451169012146602705962092285243312.0,
	2320182015980470405060083610306401765138179145245844688529974354591420066938074534577582947202060870977078766090034025728968916850241363539767358731479623752762389465762172733933177515667822319620366269.0,
	6834437197006026149324821315810650289785818320862475074301148518269190888068870015943998312257592898302592686894397338737922925535156510189011762038288809528663196882590862457112315139386296746868291344.0,
	20131996891161400067438921498759087281915784962258619881910846335847789361384551741609659972462186648674859101259714809465378253300707301561662404277973977987320450317236292833878042059622275120954101900.0,
	59302681800655892597524472624396084409912629792445745288579547570852173501507566253362852600853019474529382178232390847572283276199685565769252308912649436434208363155055849462840327904340863130043306612.0,
	174688847038440574189403705143145082847769553726596694194492095230958267266170181205310619629350171386295478846773454212285563484909605429356810528740301326340836219946392534582818165167774121906326489920.0,
	514587667788872607123145870017666084640172150695987585373121291486319720896089659844698032821052550396612942226154347768869996506416499945642505762981650823476811920744764680425740178149038005232432687135.0,
	1515852363279718413634304013913302425379609190828661335818874958420971823630902647454082568033169882290012136402921537503708974561654931932057390533081103287546910061381112314033445425482997432600308865881.0,
	4465373151462132964561374558544605850502208770714694935800608865810682014357150204931584112239961965317015729618215537999678121112345998756127686597256862890504941313159961299849337863123133974257730841120.0,
	13154123470328358313784024210964016235852799012699651165185849806880940435427230724772389065024263753252241583199867027148977982729259321911345689974832691590014629639310115958482825530749215984190712209950.0,
	38749790777765468724880881673526250986723212323905843848205379048786019291066910479831779691735306544917411872752661972288076399809902966824195900746709553096808397353910546085287304271048425629108370531765.0,
	114151096062065223935889631452206733450921793083367619172752423882669707864912697808241442335776736550356494526794155557972997737938549524466713064111345922068524412706491391868625711073373739198589523429413.0,
	336274604933255271493780794099254625320654521810043559249374099593130768895429187819007369172876121222982135445631069553110648033874787354054626620392096658197831416268987588423189049004521814616971908772375.0,
	990629606023318011771971972411757068808388649536133909431973965466915144698995090936858436464542899974395949065293768545522164100657586832354576198253815473803383687718912722842030556867645642873091155123790.0,
	2918312313454208159507890100099346647532940995992406562186036229366191452843695904579760558030335255463542155245809922758955514217060667649530777596088894047734450836325129809455286497803086490033864204033989.0,
	8597168722190569247066481869199933276524191429199227127454743729953603680622538698345859256776912002279859333905847829463860031884869278205524177353481538872145992717055885174160210773695872772599174963884163.0,
	25326917524770154736006542164010688173550056971106661668197030134594614515195302212855220119127992314725103699195470005727403162805751046188806883468630789902061910877625464072846806821793754550335310198316845.0,
	74612640864834828564128908725538110585399058757745545334903138264865663157706703667035455847966617061648635399303088166218687530113623766403040978185110959428719708939197632376490799766485301050193466954808118.0,
	219809097457422849966415120872731812804906326743107849505709930777902381002275820917995415613891796527377471211617863920767538366480181316741457891699723927319418002274611449685667524874545658816901020683454482.0,
	647563073657659217908033933965611884477573798947288273655565488736474990507074036285408295783755522447781307698855274844538574070080837223327736544695306935938305752789435937496737384099293601770475003368488612.0,
	1907750764055657343055722726836415322728816434985146212227449866089242158149099268567138592842164775778700072522772947252713771011453472212969217876643292354162936542239788774685056728873805898299361426515058340.0,
	5620362538409895220783298733433814199792130597580671366395875832939091389356605311268231098859449727866215449971944986624975378737379249092144400413082049863101130751607616510382971070375460003570706170885043740.0,
	16558086414542593395610475523265598494607121539666776614281878534743218796884080340424295127900928153657146815460932881477570270788169595613599513200544137743963643093457241066602046920126861493250066711371820126.0,
	48781939777644147262063449369007394646484091129206466732801402581171731413163003870106510585603776813539372909271880699864860129105921567556470527241963166464619413199013777678359027784746232661094797559836379861.0,
	143717971802559252424964484517937262402736403735863381412450695426923989693690498214174781115745105756331892860272735826302607405451702207806881638788511550269917924584614221624625087081050209383010918094311415200.0,
	423414935469538644672351413652057200085894202707535174539191314194921218608060143652109393968318404855330569689077546614880476255416256667750569502994233712186437842053661370999614010729954801496198184821149210116.0,
	1247453405439508941361621699970738092352288672331777579385600207019245416745087802290773590953098379154647228548528646782004021274204925847149677301608509319435925746766576954319958691999590703942332531178327904026.0,
	3675238655174565057049168040612934589702952924998641157229814373038038995345343247474418012128131484128265499334223432253848756034549467892349527690757972197236031831458863207650444055750084153385127729451282391034.0,
	10828038672453585939445088464267842733333267294264582483786821793591685195454066228589111862500914081914596128177500960771603414548023916227444455053313488560205783237532497174269369926611352035630546610510349449199.0,
	31901938789433843899072511098434656600120688780327132327578868809568811057303996167620539610800651674503859011228506719985596855644916198969806305072914335604815235482758115909836363309636254748522428368765434618798.0,
	93991238089528383113829274377096769980577250508154598970915932003275192260703178425585104505540519679632123074237891822371202697660005161115679715128440906327478636637953707713298706927163373637857259702693547397666.0,
	276924043314466666150083257543539839687342960080880484623300778417227821719483398843938289081758949801879728333066616572136172364776638335183776100991606397163251566232435485133145479523534765622542164016674018094955.0,
	815900023560891575071864457098706092710917769676855233928158507032497560627388609996319427268804636736950102295948553057379213108653560557247527501544874643441779702129846008779148773609595357973755369908848951709088.0,
	2403898920772065901120151729030358785671546950890498663131833259666909651973525761090018489358063821544712462001989060730563466463670238116203434307843309861402245786564315895055522155427269032400909835740955370929118.0,
	7082693067371490660730996226422865442200516772699185974086707843264130837310450681206072958975973236788968231377820382693517932962506581187972552503971895769790666124966316725891892939892218242888890583868994963434088.0,
	20868132762424039275670515747695854072066824532623464879563200693350457220562354771883942305524948413686642483034136341841919204972646515554220927758036508212214184609156174844408382732378969923718707133289757660859004.0,
	61485356807446975733028195446247578556436756843837589682431036818229915035106396838666851087993095660338019632984059116554427789382485270177720614317995780943844361630964430369459739288564228179039983783370831559656097.0,
	181160174034586752128763373481489227581826077005930030574574956997967891677276392130183651498272922896393598906758457911421624983382633707392059034284273761872621249550249708009614522991078399588105442084159106212275355.0,
	533773087808120898823044495283078076013451272740647073140748418285041583758138439676508278864426835373704755080271002859281155264201004080012935224125173272391536167901119716116898020308887955925434526936769451162309847.0,
	1572727634621585686867567776812808850267232339234220311461399241756464229275710721998617242589850901732149438206936409195963980251045969147340013295635637593385753711350206041227261446524566587605680840555839948905305050.0,
	4633970348467044582823630134217644569196188110127268897148434881869081145128666619952920759951395479425247270492732720621483719423471484548357827176522330252008834323210574071849864831391388034788696417633310305903100545.0,
	13653873005026784856072363834574789054100788914275929166891058287872549933427667572103898524681193369111688663028390129040254460198540188116774617856315340586566298672070441562602767170214073529957255485638167666663846572.0,
	40231046688136217229329309121620223459482877707989719388930071512128200109328655302024296339327164371749759040077133009419201441417259396230806466258101390502460576912316169938436289901747409243728106205167062048458903483.0,
	118541291974055666527767179742820122795116396472066861633218322376521232703236419698070609212380037377892099607715108202700131685444367331948485930811103816028570883327432218357963543421747133456727891585728986463966490728.0,
	349285712246018700541118695174701102174668797624419305263613190991681834860360167824427071742843803279104805240953505901791902065943241394510336624632784096228320965553988129766145891231216136143593869249819044936725266731.0,
	1029188236896232974403796833187969587113100253861927699639249857183455662217474347962694605863207704534322570140503082193601290352430467145025346396677519448848311091298113127106682186558019653457317382008747258870411666479.0,
	3032575508278129141421521400415640559085944918173657124815806809413755992529865872143532439157021710898937615359430966388096198005907164966251451298104276213133116450768672359700599813988894118945039869233646186480737872257.0,
	8935754683487364088633831443973046791215381386738685944139474194267761873654483343073912614355366121941913424221009231005974519009203791832441756971116475130507804329160856569135312431604208424760787483659515392962173208425.0,
	26330168894156481071911642118675160051703890328638850711355892490966195691999119304401979958317330672214664388422845948768388832625252747920732819265414603593776996457776331402363604232045809866435728359951780456542784222105.0,
	77585191074880785488606740100096791563800313039760789777684883647243557516188913182417886568230014851468209127312491967470010285004329887067999672784537326303415242401637095356674276984818037648195954156965017831108758017638.0,
	228616090341034455659516478894230897792447970018802095290333269934153048833084657486864330933241803955493847886335650330066778759610664928805867759624125255371652171032330627524507668350815256376996301851985766739650862433878.0,
	673654959843568659249052110493303743160647129797416758038758678166689366154170363528350509289878155761932019628797493944205128077269363136571725919656964654124807947400578993680637384350024194857808804568491078311399745617844.0,
	1985047838270756198873837727098184420004713259414706393692456681700857801790716804904058334766000101941262032049714280143333475891309271284890669227900761865361943448231049200927723368466736052184731993158291707020971377836363.0,
	5849344221884315944403815933332567011745837850126484233735206613620104228921039018878005684207473950875066586345307568365416701487513945686427153165364508633293085254813531043779288411912352715065883385811769927093291026462291.0,
	17236381842741647285952927611422792122137474536377564484456450754463046427585857842413437970336889681749580586652637135250929088923452052094662280144391346071934962913181008778145372808312871169502595262692888933200138169394098.0,
	50791115097433708836248393207660879734483024850703590034005790587387599123069083659491042469813662824930550906667717150156089973400532322699482790346569058360283142725102063626790118407149197055501712181831588821308920910802253.0,
	149669080903056149761182206217820266962502899939319997952469329999416776329944527321199064537851333452009053069459997779243452496661523321553341047964778924500514655140369710796131752675708433761462857688225793485241578854663867.0,
	441041166087335801442323950540150802730093931275212248663512567189683028852888200435859440391627088287091393608451654249929464843529775642919600186977997268735733798055779025876387934109253940085551236830435508584447353407327457.0,
	1299657282815214418721988169033855087475614195079761130941545675486401763892640803688627676373428615558601098581756928018854279388821379321040684479114119122638198844627329183670896640697382745586425971487705825214395432740021670.0,
	3829845302305560664373692577213616693608898601999847715854166108058228292961099625626496388183543657154184727266747586659975896675145910755390581795185626191756131797725770839127100168762575005337005970105335444203535180390948080.0,
	11285902100652019171947653167127657219531430978835416476892491311552683055529999247035195857312517031191465570610548771361995479812576059874730701194236548521994550801939622111900047364729779644598789763475822128576283468655285319.0,
	33257834976854251290628280795774220563100856927362060819876140641235920774859078362168274040730094182238385921390254183512562098126766175766055665542707343911112349788686173735003266429893119614996147073100183190061237294226480693.0,
	98006370801693154309152325115523014311913279566513011991641380335301470988860220986292292384151142142606186390861541827780463392798120401455564684027539762351169993638836047016644203379971153772787388509335100542878010064856600418.0,
	288813352887042419724060930768420009613688182055481823929666166220669937301730021917466045723969187805056702904871892051735685738457979520118079602426212843607856207201566137234967429717741938646265196562634754303557207466019713816.0,
	851104420578030830171766543802662283351533556217730718125750010602468532453176706329189027371547883574966253369264258013782888526879605945287645314671717388220308429708770104103735878788902078937174928693455204507540870849529634520.0,
	2508135704182106599933311637918508940549256443621730912645427347278744159730773535606829373468429765374015024906132905273228640984242647687726292782318614870748380697332145079541588923132086491221464474989732807867526962892544556365.0,
	7391316697426016896579301716384190102039792830020037202213548390768819373678184517516538890890880608037317918102263358493424290558585660198865655072804976532271981017819161607069125931879160521632505765463000297036359713848092588423.0,
	21781870775258547085102539945897552417268559265582317872786698437689026454477666464259156169550338830584153301394304111002812779887325709344480261242675539091702155258280062028940156554206765908881920404759672479323570013553081863702.0,
	64190553256137371522318897786911710956125561674960941646684513071000430957853751966287004286172743419886710466140981389990088547294182345345960954820549994746855391034426009407298983188311232686014170771538626469732636513431284443547.0,
	189168850936556816085284619654293761502002525132548458975231558622777363074081239598534267811795398107525388329703492668269927776013134193819254750224088490902413691334622656166809401422142458651660674557944137103193446082777371413810.0,
	557481792669292620457878868883553767545274360744206948950683708250172315649943600456296162374546555716246978573906598661468854996038714503325304669007370450107233484569091632597151323761241643701187445123449907644727303706693512110232.0,
	1642911974563905967088173700165202598274883178099316875524484571079393014328816382809036086133044288485993045548504254833177168946322471515185531640916174150577628011186774673013022534042877990599451959766412373944462263832494823482756.0,
	4841728549463248954157856409256801224084055151590039936606255236139041985563456877632359921876445676151164086153275054886299661871844374261065218023068248064886039776209933467480805592178952066309525030046379834611591073705209804370010.0,
	14268854330673961790012417769040448889812293218407714115517022189982008516524029978397183436062693778437400406312163006819396409032890770055972162469973249824244974219930858994569415258827894054052990456171209609182157530245246089457482.0,
	42051383289674508572774869026854497881660104538405607190752997963872771959192584609558098766969193131286812276039728905063491392318069315765504684664498941558852561378816262766566567605788094506565471723453432532117853261241422962020715.0,
	123929293573082518237320516246201977838544247462579031053225068132273596111405841461562299288594696290355022328187838570929022182903803927591034116044319365249929694666066114941286683630884914318040959842447773729964678320757924237726267.0,
	365233123250933113113561366027531658659827574511507299194398046750806294429388783649129010651099259933712898277206362326396103135818050877294158157858754573088357482374551798780020617453275073014485387078445967406745700413636564558116196.0,
	1076387946516754741157110095213462082436655591308350103693186307379038331486149138070508354984617699066386053268766652386320874891014971451347756062629917699377134900535817269617730053084202606319599821351228061648358234102200178295438731.0,
	3172268732647646243892733054339977349577513233840575960847715437498494113041611268836586135621392314537435018229382495061061260565650875583753414179907484465453515500696510634024684037271636810157100951446195578471654649317986370425764515.0,
	9349181301823526388983413298680618975091514345165360106693563893602671010513690325401035354531078320668158887709107818187986117648475693243268677956107936586313243909702704589263781300232187974825565423726248504239914809824033915286969521.0,
	27553682507214886140423511039313089288385059160848554651012417240880880296083240430216547232597957515573551359033077765788306374598174672034624296759520777830383507649214534756879265814782361667233864102635502745173362699327680079197505235.0,
	81206008684402867779474379118530657946177183985382719900146897786125888575034583204600240377754109864346139133501151296312090325245800620381698023965379159720467061690192265280549649145991453564733496089073038708862401498525886235005095879.0,
	239331089845589398225022336283834080103957048534646624729232271070013223193918122878931701029206388948656105489856570153831397435581448771367691293415516150152979836387827221237422468753684848758377500009575371855046253320096651368810476528.0,
	705362716228654651114858744528643778317115314856300033703234865514193546543690945315731942327878154781031328921856340690326533186611063558707884890774732902666045535931030556653966161352475020560728118585281644643451492705262641612408722732.0,
	2078874638326519407522117489018866593018084582267093971448097361648881082126240279328303004942076261065204451271412818056449471117703430993518358859936903265628776865570454879200352366085306662068776640886832930798715117227561695364957757422.0,
	6126980690847672449314138420258687241739513539680312655674621564044258062929414320047472787931722631347506897307219902368361244376467324553313224259021659561985452993921602841597921237972495031837384342640095737532177612524125446420894688876.0,
	18057894977182748102409181525931205366898687459478419006709110811584149766992050166681239259023063596308876027254669121769214515707699129690089473825506816538383840580395454512475283281406709925855883555948589550318682993992048533621637334545.0,
	53221869469715757410804270538505754500160206828566047158679674490464328804391757251251293474980029969106234882978403422390899395433603652490053626338253086659302679450778311276514363703892778086378426213012143078029812511329257512784934744081.0,
	156861191797281995444017266734272740606001452871593155167381798229414644619877109288737515829122019263443622201372800202697655256825893427359620599853382316997094377215726095356053647840818897596723661909423587807224582902281242157862805568777.0,
	462320624808461107830855725738926628827765713345184539326699471352420319295174405017879176396339213635279144616519510352871107466326386603152390968793981400000286120311258898219457758999026639936868203476301881147851457398530103505681412976250.0,
	1362615706265917305836635065120444443207891348984741511507784308240839586242924491274207794531355491169816909176380191622727848543555854997352335694926895800731091945255040287222636733490259049253643454476105856329875775150832387095726289241858.0,
	4016112481756656917095795448238454046710325617114290795011184618448572553432804718381244396632164932253486558945222399079999746710331910306319046160116093770795933573546717735221422649726872506258190010670129969117607212236026082079484940912420.0,
	11836973937601481185134304678280254099967353779868552170104806452467594428049884715001233322764726708051609238103475939772758002370294311455606315398795513621645945959936231020496100498129047075797655913291478548016835274623383747849738460059905.0,
	34888142879564328393965638166686272472776217500735645962131083594308184956156335426703138063727945914095537545679331647581852797451691336710983413204410876796930085875070951079535927003643111644182853089480031625840161114299240996386554149030598.0,
	102829409446556363762121756426246237617467163611227548326648980716572097891210799061189789019088002062326949952997505958375564063381024192215962231524856785891065227363992779041766009107081684580338284263441410888782571069231630261903170737484626.0,
	303081306531078125086001184756494361536434645778208426887005406625641205158987592793888799719773246953639343788739243468442828144597676328290050089999363532137655947324383203131218032914031723334566238980533012203358911475618298829842709982267612.0,
	893312211626106933206775678728967655688433734707557050917982973332615120173318561656727571676081188504570581436568669710151878672713540359717972752010970308439600891574392927477016411696516773768868216447319236965352170913154775162197194218343758.0,
	2632992931982661752910342797311461093463767426953036912069053500654095710230915148820976528560206607902325732932943527898194818427323942047395396656902861908868358835028838797071634115280903444026554237199102813143751930660268127845306279797723677.0,
	7760655573614362971785610084988987439795642617253455214514881093376130687490384214794958334668488074373105905741623793720829583178760358877099847677870377888851068504857044053018795331531796774700777857861311117122618927991053319821060986559735017.0,
	22874384165117126935361729023065739052363454078986092007228720932466954125101011942838118405149268953866182831337970241563894686700468689254151444617137029173530507812498301598149734724424413683455356506206634988118752930786930778670118076821003272.0,
	67422164117807951397062331162961239268219188953494463614173735536770350088316202947245212761201583104519237829914377745151236955386541947213397504655714721161868720128353448137216662417187561787748871263542045678858794668660964537433155290514461648.0,
	198727621320928415572636498481499541307883804313460445329632032214337957052235273595637214176757117147139270159312972018288802617248289401648073415870996400362055262413472017234095319045030297124971617061065267394443061863810802442162375333608470686.0,
	585755047675200398339069478444565977019326600211394406700863919912800906239310127851250511392983776502173287901376411005264382872403805602890685902474043670143915806388911892957420891978552765578871110809147427005239086845086183387175723281454173825.0,
	1726537821816517765672514821226882029248826855973114077896898680970351023052971088351648551859443425768556754003174484960440234946818164265927238627151675417361443319938012063190984055293182234754044172494369483866944512013248336722181653828506554917.0,
	5089069666505952124556713862913096885210729870099506970107610293477179876632622053139402516684156904404687595766590491353425707216961689691898712462772298842337914509459695639507176775561520766060148401748214020701630944455273618986583906016517345522.0,
	15000403119598004265533049784674776117012790014808766469576461919730620005729827608814885343302317058832594777397790139602259047772697261783114705921748587537665195726187968433215761137307646888269772072133375614800476414940049762596088653760797276853.0,
	44215006275945001458365618486217467426883247360058519750150855958752757056818302137673155423178670607050903497971529801367482238927441564619761840267421974338560391022618029686006380528753930902934648462036696278144475886387639344132485898552195966980.0,
	130328281800499952148799821028394333452406225962072253271518003688259389598962042128766710299588416068226336860052205958781686126597304324454848543085905782608671946914383018794472073825373475302168745370432324189738049463634501185958797848356230058726.0,
	384157979404308424423095825068867272851102037065533967053569603015868163678261025423349258942011479375580164074165909761646639264572631393914993374243538527911807456373697306234759045276728172738410120609008906169446681171977826684546720384705122986719.0,
	1132356686618524173823069678717453015385962126369374612421094195456333458008898928008611299148431311840449385067978813176278822520398855338428080037718519884241378304079707493425645462123919917906914694509930256161958698461269733062636306463964598131361.0,
	3337788648181641097298925390556707929211207929232684180031775799980682801253877779556446796918464457562090481665655426525162092784656550624215836580380951774326800870000152699451255177360578318710196469965060352825450652106065662949121823934251560082212.0,
	9838674741046168225475331355755095471766642392027964762805186297749116849349631981538120888444116241820366853811834566564959121255563976289202888526471297375977927278412073192520611077636438928233536922141105962635869593748118809692313793610177568214026.0,
	29001238923269910834986119716294991278256218647902752462964079147399099695133439524370646234539956643910133302885400265826533752245617703453422368324898349767093990589403114867709302953143392277701248876876227103683915329891525160485581629809237612217960.0,
	85486722896729569060743805559421071168518749245729745615149633706182045555581898220311931858496545609798216881011682006186572016507748938052619422810461073879797877916787278508461333478975168498947625394270188327882709413933947971830419685238738955561350.0,
	251989792238603483746482061078213266729255893328568246804045824949134080727740787074706606811366545014166992162034609328045726711901292393777849490868545005846984322755562532423884669698496657293946006037478077148550062261845742478214376460836950711099649.0,
	742795701966133719984378639009316312324625561334814199930211131258113100910366634215521996915670638981554894705802771623724371448034520480618271560033159893584328079978645073953674287798567980534276307878277044487952910043208950773250645515496618089679999.0,
	2189565603652515625631109277789853295109237358761481693052827561863780458137308973122092127128637509193469047206492236245669391940993034357427007169780091231146824688582590648774511389370456511730199971378110224872090008304789166476252709478996841562234554.0,
	6454293053811021482908755892784549587105406559948847292967511503197408071231528799010387742601363081972496720115830834663317651022304246767243580056744724031440169256912054279367730964722902342675859919462470854274034881346903508556899860166966039098129420.0,
	19025738776477920080217084420020014633558182426890745453515446978581980683562969783714260891999979173307555404673393360752847582078200659026257002643562718049888931970925290979706863559524371310044587016987907223218023631163865270874920745899587557646673950.0,
	56083679890117800685211574044466364508076882765724976757342801312536358976492532800572350671419851236781724584772873443817231382854467157165275514465350737199876007953742294320325478986521814424156738512513965570593926279796537819949443457355432604812095000.0,
	165323118749275198911980664523872448354587358386385808861368997662549020131439092775763590304881042218794839576832525347859820605367272229507502221721693780161660778814207746471036446931645930670115735793297081989097978771852558560998425165188894214163142339.0,
	487340814650926007791419077854975305562623947153632551702903147019721945033607163093751156824399434991262857733129246416019708940828440512722608412480530524652067492170054893682860382209989380028697143895993789232628125493108405886732961128347204616314964643.0,
	1436594107260436769671045706285951120008628390146042138761796510204578793116566528973014757974897121573336143420435647438819549961565400312083700096296080454735326709754523384388195743638319008479393022622075830123533984163440484429378030396685091157147990383.0,
	4234844510978950021489201985072948479027269107929198454531095815894269734214010951675594887168665543166152037266681916352928481580012800588365200494650163540580574695716262261731461260735023293944667275909343849604838327592825285727470068620047861549299048594.0,
	12483689060843903546681083725601830467845824450463331271263771894237885751447563619323158383661036848936348478254101960904616426063362461208773742409827172586789202439766932608442596412058455616374814412885450235059801395463944491467287663348457601444171018745.0,
	36800226730844791589962727047768164463784000018149241693876883474808176636558586514223090954834807841986729276441897637324641193595378153675007177640023455997626265543318300868445893732461807284465537771443583589657114859531562387144053035222767787547050638423.0,
	108482607745734302486655149846703478521799213130398814195736225052478207911952402127797020931233665864176904206725328982588148058307915666826113025420270930085980040999182604845016836097452048739777058553176240382488540231783462790667664007597758128250489817068.0,
	319795097293654744940970583476403360623168968676672821786000368959337407705828961422130720396772263154297520608277827435028896529734627163766370844831021693861899748515346178581867682491837460616035232015150305248317776882430567614528515400775902809754216227950.0,
	942726124195201106731043778201443856906714647506449051188501052878086967022868351396854965667268377024480667606052169195506799439371071789605837105797191276144339456362810732840411008030447063561125139980663637945554889573635072925232230746635466624845472670146.0,
	2779081807909563482197385531310612533564743402083959442596179711886500798226618724620817102098369961216557986874934632845060790808032875917092197645829764669382568340902619159123703394579840525809859183534914122136381453824929486034382910467811704472017829157431.0,
	8192551152073612933019844854366379686029955505132632061229567911561300268165190714984607252126381242299886223711323433891786260141983785687535794252686234462074076900684786292422702675869262773063870079354042553525346298965751866649329312382374207008205902346570.0,
	24151217330619342069800017989155078683049380080867926155959237041514189111926250981932825767550022324060145342151944744923289632061614394397660494585283873402089906461785362100259421633829658931271776418070556954375390894135960083637470481492049929438169404840061.0,
	71196872605573479314889960336097169504076905627924845876804496439868341037718826312779773600606518202371833870084037040711933990684276188345336630210383810749431347660115293575128735112460584671201889191908230517526283611159893543124868739978725227435780614057513.0,
	209886655934281349401755214005374376971239448681313185873515424629320243179905461560837631199371283264158943566035506654916225679781647506235575032865403025363127166968046175649205555323131359152855087989183891972145960612963793344092591541453637901504330873135282.0,
	618743645248221439292430518808454622641613090093148917054969302472899116237017889953525627761121884305145946995653494905076695243449340750268664123623002235845199161718147145341195356065624903709924690599478487877947772413287204470991802004802726481445739915443471.0,
	1824058155477161076131290442719647941832923685116126147603452363026021364390924146980453359610812010361361640012349655682291494502619321089839247715685589986646304043824722574687279070289244356568052226137403400149791214076218378845566307047272533375353534500292268.0,
	5377353757214353530605834263871947483092138568426972030490747915781867563055792543548037517477206661160689340195841540286373309185576570347043963452174526116314085305637055043474160267399333222797917659837494477904743521933056975438321847586578550754080184366252169.0,
	15852600939862904703150220658290891626153171202537287294308259702177498020458319706364014874725017776445695662375056671653837296808858353794241843411963003609148460202712033984393385641557444557665673558057308821149840212442321760293106374206133793613641446127261676.0,
	46734158899241161967303279069569198690127491204793989893189087647721785308421190337238535179956160506765224614206482366025424091159265908464441154235508161680214679963235761322270707286834869906204149716558995065590113742389036993405397530672575522684846434842600526.0,
	137774965897103947668502354413318373736831887117064822823046157403620600739352502599034277776297693487753941145608751735748726368368182083292500801439817061845542791695958143315692308685683416649720529409971282401954908146763529693412075419423865906672925829985359469.0,
	406170300576586802042255286466556530768311247968726541708523746015348520187377393356621394566053478122531549855743428116602593567268974764153535818787264762793906244011779479925890793476270535330548737728517281114085910997514229247150243257440910958037209059437977368.0,
	1197424060649048621242080052400415752159831950221393676949457617418038703457932548287387810805191610015820266358801666808499711989472261035978648713841364593427877028982046319559368841297025652409609432434941774035997294991540340493238296978626848153350272794579398375.0,
	3530122317150983220592507732917287594224469105099414936306399898610367401793319270214811281954391168092463020909122119326911504561850008829244058029522827985038908901066431307075027611214368488607139829106203653616459169518577806733045902600248553833718065818435706987.0,
	10407189857812172241858670090658506487527622004200560143893338437806072778644360596149896420251871978982473815749752105957627016460822722979732733484428886061753720761081040541221556989402513759936858351038345524482741371499181175299933390407357883830518124213725345749.0,
	30681680616797136092870216610186046393209618318687621209476916757381151906913914858116187938564917352754023310850396299784380086766961582394157179386623554948068075786433333816318097950798765523012857725664832014437404971800592356631638602726668296473240731736510166669.0,
	90453785975836542880558822350192209598546111459053584741301978717780639387811180161861673307665687719859540586179037080345242024493828791440385008878415630975476389316405231171939976974144372762897257328260632401074803720895262539491797992067073167076119457205137754183.0,
	266671303493905830121974990091141987839572966237783310616427222270806433154908379005707382341538182274962076172295382185266897150846990163348017759623053338251244399791730533594470909548953143477807118248986490581120891314281534867451685220088196722350801194480069538120.0,
	786190410204459769013908798665847743277522222451571962827613237949031400571964948119509884171675767082193405799235273355013691997924889751403977039983773730707213079502186543804303710674087017944121324160519124592461890437120600046253251284780575558983550475131578029406.0,
	2317827533122832480393268958175387883119918545277400502170860092005624079095438786194511973873774324514937327011643147154351100331366743559924477185216956261813668807447549367319540988411523742090515683706903736932562203254062135789436378582730142551467963809482360967319.0,
	6833393077885205960720561418834675323188821169596390239493795702982447461022764242259138247329146847328822748566818251068707348849306608835443058493295607704653332118575255511807738883855125164069929029431965665464820285487495715921639456450960069466474589317660767213977.0,
	20146220979563289256367970821193243505587399524964747553577556912725079148897602560455886136441960322276023743301917923264600179637211689903975728006126227980672335636342004465697797297250495183736222651257933752498154875099161281769376290791072652290570846873538529568893.0,
	59395382125555851297243427967506075756413667471994000442027796967311598026605403656118649299298981963603457197779672287184167520855759889691575307901567961001429053689530500128916010002795533293504379025777736620419147542801185344038231917709524856103798320417598443970119.0,
	175111093170478416613452044713735631741955553737868004032287437139986571679884582310025649884043170865399751218140433681103824024032369851751571520520018487742184902611253415540776104569607394320002991873164989881232508070592681650149921863595322246930755191059711937008087.0,
	516269563725975549552091525573728774788824257928976452793540413433354188191188271265234733398902033518114087853819885823013845358260278833697012621493704115006017060913842463456758031071046440979926648274500466160681239231006780332226259397385697837170624382984318328568091.0,
	1522093262651811120590461084672819052287586635779138044289794829509703611475240192187110337847527725216583327021790320203160801158629318936229994178962537667222351894039946619138433620002249664941693479081579697902548151030736276655916224115962008975668331996025723234338728.0,
	4487535288829419894116104080535971673892018021531788559687560756952532715760314622270803059651305366233184114883462268210351036501518678864640256058733542599036462629786447807124215354728420850582938710967086096200373888054461449027435306775389871083917547915300844797037859.0,
	13230502996291112445716456337621146175067467240625244704626042536776623517471314661365388945337334082267679931434884272295433386674742091199745286316418375165780574713047415420497369382717224893477427825524383986420786927546306673003137795963539459736857394990341725385966902.0,
	39007372120689264800410167014670265476210139692983359308852454769771684966852184656387785980731407752708996649150532008749929083937924340007401722235503188719261176858684331374507865415891449121429825007684919253416826297046756824287223990401616079758360930396769297975789141.0,
	115005572514577885106883713631720567525088403897209802901931815392395208915276192279217452264670457396505706396659620620299344594919020631724856203110819774400778984298198784021739707152843789573451607575072787021289223200865957392644393288242683103605587908841886915395867815.0,
	339072776041682173572309971488747073947680295231546330016974512734600754462397778474447288784430585748762505805590684711312808630919147295799378259475364352105201007371932589666400629494076249209578956576961050539891137428034446308579762318765049410535709445297514391032833343.0,
	999697946638457837582671980147494179899012649480815826480490015129891470729571280724529456753723914486197247408443731554381524468556130072409677796037018215009375927287147928101507406158336294806741159359144401269326189710629582200843195269810241142366470214436288362686673640.0,
	2947450448246057117702749553830223587951008935532421816295774652998745041560297331751091925357863384019076703491779528808799723699793956717835051847778952488290755205487774531046773387352936589392346948761364656616890833654713263306777685912617672021008877810765999333519293750.0,
	8690125597527291189874236095055428846901925447405173348913450075593216623109276943966087393532021306415574681089472743254310092106446610932633833134993356561724416051116437573272901626273297639826636324464794571362018709600722789418874271626087716238334140742875226826193761528.0,
	25621668987625374876198201136984375599922972833803445870659046312755718575813991726407194445473791427898649533617584634284054665160875489405571006744599626722291950850081312673955276742938118031444270939516904956859565833388780926184233067467984928476625353324253434044405049810.0,
	75542368106675791936361289076718001951236401249611041144839578931664124671012979621274308780072066732163430367328759711473372461068474980002576828121402365004405048344395143702477900649200777457947998742895630930425764312209781502928642101381051395851606589606318926279398105502.0,
	222728393109278436695782952828873748488642341928062098949965446701627482935520980464828238138123601235954227801516201955178671063363294745518931927119087967622843101443219899507159161541407560475373330548403769808362160623338513482105988214023087195604333606719691692416048631214.0,
	656692984355488170229363918356324912288301258931107316366326616822892212626149438485423134226726623392025707370976158580007732481016667301864449786065449539035074939191007577218585845453361331976659046927126038128179513760262856872504527031455990474061220587750109159972447007719.0,
	1936203350781342929376078563359768171792860495116146824364867144947777913912187771560382680621687323952151443502917528902985638610798381554900620578670814901692305698947054860965674168343236085154793373028275730198013707591388151785140605442639841334701055450200251822185748678657.0,
	5708754279043679094790766835086754539188239035699139571113490594372062739915344138687652693034553990348529494971590707483483776494047266319319551270892549152010036792051540231908730862021480304495286209105564551221261824090475642994181937859320880284173414583598574805151400472490.0,
	16831914599669636785569482934524985242582925631295430475385818765748850469759564623148424313937290159954005412805259499712084601088438718185141449391371627029677998771070935846072286464021290148488704426091591768362923235715973719109703104722586324261256496222163134508270386168666.0,
	49628079358549168837239036842004372608080614068798237445582722266181488580827840894002925603691764397096893904077078416270953213138136436136949610073909189561872564770045566571709219392333462262483261715989430043459847043415358741310532397919054348619511614831116192446066290215259.0,
	146326569601743253407923414578393241839715595557595267367674062024935017040929832910092477393395586388114387160169874174588269388931146792386091545891085267130515810325067878382497468048561071023554952839932840387116492056037441377064278964723280627928595543004177393145895535439332.0,
	431440274070609907370470346379330993210604316535791329549373102926089242338150379906965425739093745771625118538539155944391739203929884238046531765060526593228745200496253983259680509357356580262879551597058624164006292039765318827793143290941497357149842767795468477582447149056796.0,
	1272096148226117618465814355845445276622218581006323391915483768861398262454375375825360094558789174492783018483909095656401233481758097782135640415197979570461160876193449764663013480107112820165685492441115152903064387418373273928213014258376375831852635507967418012095726179945069.0,
	3750774449874050216594181572749164715961314285115530911878573191057085465769177455706048547291637271126560038044125257601641082731563656718264843665988389239811286982919614591928482546277610899191590739199745672504943203542556089428999009403703159883523005407646534967390457655629705.0,
	11059199981225940509256370840148669815003970887515877894361495676371178350313884660325890401468504153537579111388812979801075971145876142948205866282395102610727685902117177982482972001864792332629317355471577449668727756054644064753195082699775787258803620451637469527792825287327094.0,
	32608304603524997112432237758333887322954265750892200843462984559999201587244746821112654513182318076543338779046493572835411419645236508259643243548366351316511542651653068687283519337345559948086239586509231374332810776130044987713802359385215502971658797356667006556798628211322205.0,
	96146718593961437414914240812346465422799653888994795748076634721170422787261513539155964168555725086643395878079331738068777691728330089516779303983250826279041367384543749415461079807159697793691822184697037216210394585985569719857627518928454596344045067112246428035488169403910863.0,
	283493070806914597170113041456925034882313782671128255722925326343541051747081443403130638105377221109100086894791885805869908505519075905163005351278811537485392991468700960657322058639943307349405381082100834472349429730694728403054432291673736759042672662713659336138022669104216355.0,
	835895828943308959306534452879309362282605729871434107978783100088842459908123142996990071443435178712340141917635204096232533210737567515866281435506172615942996095892628497416678338677341585333844568065104253569989425157549886475971237108330806488752772092374806758622010651975895938.0,
	2464697308260299035648234177381189990700530227138684561651105663787327568094579795329497683641056441255531690878993733340228924588685346777887431610961761630398879983226020200753564445446664584408292031975614126244253573411031822118168507266232070883947900752304850508612198916904486808.0,
	7267361111296030891527221897802734203697313596820414293124623220312673739314267650333650016354387260326023652256241253959932254869898620517045224684750904383283241414726427294532903611082810232018143146890473986475553991319414783438459187975845204857766002345581970199925462405902349469.0,
	21428491641967478805259317840301458643052420792576779704600559023056112479653409397406442558066892650919349908654803269252130748290721924598549418859537770285683858541116894012069760058652447086604165718513570236447148563280064308588275571624262857978683971144983813954910393012461541814.0,
	63184153208633871057294459677784766314116868938626244295714611513660067928861603194855600229181550300497489566206558857780869069373218772993724234572020642581070639867042136865106625398899261402463000570863069259083734077114875310036943743587145569890896070204830088744827094351322820552.0,
	186305826641143402167645975551048824627871195494362160003848631580962590459737606458445249683129964255030801693380505394264670103126581163247472923806911253999472077892039825325356322176000775686724587827649951920891745552175159403376106902911828191416180196641384136849262237683187108811.0,
	549346548976170233426911378832340986283757245237309372182827573702678995395467509561412932375347214009876167301389940813411587852265602865318720583127396189386703524059678862930332486480307850113591361804690600917874971953673571898517277373672055347728689807368733482591897861355375975011.0,
	1619824835293910400195172342070734198393918134117272021266868336914484808647065997997984859031220047684385882379062157073474888939625378955081048457498193460699763322085043182866791082661362932032487777932213296501482472556676239620518513585897506853642772866647171504752354583956173433108.0,
	4776297725257803239393065069944427089170147643446557104543215045846853045193218269847456449477073001491084445027895123432821010062221617256645919044637981685046930480902933267206502135540197604109432421263085406537462572547461966468089726517279921377471173514250414096365257464438172755658.0,
	14083688339797429193329595263376953855667043309379004362619758262815289111525523912461324219558202688615529808328270716778208746627766219256977105637159515693517551516765082911621799777966486467109514940951351076425499569312771998520776037061361154908476885490778043719213353403772093978516.0,
	41528198814374350650959445304222185383774455203983085342502060685733537901881265680935140063324684579707465598324928429623786555390401223617916496386373765546460726004712233705680688899073991761460249761495193346777007364104701515487171401827821223087609144026171259648825606008399391965632.0,
	122453570333375464621597119774713346401566670874811726886533239297797078602400805796565346930903132710012318765737613626030662943608445711314908019394493553739008901918948954301872203852005133345688616648639389273531935145668682228491094132786023898875696790150889971183437805183907451100713.0,
	361078369030192372243136977813718092163949991163799365628609547094117610370790554114899200313699864750589460008095743796185288962917337434308654739015462574546038104044003074103911798778892436367316492675266366576135926762953911483660019501497997886176634488695048626097472310564202195183175.0,
	1064714452980029005991386144662877765026760196026274546639578807609240073096531194002408572352259458119561544892140728358406147519884751562214944978055837589099726270190058838183721351495200811860224398827952659629411140084160655839479598441215433867727936300682533212666208854175924321809346.0,
	3139543312944135661145615529972969524500207126595603428265632847960748877537521853712695233827760144993906405455980608127958573118374940142209017795255034362893536069512339673970743128735399179097743663502541275682880002855221163135949176159161575792836806165484097870373105960857015316599864.0,
	9257664873912272904805503472055701571186448323980410295381086572941796496057070831054319587729865938689698682139343188492066058665720132967748053024629220167289867301880695661437159838813556254455349118550715949254115348261138657248609567771687183328012233412712202476297333559914888088780406.0,
	27298455331829290552360989403259426651593627399012477356164054403422706899481438419406976987226112911826200412437671968194587569739654466866393555177852818777262969359107393852970792151277711189674934464062677717353511224982512540944844019007157406110614862231945239495868483905964626392661326.0,
	80496375889660467604969941949062628891632181934741455585138063150660236640354538917433114025700357289474538988379552732083400287265573366961704967644282030237199264509186427495205681142291640892993341238744080504774193723423186379565575054953752880865090335038309159974903564751520340302070446.0,
	237364744332555657510170769524622964868442565023950226271846386315743728611058697394907262456385571780070956599682322405020400804683353186805462059797196447836334636646260314711360085013195479966299757712489697388084105828445513446951881528769766010010314061740196895297175014278395492978937959.0,
	699935024340622608501274065000709359130894123229659174639890966699087556247664156881985792324402485115317510052327394998136330632490000540915538587639497936567861687619498443820962685534310202802713371270604557158914532298170245742156838102357171407571782676071038135178426232648389675710371398.0,
	2063958016579502013212012037898705934068205725373181884348932613608879594031605331750578599907000987864552610108927614541346855773457186443901782779405141067523439686057296280675697488741762586645291677382762136399945740979315225408947775370756699513422433832453590927804606858911546983898312064.0,
	6086191427024833484362309412788484002374343368895241152304270716704979535559087252629543247330352431275431633893351729405957375044217471728098261745429642023190069042105624279888398858456872341086943705126122221245549577421719882212807727928832494243734160813504990298145969005454480936963357028.0,
	17947004338935357900514828192033872649328163358341836500932767408047054046796683973666191163187985627911416685740693360354015414486436887477967703794761444561267168597422889397250643240184264149982580983202296355687494983249075871538622779590226530451249775648334158593749710521487136901550711339.0,
	52922449046682874194381751898228835015222521669666450093299748729239736598345511925238764529160091586736198495007028491807850960988259306593879906957830650843033572717471282489908117757612743555032098777765654525658583171151511902001011909164242815891396132156841232949375635455876355371920492380.0,
	156059244408886605886849753857473915932246026595053201149055195510168414211756026252612034540584325924171315918257239501106500221199886813955118022121108032679711626209829040804987814044796714974538910767645874288311410734262991923890916027631925291609169585691370001536624619791187670941020485488.0,
	460193692692061760383623913954982857107442403133983536700827082040288267751825744292605032264281760207962166942233135563201208907215850394764188164468511202701947959442380835640499636096678048496639106620521057293099290922181036850533921211446690167550276138004661510233788304808998024485590938035.0,
	1357042393221876317255323702084790658742791580681395871915443933621689001515608671612063916261785375050362687940260176309109449593651178671224207805172980341361410341082080069775188694140338534862998673582002210414464170542045791917691225529693542148486236121353141760953855925086498182724808110097.0,
	4001729729647763303434026593211735245778093006383985280548095657071640788188453497120809668393791146901579179394293356601313186390325617843560077819924983485083463834077512090930629209448518304460145901347391848111960899260182329744647734239151730876650347806029983025916692250299716821587629092819.0,
	11800588693004368122646246941824360783947928274461398380411731558411922158028026395074678544261423868787875808130401656481099976569936860224636847840760164019603158408683864237453935348752480247653037759289901508249782467266469657999749872808730732968234256860051315593543407808154477519028961588913.0,
	34798551684896939607436026825116341841026520609234890736571056055527683243436782727754666298781907810593436567091586152075408124686605104828582227313640034517896137604384445321843444490348145656460302836001543509520255605840460158817761644713131601597711373440092532355680979982308110464247183030593.0,
	102617217792198229958883970473354916293655440042486150683299450790493649684761665611779560062489289642462370587646571179984801680415584946166471417844320020537808223729373093359914390940467303963838492583804444891820715970918710635453504583171328203663620976436744826361225815259138354624283771086347.0,
	302608322854041312288663936058018310143534737309088122200796389757788409471188934718692518802593080452838214955833784412989869618263893560450837623440900667116689067600215240380639489485605119500056049391094470662456054774779731548188464201973592015448295819720249737693936965745170973375387538112208.0,
	892366098467885661649119116322209256129372594503692774712933862190856138251802844582378358407083914207686719294577341712338013607142420677752465884772842612776854683606350290138064568501349999606666103122084458291484622761119335911742858713525110712517017075384455681695101342675338652177151822451288.0,
	2631520839339582821503616814515937540465529185993784271523953060713439853982396984738091664304106445081898407445208902359974233969421181995425873370649147890542578650775036989013976854132364277625927834633421214082555445759242540791342903738843457838083990817359834660542995860631205879916937404476734.0,
	7760185738250329010133637642142516405023981872433019927176210508619635090543825538771483789400810509124477604305622449276859358923695819019972362218003771992848271807380480414447598595562280493443371013987445339808246833901369160811724305997074673696271801981200657975156039118736518668084635388752775.0,
	22884370246164828914734381158056346878195963708456973988934299587702588931082509203026510553677793966013852259475444907678715801847028558538788282249119856957731601135718510423656025669332152697893902129680556360540471736451671204085448393958745838902126792699919827837178546378632357741559940043644921.0,

0, 0,0};

#endif

#if 0	// 651-1000 below....0,
	67485016325010471191776213812410555915029437296076122382024030363007094662175498309713546127447270883987173966786788251966551007913212309168965377589686734284676017278481986982835424371021892964771878071835351589133690901330984678316324183551232111207795370902241506967371032514983843770346665822857498.0,
	199011093687768042186004955773892813434715624586904411975048687305611773218453091067523158229976020404195686922685181757448710814848894924201270693206338134968776671406677163815459816221838879469712521533307744420162800107683145198318801396795927739636839886227323236556693747119723975453484528213533500.0,
	586879241451912655668475762474825393927233218879002697623266598398684845604173337547789367585989915680246003873145622945194641722428275569925351868508414975894127989957641512860009589295726719833455482776470533799966578613652888197812652486626983668913677558831299059741890201988882326625792065491552771.0,
	1730699779249306548780251530616559338940243103821927707091861016665264311874015671218676723266578760065906364509778123954993924883761519580525834068494225809781251463868363588735641990606155421650152163071341364360855149217084853757666137742211759941258738632470300944268321518040308254998512427001153879.0,
	5103830602880159635660284850842430771322134304143609842192434306947815445353986153272647584949447320197690135070780817401047098814355078303551739604353315756295324874654229558822538481691090790584117828200287336616138721289823597802439788429350105314120173959206845415441175927909550967690411127366779190.0,
	15051240099492663636723388063429406877918215703249924283997380120086865775450857668789757572382146747305333749010287210299703678438853196667136653413648652088154141825919488454066099138079789947069841633303927971498574676614402537851391743008317091571640639320474973268158473008633698191080536297848891438.0,
	44386390529904216683531753918958843349492822037259002751612307616959840626239773340276506199824375283655116452323931389375703921490434663422929159826505551559085595465089087690124081733108027945254895487731111529815846826259124345463738382579312714139388178679985779788838316525329654225296452594324307386.0,
	130896756616986737049083911392768793622511806259835012838350711856349905754538719887041394211532426218716638755715297844842932257856972517042090377567587975057786080375698272996969414972204148957805873461842443634334504352363881568749087201958388666628326089067057820305737209281167876983966386544570889786.0,
	386019679935144523746617160331536890119761530766894995551142672786008959378994909514425390965799522094678292337358995955686317754122763852530852683286585542823117282951907145292742708147150387820264466511997082941718018793052864326734972093317801883798844244413664171347332992278318069612100084685313138091.0,
	1138391140768182504515279378455011529068375416258103906254890137642087884196455443655796383927595202186735988654028605300216717915116136763023521696209608828417738783018391171596892661025453971393803397721550281716438867076717503131827791083797900790254125698814170780787541759324605704107530330042151103036.0,
	3357183377593256192056375751050366495389085877910000239957361504455251087826029459078432044671798736839428586200990524934281237580210332781262658514929945799988914062282595552905534435472219327470903190034735429927534286849171443989531077909557571061985506941182841692141923193422793879104035833361117260112.0,
	9900568028708903585648830168090181814601119466017815008918913078000901303476506909234426189374473840621586311470164223843993746909148640322879875892605253937626681412065935388818470455635168451510776129812160021404033794099657164801268187966798330473246356542773214685061444511968315089546546871912583387586.0,
	29197565887513544276282783182701766076029699883956497966736218737847911257502062240133966746511110327426103317322711969038794182813721024192085448894379557216476902545682365235119764298851291848078896711623352891434418463159178279179984103895213682693537554005064404582623866902253034733481204290963292820058.0,
	86106247741037187996002907284939238210205121343550197105106739474278946717148831146469371146331730403808500139662876847712576908950681736396573831863523722198956247356533481247392103033193295384817420596367222066377604591766867321622468997138141839765182270987670929680056159705431550172234231099952819705937.0,
	253935932826937959763621385182171912954525310565930264861821309897383328861354072335384967600620773046397330445160736115826526612812725354024874527448714496259661740209969732795476754307458032533673560134460679368050050682785301927332568987750366423355357777344675815120358955091744084952367783069209868829105.0,
	748884993156271988887706083546292480855616858368887303826267797524837474045333612367152269870143291965597712189870657848925384319989489469588040680555869115397374075077088463443758655528611527675736424249602266802762963459217031303475674119010218027324613467820284476575291138083398673533890297693308589746182.0,
	2208551675671473403818894608787485525937829793351135959105242620573338629011134498972322125616925022821544480358492533180328110849457035305272535031491528718546736950379465621720329192041429519641747686384111998660989467542081023373977702516622137226878936586308108803469560248824124548311417262016413115084568.0,
	6513305778453974116373742948052291913291760697858300061757022229883720136030630653915510889196541483838089043134944155721902960723577528382380976521276567078838674294440943154826037501051721646107715048865282782412912840365064784989382779410203641568597150743858235478040058763058698408094228082525044802085489.0,
	19208649391238540300666720187488924309968558126126520770490270498750723985275765855619628182723277099371934283250318432162728468663002696902003133637475575695607574328342070802602616848697344463336851643226652680823434581437131774670269999125885793707636846693017556099579680300173964869865889446285177079699791.0,
	56649182589028311640016679058046008110647303506219014937422158743308457173067360082232123232451452952421572053799032256521460833726682551070103836232462543545493860692357311552086858781996346964228355187621121640724087220839589976469830770801746508368897279389742515173530178323959981749302402992605264038172136.0,
	167067478206025863371940268126437189587535322472998312644834080591056528279636536024424344345760123743989815396670269686958349094328169763619689624679776032321623929838005487860045416496367830361204511444421180764428288987342119835777902820990588480449622509822423176091315823819049752720819883121313516864226562.0,
	492710291770879584043299477490364478364630951967093141936760178917143081113642006930924877919410725236920571980642426483143441603123643852442503465622291078638856877337086465973926988397773126925771493911396630952148130103799561801183455074867112094590550868771746029366363788311458439109768084124010982261926028.0,
	1453090935251052932383948862114291314104253683346689657089076471433844393385047819524241051208495456623565770886666372103703575041235225426112719145564260343131888075654640236882605599221301424191590603470295156694062870294538087328059627334371563666036986610514132481589561200253303626469832137240321995165421109.0,
	4285439731105579604931349044870726701585282438276165776278276897644499275245133929270763219257054342494599694326599418949517003294847480296426451505339215300258175454327259378562549975499973443671401697020398526465063620728865871533804136992162903441319466277799675910691916369420811231744717098666241901992488599.0,
	12638613245958381874581196673004631102600316631736771873017440403253596906836411072005785893491175973527956323087859722858001010876437741673555063897474475988531914675001581251736874362290370225694894981469637177596286397960045936505513226002934899362778377528266318068385398075738982496668460944846355008431159604.0,
	37273904380127367164606726926678774256363962883299018429845195422374937631384711648011073199700839787122017519559988765242043280710874926798671288800676520390640330655409662347632518738091469710022200137624478556261659044294340536823188321895026388126246584296678721272052584821309478276655952224497875921344959164.0,
	109928872898164849301048970947381433830541995429283813353678189127258105746604999458421336981732671654935848293509934240381261498888162016438947988992579502922579398524290632271572641685120330050793708739797766412515079286904170815062454560024035560299160469715833561510892649583270026708005022729266597339247379461.0,
	324205281279448701936710503167588073882565584161250092876276445495697255394224871996201106170586580034082622617470720207645506797215571385996981163430436485316859214187485814981522116932082665943682445705883367336636413973805770690900101468294944861622171287573140359850117682157274609490566821091185471115734592611.0,
	956158329391600310392761381212206682832570536947889757735357540276504317296551144884526179532837314297239514214449045913799728331135433167494340711354797180328926981192852112302838598155017597406984613759389976027624608144679654979214273244256357298587343150441903518883244012538719546469897859803743843289715233197.0,
	2819947048198698756825653184707907169201158151210358906922533238019265355677821871910112139123464935133238400293041841952450671024739758565846369739057502924853787708811501674490633316509567603820627015043766879089763781276286169418470352026329569789315753539891213415873207555950389353728537633598143917536313223453.0,
	8316747249529115029480648692254531851170318537917242476010277811966149742667196260434891728685230642646556315575219433425988168338312529038004795568790848828276715235788763471550969172859192900663292083313008045714699246144650874425512415443136738949438494708212251910872646242881561013852695803991322027981275601379.0,
	24528300494824081616056394267196942169556827379294170047836821316133002454988856067995049078280652221441515334048344094262806895255145380888029980469313110314840267411954488681116759073589028625854221262841438917959479982050123017555507591873387619864814346759508410044960143315346246431099831948387138568076208659251.0,
	72340717801873077673034219748875581661166438457009704791269731907151728947774549519362988162177080077524472755434406042595867640739266474923344179273025011203071459072936218172922086916566975017333511072810001027695856578710344221962185004787529551142367266653719454792232924096843331711785588229704878835483361711537.0,
	213353399023754412669846677967624356329652374152798586364448905236129107178438500112289691264021339439121136629529090455616955351272944828599425345496153702670717638646028001973830666823947533626333640117567651380445116352173570769380066481937400588670346825757421304768855484113060936837918220269175513319360263120148.0,
	629242012368948857077684148681177256877351647422199577737474362450594562969415526189745607777602259426032527117704473116806594420674928724455501820117642725025525978387794727500876473366498129689801740514867856644295109128344359898418042761976392518858395204602028972902726820169340163878204797229059249838491176013344.0,
	1855825957969567064531803735945745042634512772073486672596116402762181556598769798929912183689772448453876163324322954806763151390676693105079096418187460159605975694347543574974515847154336657096916014387506983907959938318044234874928126662922971367889618327130535372811595305849655408489059403356714862183755869696966.0,
	5473412293914832570048658107812637785329573755856889448746559828739624434956311864269647776799391125146812537623114293055413103590524883647002421106694034469097989365853917423287770975394146980865533547623656013535036221607671041689902547812293935155877898572347470926906820840097606662323166414263445112300347935277880.0,
	16142859324857839814861599823927185468214177456348274296101512847766155168762577207610156009033977286612561873994976688028329600046687495463065626058674513427383958114223163430983344559977494297713705840532014837798236958759552838258905681697842715223624582953856854900005865440699328625315403942532813115511997083383187.0,
	47610652944794669291850202195033576200562648758985295815663066546074783040247004498725560085433405547750121196964902875180715159050421361849338401224674823164351839732767046331818364159837106424711207396278569913094778898843807211944771294454857476708237210224108380588136324658296698658772471186799301502117470594664231.0,
	140420070081491166181225436459797653682904199492050361929359106574930176315865499748190461142571633378138736098910334421997607351306378103648731204442990239817098552757382960217932983072883799168506633264626915967989313843285079029926119605400823921567836362534601955132500635659556550285645250816313044421740458629117876.0,
	414148031951891656033931822110028016974620873157770334729733550341924072648226887162352247324716325091096542373936353314657658122860658642216979638251154310440314818100168021246094267612319323441055502586323441838644181524509436193183817461322850711271999933407303999621814346165846376837682680957828850147439942662384109.0,
	1221471625825743154163545952647053371754314372948568269780671824059055093787207316312169721801535048677053899997961160188716094817386078954060927787694371931963799793531030265783072397006176681216944626277916288619320933662739191159411139016807441951189488576317124027349648409881758144380516660938678702054497635307144657.0,
	3602570800928841264711847075599179288018697768010646266707884704583894261009488726675109215995123337476857959206344132980055248921671899772709247807655679668448708875672637488628817764709562778996180460475937832155088953677728309422878662093703750521665666305006056811325436247381532551119301766340773318608470840402899991.0,
	10625344581273521800253255012209499444235447244928545323230836764570210571294406668223274594659137616791086355617963150915569259517754924720745090242185847557757614644321742372823018554784113516180725473912259712982106174608135813037474957017203950993420877948873221890054887916693138332745767466433192075273171619437000757.0,
	31338259644915385797232049713930411866742278596386408843133188575408645368635743787037275330701404593311638034306473435089278003716476238605866807363210679676629837086944590404515317875043208540330191515411603854495013887469000260497786655453032079276261407750858556214812662335054415944513365878949700799864768102755916324.0,
	92428961759166330771295530603100320342688818515595131576568520586275521594125614514252384423045802084562766651454627730223545701989027215728742455017529611905696171414920404466145238847318807818943296221743067965090197644478980793631741007981369808321324211549467626150946409437075201552719806042453140197826859187940167828.0,
	272610525530024742545857758203864297907536656524315465071097473996954893643936598333693300231256694280591164267443986401502407903988560931297388286874933473883724803364570373619102140780632741986922902093958063166432765872962046629653336851094235301674929972354436422646869592850220797654310665484670352595398150278006379075.0,
	804041576612117717194945418497398003262157044494738513061396882480964788421727176213851835232591440180434144182438335201434291790136562028971449203331271820040170047522507101931814625303628019577052123533135783119348247315467162082166069482838628351237957527817456360497937879338417505957665542826189148951236940850232546153.0,
	2371459599535289034432260236749956794638274873771585754871093981474305055436755866160697339379739589957611682925584315988103010938306629901464196170332850944167016088105697966106117533779960801426670949071436186843798627611596311030357955105673688439269648154246872348500871883111744747120813492811455198311534243629069839076.0,
	6994461560579414052892917140232040925162295478037554136099172258635516439865593952605061015933344321073668443730453741609731062262705969317328894933909424425336116085786815610231167656901590515860874958764758511369264789844177871267002921328372566815075239626207321870112651884794626515063115575399849973759289381442966575370.0,
	20629759969085011848316609567033665630733149122011666463538844892602243525949761546369881031007108454526882251682394677125706054623726301991698164633348636099429999601088025961341194354131328537873057392697356071066599450364312863695232299003292264694259458651316495159067316531671869590952487834094004967477203223494298644082.0,
	60846470032855746465269508938982487276674534523261065228985155651219176043089258686582992743626389704924298182637615780763756229682994789559517832331876038883728130724230456335677593083030107105824730513455775217674275440199600908233419413874207598032188597469067588164453522376916196461909718848309933557571377298141750738079.0,
	179464239637019261685432256614313137175578587090145098524813995659439439852718230748891214044031004695647403042284400763157597210231203942439832918304639509222314459998753223006017752965540811360597557020749828874261377997496959624363009192985707658269792227488807188345027082241379501047557793092921804519998107074306660895557.0,
	529324233021169173263016593485791031599885149069557149904006968121172176201629967759791713778453856021545478774134501640971085244767217711308015613059495384175625692494297458382064911815854538234023383611373564837674483864877365637279025733050628361534721497206281234897005393749780439966597800876043497342112785904299604812337.0,
	1561230205998560748916251293424036505521024082923337494985472489428372001738796868085985396978705239525990384893112137152467955849899360168081197586189681894766953350452591758472992804583174308947819029343116819714694970066799619568924821525758404831576363272369881352464435911456035144626078629285346960462203040560044385075927.0,
	4604828121591072181536012376751517229035031078094565835691102798874868684526594387074184711623121580244382629661675112280705997775248947736986444006447213419247648357589094328689846484210039587787466142258952918684401967300558792036174936430693977484287972837556488915337061020906808530591700094094642784353565416460043543948386.0,
	13581921342141281308636156474971453234431695953871467228324000286707401087100681999021968207419850196932364711843918773418875311886734650663010657938834462405039590407239446119341799239072046206870369032009108250353801595373823477173473002854314748966030283708163363390945210440608730833018580717128505657283303128153382519555464.0,
	40059940600292086386809449577055496503225673250711527184674479604941756682797303173261552132686112820007199392921555770161406627764759790877027814349083207801956808088877537530618204397357899068334688568630091254867076258435648105671747431853400006394137997541094551088392358043658691509384780563631005946261294723129894877725937.0,
	118157336040180478764963406818835673083586195746852227362037244636934638020067797611589653216410137569550221133805304610779384874435427626113089276507136982525295805326591850933334055566660963060837758217673480561654264175791924052877206350978803307862078290855282351879697908870901079910228742435046603039162893639453982999597790.0,
	348507699190999528924993902667053506132444048426922886311107931536228105950593049156955021467494919208483951772276312323446217566005397915356045391942567108043828957417575504509543122771582969741892634209680997269631164931628290978361584534538668739257986661263269829556101509177567512655160929083497290776004443089334239493314249.0,
	1027934294607669489614461084317386129489797139466387578046293644516913852057737700888914262015306005127968196183958739331924444929211217915949294881703978134608951763724527210968935259522894446103514229684633915767551963692330334928227749153780700002777444277763683995580495760476447261815437758396984380430483870957130690600483005.0,
	3031933160789491879961158473613189447994643244326456020371973270991317837858643881516639109179984643825401842252461131074701980565219203003059838318424100806519032896999727018024941017822022459622970063395832666057458499695248504596063936530940216327094051354749956734344001546100589999674901526782762384258217135062258529809944852.0,
	8942834133570882510154550043301436139095565124091909695736328633839863553888597399777930236834212327352959150836759102710204401999615320684341253514829732431577135280713254402882654868913755075358454852055275223946123177465255744918358138110169527225910837901693631086054220169257925538491614439744326666980983756690578887746509284.0,
	26377401518537170161563938862305944942694606399889799545096402340088438462100773638811051366718079976811486294713976240607191287093164451802625145442439904767667707265437478143716812764597489869797009866435028385472490686603631599036189850479208206775768545281825755868448731294004956953550810259321278439038028123208912946416437704.0,
	77801885629135295632708919164795685077157808136905901926397561330194093925341005433276770151478959446039338571318317911783897212138954796416614299758841339658037530203164434957595730475148040840705667615822211942005011372235415690564903084800155894091545146654728000490900887954894169848609159851944988563627687330245582721496857980.0,
	229482466925603372713560058490219194230316494214662076110173744245602406617261071590989593209043680996170097723607145825298993661527700423758436314403005142856099268595183556870875766592299508122192698221078778319782607021936485757474107696013091723504704594256941620649351413719898061666744709666337764930852956676201668382399978165.0,
	676877640131450636595518081834775253213344913315403380478448161094029503547666594888080363798929282868954507984448935676440988928680018419100217856660594637595095501673629974331203919147952072214858632865339627462499763632959421691252592363669824224725090243613974313029269087050657228318296754585600450736179428043651683907917226022.0,
	1996512774710697210772001248960938088591698645221797583512991004279994648770011397649860292629149977291827057917722326755759143243575522560813344638898913470072245313749699623760923358457072310618302542306484151971520155603452472509590980500304987037869890847639923293693572742996848799409092424878002969547504676346453005684703454843.0,
	5888914958303396643515593561861161381898131434079108578861758266181936819966771927942927940720396052334242976521816739124916727277282980705908004829222197967838575035414954913962224439469907329350056881200376519959723917629760608907360011479365007226908389757737725305772017255278452732564048066445500836349203874965034472767933993097.0,
	17369996560676935380576246686586964379424722941958209079669949786976049287719556852544230328387047055924121160988051759791286256810672529821708716963589128471744813235900021360348270426964181709374364228597497090578938955900298213087333841216991842237921320683449449096010410918012004863507102284290126888549604540053342095653507644381.0,
	51234846460708920023708161427632037010008421402100745825948800040698926576014308457534393133376792110476331439721900688968714255763539770914238333734329490255060905767762285044914839235583515635640550184320466801121122280755561010612013772211642888283303241106377304389448028679362798590730644405515043230925581785431830176486589367543.0,
	151123637739103475754458260642465128761805769788442280296270391790710489402617900084916846685077637092523976873215039067455097983037116128399406381754068333224335764818763343419800042601777609122437820173021688284616062891447201843844168587814703148139065165855659296995255524393766213616969690085951616223674803289583385748379933019645.0,
	445759501420704771580909104805061331813387180165718392506174457543617676148587144659738330166675017705771511952572105555092117178897995519308460808395874279501535928267280298973414752932753341894436998792655854632140773906397782356922667678338497338393955560162824667486777575982490563021037374266223761462098868271774949482581930523736.0,
	1314831394835362560526086076564428451269995529854785719837330096764587649788304816496110880934874849665948773263608489693659449435689765018909118162607441717759381806793436027479263250475622110195710702006316084606134722632688209399141732513782635765176691917605529439996427848440412944981490677789273773658271238759605891738248958868339.0,
	3878294325574733564410738710717418039160804662063916464730807086041114501556900367490699763968982269594176491453572874439422780340372056755903222702384075823224576795940978055968509000054196940786275262913274476855866135692808411844301223504692344434275053166311512465577949134820356533350102814862438266788512402654068956168972772412022.0,
	11439649119059988839495287560206489888109143965053873575640529570860908114019923909540745498949349151203833025870264056678163723629430011293072856680662700319433019883423818541114715904713754894717435463677970328758415745110048314677866287659800260945927343900408833802744442651009703833460215545423372993639267454725731866368776438573447.0,
	33743169930184060738466742798398129153782088019410964001186433898137453382456888450020187816290713624471589181626331239720157937844107477585396647424312421276101810439488864149557904976335033407405756548484695774822408737602125326719867211702163458799474229160179488032974391503238553656914370705458643860905465477243078230164980833566155.0,
	99531439918125012308540978819148262555565771107934252209784591860615551314030458103096018809152791705269489281074764389691621226350379689306174395597997809398664432391654926684985366915050837907359752079609265971376487111215962083646277180727053459447678227966375618064573979884519594860387829832748347532144398244248896511140476702296512.0,
	293586393813414962905673309824926560230878271203005220496499861613144933246731524205374212038829019973619969837415473133711952014356943205292414520333491292672359323265130763956419982315459173934454251867735076098375488168338357430632360608025179588419327825469889910338613744958262599093814249653516395707539374269575496115051506721869463.0,
	865989822214574623362841050428800455125835060550544835986165007162444212962680888452411741258088371027836088975504345653752613692512007603207608626470247273130060310677237291389846239165209762408932244599599061886230772385438534575285903625817472283362707232409171811539825165719946728883115515019438293605368609024729754505094324085546781.0,
	2554411577985766865663344897231238734264411094736181520497005072326298594832365701516045524341200845036856692945296995086460639345321451052866115725546180190430626552998249082994131260252122184761564105152506085588076655238472480238410321484262809055652359055210401624149252291157529371678403408272451839282316813502844942284842250287521706.0,
	7534773114133212438319795789189499190234351365215915578064603448220049869836342518913918877240135788929757844853165651335466841318898778958094832138416614582409008331070153975218773135635340776813272035906273689124725416689514814978514802697012841035620614859021711801449932136583762408004984543487498832097415653070168714379616948280227934.0,
	22225457061063925132076151903276127789827366321709523963390826135667541084194351169356642487358498373728891157920129333499003169588932320147924287108776553945048567964117910250075828565318708432747274424556081220946874131379871214592297922446613308384163377301136773004078022733421809139433399030109623755532279867812308457350941984435258448.0,
	65559017294337531159316061204385749149578233292875090375908039378780257572303756025649714021058697543615983823367881195225573300494820101337279051078027276463780597105089499528190562112158372022944163748427933699245770387491574491303449969574351685206137685328515584620237994086500190927788331332016970763464692785656686347282724709379335150.0,
	193381702138195515848169427602762235328895989303114349751254454045255023537513003021162504244188496135525458535692861227463474369577943186810879119949642949890521858066606723553619550658916953136659800623260518705224683791927971853162091684404544254813963821559665824435547171906501864398387300346322134256902890245380675032097747896969574075.0,
	570426283380088905510158974361219649584472734086067719566003275090242254210167232608308576337672471689336210708957661923773693581060695191163689014991623338197461751326956200597268910749794243419556752279287561152627000172111819927754832974782671569941754007512975220327294444284098283522864163722884487977039101423868150411961767265056550840.0,
	1682615482038436123899741714461152670238156467378571540626067820084479808082773654514137103032300592447141695585080185470373392931689877834598356065086697806229842748114487287511464709688224420832742812101395592553434023168941509569892734286652689679064456900881676652111577613382197425676915412105072763517620155592875421286823128249551050230.0,
	4963310357357845385112883213708113769131588122777585304502833813331159704777661373839382419538588964231800845426036142386485249736645843433299531920900356182540584045739982150054769699405442180348612439014450469394038950043582182167245679843631062278256248505304159715203442461005816233772156873329477720716878720254125877124127610399466357189.0,
	14640610302646737340540857600936440440076749633072316085912742943098708157240647532023507261422181287821246307504584506421103639881235648109721115536709159666107822059982957869108413802504408473628074841707291560615496978584775303338247879935911617280121069389452840623877483091359130375278062130746981650796770392038576536893288556286018454444.0,
	43186511309449741962837419331414583036174799647533190129979832165171944223174971963847832645488652583988932500226715468179136442127538653625348577597967613430621423561800191584641801289547918189300335970857569930325018298919957362849981859472057750437971279812642308672389147392059259540138448719816507965638264690662008961509203828481007883397.0,
	127390855322438671727813144614178171568976700800577221096960659673112243712495351316057223519013014556193993921315255396734667682970212391554757272354185305171651520973807306332418482778731195210080240741814796454152644222015605161672524803559614858060463996816637546451226003123785907170321872357393536550141730685696282846237055717087772999367.0,
	375776460506464694025108236008611503100705146877027386193580656593282462371860418272326043810667311882816088931187891475217190144955074965091078335222319463071576903081298344796544158264166704558660597125165092886344781709814562381472953790309218945639838508441877789001921780760644053242454281518777654148282848022222121318139116525801610123914.0,
	1108465224627964195651466293992680119062702858264063208840145432184554454698791038773877181838206219680605313515670525698407531360130340697511481420222883001085690938757119422054084928607699677503259622418698825279305976793821845658447718505167196809156852763144026644528412698867353487220269030678486325187184175715779978264938367519861236729064.0,
	3269759078905482146421474049629434221869504028968476312728279397240887749199435378817197745801443648859732376406670036162168308055842585552245312697216997461613982998725923593328109649774485087949410023084974591620234372207663583466109945871501844818210301581578273198958117017017259927702776204542704817840695413652316310829732565459332106178235.0,
	9645186131077608839198286146821313522116153587969754599612566407184704395945200141081307918596055042796109470284345717049079430682959213245904088008042279535884982896871173798295877462619253990467144952684881104379802698607943945616424546463404114147879327569712562604105387549787091695538183079036970779788810727439987311703176517126957123425760.0,
	28451596807248248770139149685472514402047738871208327065424423450488226478243425140290704461634832480508326220743404380042122970092429327745468268562816737001165036124754180432991532220610930400619418539542721060250383014428196932617873825976249369778750386016589116558443964999281789657234573278213822901889076932688671835951908556545024397869337.0,
	83927415411754225521948522223219073475509015223726442545099106361116298936341981162453301981874916697782316453555156105546627617912718018538978386814133797061387805259288930308081306593553113796113347383083240107568570251601355022692681994372579168635048440176374462633288632354595332343893746410173357378901177862329824221328743237866575750006154.0,
	247572396150272660691101562241622190129895068019464110123299000542687272284847973440503326230462768885555263637684453839725271367389788074567921858180537004503636139347356025333446295412436014119946049892958125476705870637100476482496787245365065459496359628948969281430779613924137674709420960949326059276220348392641906931460617553284323674735265.0,
	730300765084178336555408951280268881157650445234815748808438582271167700351253346184322570124886436749055058741720030787060143233977958579132913853373886265568507280301716147253284207803679609923694297084371341732409742366137618505419279525755646106579957638927720848292647440974553416277601815078511087079961300499203901792178858830127386102349224.0,
	2154281503419755579719586539222236114907533864527520748775186528209905210898916192339513537830937696168102079119845282149737997053466761557932383495497814304185848435459113036081054549418379219442715749080036407215114699231353202946738413033447578179279957039454570469949326687683596728132860193972690174070220377940497146623063585753920871229074065.0,
	6354835426651320276430858561073343233448639709894742760316618404170068529372422097141365519933745695914516030880855256254791657782105029026264427488316463536966314721081620624001496989229456410862866704684576026970937869101631506016642807485326992153375869397027613952343518792271426188303090310298919378068673570920556990502287952407930762043883359.0,
	18745944139320346853211767019422348402035179770989638290179327151472506203020806440588557010236118560436911316626339968535186841916108164875515552075152323673249632502816374473591848468700751097070709706937588934439236881055348450763206383345297420757188994292714367136970355210847713302099110020234340643549914987433282138670804118409628808200444270.0,
	55298261932733710853626985599791769643591694869453220860032959741998514323693590049533395747281194658086117736250437106940747764835567781537766824912609297503957357906029010424190016520752063544100039848294896491349655676768489574556804535692381156333172610084391098518751993134271923026116151482364506679403395256525349629271124809956236726647266306.0,
	163123598421494797769578744295353912699214734360202365051090087224562218769457939807909303185298888628832563192885269706461097863314904366483131579999226408994610989186862654718982852248742044285089152689353567438864527811553787458497624719440460124783439346634229527640176714751949411104191202531598171815606502818711136873740233920307419217814574215.0,
	481197376772799916527398297762269013090042053582864206740839383964271941738070703434173399378471835711742668004088792487987751642601185380245548030954391235020313939208346233211666726178757193468777806292331908244385588469439671059566629524616817053263289842861451675846244532743060998506213720053091735492373554852398463019603029702033780548699354867.0,
	1419485145515487652944398796509731442413123468151552938009135007397289643991003192057011469902696624309763899094610701185146116131227004769242119466446600886851317841337583675573087349423237142623141914917577055145482854603781471378561225719679390070356920070612449828691790012486986298027545054031360714978018299282696373693572492628267492588989882224.0,
	4187353183505439254090687160651270367032857667108532276823016497831644115216169912997476487156215343747990815497071267485406446852047869247696772797803159012283904257585273905455446566466092996490120441572613725788795873648414118007613621543234380897091928780411346166319682892286914955499313596087646548879177636643325390587266958121213829825634932011.0,
	12352346654413644643380432958941863090284373505890116656562192387743624886061526833990981708002319496402049725829560290085613282328234214407679548926229901762937200126510709726027054560386167488676867581216040824809428902783220828185593128235256975718784210596226963400116558466610623195153144283901704377269595035919345936162761477099318572407035011584.0,
	36438499356229115875401491716531302094925006394732635065351297704907807273993116154934046404428761246765254589195321248771999364203991582458377199178932380772535861544923144080282336373657400346628782984122284212413770103159362335312503149681526987056359678334616348830252821780858410420002041875754334391242089558529219825289373622152868522859842282486.0,
	107491129446408193212220776527893521655943331538390328575574814444657144714269942842253055630154271306094187541219312213713370030785832278723753630266729174731481342933972523438271272895018911058014712514211497284112113531552881601750458505117187522221319209364361650104389142033841530937567741580973550647433289578722200202998470575289757219642710780059.0,
	317092446871823820754501489753150646233859572977009740276707577486647518562807856578491736128444730960235819227325478714579545496623404035807256852215910100473920795981629234863288160502711352060336313204270775709888031685240812590893626223377276655128152578435362867629398861197811096765442924062567217149831453646531237169316195077247225827208797865663.0,
	935406306175337473655316505593260105351727688000059863839414475042707450178846590541915366112600540982391672701757599248538661661368322197047271992243078137302607959440580706086044430365464320577936691578038975179430776987615117115248724709257705987179487815544816213114719095723289198556484243881866526386018730493410406114275840724140984504569460984434.0,
	2759407318139106190716580215796785310688064602764116344561948509346584137694447725701114317691912326118386586607424789027420717106181913542792497272795206311212110642653134455900461192095564657846783054680400044770253650218410703010452300983359273159185925598891109573496082802753475021939575620420287401987267919439129875377208552705536574693456445874915.0,
	8140150776775289922554691965949086995309982291650341829518231307167133044571262254089840687357618592045578360190204954629515267690790498457268373632978456197880210504698509184251178389533913029714649125076153346589292447361925558748100147751412929951537277985811998153720620736234711065164399798756048194673815129665749900835965817584644649212549927764910.0,
	24013209121437544402546760708836197479159627947590635448073219499707398885137805149774721116142200370761715703540701180543742215232505293934331180145651956865628928826739822649309573435544201442577922690350731368748230799128975602151812196680853343266538904111926390940296919559592928049935008389099576848881079522028837284849738765603207248077256555394607.0,
	70838453287964969172268784748696835986904209443350477184565578584735741498858264264746329276283511455141580485166001202097344930882992103620785745239407482681931093830386206822727588114614700703002288243610552220923975950965972458755033512101307967439079748012591818668155385365251537060356467609905480927822436239627785167201806012648263164281360459697577.0,
	208972456348869357941759972368026461391439542261608242848881988408568842951805101123022446868527431407945622435889757866945362544983418763878241829921531400875198067792144265082916546778631922450819860322889223736450769692343197607948107003488762092742996083567163978915564176680698058355107505733997572209043275075881760589151943066512748846727584577563093.0,
	616467424860885449169646318345382964081923182391893895700522185835365187186102217641134537458674368671582363464029757290345457739196571822848023248295985604549382613857337681848071265521110997189595613438271843098015777246265639579395562925138588298827864439133303143659949312930482443137612504647791013510687720648964669748781811073169152137476613785677561.0,
	1818579631018724540761007054142670680340031666220387411646251010811545077389346722407837180449118381076990520726032602299990330978761545005379631253788011197722922400008883664855078678134795467042057640014285847165068333424210832376855204038726595800487669764238793911475373030857739030293689038976988697998535682351150858939283017528635011269149573488377394.0,
	5364825668565699749894709078340118654534196882882274960360049297965011673642071571803586311577247957617319255366150209994069794946689706326558586412273719750170007301197311311011001061733299888157246903050845224883117631026548423907584561612764566293195141180004450784064577875895088073925026143826147613933987731256659116293611538364956572078915454083979002.0,
	15826322252421840056654971433720324253809756423058898673360727785270339235310230581283643255533606127850695274210759154463275810318875091049807703577265111229556154627628082467790282847812868376813741366093299536974587044750204216739997262593341706413247759779869065508870352590953253298934716948906335205592094484276648120963466400327781517544974885459779660.0,
	46688023742381146041240149705864191272113290462348846268538298870190737722430471833302390106489010551013727480701371602367564728713141828757493691703375519573714769586832863040515858406710893598003001871955798981067538059283948169323055044871073444730190071607101570505337662379128394048375400198994729538540272084856912227883181609182907047208459968668599987.0,
	137731117396306214576202036737028726612903243389954248319224077507091125528845258708477882033197074320463809610492929150453635376055491769675103414840869886151359281177003876671856961755545293350162668345535612811389431194137085934696459393896091601777516083987361737809736254495590965405570607781338837579230206205698753291995389618337571396592272713239341052.0,
	406312086225498639595621632967744364584759609866115029067070131920924641151785887490299172377636460902151306770947571898900068293392524367930776577037005520965639765730010549891683482111888808127334090302982026536289759161958924216668795742896719577078209499850054295659031322620108864190169331092858911126042639267573782264671976671481181056236997628100744534.0,
	1198639261540229055349871501428589961182678161010607882186605851451371693776345889750678228314533432049486577238486223328843537494111307100388620388220184374185604487269051676700325442722370639296217227457391165986098780383492639259128968856757916279490299293619710417833877994798434229094915668104307667465843540610896285771652029975907524595614349077958449219.0,
	3536049546038442996089827320534684668756985690990782539061723818844706316257903423197125393209288916454170180442455351239861859270438373783368268570970273865012728819532768333794820073158586820534455403883214387704258667851456232210135337874900545811034667267573227666283287557697497426940086213965691177018789396505826019036595477504650348819956008771584365431.0,
	10431560140682381126995793783958011841171564302293227620448434974102616360941737946958586182519897086138648740326847787751292948695319222633558360954748763254225644185528663403241061324818497684317128211595022439377297294460568952325943452135439618732897188914322211244783334666380111776672725962764770334488854941909640539169413913461043358634718755230372337567.0,
	30773810141302816927035328314423936648687327876349531018213374216778267080201949179314342883140134131954145405797655700012804861131069906566351173869004238566155361171385319345269626255589021491466045315759211339035394158514872954537671172991716392320695340924855116474327133862988046968165469866917244447074521610506801239052469111899301269759061272716489688144.0,
	90785052778079348225722274832898832243704240942901087154987254880328034634784672236303315420085913391117343510344304641018686393168393466155561645022796899283629450385195118062317189929967877173996111631726380743033676396009023680267551827322979315865835908506122430752486458286228406555127214561840078688434881420513695188974529097360534109221850424439252435605.0,
	267823390935955042179439744453476661497064236923943885933352269935473911067962622307516655260673117006329498421005268806747860184351841168834095923321866488130407615844156623228751227539487085285231468531883889917636669128852054218804654413848590210762897524306106441661615571902404416675492082166607911561558841003076949600542217149892822749041656410233245456766.0,
	790103033663826729814794663986502749924045490699139637643336920550239306314619566813275987159129497086389032973872879843746521684218026755179869160271969152668029092835171324076144890370343039672639665328403519432751286957217455151860687438678716985863534677924326455919888963374107047691727045973379383398470531768030300293502207205904549225388626821449177393252.0,
	2330880574191689924537466665396840812091327107392476215475155147162269343999906710148462798974504156661505389544162566201584355462765148033527544284487972696642415929002465824089447609719084554369613692509009660236311542182297824390362838831183103469279520144238669258944428839062873035302161704254317361154794478866355103833963903842733275173964649474450698351347.0,
	6876340614533530152561912640970733288833909296228109096730349954779199678453904722419336620514865775947113518126958498455045773214929972178157565397629890414938508696438629696791699275893165011730360499111616128737693983517112747838126103256775134259986191023864420064890964315057619692978909525891841121958933163367291577733284214738537946359923776824911423659630.0,
	20285971094991363309127568288785394377890854089128813839514767274983365447424187488315941420957972765581248278590067405651858299016625625747109340114873709631731003954021697405959469135471366425695493669670237595062863715382478436166833751888151623591015163439486118126873403870000884829210037994703651628729823542015342864963583066918471865849393483988351519065318.0,
	59846021420818819986178172925793928177514756692014635992648706255334304054860501230667043049207911831786242385577592413925683364204760982661971266484985170189764612529984012911335333297571907780657214778367655578152303522049070171058598458676749757728229807107685443877815303938962285208642397022765634559566960062161299407514121083291921459965561668888878098705891.0,
	176553293050473779074687984628712967040040772578427693296367857792903509094072842599348768836181985867414869410678424812917280781838663269372893608488474533983446706087967000481743127670102762610279790754630305125182170652855188676651000807380512793697959516027307701841073010196927975286895979494736502730319937167772164184480795584484436068200726825098448725485985.0,
	520855693379834292956341518594085310373789276595690789534111862807031448874239685720373193528538230061335330965018228286943708730437199815967577371941645820302063986692594242141867432682921407592084538202436116762246917035124216526910248262222157609579247600257015083949716770727553309031063027858605015563498878036394590600672600495760410385746209843105828266909804.0,
	1536597283296685629240453489801602434864469891267263608153373468459650332576925163292157551053077612678564946776527975377605911495067622480050991618868977017907521966967113771906344494249426110706272342929607486025629089394639936642966601116937290194716005097852258091163589601642343172800811555568555601817944065084320038450277243461566870492345505685983022434258005.0,
	4533188262649393494360908828884985627126800608953875067098762682158207491532930665950897327207668991196563429237566869804222429744185036844166429135664755362431657236386101834566494850691942459268867305729416293826425479196311856479602478432555465061999381229895052672862678955424402059852516888290518236187928235149383550586842738396600887417104113828792352736543771.0,
	13373605155089671242289208580551763529090541790202713699393048449308229220787837848496991101844330696079952342454171280209815574945892101022421685498453101272366628118354930927753035097904713908320157357720862358569476225957734083071133935133721330193627094455197769145682500099686812809743540840964300517568204658586052242738501403623215770817838572211556691484927944.0,
	39454294510541371700567150766418376625808584977701489948898637925565593063098052304347935730887784273773144476309469375561063879166953387413541054229452842610045111977530210129420372387332487659337994706804215988684850392813159929833051010099298693199927268676259170955996880758065177817869762974158577319376922468523793065097040595331152978755693931444824182681780621.0,
	116396818194994290097865792736877687521758657050760931275757489613543085827468146228182580821761905165013080730131234185342897097988440991468290763829756371490563859897844115558049374376956417855692048488024196092118891693863986950130428958400791355084043691263582130739397505234006689295723343429327421634404659510877785347403237650205283879873146557193248806999444274.0,
	343391051798179626455555830130951130472342535752339544206957489514958647345730690750923801001666161689343467440312610788216036249523547516774445782678391047515093254812399126983484871262923789297266924640436314913759965227520937137270892410697022213370242920566076380918425663795988251438930807202139754889130054598063127623566051604603826264028640473253060091426675977.0,
	1013066315748299092512790152274776299575355049125112466532908899988311261379116935639501119037577634713226196448953333605605221822212385171805159292088396870799130073258633598590133381451773498765105763257819843216469361384592142647635070056137576984502702313807189901125895126167027415040092148754552907521418890376961313327822952822789930755788040887939942641437719687.0,
	2988737758434273650091060836817628258785883124119684600676162933796075822177409934958911531208965905134994980080894589391458893986910189646998285584728594054977341469201662333913427743493321000410831966540615196223968276132824035944581960086781276498258626274416387401246501326644561445265568721442371540750795709360961571305984470910807475675430199792296583087039255744.0,
	8817364128442096946004766043288854652035480019485325857988344154142049329641798282352855573732739739005356480175060076078375412971626305222001434889916421572288837217911161321848628775162943142751258417799989603561394520649321514404736640004183425189506103730479539733963594954504652410448583087849427770795489205988250802669592733490240056515982620749509685434483295747.0,
	26013019723441384525863855186997956205359628913774534529287142061180315004548332784221016302509580797144323048840310388190467965444126932025451724359991222871707264184067348382724471178117694726596378318832870185633304059709555819002234289320937318949268536099636731575041860295470592898273360784740764089597398230808011955492694439648481629348590672047108800642345842527.0,
	76743886662244805036899417771575086867730344899107600436664395615453281068549243791223490100046712296907175806429830030285168543377630059130201100008959633724914782811482823442133746234762738701817927347976493454282650372358567833072608798546065579223323260652720872333282285243601084481088887510607830296346567357246876128047705189884817052215031121852223995185615239722.0,
	226411161723137110624841238338768313961797242680123663877700393947782056776030190735389876492922588907755478796998054694754065090933477023774784697213355340660308743449923437829680463404070746197340194522677356265535763235525450511631801748555591368468768323077425961359225934888483245437284169515106410609816553309127447016586513480302181155845989977733631746636044597654.0,
	667963753849197439096350687288106380686955504898976909918145316493419865360375964212345419733881271144567930814752992012096605684929636329242165551794948185567523905250881047545269562491082746046678773321948057585119922867715111230316089129254329857159672501177881334037475516853512249948059089309368719616298799847183512553507136699520870990389230888161372681804175908271.0,
	1970647643715745092492475046608919276723624641866319453696630654650689878407445878168388290857232726755395782890375810822358743260277563966438581060397010536509910435122261669091419271078451078552554401976816655192936710671742987537162217256157221246611194979181882826924474677928794763736334773459885826313858071394437303846773452685707715183121627773119804458727039516808.0,
	5813880160407185268387877905935513323044250548376289798056593212249577321531038798451718549506780985979507214662375906548703294080940968552372696545727231459093339927740579157548597669169097870129197270695110074896386479316950974030525111483201829721471893553799122326849806003864393343511670887745371997998307213485282880760797693093021475902486439893116420837784390392920.0,
	17152371946281371070866781781350624463388399942463550947217097872556706939417340359478821186914476555323232528985998314521202028949562383582387349256134973911574921774780156628870838397733523337598527696753994738917718439779315045208114341900148355510881200150591420130445950785421083805922505922181915157470634486305665424566625955385090191625703428499569181830974718722306.0,
	50603820474730473939167488099565414471459863364445593218724562216672282902872380665874436398438159280896596279817611189284048068592143050960650473353555137741017876856421103129359606845910047300529262406551588668214112699905849172670760478825718656137611316637380072214736773176515201214574388729034795910873632596039482647825673385832950228293358765903271594029656445394074.0,
	149294371522356872839287162200674959210505780576739974612415869158592643249068881361968852513124815504546769908623428777378599896291084139473189742436683072212632349172486409024295222050852105637860507980795789655690129342020428294234918878605098170741572376404983314410293123378132355960910692243985417362678918719669305942597949696330674147006439319227956725873008973152824.0,
	440458067404241811078780178654506208163437286393957563115166175691955367649973705935178239610636699091540240314866203323161345243657854593442096812290186811841677908520475848631910589403855393543534442974741200897982107344935752020274066720566135672511085639841921569300465518194940736492691991145613718997235808976190606900630986741790649005222645325614635432309433355202529.0,
	1299471341020229719912667439002910418955273861446636980848357970407406401062456661608767833011416255309040944775884560611899941482525120673068739066846590031098197807339052451010392905755148408297552020974974888917418751911170085919589329086255913804146850483792364205220087693955896918073524226895324945393958171659907550675829528719672169419273640217999220400242799428044150.0,
	3833803444909938734116485784200631651005022508087011525293406348615089615838020849791821449389063394131719112635271413067077557922976586986256026295422685326085598097577896069926379562014582580016515158944364512828490552231716769414032171120772488157709346820352838154902237005023526754693685311685877531661968278466637013622876306612110342870201760165214762103183027174958339.0,
	11310817072892941988144912466485868712436559761487404460148764769357872575319986418120844703509758565641268970362206202553955339857538541715292056107830520434883962715950737398821333467339686483821318307285252518342161258199627723663815861582441880338155124751765522999822946066719960695434571230926473640604920718402400135320277572944235465276931794818863698641816794651014883.0,
	33370223058403824585600755425061872042909251968801196913433338678807990066501066703577197283480152835505043455658235831073257921314821638663733613206998856541723701910041070350677110342075393966758170488882371204851872874791011003224196194657759351614689333440081559919864846109432149625676895408889515303807828259134033767714971423371426698010716568462336978910586973158844080.0,
	98452156560702498941620243859588147111092148565354400560449522423459751678496293298914077356553876277248575087971460242077241189607173988550797361843376389694941404646920733270628734795735157702257357466221245751563594293799212903920074788205338727145634579936447256433561619118956311957758998193112745838036551941274142807690312003995957050451747381622014864377694460948283687.0,
	290464023082225771516124190535475037372920898687586479919126647140308648338696621104413382814101165054075308280223549186161834058045990044050698736431701228601360281640645955758999448587033900853762346056579895023601094214655315363175473578657493325265629838405155388575553015393339446592094617781715155299927614657052782146744159812024789866482809785124282167477882335105228616.0,
	856959802855946499888282718609977407790633416372847930155339473826997296824348141752194867708665067088351030189666212316692045304889829220039099979216761790930792386773410094169704024251735231819304191374168654570208717445510525339232670501357767338719577068163072189633354710168465210680870509240335327252256614312669415821125708780930304342274031767673677633024887178807850488.0,
	2528305443130530397653190251318068401783818159303540536143691485504069709889640815481546519387824476893050840944145925576467840492094037135425778476130133260096275156271407610104866636438312311460611313904878909933528707451828034884330417036281433147972052025479929324051062651036067971210931185441098550069520689321552490422891265864859224827513721871961775042144350800415249972.0,
	7459326407155547988247653756386311587356955176366171235006061716614503846881824578271296356742906462004596699804226842139291970122942440409869997155520355511224405263556511459863514473835227651307088082722324670507363141382803826031005705741077007391939674481021638505602408308377577790295124796026568149819103507570289015412913038622824283393071413416622217892816305296761212715.0,
	22007497659992209076659311855698786119706329926493880522492382909106675639748628825072319491872073571594668629971369200235710804732832862868292903539802697381430266569684626254988208283349721870245172364745236958150303544532905735862236622459816885137295653538204403012831040429989145468190230712862106684719748372738580200343192298820348789528971406821365141174972275707742600350.0,
	64929595257212407405266155002552866738696941073042177150950103129835583188149052359432399611595419036536055360790505631872513554331942616857688139460939636462290628750937351022568955744087659977739681029522205674577431033326468208324081388964392115849020147550880750336584680755202832065519879866921179574191188983211034820634579076446810661716752948420415451961552083778638165784.0,
	191564796733334901975848784542695753263897248142491542034634312565378714480197382816945382690995436118383758633580711258750702300836362855522385634261694173110271188333490082923719060387785388803104883429265224532080758330694601959690413955816729326164096633910329822222599534255277229731537605478295344649837401075062277340785701357909212239737894277524796308849411883733542512931.0,
	565183772995309591351752792051661281145035910605079675634072995379030156733538508685812783871555052143896204588369045423607094254936213164095616986036363930230857241806526843962688389151398386557480025906094049461542591065300224621509236128056074169205963215263415017478462467498306522700493010263121257790236373435536222939975908000571159639119476181579959974984170167710677244474.0,
	1667495370553851024254556866212944065864186990994818247837870655727999201928601987233910908604310637899857958132895656354994466205238349429678176160642159821612581015502929196372326297880628628887283644194828570390520636887461748974928758993915317462732940138223671886755752528837378882546420471305764568407981539058227914948928653708562672706944001589815406060868892798383606728553.0,
	4919721951671302128935870044344810371157406580912485682944154316662274833672301539425143598426747384090567777585072048733164237545446171579500612889557714531466601025557718346971249123110360100174363244423540731488138010018921224943091279670513462901896178459119410330814152750256958446118646079701207031850716360249313868366454099128024902687707020328326346076492407089791735760561.0,
	14515013583039651554092496299837733042395065958923121047826007891379822168880874793762047308541898557625010366355655978492241069455470797650896405788622903033617279504310956807160497047936466540298751959739307462432698185175345850819640485905154638018101473464865235305386482983873817728543935419197630507140239388886034119403704379765381064356385360166734155636985346358052393097067.0,
	42824795624679059532503375948749804803591935894422705387934785836216115703081726060938952696511020218687772356003405166384987365530059924739022431293046692043067659156084495025732441354491242185851718286780960813628321894690354191402345527148730523305498861619599645084770494350258829851350018834491589906786445424396146551501235762322557537374559802700146887588772161391385317243877.0,
	126349670425300126341066362662381450162740475390886993722220833351216820946529407875333917702999702336283941420685429741736250840405916012770649149057841354156494562952317440261702947983922188072125239395876815260138782519906629872930983206946806346951697117016527980729980718196170176515413044897303942106961669356054981062577206829983187001172380316149900053170233443469777402150994.0,
	372781101648155493541081952297961412377823651643634783913080961492257122716526492932091804391973624594934027799510353978376998297702078725206499660193428500522189111679424770833727969357209111594824264153192993810393190657754552477064300039060057680035145974319738346357831107165069311124925647355031840788770265325869110390093250415551506630727073083953062989027850403712379506825108.0,
	1099852936616421672302366883501468898556160746479421758647804863663515985395345958038231326068742112396809934849529188911058553081947582646981167149177129581357876099903063564829530754104803976874445152308735092016685249077078682408786768116895477628777317961541694086524971100846761433859012501911072314996741315638533057588725626257030617421891876449851633921526038057598092937349366.0,
	3245011983659397457218172503247163065663876068274718773596087298660559185181114582048012609333535538379876079958263241781313789528736379255668195260913557312552980968892887373697463053737308705168971886350397005380041319917766819325942243625613941082785720284532833710594908816948248773248133470591847125307718236844841251220963654966982230478545676217439630412605219310176243328133440.0,
	9574121704911308891579414895304763173817496816921159765539464168864016406437005197140618890777320223248726838392162779837836303278850941059269785852406825098475844578684685102588582743864434287670677645563967137636302404539631524830663122634226546423127555580730561655901701093404286998894129963120877741834975818281091992513190459888189118434776016815450891863263707184585661899285637.0,
	28247663635172900417554746193126658705102775704729413357476252158166611351011271080798742437858530738682240759828704479379732781190596852105823834451832715500971471425470253154870161222924462529354744624684799162390943979099689347148766044736917967696947455592971648873394407107814096486619411316512859828631320198683392790285091462327619632356359290717759978643862115462052291151220790.0,
	83342604922333997666244388738108090905160568649681772321777118453104630566526620908065296599680324967707423372146068763784554257353164331632596675498187972860211145320885605683133731869967073097829075070109586939207687411379661687529730228954229840265835252572159409265805676687006079813917982999029323652561543443701462593238025075109766404417267125734676649083810251680553079595757165.0,
	245896616851210463204413682101121679883911524899777498260637665526003999489572227195652754562435288602858990921810243882255451935144955542539564576663739738769685859067335162217980529216837317452383547625124931770734333430991960923101821302875246714965938209941453701221614603104109514966153327637487846315049331674806575075427835274484748046416334836894720900166356963774164128670706932.0,
	725502611733609654527601577394513383537816589386665495719422782605193592232650504829771265659648482991696744919644346363048587113659135056662034238208290544620486101612057272068721879105333860095789192785788699192660885562105773889584732041497823889969684436940404142665196892193269197968468879924023462493269204103632235153274538013194836364445080800870745998564093007600236951037859654.0,
	2140554787345108009498810423187300446865696474078130153650978184273864709714554293880682261849041955788944896962685698877870514802633935174304251315262865457886685775547849466566660808517122607569616498076814409248393989810153393153862964136092823601753671958834106740778028800771835369234394425415784744297599672249185109932829887712349034356929571923903094354145581685730663982477771314.0,
	6315600564557133123696378973154970476839166175768589488134033388634720624612518621157501795811211949594593145462972443746881260847624056934063430606575265309576250142423541797154189189596534746020905673594082245588089046067440702527248902852998210722948058014148313193773362293534931539548921067005784996280393065030891347019198917014794454748252443161669027086635130779771456091983635699.0,
	18633905919569354918645174460078592875011900526491821321401424562422264775660410754560728075928880239214957498239990212736822869292012964051753368523823283603537252922654851849454074391593602670383818298403109449332329777402509573019073935578726511445704562804739081186259353577159234079546183086380389465817367785679141238782058812978949306238387274146147313329564879446434591163278220206.0,
	54978650629156392010673364180845893735940767760908585238001625382550790334894212177885586403423303258481698892674255878247540392498566261549256351899702078404130291723026599500072682821995655081406593264081494389862011168618458122763803513733392967523805212373150685150056526925138015119029784029325215519500625275179054123602203321052270350135363628689188689418905070799749658074472057820.0,
	162212824646738623060508865833469605222271949485990677035737284110288711940034665400225638798611195191631858459160663044098029308311707346158545280011293695485626047415787782280354659107317418883734303435000799009796798195416863471539673923630207094361202558844467559443199483786808352256752123707076612686135083698813420411250104312531686347997958905168185197917740825172458758072099483512.0,
	478604995343374422108725269421884545323072933721827224809272707270920163536824663125792710169081546508231748876830602097255423792626019424681305140356861545352807931666283469653358073054542811224956478652961265624415938531000377555592919631204575201174256027015496773385034099536923807626327667120790507026034590382453306381767725996621874628024695064576842651708162045454989394520638063016.0,
	1412115419524652754123858724807090318691893647510382524828015772188896226968602162138531349694699340098462620217927533626691707180265042416074366925172749696687332767806787721571019750726834881191688256753766450422475455916366790173161510976532344496815706392628882181001710918274915382558944012416807778559238327222770631026193258607757163031463182765697233663640692993501710348949726200162.0,
	4166429994178778993962084251678503229133425162041084464237869900922455528467924787582737934132705654037306221609132153580504848062182908714534159997569366193169569519647564229163830052409116817194087918868273804509136114800104726744253968842475198931922623710379884375910217690448420331221286638370633291326164124716638166416722798677714368418866429852181487934198914784772702300902412484781.0,
	12293029001283294854876084775788370243930624821607205016028744128106241225774296179195483402762464139022802821971702204680312624318734756000382403816958723494783104188503344426735851489302707796468499918702399450683964631998057801423947745139780405454364212652767817898020649850289393925814421205038617868102721104464656416986663299952422052349937597299578811698503106499383327926723245175992.0,
	36270592037294054070727442762029944082709389346284034205994377797208944564716739617864859216986595553308386832679700293557332076137826883706425161991866145049334226801605853528944661038421569002299938674633559363555326001535982933793605955938966630059093892637463483096292845409850131276091658109087712740684138247692032684482099320262383311624828939311352920480114203021571932050014963714762.0,
	107016637678036663122704135831850069529463884871389241737636844470799643825540057410305880573547388336108297431338296179244468410970087371999579234774787945331581238232644556961032941576123134521779918018633144586255892218925992211973035104105392840242760899296873362827596237851663173560067673009278959023101387410552767015867513804734058881521314947878591127808322441908560168807164035607008.0,
	315754011005405660977179823734779372545547822753833899241525663776412076055027139174923476707771937029743750233842251232374127258006624056242940520860356557128347493222351630621431610479793393063056014042973128707264315651970464861153685836539559324573702460795019181167772550373609926738495990525964432884580967202524825966452794679141092315155909971277632239455549467310085627050662349859688.0,
	931638365844871694034388852060560321464599573376958254160987008974052086974911934876879541284303072809358098119213150662284344174336262149580784498628935406566932554059971949901114649478804881164225260266639982647859005934757441936694968718947272213483993500143839182365417876669185519293489884105019839594563978272875628808741632044707475601198163335469955917886505907670422435146695128532813.0,
	2748822938490149377108305558683028749267938554235690470499029145479146222439787004222423630156363202528270515903727422390409518616841913571017208738178943131468672427008481199011399411131302890469134389406898631280453558703119427619921120651902320699359125283053912266681544688831358314597694680620618192127214329061899002710182456754289970061869401535020060968886918689118874158543957708069669.0,
	8110489716515008178119600375370394723440202062237367167926739231138007223736424639042208565912954591679988587524705233759833745214992568401054989037930277333042807620076603298211170522764127097945397595979601423849859144188536758742256966031152588350074082570300712848205761504807044060135313295488860690688786346509069709537954907716543117053002138593265051725990883445567071536631270040315316.0,
	23930308525760891411222037417086976070368269221657608031380431687976063899246605868692573779574823238782023264949911034533825734969370755355017480332027505393408698832965192141805740988753838066337543292619740412989447069712189201454282575159545706285644488664143905547462451694257090442443436042059634325630991508165143061366866805645991726344457182891797918474894190827053713799668454814378985.0,
	70607433197716204645891055372821313790878819028926309996028444078903958858910806723680231241838716584621800477649689516428423668232173807886598011891499528880200735000724994925618375963594758949326602549752379091184007818595565767426054666012081840602460925184036086197537227474676930215307739355412247561147501746143312762445732634028072908133720477444269806049279083172683830535220476398536884.0,
	208330786617908209092761486093571465739204361493397238989508002517535869431017080300717191488610958567229120177969566631350864135321927618754847343951490961004381668754088930998684454698441837690457564486121170809107271271265048542964328678888552115603386503096132898424417017362338089557886863922020514813820635879776440701785877285119602138697416177850681326636380685998233405894268647060022481.0,
	614691751409100520405194735182839398315799434699866477214378893935029617395686355658517152728151979910695148870357907028409203928644395031739370754373482303501095642529197468023926736470762386068564748515706898920426957167333116089074836525282574300391476955308139718364667707197482812806644319321782134904381133452068652016261039128766351300377865910420638531281343296975946325177967974581454661.0,
	1813686484478916547126576110454978986348243636618192700235471110382892905023791789730714033033171687699815884272970672043044944786647396672898918046235998200227806391039204515387865360635246561779107253767603079569198835945970078620215442527381747336827206335653907475878796802197432124578909794696148871515892895064636872870895513888289322068963430894170221928691738333464994333404630409416257484.0,
	5351406546192355120495822844692456092920328977964214042451406886322794405691207630505120335446948274798690626273281398990891727314048516352908730964188272506778557328334698348655350331756477224458458087772912952347995284834502764252655584822327623624316449823982405720452120762566117047906462059687364880616292939580525240109599326428214908468452491556820713748439320344149138506914165570391228859.0,
	15789725134353633152853178089730236539783328315575730074165963905361422241447331676780330467518256047745088978144581615990770631453754480296682756769504084256551430211842513552480629491698353138846713076564669498520001161011408502391986736817126773569508240723094322599140909320517086581234878064557410835289444293954329135141238524146693624327771700843590272465472157939907810142446839591682884655.0,
	46588860427905279925392067281827363718555718170883661580040089575613033495127559928105371097900998176071539832821830555985434386927524881211814137036701110724709317026139283983087655249774159076999939241307726043254448687356384089822434257670662445835795460834588014736038123996657920045164826512721126834857120251357348578709278548757016063826504468648964953898537472466104210686337946966190050453.0,
	137464480980019424237523203276842370491861007920250470707854184018252557087953070787491075296945363963928698236464659516487276018916141377622843871404280099346379232877174502227570790238757095295200326731935179428640268210841320295431614403409977660727681231542268702518167568066588750465014503647712315165276018136200135863079846633446562941856447743726603571741461626846158897988941845794869042952.0,
	405601726403621277284909821127432932175552184695677102168313926536948446260414451513225951020272255323792497168181559572674369901004925124010561815147424226784373760322520511388680996797218364239471270164119298344406712638013610680674021498793264498073437630671404183792604214157587677349131405212937039456160612940371569580498110110990713399870518816269191565101454783270051727907386551973900567912.0,
	1196768032985159558050366228420670119618736964373305110797209214157608587360838378722828742710108582414361323571371397300183058236733829121795614239213359927013240883998196223206873757415233686412007081661682534725312650982379216880671870920124457581140087020346168941916776996380792891227815674984917424574343901776920401302149390514678233399563585556765738744386342984143146200320836256117485342798.0,
	3531189712351630909456060903761976677662818990431749125727689178114720688620934277255100834557570428720209496657315906512713129727769797662536610216618623817632867431418674489861065607238619001978864785776464640860420013069569836899899079540502031242603780669654884713788020071798940857174246885856628469988125863056611538723619375248773522335824791749653584829571877074468016232603171121685810076135.0,
	10419167117768216025176486371479527620891887210401923056147336722720238101541855530994031483176167620936693613558722247656887330227672798811400271474766958960239577377712518288328050550086996780944304433551938422338611461551254513223517931736394984335052252863622628565928036797739015345896999614642251890185844466179419567703258482848563057638818250073735003364065308167411911808703127387509890164843.0,
	30742971201639927233648512257935272760621265404733926820522740179232965941762374599413560031604352538720005719567037598835996133271145344371057435097103626474878187617159123634388885082522084079951328606563743898654486602413478258967734719681324383340770777206480049637919615195890016869298250456257451844511589830341863010352433160457848933316773864192070690447088142668544129922457818666268078920969.0,
	90710915788038229142008085090948414492896283537614669683248734009463130461611512086261223335456487726947764190603373396239088061062072530440967126943642480488194262905256990739790189503863843090211693767325676393048365127350433359028998284581809778488701352148773788258670705452035226043239191674861985163667696739956979603470533877980126206602944653676033344411474961528525418753762787732199890803782.0,
	267654248601720415607691495736816830385226894693980543514108101034397268356949902029228252231889564360757068407372707561401147899461109832375430797733405562525039060473652944831350932131252790875814055630910903776914562294658815591750668976623639776037169933632431101349500433429198522802592759133404520030657517477904670472501016870554082961789168712212122878467190943891409258888611575211444240765663.0,
	789749948825214611491368293783330780640117256147192627741325071409521430960448505428725535093927932019265747868191787999716843579385758856074659711856626172164141743852834682532174455158814755910333019514589712773193770871698002562257663094304163233925348150069905904943928124684954124760461633785841166791315869713606917565205769682048779299469897874362107025466247957522399915887717099453860708472202.0,
	2330268390629625595943380338387336397311941926692707387556739173052220712038465116531710286130668412884709930845614072179139519451175143538722922832641155134265552647519190188368986502028395347551687387325613206782493613733196283395774512039184451186099484864420235667211106141658333179687634814126713879788814079251605849116220852542226949057418816763862505579390433689625650609684255772980452720935983.0,
	6875798685701303079133356435803662699408052427523302633025457089906807068425786964740560203791188179602640219484581655663969943777793596915714585344995457765252022363652061321772297970422857373401551475692331367279519043036438182490986802418065388276896595431874523482351423397172234167950073053626477327944905568566608722954532276214404203386384071652811289498593109562917836106008895240876430861002802.0,
	20288093135619206151811030317462222905837584814823087869319774667127790247741517560840752932424656557309981047190568180699076569401903430800494236581708990827066005805745828978582361799326451887432607514993724689984217241260250156391479804773262940482048121593796174100441110257535525274616921421656863556661767262022322021111995752503001464674952003772994417695576765844701730180286196618195181662882574.0,
	59863233842150085869488310849254742279370536297045440467707437748035528334559499069588522885991370812870862195005939694775948343234760245315275136871374836840997708771891191370173371518714767693494018706636580646454563764284060521119048741122688358035162390418881567707800038836985347950198070516048107206732600155538811211491308803406053409891542622176130586382193034252801518867030404946831306726992375.0,
	176636309674717244972649238966024397064184852655408720165763731392722808525775281205113148789603044957528350028302413936829929011508121720579199992892725699704237248508017694343464176527240741700219657293455848224502555958901384291999536725690149113679795824566031655910372671371645763731287958472968147270146130996283755699139292297545809736594083552334140662216285597716814893440717368696886494022437704.0,
	521195496419293647611102088746545056986637325954328306712012522027558110601627665446786548498295931438891380717098591944856519837078759202241578366749325658673766353541209523012172489530331479010966418091495341979980102439174389151185655785125656955208082489980306329842062184452998887479693183139870278536223740972444835726390794039485459631054491478163866667840101704321329353452814049464528599443002529.0,
	1537879071465826776742285545377741632977525844790900942045576774967233872199327297225531932110727594567403816293239027630221688261646686905214363263472336515423646667894977497865154973705786123826286315718710813753097903106621248750533921346884568679031050614831668419476193036019848197706042154437470437916523211866508573020500702992318976995842247526389851630633955834026728399385333559708757202950412189.0,
	4537791925884222072230835969209081337082964439706857871668468178165680949770446664392022742429857068783460819212166385078885749467087441058761510284654202717706053493957804890983863421984181237625104530904488289209685839158360076453874847313481324076425756828156992730557329400697794232480393741747649025890695217576541256339803009962757379068948005206562883216748233959234483252707096555660288468186524306.0,
	13389606875986461592827936585030438886412029337912697108783236938654991602732001183196801824501621999473653654973750233548339081854382012318550477117840272348004799983000449590503978398379726786322931311271049258618641268849133523085403450592904639121403415893587588137057826068045896879363236624985529881057689153014975428768261679092736525838598753991133911314263521863580674396034737907284423965243382587.0,
	39508626251278630140828447665507920908798656630567825163938432233458165353660994686888693610428646970500694379079688256836403643616077096376543250308449276141768363207829372344374965588825090394742750639248835397806297449811992964949067967773562203563520764143426770767832987022133962710678272189370799115885615713256764248642998172268825790272910402328172526672201719684241079812854288124826524680121076673.0,
	116578076440685511881829563471933662823381984752396376394226878203147983756182088157795861203303651960980061985096070645336516689650784416816764559992238381663991481024444630170794563439683745233876420052773105182436721145433115310651621747036423481874416878820133208151154360457003433995915422822138343925071906968891756670116401362010432043405972815307652277361969168250511754684986225003612890117072334575.0,
	343987524409086019687287048903062960787664748794141527301464988849569809041770879832391691787960327467261732318886908096729603321331061125561545454245944657296110307686518654634865329081406557392687316734800975078372364965332889701976689418710136667660041398285799204382183740570629194360187105240966477638799814124580348860561341805710448098553146734989051665250703544656416859598522718173358483918952850047.0,
	1015007726103554591855365183924879420734859469036010467171201610082477428459001364986641964251536917369264927384006911849527103482906905025134376376094992123282047851692368631341706618737254041505159896876422291512716512233440667812606324237474948431154399130907786612381955639286486701938978988234436424403328976598732407155409458723435457282890646985119067264917459680899317180664697334083259711846203964528.0,
	2995000168596465859266710394433467637768431084828781186590622828240576574667087710466126807748599229077732246880085054267060181300872782561442877913790881082860168511737750274930358056891151020990386376030328620439654868578247741784631750761801036154710102707464921752386616184053547618074873753711388383219236550490531009015598006737401759084447360447261344422940854995963502356314600877442259056874413635685.0,
	8837413978217706832543396330930769920944555180616887765861185866460508806447840743872145435434779862774965065340128932381031876847318861649939415666655117669143647586513901368890654282267548446648532284660685037400977401233706663318904970400119758005843986718261267014952422853131243106016190051178230114449582737542161438377803112606261076804730311913911121144259442509733245476727084139060483555769481584536.0,
	26076805700254380683599078442377457765708480436797857607925348633937397773210223810619140426995910437560187064053608091041083373462086949090769043931918531520628974524493908461080844150854642256167050141625372122353206066682674203108545322174623627887921509175889125044399121263908776967678879874941321890264013744080772524298179218289843489691999162815248310286663282233748744090271840136582600165541904655203.0,
	76945712236539083998810811681875928907239700599522251627349206291292400404282208878485068791362899557670823575042898367615546981813289000685773333431372595724526168552842640652833766743119115291004838137002611977197402904722859286468330628870380977479440274892196640773829885855359718660127937801911563580610197704378997807093668936088675212133035994381315095596755556916340522004894453545443563487324331877146.0,
	227046753486548836458927866829674064884385617107043525128139561804626025374612669827118113439898666748332353957204403916849825370807686440363505297769162569973605312061208187868185356308515682226386645132581893375092243291889352465414300187615655757062562406982851318564954195475158063166462228764184088346986292626204524978818877734892117320807136324056112864678669869114700010944101691655656434818659068999543.0,
	669957118928536411432725506080769579106117515695621058488808725341704544287748950587235808864818977222936107449738343534920967549412442284352816438919359400355578294884054746377310908250711463566861391071673013158629128616095491748819889224745511979508230511018828759513452544018739804936898187666458484654196359597640575655770171007144702079075667130968858136589776225773052791536830378948921489057852131455913.0,
	1976876559334610189380338930905196103896247238570668609984796868463101916786572407367038862047901917604376400865443875339392978421670885252606626550857751720045282874995573618862451903891376891780461418051063888478124995067577685018489288867673931137278105713520304825261764583768567138426178353667466165899369390264805931770140702534181690259411721956662148464203479058544247665457518941921032792495541471237237.0,
	5833281449004874017944861196501366341445460102333506866653894565441706446707128943433910787608002604232789606186604597845023322704185387190276347094399485938398335586211104882838978766971074469108675251784005885034065975349457763793366861604069320131555785963349231188153487854711141200223753740398782098953872008542023864025943203643638312176474451020638576388699004576664701097071426641241877771834527032410330.0,
	17212626392977516110806191326184628540298192410348666438690797787245294664387683215260386775956359327208607259898216347506033422631510470565499884812690570924320747330993092650797978597529767482233092756486184493666259788878838226660626015708733388675904995956700569507171464369134876278800968454257852094173283655603874716017289445007818020039477374008405556556259530477662713233600360864267391090194121667227486.0,
	50790464364646734145982183649219034538999227668629452823877850752415809725645768100438681690010621914982439695502853984436783278992927245832424834277316300364889242713730467713550763840745263360068968090140578305131229959367106980718497076437374473625007601470915052028032835182412095711922359934355739408924199047228149029279582537348467495928638850726625458907038210971010842274980907132915490973915151629683736.0,
	149871154492525916716072569573506534175144188201731875842529222378690146006237405252469442269782091125211100014560097265080659933939489700419223815577962515822622965371695955933881925305826431274537608671465528187462504449123217555468039592554710810182617415167193915891559806103533767144532968696448908500561574557350996555141832711703336777315917322361800462725478506484280365461686502942018242273694786018163953.0,
	442236667126832822185781764601230047825841401273052617335226934686123698249875979524394610696302431973172571364233117754477376319933163516703166432758067207308304131013816436791579755411504448799805179333445059088626032458571589103579076973906247784746034158823845727212603529979308238730745629919148105724336555593172040944625157587948444265440558456244597697545706769259215823452269628359644356191973667214256823.0,
	1304945182159501032336618391640285637408763022436445080941555497720294936148177807304045674355281907354807538791588671760297866404453380057155736007860697763176139704894526877190297350545267249771532238684996905582886457218028314328728554695441169436592004389872215943799396442423993910467418921823137057238268895595701985466061121389799187657131384581586385768947231760724962965669626879739870149615846923953793308.0,
	3850619544397149902561827864503913988106490185045261493765089494885336977569209353647575089476395985971816699490670123863357999569024715271111324218570733549616970806492001847475700342660941534629375263097944260650956316428685133442934184945775967618547920785990550665181376902038882521425667240714946189448963578600976124260072520662576016020285957155517187374453753099043786520882312662090882407905077926906469925.0,
	11362392151137301835501187197207155946563719628876640325838847552492714476434482302256772299143263563206411095060227524753250119294920670658266530123857693938296029593476013691520735076055809862719250524735015836899288220934392091872491697372895206304508939684949950646314617725943564202850576907487587414787726394660795156367043624782807828621553665470109938670098176361954773136056192575230333737788301949705432883.0,
	33528162762974365330164661193827016083723417110772695871408880170403195318493243939510527346117726503570906838779112431959769980446602263310062582809895387134645726329466510806886606686366398974534741636376187974340568288787594395322857044312356670244365198695196144065922176350308665456776844367417704997481680157564542443022807469346186735988051939438965996878881086392590741900299108850651350818345513144485113948.0,
	98935136028941071356391374343874242045691447334789401956456648516007108406615533941890587729395511288072400194643151589207261629143135320665409248707258494090571293590831126119000344411080262160508914078161350792980076421420476009697784029607994303396388306673504786614008066714926740799300120166386892904200721401331260493219647294219041525011013248635814974352387569138972970913349476654584328809541816092475540393.0,
	291939035951173005154028135625567287726917358604343324343968807971140175535503446093199431399534986712158169597613195498880704300927047490101905504708780860847092268634027795221114930837106818582129013931393197796445417676882801608024977073204599802509102797498840019188287612627235130598198990191438269152692396698731197361193710539495956640960164674467337413612205287146084506525959867798338400413119399695927277598.0,
	861458969546033004932914110497115489024217284702631824895443112847915325668742426343284170994099153445532129504692424822447769548216390173473086321960738618246953988108086930293667453312720766426006718057508925115376317457964754084898323587969552510702876550392590164987210656417017182939100596928502839358869021781647260456837110791907589729970998910883605330212151552063071892990504255411273458148058327572717393242.0,
	2542013405588722134079105347081623886176916029145517111463615434541863081954019915281733159468571930462078540650351909566164584886175876022150645957582898885121497124965726445185720844930938856771289556348777000683288624786137259602072460473790542751568678583131940311623337013550311462904920471162158684195528689235234514075115463472505827038742162298656716188535458535818583823369772111361031375223949910242908901310.0,
	7501046980771387002323154756247848008171468392032127123887875605160446724552875698291185216224590406894319594143760682029045220587845104944674931596898855681312452886694491656457923863006555931720689073098902154955732567900200816833037368863613021372423994731143750874148874471556530923624206618567598328448110749081473816343846898953936570411345783967951928291623683804179819906483836161203988507735627104348214401924.0,
	22134348450112328926225579323028370789316114337489385300826885706674316475597236076975084923463094033483818385044899924308815612768469858784033171065174595657571416543829604662247217448881172986609179302292469205851704819366014057302928440911871681065476874996867145798572774807147796081514888820007778278738532194463256899050176730910762870953935661048262902451726534090858491306361799105868468634338877164760803639644.0,
	65314920970652357869700017638751602375934914058858676266944003765404583656840395360925257274860650781666187228508598213068506698699211496475573355268037283347388360725233088015320897544857208310766553872311698955434427388406922515890996284691601352001902720798693337416893262855821180857221874192200303816613224393483362568493129346850839989022176511473743618727901334398511148468566481490852227285361339278517596911499.0,
	192734238927185729892693978048363266846141245322026014657476150981436714415290913873849509940182525180328367179945378521167962481421948384093605274638929310826013687380481244799598775138945370126325968173369593617328233292218734087211908073029629589855180079967364905833876956416963010578886972561815987444826850789240650098476124548163081365391521343041957011010067187721168298514405686335284701308105938855871767389939.0,
	568730007637690301587721057040197415479701201117366411679637420748101527608734319571786765395986361545091263399221771797052411152745960969707932009956929407062861052647270993578123666104150065958045067187658482779576367130332997889961827875686826118879123191838255257377391524309592648032342169446537855038397543755489467861948224398590740872113738763514604680455143381322967690337160942302485071450932735090470444400558.0,
	1678240564905021560730997615792829726232553472373046201060049350088181294759450506166194622750564265631178229404769273493169998619653383910711595060759746019665219588980581622893891299446837270729827665322314273654696669350801947435829713448025042420337623294295123223364892289978298238214448770310706141059982039637520828977079355047618333243818288271344059898156377567815931735344314640150434940561201305113730408946406.0,
	4952255969940333729029506269774505596920736220839600778222330028742584124233063366860104336805563282113854069042625261863501797574356463647260521273604893840434155530698724338508353253031634557163757929646249454516832708682479642714827143178302834620830213696065513707620796025518355618588784553538748531330829120569112855020481479704860535862735000786271935765468925279232666163878765216109743719124340052201571149025212.0,
	14613449780000342667174610726572453816954222186507148619408815841077149205191542045193177218417858476912257341573226553377172241449113911781426410810775856662829150619316343478771372362259524721716807350308348089194979845322002221685490698511198738492041373202916997511147478335176414031214170423477269144443952877576386918833315242801382533959904111001657050324459767107428108450394747940419627359935163807384975008468941.0,
	43122428836244758704441636428766013573550030062369561150775657174401832586587739177715734490592547634571623584228574752393548627414488325841705426840374629627050823524360718934821701418886334328534744005820945549469658078313980742993493387179864978439041827989336533328654349742620261125271120694594342416659092760067149301010669426371195794167339813821744593143712964832715289660955085527752538363023984112472880215311532.0,
	127249027121422329892624976418401369734705738369027986644711930141831160450252137767921950378497531468369041308881673672934058523889355309776323458489850504500151907834537298396084604791052818275123093481801319860443586776019907758582601945559348993389807561305233825375409441499706517523773185513643249808770911966883578986667692417204007665480533473384844445919465721247621413631784926419389115060526498940061399580907185.0,
	375497041087875781377054061583634605754920423049414102451412355747444121711874774463367749891493885805204153052420902441575910802591604858807903297463081348593185462596582977800082644134362460636757467196323283005786583381517177465550854980818130991215289912005155873923753690471302399600811292208184516451588708728234286532298431925017358589701429883023496506399782343585513312542455536569362924607399227155952456075430945.0,
	1108049999445257385090538981109509176078987945975402575094959837529079791620890704608395523307786150415874202744750436432351873521068930811852351311312354356958450799571630697653562033001278808923388824274800893432645827325920699160240911669196830522417520366738548524883851220855570816460291865618647641246865973629540437409317433453091186862354457580765189027937558589140362438232552170382697201269258654367925457682894074.0,
	3269738229914227823566797849727956994790048316877621056369067753723858580451956821930572617231249897838448939548772630984977219410884319104728559243001239440551174501878812052943393399671292234092494819078746857825115065375814477284149852879851641034070766453045470164689358288055014182865695108228200566377269138772281348763616492600362798978270586580035509727548030125640344401294007441386543836957305300274540087287752579.0,
	9648668802126164110337340938588540344493517618422704851082964446749946937449201302014437072902931550869462115397805551104239178741045753592327105345803465084693806405892873287263046820294480270743055215874085383734754296758530299763117076295890028938279802680621452749839143312570135569369580724872599571764958818430702612578907345577891693126669949858210615992227588395740338635147816591423237516412225707956212599187816903.0,
	28472303100610741473674700594925744858485162130569063818890100564253460727822224049692252005474828272718453548826250572482311404287881035646288260944111138675388062942733588450244874234048812568127108624705562266128555395452856027563706377924446817904496224641627816693926650919328234586893465003314988885218199162852608611109756893525954280442099270608945661521424101900543558335935968882367303785497877114321997791257632480.0,
	84019207488265246209651401777446848804596309849820908521812509289546267145641409419835665003094195793334242532029881640805294818910595386828797793254499115312849839269602367471888534964927540144439006206087252491400966132980724636738764223908643758566258061263764129549375513461212187219667398838720538837475553446214250607387465725873426182745752592371775380039838150114246368716023715475575280780265885895056260389476988140.0,
	247933576252694545216955236559716702447118945307419015450846873088317819496609126692261589721592621042418587369630922407602399668685323664413145844973272169362633011379907397299035619770307166964356874478794683680020880677196679626058546764079384323680436749821618948940536466625070382089411574741870232394912206790456530977283229485001385457135469675695375958427624868984126607272836238052252316974374722307569835711760677762.0,
	731632331015964318779361740365732461087819769308921573176570500292334367947663917958724123183153499274403367768983113912263215022262945796519807811942296324432337862436885002355351230353552735800647095109726143299276616596341572721816283277892896173976477107599770320011178315776135701338425037233887254823955322426948540229187255092429081242468813836242228173910182380416243290560719999220896770401658902395693981712109070105.0,
	2158992884538575465170502952718757538100267682713364210515413119580484795499782990399269869435060999739366509181992877304310716480327714275590162005343836074497481325461130958892494016753120946286011857702929735948636363118385749940787959373651423006658750038295086314220210524158128054655316203541795137912704520339876474771278077046051811566502254614740338126276975653210450136254265715240621041876258180040487808773442911371.0,
	6371039676843760818667876117247118184243230379526031251070595527484629908195805508900049760532334310596486601370467685288522063649328181899018501913449969754529941544173536189960684163877378986314146090211129094531259005978854366127249743325396500653522343220962508595841063689820397295165277958730862693465342708135702236769153053544526773998096479945653967458971024660200003160139039280609724081974623852324021582811890585707.0,
	18800533930068494046788553643989371338580888072655783400638858487988234550513986746636708362120446513023820451977921071308278294842169738322099505411763755142251553138822018954081947380233062839153463361965747613956895569423412031421325007775634829084219557178653200702256963126250412945161945123560391908635611863190895000554777936326743144617708177474335310834490213155263863158413225184933029505454930274514338164470478348549.0,
	55479281752557892138966562390372306006317915099569718233828317924634627847252411526973417227530919875733314704515618551239515063285700731423488189225487744254762189884515170216002007873364845863804763818032785214595334592124765084695411926945442825759046802887041648754311105214137284816220901071895276968435580317835967050994785216862262730532981301688659080876391290764613866148679763289511501876499401703876511041808382796950.0,
	163716423304996655010793234026948701654976351215533524655911553358093826607206026723480903035184055056100795228858263674913398116515728278834248631780473712208235156798766597589626746436868479029648133640277598407510276175601452283622474328693271839031240620651674838880288731325149911393409421608219143267573071368581168633040387671359618495223390429668136221877101729699627995068474757161325137783921897915945442941684451273790.0,
	483119354124480353799861450778387462733915575531790445854561163822854441611729779594836556410204170923426873859179369242435450231309595649396188194453070427727279858269872753660045384145571041823022735269435738618989483659337688501728432057124237996883259586298070830339678328142615698525168657782182536896376548719646191441245260785505778117950500997334556510421615521939788857196251678498202259028185918488660093281280109783965.0,
	1425664685457431217495104478382943305651260007661379805971225102359828532218963628262045329490187355681663067298994732411956646877710853887773313394184025939761602379871519575053235939333839495766197907408080851642055474990256358867518285393096329179488844489965588572344282874548304214453899079057271076204977427180989257687461111884288640896581272136910489381643631026981896866030752897730354165548386151848220738069341888799242.0,
	4207083332489420509468825716080904922115252455250700450511623323512074300215990849512375044953494595795042854579429834745593032795627170547891265099014617508041367837067270098341435179825337133599927813057085275724601208719188081803717372720543206461346537051779335765369364528464594438809834549196739128387670155429894012359065327220361307039807899431850663013177055112857633891714308039676174256367217253721599042740790761684097.0,
	12414967920207318907136926647777737412783928217097333231228934529008791819305928022328911113964598503863168820757060794607549306363743305664051505255301689615362303532752489688247435768064033421083312141376591091193431228433377297570693119904085239411460389980944542016153933282289358924617056201156271740767494646723301143017847902264946911881507468320490400350719774381548278744276712005115325398538016371287462379175836292709374.0,
	36636236345363592684056252851067582403494989115420250956300101892664594074446129953392998822260469073097556925222875784952953011583630334123053601017472326262288253141584952842515985747890892821838811903227881495831911125817749909071048131205426699897955515418716358488216826394186794738183672584994992366109658139706183492550767327027713181072107484889824354042720151291243505146539465413681620768387548405637845849572891597525106.0,
	108112737428761881566340784279309647907457417402129124656788438999816077730513712729177007936600975480474803074162876880231818797033782162418146291035928389508500079170748614196970693583149825702975937645162669467254640168438626179079032078130607410843343154898930362804443966019441875740628475369152373963027118808362002856306872194913996692961105778927702798305438856885662522466971868967349069203996447108010472730939933238367903.0,
	319038897278634202192856434425807407962845541220754403539041050631063140680037665823294398503770259025261066627125056403732092801946815312890676176838569621924091357369586571913160987306110586534138497320980927900268946675139691325693234555043942026184620455978482077875242393167017326279400619274628632928147114973147239029479447497726809281391119314665119768708859971147265607686537736439054792036692674023712774735878526238792820.0,
	941480144670260998441707799383256192168613395254943488193968167005667475461781616757823623307106779799096172009046505258757206188143061239696437391758237889365978029844454446968635061639464701670990706344231715576905690718227869854602023541643430163140553863438941349360273719833357568263506348127385683387600096651652747810255777579285874939994636630998942306827351035206791736416285468446375802630325394458061854215183649371482348.0,
	2778302001706504888424588583519254076935420268195766192725848267646391269077957322501146257392623819206063920149697385615249778766464606003024225193716968341839879251391155187173024641447420315180706342582129275346490015035110792614971334043242811790362827266135054004771929655203342391023349218307084085957761830335701221402779596626464505637235338129189585186526225701651774720652620796201351264124536868183963996747691257447722608.0,
	8198766032650121324436687319164571984823011981560291289682080712538971739190368255895534259941615124953145298801889629920661477685940950427744660298280897676535861771829328195967042783932490436277494635760817283114566172084002440882182915444522651372328649477865187647074710045239383966893363106155364397802503725421723896330865362832857263785476225965270780245322320519804259279551186428596724957969679711415223558778003024436178050.0,
	24194591161656753022609763641342570945406320462882311262697543788643312496793453147392700659213104675525579266719182247979320136716577474792739073447009070453982240890623218249733736744519715924016257593054358028826322604442970656533814478248090942942853009404961680032254078648008843533984349267077764805715950170367505325531330452536606267912666999829835441443537155659501661282376806616786038775005690223604184771199060147294914849.0,
	71398458297555442126981664635856322181829999440908472603451542066790311397928136450025881876996050672173929839793450901910363262821244986153282970444926970739511875027447772663740245509060653956627786059289751092393784669073818012601515138664048183158288646315215914742423306009977084414851429994508057111641978916695969506219823079098935218748457242513620364633531962065292666064676080513204148302169873876318970081422016647098812276.0,
	210697862908048781191448181031162897361773023200933868999337725077947582513887377629782004464881922498982979704313466757535027932193731793418127124272279708562503297357908757907688681736251601457604821170216708700198169613167968790004084503369002901545575730246804159466665904748650143932026864235686511549341596651903838144310074499811607601589970582569201343729347906187428278154851976597320084402057393654177130059090596801357131921.0,
	621773452837654810797071832190559257035499817884530270789135657544078723329818473444485082054684319905405448883962135184235949184276620617660713153951167728340782594584029953934412795042060739919380503115619504613360720163610622036602808956460776857221417654289703707349282000511619342421536932544912291582714960481151767666856639440306628315844836021056182344772056980919791169250064735864776319681451470477781610392605358753953995512.0,
	1834868594160915345739352271700699714786752366344285982727946865727611259646776456859701695075183927692931544639332588573271508486712987423876310560469869442595774142776236738254428429026393480910144368189771048007490809744743421283170504602334853520784463655307461783473010286314842929805824932639845273035352387323846913124071309608498409978848785905711337246569608056686676664185940981688899939688786591266289045304579638613583323599.0,
	5414751176649641133228401501895079775384709679287024614869065716773889574885824961073599085312736096580556227373770122704985370006491178590355149211308912431372338556413361383834634400723972782620607891682073710298524600029531225789555800327570460123442849999051183071735945417715400353890699504778712047532995348697426408271537524906935820524047617611930553229080907355869881823230485585719390303494209077016616849618519393198748270930.0,
	15979117308385277702777059074443456601684533305835166242818361740457142448778333704030505639821039558032282232856554639308145704870436245030372328044176797511050229291773741590335414191750531229748574217198140198127842457846270494192974010304660238873644259923956071690387888449597607804223756650098665936754220695257583539998006952881308795229361467662506925175195038412185201738851773014914157172951811237634506397058999721908281355060.0,
	47155006374493898905850253193419252580543437623714456439802856523579216342194985631812190277868460128664114290287703362567971240917233375381180633112535938215049107702829243670729903680223507594589351024219676189871017674476824964882952948599529078818850933316789605960459089257083763020213501572858314598340922694654263261255713573471093604140010299323795038810966079649381816803787421083997161810731056866816022247536733666413802563722.0,
	139156523774746978658447602701513312071473079138274128837155244194011836770005377276383373474283238836270092977118487494095369667912916145549397356134388924080065977539004790242021604131074883727828934997066601181393854010141808774531200924742278144307272904451622028903312130817639333502754348501580944848041202979427396953546135201540383857893334930394325834853511283764305656818903507668826207387465599065131476577518513434711048434414.0,
	410657797465028819855811787478406456578122131905619448570017410936701839127913214577575236628445210313363189654930574703769429340245681423223741798586314264808266987689068873538353017248942851240271869818963389396095196667363058635594565708489555183420476318470066631694367614602928970896104700214310570303798429180084246516561980601356159579767309388734393759825115473073412481846838130058130486949984115137421679231694809257462279218090.0,
	1211873567758325335024835090806363743576799966944553591240243703133026239697602211225132877746353937864853042765826338739606977842456299300816023106305249943991155303855378991922431567841698244211069984115295666132380022986713089887017860600337005983019693528369179716945163834445343895668000473555008571307351239232627292876696177068168887409900045808411470985006370427646004329788281438053198229881576001684883817031159341747881189867214.0,
	3576311083155501825470001473916480487136897260398317202117292290707307052299222006885262101193412646215171576413102810525158802666592467148963855055170025795435800696761281904322213084290894399812240366859585873860083487206428991016090794188932900575744212564420141536139195155313286580068695067370333989657800969352633178412368779087818686749733966732920088719451160079575185708744952278324323207661745326230775862333327408540548572790335.0,
	10553924870667385017012097412667902354931380311992335110683469383293274755254073615774874210455696714399078940542579612868031537471508955785619718872506652737695273548353867548081073266070540831600602016935681886510922410632469591030251306463768145724181622988147808017992825674612924666459761527517146219261928359128390852018314205885277354702175853204226310383575387311935876537435202710823465083847400728528919830161534152998938588584227.0,
	31145366132803445148477578452077778251285943803557634135890822555401248050365035325629930023888538401790046926951446028688626118768507253856819135400933903933174230609032596555174729011017775288930760482698240269652150088006934392154137237459212481931638804712370009170647253046152837720732630548624974291280544953509683074172550390826455746010513807192320832081229805796053905154110420205867743835589443609821547047689405128662906931518669.0,
	91912295802322725894396332244355214780404415045093842434373546977597915124617649692088582126129690624409815084641326164519355244826923759665671746953568974426980213118876860041652718411934859250622052659293610481403498920188525210620155305498928239412046207911290995743095508501959626800647320914164736172519516863631262704019939036150184837240913912101549999079206924193069755957424610520829330037117766213231420593739526187026998511301699.0,
	271240488085711527682201764089420606620409326757858354478137650292607288948828940565569341179841976758286790858289512556252167879379707409288900500989196328021293938099137886296300446773072928386406191483722265186278041683576194230774400010102707988601429669696531951279398190304980188934713925481632942277977754969861411164544470293954687074365429452263228970804621921501355761370720003655988316561212025574988835722055876469642083682563882.0,
	800453574445652859818615656356857881539462299000878882476614682795873335094093297900151099701516416546425702126555679347190898221900183619776854212660257104359165075274202411656294081991422039324540997475645939577193062684012542091980727819437779427101067331065366801839737219349251684568386148264156872211825506415481498285187545628883437158891002603008559083849777014162864090111102147722374724477015934707675778106059884605188589697268179.0,
	2362210012216086029944366011800830371038313954065639489462778297700776004946543510462904467607521770345903303108816925706337332933094828874234199422983089334902949666358341466271326829125848274752250516392159353505495145440424089566259177486543828509457930318239189362193916491869086540638343232538144519151205763055885302069364573479429723515188096107650164420168332601927769014860377722712623992103443561918388529546686750373677101540971581.0,
	6971104427260473578637770007137329907758108626130519980489270979154927851785634235979424276808768514871683610127557225309290213966841438816899372986503777682694846081693448921843619299941006974864991231337065498803518386734472206411667009110268277832702539640324058641066910334457429067939211073371847428018823931397600746999024700332187410028488958673189529431142763203521063661476316628444672866344572595280279389551781387201958901379190768.0,
	20572420587477646618852952951908559280210748476369541418123077587709977721848038286295822338269096289867170988963716186142935595940918432666790990417921014103597603953200690945244904000742662009105079475337693564969745071167154474265917691166718120396240989497647054625214254289673591484133599908995494315036097020550973239638671662718613931017865310314051217808821479084349142016085265853196720988759656005330576318016102678634710252755710554.0,
	60711354530126319853889565935841469352156674734279399789718735373404178406120841120281755665531929204172651952850115772537566801509097980344835290584524792576791615525821085308820083891550578838321186440863288159656680473301410264831350754404465398299348152067063663607906692342450584637524409995570745109109439438044168618856825581914100711053567152326611611550644297837701413543574495952730410745887468737105328048511573707238045759884415666.0,
	179165823842309678277992115531898644791186611128531130395399669181468787159330038910948381611888109565720982512481779435304981097401583936462721954748828009884210642260591285384199767718805430379167405004328011987745662764990705044748631684783795774441268548954874302307557385423390405981019795981816867070557157831311125465245197542521903179527829157909854216263223968981281832283090033139070447402721506931039535916564915419092632603766671006.0,
	528738747763321910150339312035447342779984165130253540139452156890316526084738200643301845504484333299353462891689423951327402425440846902907002637813338232645078842597373822579263843469661840411702927875226917913704075544482750322796880222030505281070890365328842095863348821280502057405672090465441379113888187637687152058817000575891047533607056454761867109374757073394845777560316335226811959477287519937603553677849940621881510162550270019.0,
	1560370829587002728162589928515847431965552032162022560696253753258691114525057721466627109300828760908277459092713995068925384315776046355985313584635734899244698810084170507648840319059157363068903383368336714693043103969151680840032568116649727878477347832184082173919259505243952978574209677360463008032213257867923679507319025166435634634834504472650538238786519903038580992163583426340072103857933322671634996163052637865967762749850773237.0,
	4604847194436717802731671294442532743030562700319074248956220499133877564465075066715675404167283036119952285087750524339235181631343667579762407635610313566421418185093981360054083575640467862300670487501397299023085108563384040317684512969073110289840802447470416729700729617414717315062325151687239300412412263159437898453961048498210655746910426545292691679025523762151733309461074406035074876758069913051301355175834376401111871472880375522.0,
	13589495626368230744783045035883411639289888143193650170450801266890816640942221482042612351194604612088780120211021274925807927606762195926528500738108024272615806508051992533030502797596285574767599431911701354904626748887895653952418419058451379674425877369876681985525389705043670832521745661381440173342021810300260070541767476960601645912808980349386876039470721005341169292701267469235141307819433863230257870482613916261842068858150710835.0,
	40104413180762426998206693184595286442318186803373577608720846297432003518986009427779430251656945840674893810373090059111545498050018586808393980170340194375454911268255709472954904495587639922591866478225708339566194366148125254182964794845988304493805767917697481328514200439697929086639013294895202287630923297470470238488434005223299121773154695552070421415547591994624779707248519472292113675802278325734199057582003652489265459548957869623.0,
	118353663402225432742997548566128446416135372489849889692047987050760576732471194200892380843991912404630942807473530274199035696212761673944012637245119653157471390171689080635448677328720933146931173243796458902777200067461710891944316678504379836030349793823919175199323961988359089355058039503532232419683533324888857572444157456178004856569264375093181925370272829853499132781994243059588609986705411792376965739231537606935336861974460221426.0,
	349278581261753815944352042713666937363270872565787905511387774221616511660399004437392664007250275678921408236938990021673031092422988190470494375137430532590068752851089435800856777717367482523808215924849971298059972253915312572495743500679221658747023679649230604758618967366775865121355795875492635063086133219816446999543295540858278884288451135318127170466633702997616835484703785352366313757609842452776101336009723828349970807348096692774.0,
	1030772709728853557151562107892502190126420252998775194836127319158852284783310797782183117970979070067947192215574980799720629439294372316777347279091675772533212112879210316256883602523798477473700476558083073652874739303699298395259120941547319366459128728902718521649737550662982504400190278575806427755660584794453068080049100497340076835099100647409989327871977666631812011570175837011660623288466793610134980316036989351451073760506370779510.0,
	3041967545928083110152030929700798683511663450891774694668112272799942969855091447315893974642286161609330622799222474970786620334014567682722747692203800216862852143961724561978881155830361520917493080348828770788846181100697352127068851686362385728925027560998273159253497293435971119549238081943839337790004554030225606753790200777881763795259545788873915750250379902135770291973440821706868114048494722924006704638863170963872224596077480158586.0,
	8977324967087797377810057104311013440658679456475318939540991203634124215200427861544577948589048503021897594323478397543756086234668615122691708836339991809840718826037386748567270190432271816151953760500402463359162541378813247544883228521494522969689481894021082283264278872940278754582725616035792188750108600483958415276603327291599108098438533852729368612945179361983752465504748774976236683256978293736060064465478370751772587048514253472477.0,
	26493541760113108539672519199746760187079511950586535913618779235839979563808558708064297082558653259893537944880965128240944240978312211328924743823712906511803985919157515582580432993959615185309649633380911732266305979454040532107249641363277577730836267529050986271382578801837439605992526156655472025123143784633362618272004604028517659702825462121046093761638317397780166528672820769736201094639426833883219866530383675434423028845834267842339.0,
	78186864466990058821888022943435455233319779028590013380192955148013464851971209803570525786462865507047368107223006902543038719437217878620724869536327513498907079628916273119974461893340214140593084985930316376795042980683324627137663387120647025530805754275763982461708552363375691549912752471191273495188061465378788190955693270012251354721575137126153895355721585267286550469324141746037992794218516009375445706511217584596302002208099751923419.0,
	230742861765452267784826205050279255394211239053946096750620779291143957785145848188263831236344714440141610169790044819485873624316465338228631840902993906648526789920754334866560595013227453916029439974847221107004961210507435674346688753206603897229271449379817980320168800176504509809064053920287595707115232899907445269969838954453481530112739565730287225700956395834036341447676499042277803152031736302402838836384191599475494223605153889271702.0,
	680962900770213168164808686617795137838776016624782387229545187495442059870017258179970498881618399822559295487309198028936775160634465469351961055653866625208230644993168527407423443291050215284294512276444241716505971479437411367135291016455584357168969290848140041741896290355926269402313113704381773334230225525874536522647300086979469366176237730346553743186816481846214147536620051802639280523868968254220984882766252982826390528748485040899640.0,
	2009644910243171339409894412408360773342244811074607154986636365008065330919727335055557721491760205788851251180944975325853678588113098083203721224677705338096915226622249782116547639718570475875542206323667804673500182483496659346630136292736443783724698339289986639332506678236976719091774576962150923851266326910130948390804588922959062299351063548162620129806889006595566634749756906222726177096189973090690760231246853187083899655434190648681299.0,
	5930835791722425079077921811586487382080192084066742954326317804288007708473223491492806531640021319476021154558972367756818747666844740584628477861698086561863484888564626173347099629919798559720997447832314190275170625210459223475807152719246529852211756729611980258754557676090263489443179297848111362723880590593384383948363615387170417277264486618267614731245567062034123529341927416795186981477207834084114716377890002144714251879240296974231591.0,
	17503027189212996015024196283417065355893409919187283109977035712325824239923438830966874286549768147116242935704006004550817643095430052016182671125717750278798067727729741235272483283934698189586049287762758812400412742715083357788951251182830408467721425639003154569521515045145113392028090685395890899441707684267178698940364874379442886985628950377226697962639135480120680481955421823968502825347115433995341686881339511233167740309085197539956400.0,
	51654852877576830987197063999615777308563374984053194610285378180936635404834295285472949618385999707266443136613337748708390364730289790789468923725717515886961529079262440761154148415876132088928680570601532130875914576948038194247830570100566973127648177958580665964153987815591852780970587946641908650129634140813272974229279111044386099275294916050284418092792831127634608495673731996174868516612716776881983564277806885321451731676277729841366048.0,
	152443805936700292003382763746631456428285810187632238081976694409143594859592747312489818797224236998318180005802699291783267595266403799622708737833345513414307715095503547080855218146188395003335115542062926274706421922093973477622466181096393137836649719892558759969349022029423401945123746213845735388578260867854568572951785543299053569088543709755668811469043215973279085266729567803396700022087493609887758204734021553582650598957705065461802642.0,
	449892888103263977679828587701369664476701963249289048478835646777418601109961535706480592710794412077018244377906195305098823975967592494664634588218623143230320344707949329381459380536505687077922065208168810746666011128383550847628163868181871053754265337277596964748808353576973158668933289816199229188469140550939375348887520849958173154888727598645244189940366988357024267863788704695361217404884902397253912478732069680039593880351052001249817477.0,
	1327728148196016429858256022943366454125888957798525020164242501774522821882889296764165471110061121798727739326204978294161103939586524502611852734657833886800823081826150067833742353628074491455897140310264636881570300052926470359313266930924286784672952739638603148830047950450884206370368080566240742962001425805730645920652739635514202483568218974332332607796201679397140208820232773736646606317359031431616868138540155913290100001326965464187346133.0,
	3918410082945574927388850142781675882756500176528916522479289394473731358205061574350402742106856801077146486690852644086274920185098102156932702242462553736416594433226883720445194434991333353492944023705237097407498495576056121537384096850919005442988472924386013406945111442955638258905489072974276737027507348814282822864233712414989058266768320483711994548033007281560603212873471362567005906170991858156152582786496024955003707776745166224333503539.0,
	11564085524062159430115324471300810179061517798697505397154186295725830969492775970916832928371806951075634484196405441221011310585444598352870394606793729302636360174275707292660427676114837012977222135021978756199053351261940412475628007007821332929191136171453787092121444429578157873909944026098945715541389625505704235599763921863101836373014604042387607863972386619477581301645176655988120686227201333815425051772972161688720145943190886963462326298.0,
	34128200524576314161512266018130779995981048942385406853107840760624123235420009324732467149030897540310538229915310752817953422335791323834379308614390531939066755691380376728526611115150367089540451553582894504095454674862256937413728902404821442432445920089103750764629392332700231802481990349696208289298176929173335190954447664040615382141138218554147048682558296524367664150838786604574781581804862005082326548867609937108448454833988778823543566376.0,
	100720104755411802842501066647472903737440281773150835891878507371796921668997567553577188379861613367803973238616323786892225075048094496169853062075247585650977581720831860046467701943381595823035350998023866023624963098075916103502405208223219049781269297760543406267399374212224501922142650246641343415804010197613216530051908270263461100319048765066305241480041915329713685661761515051282902057655458695492417061938703861175897659364997987685224371241.0,
	297248471643523340692259268964202316062183231859118824583570944780647327776058500753018697746488002133245838095561414141973244974606597003016907044820481131783441649459489654519434853054160186497558679482449945277633816496816001234864919395345471329399679218564151839007716635587620252991016181466391701744315632048991040963578547646416877140551434028371782051718824747401101284103480562353062994289360934239227305588946729509490472962825852535744435306042.0,
	877250800058047086364441903218223571375999149518414043900504715886754477671083427146967639401600262536266484881002583599871282269205674453795309859049521485790190034612344644140151690455273525472696636469889590117328466240921289562051092895744653010287280604101086687256576393279132815334764278383713176762217192615297312770335538032366628024141098273373722836561370351112102030441139390658712460096710620009959339165474872160494062896551813540485087709446.0,
	2588979403404989111152548964199813135536905663145567017125759666091813154235819563037382203287842970139981468051515454068022317350580173236969067669747975448498692189896568371222617073427753049212256054457655753559775283317011274581653752571655397215065818717591959612754022830136633601419990003020183851502325697646129046199714948788486870323041820571058536922429657004015120253819061984530175189299063606779177850516761522835141289969148706303644911515360.0,
	7640716681093693998219986127296060408635570583800939403590070113325847245787223159216288741952331668612544589934331911615404588805504343198885142327646711881562495264889537839408501944077948915492147158879349021778649304404387367867340850194794793304468862001830425698013395958378354691575807719326557835015588376772344723282513102283368307826093056544404130403804811638258337713694845213221086295645625810628371913624001528730638113101655941922891644081140.0,
	22549674335959119175237395187145888129841736359816297250952696133747057103549856838118969463753286087500719087784218517923710967070760655130654789815629337065200619536291974377608433607115103438192305877675553655473293678324114741741503095491919026681677385266203477134798877807555530609346903647925047248107474558947587722130264516921480246574480546544045038557359423849144323319654784893287018396347368650493370068223207300389450989639874007799169282727074.0,
	66549857158840247064165848679310567151349583160045941409610447032989556956647099479363472097601502016928228071849548448567813138355018781289788925679155324289310818401129886576990994544834041118506242411660550771988091962650359296436110909104658018481048126444220794886260327865796404609990870361951775161294199375918127504256489692204125114269714697004986898565602376403592202063927173200456366385636672594506112434926041677483954895378721356220215229794944.0,
	196405956819092324054100701371593280589802210497468618550119207294646139531232335119999499415613864146674458505975052915482455881434348756719042699914219419351115485251317770644978460301390618560406158695782659340632351133176829554095482772969169909013259352508861760203748589556135784230227751165098305590926169191209691761629562947148634912247574784102790306464775840920833594605494265390953143500199823089774950579438593585552908018274467721259214891840107.0,
	579646017124482904203789762224816618116974911534150739869263800617198043293716001158710375160997667887765596498859158356067067126900709726390715647160777922550741672450414217499419142434665832769508309353089862015637610679488816221921193836997286272305792689186751974736484830668969658915903589349650969855186003745558000860557241710847483158055213923308140799643359331482868902691137484237016500283722754502582503595643174435972928694182304405738373308327903.0,
	1710691621237368855020022662308218463335305162311419952730914029633666525541555544578259473918058121421457413382213831293663746567240234094744040806552962653198098882887488912688288234044667412775018635413498414142326781375848266801798671354829378172838318942150053570431798483090788769731696818329159840250535770185003033471795867761461031756536892106468742496157174883204639711606937755001226914759952761168789627789302653457253365941002357505377665865069394.0,
	5048719826210642379712574021720627953278038413248170821024979655859884121541908821768596732931336564950324375738267150126844531196440978383830156582139289702032756858269277065302114074445462620904584153644036674253704009593545098309805718332001819420570562029112468444549461037490515969157309181223015799627399690680038375205525097221707312899641227176173721613987965263075257802919833695840172336258871830823283232969966298637163373468999686562126600309783286.0,
	14900178863778918319671088238336655656810089362134730501463460578303942942713587099909756010051496545948949653225795219392770252332244572431767806355805947135723051096745373772289971118041315825454143844299095294937599175394213476808217629284373325807646953782592038589090507487961568504693589256036463935621819709710279023184813209346639675834521157424107012547773999606454706884870946876024029226273297535391764620000357025241036427294326068146684930935875300.0,
	43974646845942344573302565349293926502575488608056577652590715343798969612694575692748214724266610284875615190384694435396358923401487244152265798135857123457116394682730268356478480551825773981542802976444004157417780912619730591095667109047747229276134226621955871508351300733336071899089060508598109823356135838491080478939902609521930242404527689075960815162902194882212334304276865416454425569534920385311308833681591159928212153958582470584791979718654917.0,
	129781833416431623041268839564812888924346317670216047091107998416357225504071723536121135707878969440941827116042127181397567165657952613084127408052979182600288358975070304528804784000617600201994036106261195456825670390038208460977520285621784901458826681365499097674436398383410717534842537262101535261202740426277905584882805958189702704372774612095298854327763414181065153137744680336013980213000187302086827190406603680895103547679377945243107860719012970.0,
	383024112177131688800382616679776087944613906358308732203193130618012616078433153352089640072341344119076179581009876531994729473566699918395721886649136793551706587255932903389975962250205017091652286378597584528688860713198430442609557353870066235961147318312550868420066716612313300538078302887311688027922662616722067540827189063130524857835412242901960457891939082212309695629861970935211177067751105742453985593169197184906381634319197168529284451977473006.0,
	1130417800045893849020059597222242635015208353262622399391700799014533497477442545316574351910691444586712963975886382418362019909029571838015069122091977574380380053928417668944739567094632109174772580287363189095673594710742327675318079681677057953889372437778552359853614407234156185890885598025758959683532029506305813098484896911828868864755977242220501112405691482276186446750377060196961545916151995428292094550392183290474004899055525207355694074282846308.0,
	3336203414122970943054197971954975520466430135533297135673815646052837841718850864716862889594120078858480361778767392687091257833676354775175867050437912084304668504885906054155831619831703199921166349561733867839058534153180083171674017713728353886675849120026140650375783219395151002108974304858008742172324628590479797192831622387058890005409279015784743514383838512816270311168338660213171354690800357256048460082236069909464527354778245349810894594394726650.0,
	9846156132613095895755050639873517114140804250072340697266772579635168384772076088283652962862812114325308104840425338852694629028311718120251279771388689009083965411656673454823326210797248441414982886477182902518358478115598793879810621367597566088071729884973985080136353652113580894750494037752750424876897815824241884091970738885370526623080601421277547280803626896581168981218176617379759482896903755094077563592520275668226823998833688721770789451981040832.0,
	29059060781114962295650392492622324450251423163486250800169391684756503777044482440892757687727875010004392706872099340617183949490574956879332017834179749078395466307865032744609585080140946483153971909268387712469218601621230962956684465573826119378307693118104869086278358801316927221171510791841468967485608958879065920719376270624848396328433688636547473554625945362558360697453049209415989058456701738258394683586512287124584061379849508233570999892255923560.0,
	85762431723532955532302317638330062325832802729948281930888841155660561669380199704040148962270295345791120145889471594049304206102212182758037102306963996955890226975722723068769357743277169888422279904414137202808379006014457917546468565241575600937277666898056608277017299391959257687100273715970054565457970113480803106648683304864394873180236310890752010407030415721820071111183115712137392179394553393000944505409967193460743617004785840324180892972747747707.0,
	253112303720149296189761332711443073736824621005736013695692080033707453456647531054783155609341450306058716887333970803144318379620032826859297580185992235537458141445483041101608913247960398370518298088740243130152408570979972647972831021559303511688304771810356268955419712834235005075407203660383040189583683878178316039887360466991476494074543077445706017581831840723336316573717117006881759185493144147820246939777672578908277088054295294936954299599801696347.0,
	747016306537344068646682689751884247703053964535271724083070337883922757683790350347821509917785875821257412301078180782206466334352467885912996159288050324216024991280404767170186283664143668608431360747207594961639546412110674892737129726018603440984869715540915373760814629046840317514081237538354652328852493416777990915518894762232946386972494945681142381683548127418482322832802563811771997859999931699849782436395027273456430530550091982186198189841768530277.0,
	2204690149608366118593376894389713641354546928185272086787910019619084900152918787500796163962465626167233261589140241205683183222184578140331297919315655875619702939337972781834270840191615049840562119172965270909677496134309869443290987936198447931019204627241033539144457059762067293043222331513334293758016741261836086599161146625013111994895099872659209518105672635091421399868301736811664176621988757497888913640043689461077897171322687842624052016408400719508.0,
	6506773573532286514102589613906186235341996746918454708675073361477136201679289216155681650984814378249642947967334821138792652645892524337004802247559818257602475594170130444974455610781943167046118533010370258184672742002624495079178684766225533210574200532022209174440679652807339359426216846413016596191295248540149732518818331686244426319339802783079576228726261544119425715838799362600280070608910696734366902816248416398821787927731839139407228820228861274503.0 };
#endif

#endif

