/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "sma.h"
#include "sset.h"
#include "cmsa.h"
#include "residues.h"
#include "gpsi_typ.h"
#include "editcma.h"
#include "table.h"
#include "sset.h"
#include "wdigraph.h"
#include "selexCMSA.h"
#include "dheap.h"
#include "swaln.h"
#include "tax_typ.h"
#include "hat_typ.h"

#define	USAGE_START	"USAGE: matchvsi pdbcma_file pattern_file [options]\n\
    (example pattern: L31,D32,LIV74,G75,R81,W84,FY96,R105,E108,AS109)\n\
   options:\n\
     -x		dummy option\n\
\n\n"

#define MAX_PATTERN_POSITIONS 100

int	main(Int4 argc,char *argv[])
{ 
	Int4	arg,i,j,k,s,blk=0,lenrm,mingap;
	Int4    time1,*len,t,n,N;
	char	str[300],mode=' ';
	cma_typ	cmsa,cmsa2,cma=0;
	a_type	AB;
	UInt4   seed=7061950;
	Int4	see_aa=0,see_blk=0;
	Int4	deleted_pos=0,residue_pos=0,Number;
	ss_type	data;
	h_type	HG=0;
	dh_type dH=0;
	FILE	*fp;
	BooLean	SortByScore=TRUE;
	Int4	MaxMisMatches=0;

	Int4	MinNumSeq=0;		// afn: 11/13/09.

	BooLean InvertResSet[MAX_PATTERN_POSITIONS];
        char    Residue[MAX_PATTERN_POSITIONS];
        Int4    NumResidues;
        Int4    MaxConcensusLines;
	char    residue_str[MAX_PATTERN_POSITIONS][30];
	sst_typ Residues[MAX_PATTERN_POSITIONS];
	Int4    Position[MAX_PATTERN_POSITIONS],Position0[MAX_PATTERN_POSITIONS];
	char	query_cma[200];
	query_cma[0]=0;

	time1=time(NULL); 
	if(argc < 3) print_error(USAGE_START);
	for(arg = 3; arg < argc; arg++){
	   if(argv[arg][0] != '-') print_error(USAGE_START);
	   switch(argv[arg][1]) {
             case 'x': mode = 'x'; break;
	     default: print_error(USAGE_START);
	   }
	}
	if(seed == 7061950) seed = (UInt4) time(NULL);
	sRandom(seed);
	AB = MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);

	if(query_cma[0] != 0){
	  sprintf(str,"%s.cma",query_cma);
	  cma=ReadCMSA2(str,AB);
	  if(nBlksCMSA(cma) != 1) print_error("cma file error: not single block.");
	  if(!cma) print_error("cma file read error");
	}

	fprintf(stderr,"command-line: matchvsi %s %s\n\n",argv[1],argv[2]);
	//************************** Read pattern **************************
	//************************** Open multiple cma file **************************
	// fp = open_file(argv[1],".cma","r");
	fp = open_file(argv[1],"","r");
	cma_typ *IN_CMA=MultiReadCMSA(fp,&Number,AB);
	fclose(fp);
	if(Number < 1) print_error("cma file error: less than one cma file");
	fprintf(stderr,"DEBUG 0: %d; %d\n",Number,NumSeqsCMSA(IN_CMA[1]));

	if(cma && LengthCMSA(1,IN_CMA[1]) != LengthCMSA(1,cma)){
		print_error("-Q option input error.");
	}

   FILE *sfp = open_file(argv[2],"","r");		// get patterns 
   // fp = open_file(argv[1],".vsi","w");
   fp = stdout;
   Int4 Pttrn;
   char pstr[500],color;
   for(Pttrn=1; fgets(pstr,495,sfp) != NULL; Pttrn++){
	if(!isalpha(pstr[0])) break;
        char *Arg=pstr;
        if(sscanf(Arg,"%c:",&color) != 1) print_error(USAGE_START);
	if(!isalpha(color)) print_error(USAGE_START);
	Arg++; Arg++; NumResidues=0;
	fprintf(stderr,"DEBUG 0b: %d, %d\n",Number,NumSeqsCMSA(IN_CMA[1]));
        do {
             NumResidues++;  // increment...
             if(NumResidues >= MAX_PATTERN_POSITIONS)
                 print_error("Too many input patterns");
             if(sscanf(Arg,"%[a-zA-Z]%d",residue_str[NumResidues], &Position[NumResidues]) != 2){
                 print_error(USAGE_START);
             } Residue[NumResidues] = residue_str[NumResidues][0];
	     if(cma) k = RealToFakeCMSA(1, Position[NumResidues], cma);
             else k = Position[NumResidues];
	     if(k < 1 || k > LengthCMSA(1,IN_CMA[1])){
		print_error("pattern input error 1");
	     } else fprintf(stderr,"%s%d(%d) ",
			residue_str[NumResidues],Position[NumResidues],k);
	     Position0[NumResidues] = k;
             while(Arg[0] != ',' && Arg[0] != 0) Arg++;
             if(Arg[0] == ',') Arg++;
        } while(Arg[0] && Arg[0] != '\n');
        fprintf(stdout,"\n\n");
	fprintf(stderr,"DEBUG 1: %d; %d\n",Number,NumSeqsCMSA(IN_CMA[1]));

	//************************** interpret pattern **************************
	char    output_name[300],checkin[200],temp_name[300];
        for(i = 1; i <= NumResidues; i++){
           sprintf(temp_name,"%s",output_name);
           if(i < 10){ // use only first patterns in file name.
                sprintf(output_name,"%s_%s%d",temp_name,residue_str[i],Position[i]);
           }
           if(islower(Residue[i])){
                InvertResSet[i]=TRUE;
                Residue[i]=toupper(Residue[i]);
           } else InvertResSet[i]=FALSE;
           Int4 m = strlen(residue_str[i]);
           if(InvertResSet[i]){
             sst_typ NotThese=0;
             for(j=0; j<m; j++){
                char aa=residue_str[i][j];
                sst_typ tmp_set=SsetLet(AlphaCode(aa,AB));
                NotThese= UnionSset(NotThese,tmp_set);
             }
             Residues[i] = 0;   // Empty set...
             for(j=0; j <= nAlpha(AB); j++){
                if(!MemSset(j,NotThese)){
                    sst_typ tmp_set=SsetLet(j);
                    Residues[i] = UnionSset(Residues[i],tmp_set);
                }
             }
           } else {
             Residues[i] = 0;   // Empty set...
             for(j=0; j<m; j++){
                char aa=residue_str[i][j];
                sst_typ tmp_set=SsetLet(AlphaCode(aa,AB));
                Residues[i] = UnionSset(Residues[i],tmp_set);
             }
           }
        }


	//************************** allocate arrays,etc. **************************
        for(i=1; i <= Number; i++){
		if(nBlksCMSA(IN_CMA[i]) != 1) print_error("cma file error; not single block.");
		if(LengthCMSA(1,IN_CMA[i]) != LengthCMSA(1,IN_CMA[1]))
			print_error("FATAL: cma lengths not the same!");
	}

	//************************** compute pattern matches **************************
	fprintf(stderr,"DEBUG 1: %d; %d\n",Number,NumSeqsCMSA(IN_CMA[1]));
        for(i=1; i <= Number; i++){
	   Int4 sq;
	   for(sq=1; sq <= NumSeqsCMSA(IN_CMA[i]); sq++){
		fprintf(fp,"==== ");
		PutSeqID(fp,TrueSeqCMSA(sq,IN_CMA[i]));
		fprintf(fp," ====\n");
                for(j=1; j <= NumResidues; j++){
		    Int4 r1 = ResidueCMSA(1,sq,Position0[j],IN_CMA[i]);
	     	    Int4 real = FakeToRealCMA(1,Position0[j],IN_CMA[i]);
		    if(MemSset(r1,Residues[j])){
			fprintf(fp,"%c%d.%c\n",AlphaChar(r1,AB),real,color);
		    } else if(r1 != 0){
			fprintf(fp,"%c%d.W\n",AlphaChar(r1,AB),real);
		    }
		} 
	   	// break;  // only look at first sequence in cma file.
           }
	   break;  // only look at first cma file.
	}
	fprintf(stderr,"DEBUG 2\n");
    } // end Pttrn loop;
	// fclose(fp);
	fclose(sfp);

	if(cma) TotalNilCMSA(cma);
	// if(data != NULL) NilSeqSet(data);
	NilAlpha(AB);
	fprintf(stderr,"\ttime: %d seconds (%0.2f minutes)\n",
                        time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	return 0;
}

