/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "stdinc.h"
#include "probability.h"
#include <stdio.h>
#include <math.h>

long double  LnFact(Int4 n)
/* static variables are guaranteed to be initialized to zero */
{
        static long double lnft[501];

        if (n <= 1) return 0.0;
// fprintf(stderr,"n=%d\n",n);
        if (n <= 500) return lnft[n] ? lnft[n] : (lnft[n]=lgammal((long double)n+1.0));
        else return lgammal((long double) n+1.0);
}

long double  CumHyperGeomProb(Int4 N1,Int4 N2, Int4 n,Int4 x)
#if 0   //****************************************************
  N total balls with N1 red balls and N2 = N-N1 black balls.
  Choose n balls at random.  The probability that the
  group so chosen will contain x or more red balls is
  given by: p=CumHyperGeomProb(N1,N2,n,x).
#endif  //****************************************************
{
        Int4    end;
        long double  p,K;

        if(x == 0) return 1.0;
        end = MINIMUM(Int4,N1,n);
        K = (LnFact(N1)+LnFact(N2)-LnFact(N2+N1)+LnFact(n)+LnFact(N2+N1-n));
        for(p=0.0; x <= end; x++){
           p += expl(K-LnFact(x)-LnFact(N1-x)-LnFact(n-x)-LnFact(N2-n+x));
        } return p;
}

double logfact[501];

long double  factln(int n)
{
        if(n < 0) {printf("Negative factorial in routine FACTLN\n"); exit(1); }
        if(n <= 1) return 0.0;
        if(n<=500) return logfact[n]?logfact[n]:(logfact[n]=lgammal(n+1.0));
        else return lgammal(n+1.0);
}

long double Hypergeometric(int N1,int N2,int n,int x)
{ 
	long double p;
        p = (factln(N1)-factln(x)-factln(N1-x));
        p += (factln(N2)-factln(n-x)-factln(N2-n+x));
        p -= (factln(N2+N1)-factln(n)-factln(N2+N1-n));
	return expl(p);
}

long double CumHypGeo(int N1,int N2, int n,int x)
{
	int i,end;
	long double p,p0;
	end = ((N1<n)?N1:n);
	for(p=0.0,i=x; i<=end; i++){
        	p0 = (factln(N1)-factln(i)-factln(N1-i));
        	p0 += (factln(N2)-factln(n-i)-factln(N2-n+i));
        	p0 -= (factln(N2+N1)-factln(n)-factln(N2+N1-n));
		p += expl(p0);
	} return p;
}

#define statement "N total balls with N1 red balls and N2 = N-N1 black balls.\n\
  Choose n balls at random.  The probability that the\n\
  group so chosen will contain x or more red balls is\n\
  given by: p=CumHyperGeomProb(N1,N2,n,x).\n"

#define SQRTPI 1.7724538509055160272981674833411 

#include "num_trees.h"
#include "lnNumRootedTrees.h"

int	main()
{
	Int4	N1,N2,n,x,i;
	long double  p;
	Int4	*L,l;
	short	*S,s[2];

	fprintf(stdout,"%s\n",statement);

#if 0	// number of rooted, ordered, unlabeled trees: Catalan numbers
	for(n=0; n <= 500; n++){
		fprintf(stdout,"%d: %Lg\n",n,num_rooted_trees[n]);
		// fprintf(stdout,"%d: %g\n",n,2266717902172939745356419584149509390193572111090.0);
	} exit(1);
#elif 1
	Int4	nn;
	double	SumCn=2.806133051;
	long double LC=0.0,LA=0.0;
fprintf(stdout,"const long double lnNumRootedTrees[]={ 0, 0,");
	for(n=2,nn=0; nn <= 650.0; nn++,n++){
		x=n-1;
		long double lnCn=lnfact(2*x) - (lnfact(x) + lnfact(x+1));
		long double lnAn=logl(num_rooted_trees[n]);
#if 0
if(n % 5==1) fprintf(stdout,"\n");
fprintf(stdout," %.9Lf,", lnAn);
#else
		fprintf(stdout,"%d: lnCn=%Lg (%Lg); lnAn=%Lg (%Lg); lnAn2=%Lg.\n",
			n,lnCn,expl(lnCn-LC),lnAn,expl(lnAn-LA),lnNumRootedTrees[n]);
#endif
		assert((lnAn - LC) < 2.95);
		LC=lnCn; LA=lnAn;
#if 0
		long double nT,Cn=(long double) factrl(2*nn)/(factrl(nn+1)*factrl(nn));
		// Cn=factrl(2*n-2)/(factrl(n-1)*factrl(n));
		Int4 kk=1;
		//fprintf(stdout,"%d: Cn=%.3f",n,log(1.0/Cn));
		fprintf(stdout,"%d: Cn=%Lg",n,Cn);
		fprintf(stdout,"; %Lg\n",n,num_rooted_trees[n]);
#if 0
		Cn=pow(4,nn)/SQRTPI;
		Cn /= pow(nn,1.5);
		fprintf(stdout," ~ Cn=%.3f",log(1.0/Cn));
		fprintf(stdout," ~ Cn=%.3f",n,log((1.0/Cn)/SumCn));
#endif
#if 0
		for(nT=0,kk=1; kk < nn; kk++){
			nT=factrl(nn)/factrl(kk);
			nT*=bico(nn-1,nn-kk);
			fprintf(stdout,"; k=%d; nT=%.0f",kk,nT); 
		} 
#endif
		fprintf(stdout,"\n"); 
#endif
	} fprintf(stdout,"\n"); 
	exit(1);
#endif
#if 0
double p1 = 0.7*(0.8)*0.6*(0.6)*0.7*(0.3)*0.3;
fprintf(stderr,"p1=%f\n",p1);
double p2 = 0.3*(1)*(0.7)*0.7*(0.7)*0.1*(0.7)*0.9;
fprintf(stderr,"p2=%f\n",p2);
double p3 = 0.7*(0.8)*0.4*(0.3)*0.7*(0.7)*0.9; 
fprintf(stderr,"p3=%f\n",p3);
fprintf(stderr,"sum=%f\n",p1+p2+p3);

#endif

#if 0	// For InsertNode() combinations in omc_typ (see omc_insert.cc).
{
	double x=0.0;
	for(n=50,i=2; i < n; i++){
		fprintf(stderr,"for %d choose %d: %.5g combinations\n",n,i,exp(lnbico(n,i)));
		x += bico(n,i);
	} fprintf(stderr,"for n=%d; %.5g combinations\n",n,x);
	exit(1);
}
#endif

	for(x=0;x<=500; x++) logfact[x]=0.0;
/*****
   if((L = (Int4*) calloc(1000,sizeof(Int4))) == NULL) 
	{ printf(stderr,"out of memory\n"); exit(1);}
   fprintf(stderr,"Store...\n");
   for(n=1;n<=10;n++){
	S = (short*) &L[n];
	S[0] = (short) n; 
	S[1] = (short) 2*n;
	fprintf(stderr,"seq = %d; pos = %d\n",n,2*n);
   }
   fprintf(stderr,"Shift...\n");
   for(n=1;n<=10;n++){
	S = (short*) &L[n]; 
	fprintf(stderr,"seq = %d; pos = %d\n",S[0],S[1]);
	S[1] -= 100;
   }
   fprintf(stderr,"Retrieve...\n");
   for(n=1;n<=10;n++){
	S = (short*) &L[n];
	fprintf(stderr,"seq = %d; pos = %d\n",S[0],S[1]);
   }
/*****/
   long double D=2,d,dd,stirling;
   Int4	j;
#if 0
   // for(j=1,D=2; 1; D=D*(D+1),j++)
   for(j=1,D=2; 1; D=D*100,j++)
   {
	d=lgammal(D);
	// d=lgamma(D);
	stirling = D*logl(D)- D + 0.5*logl(2*3.14159*D);
	if(errno != 0) break;
	if(isinf(d)) break;
	fprintf(stderr,"%d: lgamma(%Lg) = %Lg; stirling=%Lg\n",j,D,d,stirling);
   } exit(1);
#endif
   while(1){
	fprintf(stderr,"N1,N2,n,x: ");
	if(fscanf(stdin, "%d,%d,%d,%d",&N1,&N2,&n,&x)!=4) exit(1);
	fprintf(stderr,"Pop=%d; sample=%d; # 'red'=%d; # red in sample=%d\n",N1+N2,n,N1,x);
	fprintf(stderr,"HyperGeoProb(%d,%d,%d,%d) = %Lg\n",N1,N2,n,x,
		CumHyperGeomProb(N1,N2,n,x));
#if 0
	fprintf(stderr,"HyperGeoProb(%d,%d,%d,%d) = %Lg\n",N1,N2,n,x,
			Hypergeometric(N1,N2,n,x));
	fprintf(stderr,"CumHypGeomProb = %Lg\n",CumHypGeo(N1,N2,n,x));
	fprintf(stderr,"CumHypGeomProb = %Lg\n",CumHypGeomProb(N1,N2,n,x));
#endif
   }
}


