/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cmsa.h"
#include "residues.h"
#include "histogram.h"
#include "swaln.h"
#include "rst_typ.h"
#include "dheap.h"
#include "sset.h"
#include "set_typ.h"
#include "cma_gmb.h"
#include "cls_typ.h"
#include "new-dsc.h"

#define	USAGE_START	"USAGE: gor_driver cmafile [options]\n\
   options:\n\
     -t         - test mode\n\
     -x         - dummy\n\n"

/**************************** Global Variables ******************************/
int	main(Int4 argc,char *argv[])
{ 
	UInt4 seed=18364592;
	Int4 arg,time1=time(NULL); 
	if(argc < 2) print_error(USAGE_START);
	for(arg = 2; arg < argc; arg++){
	   if(argv[arg][0] != '-') print_error(USAGE_START);
	   switch(argv[arg][1]) {
	     case 'x': break;
	     default: print_error(USAGE_START);
	   }
	}
        if(seed == 18364592)  seed = (UInt4) time(NULL)/2;
        sRandom(seed);
	a_type	AB=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
	cma_typ	cma=ReadCMSA2(argv[1],AB);
	Int4	s,i,j,r,ident,NN=NumSeqsCMSA(cma),len=LengthCMSA(1,cma); assert(NN >= 2);
	double  predicted_accuracy,max;
        Int4    aln,best_ss,t,left_flank=10,right_flank=10;
	double	**ss_prob=ComputeDSC(NULL,&predicted_accuracy,1,left_flank,right_flank,cma);
	char	*SecondStrct=0;
	NEW(SecondStrct,LengthCMSA(1,cma)+4,char); SecondStrct[0]=' ';
	for(s=1; s <= LengthCMSA(1,cma);s++){
           for(max=0.0,t=1; t <= 3; t++){
                if(max < ss_prob[t][s]){ max=ss_prob[t][s]; best_ss=t; }
           } SecondStrct[s]=' ';
           switch(best_ss){
             case 1: if(max >= 0.75) SecondStrct[s]='H';
                     else if(max >= 0.50) SecondStrct[s]='h'; break;
             case 2: if(max >= 0.75) SecondStrct[s]='S';
                     else if(max >= 0.50) SecondStrct[s]='s'; break;
           }
	}
	e_type csqE=MkConsensusCMSA(cma);
	assert(LenSeq(csqE) == LengthCMSA(1,cma));
	char	*buffer=0; NEW(buffer,LenSeq(csqE) + 5, char);
	SeqToString(buffer,csqE,AB);
	double	p,q,re=0.0,ave_re=0.0,tot_re=0.0;
	double	ave_H=0.0, ave_S=0.0,ave_C=0.0;
	for(i=1; i <= LenSeq(csqE); i++){
		r = ResSeq(i,csqE); 
		fprintf(stdout,"%3d: %c %c",i,AlphaChar(r,AB),SecondStrct[i]);
		fprintf(stdout," (H %.3f; S %.3f; C %.3f)\n",ss_prob[1][i],ss_prob[2][i],ss_prob[3][i]);
		p=ss_prob[1][i]; re = p*log(p/0.3333); ave_H += p;
		p=ss_prob[2][i]; re += p*log(p/0.3333); ave_S += p;
		p=ss_prob[3][i]; re += p*log(p/0.3333); ave_C += p;
		tot_re += re;
	}
	ave_re = tot_re/(double)LenSeq(csqE);
	fprintf(stdout,"\n ave relative entropy = %.3f\n",ave_re);
	ave_H = ave_H/(double)LenSeq(csqE);
	ave_S = ave_S/(double)LenSeq(csqE);
	ave_C = ave_C/(double)LenSeq(csqE);
	fprintf(stdout,"\n ave H = %.3f; S = %.3f; C = %.3f\n\n",ave_H,ave_S,ave_C);
        for(t=1; t <= 3; t++) free(ss_prob[t]); free(ss_prob);
	free(SecondStrct); free(buffer); NilSeq(csqE);
	TotalNilCMSA(cma); NilAlpha(AB);
	fprintf(stderr,"\ttime: %d seconds (%0.2f minutes)\n",
                        time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	return 0;
}



