/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

/*************************** compare_sma.h ****************************/
#if !defined(_COMPARE_SMA)
#define _COMPARE_SMA
#include "stdinc.h"
#include "afnio.h"
#include "dheap.h"
#include "alphabet.h"
#include "residues.h"
#include "probability.h"
#include "dsets.h"
#include "dheap.h"
#include "random.h"
#include "histogram.h"
#include "sequence.h"
#include "cmsa.h"
#include "sma.h"
/************************** ADT COMPARE_SMA *****************************/

typedef struct {
	Int4	ntyps;			/** number of blocks in common **/
	Int4	nseqs;			/** number of aligned sequences **/
	Int4	*maxos;			/** maximum offsets **/
	Int4	*max_t;			/** maximum block **/
	Int4	*max_n;			/** maximum number of matches **/
	Int4	*offset,Total;
	Int4	*rm_front,*rm_end;	/** overhangs on either side **/
	Int4	*overlap;		/** overlap between blocks **/
} compare_sma_type;
typedef compare_sma_type *csa_typ;

/******************************* private ********************************/
Int4    max_int_csa_array(Int4 *I, Int4 *L);

/********************************* PUBLIC ********************************/
csa_typ	MakeCSA(sma_typ MA1, sma_typ MA2);
csa_typ	NilCSA(csa_typ C);
void	PutCSA(FILE *fp, csa_typ C);

/********************************* MACROS ********************************/

#endif

