/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "sma.h"
#include "cmsa.h"
#include "residues.h"
#include "gpsi_typ.h"
#include "editcma.h"
#include "table.h"
#include "sset.h"
#include "wdigraph.h"
#include "selexCMSA.h"
#include "dheap.h"
#include "swaln.h"
#include "tax_typ.h"
#include "set_typ.h"
#include "hat_typ.h"
#include "hpt_typ.h"

#define	USAGE_START	"USAGE: cma2aln <input_cma> [options]\n\
   Note: by default both the ccm input file and the mst file is created.\n\
   options:\n\
     -mst        ONLY create an mstarc alignment file for the NCBI pdb sequences (as <out_prefix>.mst).\n\
     -ccm        Create ONLY the ccm input file as <out_prefix>.in\n\
     -pdb        ONLY show the pdb sequence ids within the input cma file (no files created)\n\
     -ptrn       Read in a BPPS pattern file corresponding to the input cma files.\n\
     -P	         Permute the column positions of the cma file.\n\
     -R	         Permute each row (i.e., sequence) in the cma file.\n\
     -B	         Permute residues in each column and the column positions of the cma file.\n\
     -F	         Permute residues in each column and permute each row in the cma file.\n\
     -C	         Permute residues in each column of the cma file.\n\
     -seed=<int> Provide a seed for random number generation\n\
     -T          test mode\n\
\n\n"

Int4	*PtrnStr2Ints(Int4 id, char *Str)
{
	Int4	i,j,x,*iarray,s;
	char	c,res[22];
	for(i=0,j=1; Str[i] != 0; i++) if(Str[i]==',') j++;
	NEW(iarray,j+3,Int4); iarray[0]=j;
	if(sscanf(Str,"%d: ",&x) != 1) print_error("pattern parsing error 1");
	if(x != id) print_error("pattern identifier error");
	Str=&Str[0]; Str=strchr(Str,':'); assert(Str != NULL);
	Str++; while(*Str == ' ') Str++;
	for(i=0; *Str !='\n'; ){
	   if(sscanf(Str,"%[A-Z]%d",res,&x) != 2) print_error("pattern parsing error 2");
	   i++; iarray[i]=x;
	   /// fprintf(stderr,"%s%d\n",res,x); fflush(stderr);
	   for( ; *Str != ','; Str++) if(*Str == '\n') break;
	   if(*Str == '\n') break; else Str++;
	   // fprintf(stderr,"%s",Str); fflush(stderr);
	} assert(i == j);
	return iarray;
}

Int4	*RenumberList(FILE *fp, Int4 *list)
// LELTPLDPAaDARHLHHAYGDEEvmrwwtrpacadpaeteRYLT----ScaaapgARLWTIRAPDgTVPGMAGLLGGtdVPGLTWLLRRDSWGHGYATEAAAAVvGHALEDgGLDRVEAWIEAGNRRSLAVAARVGLTERARLaqhYPhRPGpHEMVVLGKARA
{
	char	c,Str[5005];
	Int4	i,j,col,sq,*col2sq; NEW(col2sq,5005,Int4);
	Int4	*pos2col; NEW(pos2col,5005,Int4);
	for(i=1,sq=col=0; (c=fgetc(fp)) != '\n'; i++){
	   BooLean indel=FALSE,ins=FALSE;
	   if(isupper(c)){ sq++; col++; }
	   else if(islower(c)){ sq++; indel=TRUE; ins=TRUE; }
	   else if(c == '-'){ col++; indel=TRUE; }
	   if(!indel) col2sq[col]=sq; 
	   if(!ins) pos2col[i]=col;
// fprintf(stderr,"%d. %c: col=%d; sq=%d; col2sq[%d]=%d\n",i,c,col,sq,col,col2sq[col]);
	}
	Int4 *List=0; NEW(List,list[0]+3,Int4);
	for(j=0,i=1; i <= list[0]; i++) {
#if 1
	    if(col2sq[list[i]] > 0){ j++; List[j]=col2sq[list[i]]; }
#else
	    if(pos2col[list[i]] > 0){ j++; List[j]=pos2col[list[i]]; }
#endif
	} List[0]=j;
	free(col2sq); free(pos2col);
	return List;
}

#if 0	// not used right now.
void    ShuffleColsNotDelCMA(cma_typ cma)
// Shuffle all of the columns between the sequences for cma
// This routine is for testing Jun's BPPS procedure.
// We would expect the BPPS procedure not to work for these
// shuffled cma's.
{
        assert(nBlksCMSA(cma) == 1);
        unsigned char   *res,r;
        gss_typ *gss=gssCMSA(cma); assert(gss != 0);
        Int4    i,m,n,N=NumSeqsCMSA(cma),*Pos,number=gss->NumSeq();
        e_type  fE,tE;

        assert(number==N);
        // 0. Go column by column through the alignment.
        for(Int4 col=1; col <=LengthCMSA(1,cma); col++){
                NEW(res,N+3,unsigned char); NEW(Pos,N+3,Int4);
                // 1. store residues and positions for each sequence.
                dh_type dH=dheap(number+2,4);
                for(m=0,n=1; n <= number; n++) {
                        // Pos[n]=TruePosCMSA(n,col,cma);
                        // r=ResidueCMSA(1,n,Pos[n],cma);
                   r=ResidueCMSA(1,n,col,cma);  // fake seq?
                   if(1 || r){  // shuffle deletion ('-') residues as well.
                        m++; res[m]=r;
                        insrtHeap(n,(keytyp) Random(),dH);
                   }
                } assert(ItemsInHeap(dH) == m);
                // 2. randomly sort residues on a heap.
                for(m=0; (n=delminHeap(dH)) != 0; ){
                    Int4 site=FakeToRealCMA(n,col,cma);
                    gsq_typ *gsq=gsqCMSA(n,cma);
                    m++; EqSeq(site,res[m],gsq->TrueSeq( ));
                } Nildheap(dH);
                free(res); free(Pos);
        }
}
#endif

int	main(Int4 argc,char *argv[])
{ 
#if 0	// check a cma file for deletions.
   {
        char	cI,cJ,Str[200];
	float	Dd;
	Int4	i,j,k,ndel,pos,N,M;
	if(argc != 2) print_error("USAGE: cma2aln in_file");
        FILE *ifp=open_file(argv[1],"","r"); 
	for(M=N=0,i=1; fgets(Str,100,ifp) != NULL; i++){
              if(sscanf(Str,"1.%d: del=%d (%f\%).",&pos,&ndel,&Dd)==3){
		if(Dd >= 25.0) N++; else M++;
	      }
	} fclose(ifp);
	fprintf(stdout,"deleted=%d; retained=%d\n",N,M);
	exit(1);
   }
#elif 0
   {
	UInt4   seed=7061950;
	if(seed == 7061950) seed = (UInt4) time(NULL);
        sRandom(seed);
	Int4	nruns=100000,len=481,i,hits,j,k,real[200],permuted[200];
	for(i=1; i<=len; i++){ real[i]=i; }
	dh_type dH=dheap(len+2,4);
	h_type HG = Histogram("overlapping residues",0,len+3,1.0);
	for(i=1; i <=nruns; i++){
            for(j=1; j <= len; j++){ insrtHeap(j,(keytyp) Random(),dH); }
	    for(j=0; (k=delminHeap(dH)) != 0; ){ j++; permuted[j]=k; }
	    for(hits=0,j=1; j <=len; j++) if(permuted[j]==j) hits++;
	    IncdHist(hits,HG);
	} Nildheap(dH); 
	PutHist(stdout,60,HG); NilHist(HG);
	exit(1);
   }
#elif 0   // Check relative entropy and DCA relationship...
   {
        char	cI,cJ,Str[200];
	Int4	i,ii,jj;
	FILE	*ifp,*fp=stdout;
	double	Dd,dd;
	Int4	nLeft,nRight;
	if(argc != 3) print_error("USAGE: cma2aln cma_file dca_file");
	TurnOffLicenseStatement();
	a_type AB=MkAlpha(AMINO_ACIDS,GBLAST_BLOSUM62);
        ifp=open_file(argv[1],"","r"); cma_typ cma=ReadCMSA(ifp,AB);  fclose(ifp);
	if(cma == NULL) print_error("USAGE: cma2aln cma_file dca_file");
	float *RE=RelEntropyCMA(1,cma);
        ifp=open_file(argv[2],"","r"); 
	// cma2aln arg1 arg2 | sort -nr --key=3 --field-separator=, > re_dca
Int4 X = 233,L=5904;
double	minRE=1.0;
	for(nLeft=nRight=0,i=1; fgets(Str,100,ifp) != NULL; i++){
              // =============== read in GaussDCA format as input =================
	      // fprintf(stderr,"%d. %s",i,Str); fflush(stderr);
              if(sscanf(Str,"%d,%d,%lf,0,0,0,0,0,0,0,%c,%c",&ii,&jj,&Dd,&cI,&cJ)==5){
                assert(ii != 0 &&  jj != 0);
                if(!(ii > 0 && ii <= TotalLenCMSA(cma))) print_error("aln file input error 1");
                if(!(jj > 0 && jj <= TotalLenCMSA(cma))) print_error("aln file input error 1");
		if(ii >= jj) print_error("aln file input error 1");
                // cI=AlphaChar(ResSeq(ii,qE),AB); cJ=AlphaChar(ResSeq(jj,qE),AB);
		// fprintf(fp,"%d,%d,%.5lf,0,0,0,0,0,0,0,%c (%.3f),%c (%.3f)\n",
		if(abs(ii-jj) > 5){
		    dd=(double) RE[ii] + (double) RE[jj]; dd = dd/2.0;
		    if(i <= X && dd >= minRE) nLeft++; else if(dd >= minRE) nRight++;
#if 0	// output for excel
		    fprintf(fp, "%d\t%d\t%d\t%.5lf\t%c\t%.3f\t%c\t%.3f\t%.5f\n",
				i,ii,jj,Dd,cI,RE[ii],cJ,RE[jj],dd);
#else	// output for new array...
		    fprintf(fp, "%d,%d,%.5lf,0,0,0,0,0,0,0,%c,%c\n", ii,jj,dd,cI,cJ);
#endif
		}
              } else print_error("DCA file not in EVC format!");
        } fclose(ifp); TotalNilCMSA(cma);
	dd=100*(double)nLeft/(double)X;
	Dd=100*(double)nRight/(double)(L-X);
	if(0) fprintf(stderr,"nLeft=%d/%d (%.3f%c);nRight=%d/%d (%.3f%c)\n",nLeft,X,dd,'%',nRight,L-X,Dd,'%');
        exit(0);
    }
#endif
	UInt4   seed=7061950;
	Int4	arg,i,j,time1,Number,pos[4],r,file;
	char	c,PutAln=FALSE,PutCCM=FALSE,ShowPDB=FALSE,Permute=FALSE;
	BooLean	PutFlank=TRUE,FullShuffle=FALSE;
	BooLean	PermuteRows=FALSE,PermuteEachCol=FALSE,PermuteCols=FALSE;
	BooLean	PutFASTA=TRUE; PutFASTA=FALSE;
	time1=time(NULL); 
	char	Str[5003],*ptrnfile=0;
	if(argc < 2) print_error(USAGE_START);
	TurnOffLicenseStatement();
	for(arg = 2; arg < argc; arg++){
	   if(argv[arg][0] != '-') print_error(USAGE_START);
	   switch(argv[arg][1]) {
             case 'm': if(strcmp("-mst",argv[arg])==0){ PutAln=TRUE; } break;
             case 'c': if(strcmp("-ccm",argv[arg])==0){ PutCCM=TRUE; } break;
//  -P	 permuting the column positions of the cmafile.
             case 'P': if(argv[arg][2]==0){ PutCCM=TRUE; PermuteCols=TRUE; }
		    else print_error(USAGE_START); 
		break;
//  -R	 permuting each row of the cma.
             case 'R': if(argv[arg][2]==0){ PutCCM=TRUE; PermuteRows=TRUE; }
		    else print_error(USAGE_START); 
		break;
             case 'F': if(argv[arg][2]==0){ PutCCM=TRUE; PermuteRows=PermuteEachCol=TRUE; }
		    else print_error(USAGE_START); 
		break;
//  -B	 permuting both residue in each column and column positions of the cma.
             case 'B': if(argv[arg][2]==0){ PutCCM=TRUE; PermuteCols=TRUE; PermuteEachCol=TRUE; }
		    else print_error(USAGE_START); 
		break;
//  -C	 permuting residues in each column of the input cma file.
             case 'C': if(argv[arg][2]==0){ PutCCM=TRUE; PermuteEachCol=TRUE; }
		    else print_error(USAGE_START); 
		break;
             case 'p': 
		if(strcmp("-pdb",argv[arg])==0){ ShowPDB=TRUE; } 
		else if(sscanf(argv[arg],"-ptrn=%s",Str)!=1) print_error(USAGE_START); 
		else { ptrnfile=AllocString(Str); }
		break;
	     
	     case 's':
	          if(sscanf(argv[arg],"-seed=%d",&seed) == 1){
			if(seed < 0 || seed > UINT4_MAX) print_error(USAGE_START);
		  } else print_error(USAGE_START);
                 break;
             case 'T': if(argv[arg][2]==0){ PutFlank=FALSE; }
		 else print_error(USAGE_START); break;
             case 'x': break;
	     default: print_error(USAGE_START);
	   }
	}
	if(seed == 7061950) seed = (UInt4) time(NULL);
        sRandom(seed);
	a_type	AB=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
	//************************** Open multiple cma file **************************
	if(!(PutAln || PutCCM)){ PutAln=PutCCM=TRUE; }
	if(ShowPDB){ PutCCM=FALSE; }

    FILE *fp=open_file(argv[1],"","r");
    cma_typ *IN_CMA=MultiReadCMSA(fp,&Number,AB); fclose(fp); fp=0;
    if(Number > 1 && strcmp("Random",NameCMSA(IN_CMA[Number]))==0){
	TotalNilCMSA(IN_CMA[Number]);  Number--; 
    }
    Int4 **Ptrn=0;
    char **pStr=0;
    if(ptrnfile){
	NEWP(Ptrn,Number+3,Int4);
	NEWP(pStr,Number+3,char);
	fp=open_file(ptrnfile,"","r");
	for(i=Number; i >= 1; i--){
	    assert(fgets(Str,5000,fp) != NULL);
	    pStr[i]=AllocString(Str);
	    Ptrn[i]=PtrnStr2Ints(i,Str);
	} fclose(fp); fp=0; free(ptrnfile); ptrnfile=0;
    }
   for(file=1; file <= Number; file++){
	BooLean	found=TRUE;
	if(PutAln && PutCCM){ found=FALSE; }
	cma_typ cma=IN_CMA[file];
	fprintf(stderr,"------------- %d. %s --------------\n",file,NameCMSA(cma));
	if(nBlksCMSA(cma) != 1) print_error("cma file error; not single block.");
	if(PutAln){
// fprintf(stderr,"DEBUG: %d\n",NumSeqsCMSA(cma));
	   char str[20];
	   create_gsq_cmsa(cma);   // create gsq objects for cma if not present...
	   FILE *afp=0;
	   for(Int4 sq=1; sq <= NumSeqsCMSA(cma); sq++){
		e_type E=TrueSeqCMSA(sq,cma);
		StrSeqID(str,10,E);
#if 1
		if(strlen(str) != 6) continue;
		if(str[4] != '_') continue;
		if(!isdigit(str[0])) continue;
#endif
		fprintf(stderr,"---- %s ----\n",str);
		if(ShowPDB) continue;
		found=TRUE;
	   	if(afp==0){
		   if(Number == 1) afp=open_file(argv[1],"_X.mst","w");
		   else afp=open_file(NameCMSA(cma),".mst","w");
		}
		fprintf(afp,"%s: ",str);
           	gsq_typ *gsq=gsqCMSA(sq,cma);
           	assert(gsq != 0);    // this should not happen...
           	Int4    *sites=GetPosSitesCMSA(sq,cma);
           	// gsq->Put_ccm_format2(afp,PutFlank,nBlksCMSA(cma),sites,LengthsCMSA(cma),AB);
           	gsq->Put_ccm_format(afp,PutFlank,nBlksCMSA(cma),sites,LengthsCMSA(cma),AB);
// gsq->Put_ccm_format(stderr,nBlksCMSA(cma),sites,LengthsCMSA(cma),AB);
// gsq->Put_cma_format(stderr,0,nBlksCMSA(cma),sites,LengthsCMSA(cma),AB);
if(Ptrn){
	FILE *tfp=tmpfile();
        gsq->Put_ccm_format(tfp,PutFlank,nBlksCMSA(cma),sites,LengthsCMSA(cma),AB);
	rewind(tfp);


	Int4 *List=RenumberList(tfp,Ptrn[file]);
	fclose(tfp);
#if 0
	// fprintf(stderr,"%s",pStr[file]);
	fprintf(stderr,"#R=");
	for(i=1; i < List[0]; i++){ fprintf(stderr,"%d,",List[i]); } fprintf(stderr,"%d\n",List[i]);
#endif
	fprintf(afp,"#R=");
	for(i=1; i < List[0]; i++){ fprintf(afp,"%d,",List[i]); } fprintf(afp,"%d\n",List[i]);

}
           	free(sites); 
           } if(afp) fclose(afp); afp=0;
	} fp=0;
        if(PutCCM && PermuteRows){		// fully shuffle the input MSA...
	   assert(Number == 1);
	   if(PermuteEachCol) ShuffleColumnsCMA(cma);	// shuffle within each column...
	   char *fakesq; NEW(fakesq,LengthCMSA(1,cma) +5, char);
	   fp=stdout;
	   dh_type dH=dheap(LengthCMSA(1,cma)+2,4);
	   // char *seq=ConsensusSeqCMSA(1,cma); fprintf(fp,"%s\n",seq); free(seq);
	   set_typ SetX=MakeSet(LengthCMSA(1,cma) + 5);
	   for(Int4 sq=1; sq <= NumSeqsCMSA(cma); sq++){
		assert(PosSiteCMSA(1, sq, pos, cma));
		ClearSet(SetX);
                for(j=1; j <= LengthCMSA(1,cma); j++){	
			if(!IsDeletedCMSA(sq,pos[1]+j-1,cma)) AddSet(j,SetX);
		}
// FillSet(SetX);
		// shuffle residues within each sequence...
                for(j=1; j <= LengthCMSA(1,cma); j++){	
		  if(MemberSet(j,SetX)) insrtHeap(j,(keytyp) Random(),dH); 
		}
		assert(PosSiteCMSA(1, sq, pos, cma));
                for(j=1; j <= LengthCMSA(1,cma); j++){
		    if(MemberSet(j,SetX)){
	               assert((i=delminHeap(dH)) != 0);
		       r=ResidueCMSA(1,sq,i,cma);
// if(r==0) fakesq[j]='-'; else 
		       fakesq[j]=AlphaChar(r,AB);
		    } else fakesq[j]='-';
		} assert(emptyHeap(dH));
if(PutFASTA) fprintf(fp,">seq%d \n",sq); // to check relative entropy for columns.
		for(j=1; j <= LengthCMSA(1,cma); j++) fprintf(fp,"%c",fakesq[j]); 
		fprintf(fp,"\n");
           } fprintf(fp,"\n");
	   fp=0; Nildheap(dH); NilSet(SetX);
        } else if(PutCCM && PermuteCols){		// permute columns in MSA...
	   assert(Number == 1);
	   if(PermuteEachCol) ShuffleColumnsCMA(cma);
	   char *fakesq; NEW(fakesq,LengthCMSA(1,cma) +5, char);
	   Int4	*permutation; NEW(permutation,LengthCMSA(1,cma) +5, Int4);
	   dh_type dH=dheap(LengthCMSA(1,cma)+2,4);
           for(j=1; j <= LengthCMSA(1,cma); j++){ insrtHeap(j,(keytyp) Random(),dH); }
	   for(j=0; (i=delminHeap(dH)) != 0; ){ j++; permutation[j]=i; }
	   assert(j==LengthCMSA(1,cma)); fp=stdout;
#if 0	// Debug...
           for(j=1; j <= LengthCMSA(1,cma); j++){ fprintf(stdout,"%d ",permutation[j]); }
	   fprintf(stdout,"\n"); exit(1);
#endif
	   // char *seq=ConsensusSeqCMSA(1,cma); fprintf(fp,"%s\n",seq); free(seq);
	   for(Int4 sq=1; sq <= NumSeqsCMSA(cma); sq++){
		assert(PosSiteCMSA(1, sq, pos, cma));
                for(j=1; j <= LengthCMSA(1,cma); j++){
		    r=ResidueCMSA(1,sq,j,cma);
		    if(IsDeletedCMSA(sq,pos[1]+j-1,cma)){
			assert(r==0); c='-'; 
		    } else c=AlphaChar(r,AB);	
		    fakesq[j]=c;
		}
if(PutFASTA) fprintf(fp,">seq%d \n",sq); // to check relative entropy for columns.
		if(0 && sq==1) for(j=1; j <= LengthCMSA(1,cma); j++){ c=fakesq[j]; fprintf(fp,"%c",c); }
		else for(j=1; j <= LengthCMSA(1,cma); j++){
			i=permutation[j]; // i=j; // for debugging...
			c=fakesq[i]; fprintf(fp,"%c",c); 
		}
		fprintf(fp,"\n");
           } fprintf(fp,"\n");
	   fp=0; Nildheap(dH); free(permutation);
        } else if(PutCCM && PermuteEachCol){		// permute columns in MSA...
	   assert(Number == 1);
	   ShuffleColumnsCMA(cma);
	   char *fakesq; NEW(fakesq,LengthCMSA(1,cma) +5, char); fp=stdout;
	   // char *seq=ConsensusSeqCMSA(1,cma); fprintf(fp,"%s\n",seq); free(seq);
	   for(Int4 sq=1; sq <= NumSeqsCMSA(cma); sq++){
		assert(PosSiteCMSA(1, sq, pos, cma));
                for(j=1; j <= LengthCMSA(1,cma); j++){
		    r=ResidueCMSA(1,sq,j,cma);
		    if(IsDeletedCMSA(sq,pos[1]+j-1,cma)){ assert(r==0); c='-'; } else c=AlphaChar(r,AB);
		    fakesq[j]=c;
		}
if(PutFASTA) fprintf(fp,">seq%d \n",sq); // to check relative entropy for columns.
		if(0 && sq==1) for(j=1; j <= LengthCMSA(1,cma); j++){ c=fakesq[j]; fprintf(fp,"%c",c); }
		else for(j=1; j <= LengthCMSA(1,cma); j++){
			i=j; c=fakesq[i]; fprintf(fp,"%c",c); 
		}
		fprintf(fp,"\n");
           } fprintf(fp,"\n");
	   fp=0; 
	} else if(found && PutCCM) {
	   if(Number == 1) fp=open_file(argv[1],"_X.in","w");
	   else fp=open_file(NameCMSA(cma),".in","w");
	   char *seq=ConsensusSeqCMSA(1,cma);
	   fprintf(fp,"%s\n",seq); free(seq);
	   for(Int4 sq=1; sq <= NumSeqsCMSA(cma); sq++){
		assert(PosSiteCMSA(1, sq, pos, cma));
                for(j=1; j <= LengthCMSA(1,cma); j++){
		    r=ResidueCMSA(1,sq,j,cma);
		    if(IsDeletedCMSA(sq,pos[1]+j-1,cma)){
			assert(r==0); c='-'; 
		    } else c=AlphaChar(r,AB);	
		    fprintf(fp,"%c",c);
		} fprintf(fp,"\n");
           } fprintf(fp,"\n");
        } if(fp) fclose(fp); fp=0;
	if(cma) TotalNilCMSA(cma); 
     } NilAlpha(AB); free(IN_CMA);
	fprintf(stderr,"\ttime: %d seconds (%0.2f minutes)\n",
                        time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	return 0;
}

