/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined (_BP2DC_TYP_)
#define _BP2DC_TYP_

#if 0
#include "chn_aln.h"
#include "chn_pps.h"
#include "chn_typ.h"
#include "chn_vsi.h"
#include "tax_typ.h"
#include "adh_typ.h"
#include "rai_typ.h"
#include "rih_typ.h"
#include "clique.h"
#include "mps_typ.h"
#endif
#include "swaln.h"
#include "histogram.h"
#include "dheap.h"
#include "random.h"
#include "residues.h"
#include "blosum62.h"
#include "cmsa.h"
#include "sequence.h"
#include "mheap.h"
#include "hpt_typ.h"
#include "set_typ.h"
#include "pat_typ.h"
#include "sset.h"
#include "swaln.h"

// #define MAX_NUM_PDB_INPUT_FILES 1000
// #define	MAX_NUMBER_INTERNAL_RPTS 100

class bp2dc_typ {		// BPPS to DCA mapping type.
public:
		bp2dc_typ(){ print_error("this constructor disallowed"); }
		bp2dc_typ(Int4 argc, char *argv[]){
			this->Init();
			this->GetArg(argc,argv);
			this->InitRead();
			Diagnostic=0;
		}
		~bp2dc_typ() { Free(); }
	void	PrintKLST_Files( );
	Int4	Diagnostic;
	char	*OutFile,*SeqFile;
	ss_type	dcaP;
	Int4	*MapSeqToSqAln(Int4 &Row);
	void    ResidueToName(char r, char *str);
#if 0
	set_typ	*RelevantSet;	    // A element of RelevantSet[S] = pdb seq matching a rpt in cma file A.
	Int4	***RelevantSeq;	    // RelevantSeq[I][C][R] == A set.
	Int4	****Col2pdbSeq;  // Col2pdbSeq[I][C][R][column] = pdb residue position i 
	Int4	**NumRpts;		// NumRpts[I][C] = number of repeats....
	Int4	*NumFullRpts;	// NumFullRpts[S] 
	Int4	NumCol( ){ return LengthCMSA(1,IN_CMA[1]); }
	Int4	***Col2FullSeq;	// Col2FullSeq[S][R][col] = seq, repeat, column.
	e_type	*FullSeq;	// FullSeq[S] == full sequence for equivalence set S.
	Int4	**RptCategory;	// RptCategory[S][R] = A
#endif

	BooLean	verbose;
	char	string[300],*mcBPPS_prefix;
	Int4	FinalPnts;
	Int4	FinalCols;
	// void	AssignSets(set_typ **sets){ ColPairSet=sets; }

	set_typ	**ColPairSet;

	Int4	LastNumData,LastTotalData;

	// search routines
	void    FindBestPatternContacts2();
	void	ShowTheBest(){ FindBest=TRUE; }
	hpt_typ *hpt;
#if 0	// For using top scores only...assessing structural scores...
	void	SetTarget(Int4 t){ assert(t >= 5); Target=t; }
	void	SetDataPoints(Int4 t){ assert(t > 9); MaxDataPoints=t; }
#endif
private:
	void    CheckString() { if(string[298] != 0) print_error("input argument too long"); }
	Int4	Target;	// # seqs to include in histogram.
	Int4	MaxDataPoints;
	char	*TraceColors,*SideColors;
	void	Free();
	void	Validate();
	//========================= bp2dc_typ.cc =====================================
	// output routines
	pat_typ *ptrn;
	BooLean	AddColToSeq(Int4 S, Int4 A, Int4 *ColToSeq);
	BooLean	AddColToSeq(Int4 i, Int4 S, Int4 A, Int4 *ColToSeq);
	a_type	AB;
	void	Init();
	void    InitRead(FILE *mmafp=0, FILE *hptfp=0);
	void	GetArg(Int4, char**);
	cma_typ	*IN_CMA;	// multiple 
	cma_typ cma;
	Int4	Number;

	//================ for psc_score.cc ================
	float	HA_dmax, dmax;
	// FILE    *ofp;
        BooLean FindBest;
	BooLean	UseBeta;
        Int4    K1,K2;
        double	MaxMeanDist;
	double	MinCaDist,MaxCaDist;
        Int4    MaxSqDist;
        Int4    MinDistInSeq;
        Int4    MinDist;      // what about inserts in some proteins?
        Int4    begin,end;
        Int4    Begin,End;
        Int4    KeyCol;
        double  MinVar;
        double  bin_size;
        Int4    D;              // Separation in sequence.
};

#endif

