#if !defined (SPRS_USAGE)
#define SPRS_USAGE

#define SPRS_VERSION "\
  ----------------------------------------------------\n\
     SIPRIS v1.0.4 (April 30, 2021)\n\
     www.igs.umaryland.edu/labs/neuwald/software/sparc/\n\
     Copyright 2019-2021 The University of Maryland\n\
     Freely distributed under the MIT License\n\
  ----------------------------------------------------\n"

#define SIPRIS_USAGE "\
   Structurally Interacting Pattern Residues’ Inferred Significance\n\
   Usage: sipris file mode [options]\n\
     The sprs_file is generated by the DARC program.\n\
     To include residue contacts between chain X and adjacent identical chain Y\n\
      add the line \"adjchn: Y.\" directly after the line \"chain: X.\"\n\
   Input:\n\
      <file>	SIPRIS input file\n\
      <mode>	SIPRIS clustering mode\n\
   Output:\n\
      stdout		show S-scores for significant clusters\n\
      <file>_<mode>.vsi vsi file to generate PyMOL session files\n\
   Note: Add hydrogens to pdb files using either the h_add command within PyMOL\n\
	  or the Reduce program by J. Michael Word.\n\
          (http://kinemage.biochem.duke.edu/software/reduce.php\n\
              or https://github.com/rlabduke/reduce.git).\n\
   Possible modes: \n\
     H        hydrogen bond network (sidechain-to-sidechain and sidechain-to-backbone)\n\
     B        hydrogen bond network (also includes backbone-to-backbone H-bonds)\n\
     C        core clustering\n\
     S        spherical clustering\n\
     P=<str>  predefined clustering (<str> = contacting chain(s); e.g., P=BDF)\n\
   options: \n\
     -C=<real>     p-value cutoff (default: 0.05).\n\
     -c=<int>      Minimum adjacency cutoff for core clustering (default: 7; range 2-15).\n\
     -D=<char>     For PyMOL, show class <char> discriminating residues outside\n\
                      the cluster (labeled as L).\n\
     -N=<char>     For PyMOL, show non-discriminating residues in the class <char>\n\
                      cluster (labeled as W).\n\
     -EV=<file>    Use EVfold CouplingScores.csv to compute structural contacts \n\
                      (C or S modes only).\n\
     -ignore=<char> Ignore the <char> class of pattern residues.\n\
     -K=<int>:<char> Use <int>th residue in chain <char> as starting point\n\
                      (H, B or S modes only)).\n\
     -K=<int1>:<char>:<int2> Use <int2>th atom in <int1>th 'residue' in chain <char> \n\
                      as the starting point \n\
     -k=<int>:<char> Show atom numbers for <int>th 'residue' in chain <char>.\n\
     -M=<int>      Maximum number of discriminating positions (default: 25; maximum 100).\n\
     -m=<real>     Define the minimum residue contact area (default: 1.5 squared Angstroms).\n\
     -out=<str>    Write output to file <str> instead of stdout.\n\
     -P=<int>      Number of top positions to use as starting points (default: up to 25).\n\
     -pttrns       Show pattern residues within each significant cluster.\n\
     -S=<int>      Randomize input to perform <int> simulations.\n\
     -seed=<int>   Provide random seed (for simulations).\n\
     -verbose	     Print out diagnostic information.\n\
   References:\n\
     Altschul, S.F. & Neuwald, A.F. 2018. Initial Cluster Analysis. Journal of \n\
           Computational Biology 25(2):121-129. doi: 10.1089/cmb.2017.0050. PMID: 28771374.\n\
     Neuwald, A.F., L. Aravind & S.F. Altschul. 2018. Inferring Joint Sequence-Structural\n\
           Determinants of Protein Functional Specificity. eLife \n\
           doi: 10.7554/eLife.29880.001. PMID: 29336305.\n\
   Funding provided by the National Institutes of Health, National Institute of\n\
        General Medical Sciences grant R01GM125878.\n\
\n\n"

#if 0
     -pml=<int>    Create a PyMOL script for the <int>th pdb file in sprs_file).\n\
     -pml          Create PyMOL scripts for all pdb files in sprs_file).\n\

#endif

#endif
