#if !defined (PurgeMSA_USAGE)
#define PurgeMSA_USAGE

#define PURGE_MSA_VERSION "\
  ----------------------------------------------------\n\
     PurgeMSA v1.0.1 (April 16, 2019)\n\
     www.igs.umaryland.edu/labs/neuwald/software/mapgaps/\n\
     Copyright 2019 The University of Maryland\n\
     Freely distributed under the MIT License\n\
  ----------------------------------------------------\n"

#define USAGE_PURGE_MSA "\n\
  Usage: PurgeMSA <cmafile> <int1> <int2>[options]\n\
  Input: Concatenated cma-formated multiple alignments in file '<cmafile>.mma'.\n\
      <int1> = Remove sequences with less than <int1>\% matching columns (10 <= <int1> <= 100).\n\
      <int2> = Remove all but one sequence among those sharing >= <int2>\% identity.\n\
  Output: A single MSA with fragments and redundant sequences removed.\n\
  Options:\n\
     -iron        - Remove ('iron out') deletions next to insertions.\n\
     -iron=<real> - Remove columns with fraction >= <real> deletions.\n\
                     (also removes deletions next to insertions)\n\
  Reference:\n\
    Neuwald, A.F., Lanczycki, C.J., & Marchler-Bauer, A. 2019.  Extremely Large and \n\
      Accurate Multiple Sequence Alignments based on Conserved Domain Database (CDD) \n\
      Hierarchies. DATABASE (submitted).\n\
  Funding provided by the National Institutes of Health, National Institute of \n\
        General Medical Sciences grant R01GM125878.\n\
\n\n"

#endif

