/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined (_LPS_TYP_)
#define _LPS_TYP_

#include <cstdlib>
#include <omp.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "gsm_typ.h"
#include "gmb_typ.h"
#include "cma_gmb.h"
#include "mapgaps.h"
#include "chn_typ.h"
#include "lapis_usage.h"
#include "cdhit-common.h"

// # using namespace std;

class lps_typ { // lapis type.
public:
        lps_typ( ) { assert(!"Illegal constructor"); }
        lps_typ(int ac, char *av[]) {
		 jhs=0; argc=ac; argv=av; time1=time(NULL); tckS=clock();
		 AB=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
        	 if(argc < 2) print_error(LAPIS_USAGE_PLUS);
		 else if(argc == 2 && argv[1][0] == '-') print_error(LAPIS_USAGE_PLUS);
		 else if(argc > 2 && argv[2][0] != '-') jhs = new jhs_typ(ac,av);
		 else Init( ); 
		}
        int	Run(FILE *ofp=stdout){
#if 0
		   if(jhs){
			jhs->RunJH(); delete jhs; return 0;
		   } else
#endif
		   {
		     this->RmOutliers(); this->CD_Hit(); this->GetGismoSeqs(); 
		     this->Gismo(); this->GetTpl(); this->MapGapsI(); this->MapGapsII();
        	     return 0;
		   }
		}
        ~lps_typ( ){
		   NilAlpha(AB);
		   Int4 tm=time(NULL)-time1;
		   clock_t tckE=clock() - tckS;
		   float secs=(float)(tckE)/CLOCKS_PER_SEC;
        	   fprintf(stderr,"\ttime: %.2e ticks (%d sec; %0.2f min)\n",
                                   (float)tckE,tm,(float)tm/60.0);
		}
private:
#if 1	//================= jackhmmer search class ===================
	class jhs_typ {
public:
           jhs_typ( ) { assert(!"Illegal constructor"); }
           jhs_typ(int ac, char *av[]) {
			argC=ac; argV=av; // Init( ); 
	   	}
	   // int	Run(FILE *ofp=stdout) { this->run_lapis_JH(); }
	   int     run_lapis_JH(Int4 ac, char **av);
           ~jhs_typ( ){ Free(); }
	   int	RunJH();
private:
	   Int4    PutUniqueMergedMinColCMSA(char *filename, char *matstr, double MinCol,
			a_type AB);
	   Int4	argC;
	   char **argV;
	   // int	Init(){ }
	   void	Free(){ }
	};
#endif	//==========================================================
	jhs_typ	*jhs;
	//================= lps_typ.cc =====================
	void    PrintError(){ fprintf(stderr,"%s",LAPIS_VERSION); print_error(USAGE_LAPIS); }

	char	**argv;
	a_type	AB;
	int     ArgC;
	FILE	*fp;
        char    **ArgV,str[200];
	Int4	time1;
	clock_t tckS;

	//================= lps_init.cc =====================
	void	Init();
	// void	Free();

	int	argc,NumThrds;
	BooLean output_rtf;

	//================= lps_rmv.cc =====================
	Int4	RmOutliers();
	Int4    CD_Hit();
	Int4    GetBestRepSeqs(FILE *xfp,Int4 N,ss_type P);
	Int4    GetGismoSeqs();
	Int4	Purge(Int4 PerCentCut);
	Int4    PutMinColCMSA(const char *name, const char *outname,
                	Int4 percent_id, double MinCol);

 	Int4	Num2Retain;

	//================= lps_gsm.cc =====================
	Int4    Gismo();
	Int4    GetTpl();
	Int4    percent_id;  // for GISMO
	double  MinCol;
	Int4	SizeGSM,SizeMGS;

	//================= lps_mgs.cc =====================
	Int4    MapGapsI();
	Int4    MapGapsII();

	//================= data types =====================
	cma_typ	CMA;	// working MSA in cma format.
};

#endif

