/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "lps_typ.h"

Int4	lps_typ::MapGapsI()
// 5. mapgaps initial search to create profiles
{
	Int4	x;
        NEWP(ArgV, 12, char); 
	ArgC=0; ArgV[ArgC]=AllocString("mapgaps"); ArgC++;
	sprintf(str,"%s",argv[1]);
	ArgV[ArgC]=AllocString(str); ArgC++;
	// sprintf(str,"%s",argv[1],cutoff);
	sprintf(str,"%s_U90",argv[1]);
	ArgV[ArgC]=AllocString(str); ArgC++;
#if 1
	sprintf(str,"-e=1e-8");
	ArgV[ArgC]=AllocString(str); ArgC++;
	sprintf(str,"-sense=0.05");
	ArgV[ArgC]=AllocString(str); ArgC++;
	sprintf(str,"-I=40:40"); ArgV[ArgC]=AllocString(str); ArgC++;
#endif
	run_mapgaps(ArgC,ArgV);
        for(x=0; x < ArgC; x++) free(ArgV[x]); free(ArgV); ArgV=0;
	return 1;
}

Int4	lps_typ::MapGapsII()
// 6. mapgaps: create search files. 
{
	Int4	x;
        NEWP(ArgV, 12, char); 
	ArgC=0; ArgV[ArgC]=AllocString("mapgaps"); ArgC++;
	sprintf(str,"%s_U90_map",argv[1]);
	ArgV[ArgC]=AllocString(str); ArgC++;
	run_mapgaps(ArgC,ArgV);
        for(x=0; x < ArgC; x++) free(ArgV[x]); free(ArgV);

	// 7. mapgaps search of the initial database to create final file
#if 1	// iron out input...
	{
	      sprintf(str,"%s_U90_map.tpl",argv[1]);
	      cma_typ tcma=ReadCMSA2(str,AB);
              tcma=RmWrinklesCMSA(tcma);
	      std::remove(str);
	      WriteCMSA(str,tcma); TotalNilCMSA(tcma);
	}
#endif
        NEWP(ArgV, 12, char); 
	ArgC=0; ArgV[ArgC]=AllocString("mapgaps"); ArgC++;
	sprintf(str,"%s_U90_map",argv[1]);
	ArgV[ArgC]=AllocString(str); ArgC++;
	sprintf(str,"%s",argv[1]);	// output will be argv[1]_A.mma and *_A.seq
	ArgV[ArgC]=AllocString(str); ArgC++;
#if 1
	sprintf(str,"-e=1e-5");
	ArgV[ArgC]=AllocString(str); ArgC++;
	sprintf(str,"-sense=0.05");
	ArgV[ArgC]=AllocString(str); ArgC++;
	sprintf(str,"-I=40:40");
	ArgV[ArgC]=AllocString(str); ArgC++;
#endif
	run_mapgaps(ArgC,ArgV);
        for(x=0; x < ArgC; x++) free(ArgV[x]); free(ArgV); ArgV=0;
	return 1;
}


